/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.tender.notice.controller;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.els.common.api.vo.Result;
import com.els.common.aspect.annotation.AutoLog;
import com.els.common.aspect.annotation.SrmValidated;
import com.els.common.system.base.controller.BaseController;
import com.els.common.system.query.QueryGenerator;
import com.els.modules.tender.common.aspect.TenderPermissions;
import com.els.modules.tender.common.aspect.ValidatedTenderStatus;
import com.els.modules.tender.notice.entity.PurchaseTenderNoticeHead;
import com.els.modules.tender.notice.entity.PurchaseTenderNoticeItem;
import com.els.modules.tender.notice.service.PurchaseTenderNoticeHeadService;
import com.els.modules.tender.notice.service.PurchaseTenderNoticeItemService;
import com.els.modules.tender.notice.vo.PurchaseTenderNoticeHeadVO;
import com.els.modules.tender.project.enumerate.TenderProjectSubpackageStatusEnum;
import com.els.modules.tender.project.enumerate.TenderRoleEnum;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.servlet.http.HttpServletRequest;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/tender/purchaseTenderNoticeHead"})
@Tag(name="\u91c7\u8d2d\u62db\u6807\u9879\u76ee\u516c\u544a\u5934")
public class PurchaseTenderNoticeHeadController
extends BaseController<PurchaseTenderNoticeHead, PurchaseTenderNoticeHeadService> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(PurchaseTenderNoticeHeadController.class);
    @Autowired
    private PurchaseTenderNoticeHeadService purchaseTenderNoticeHeadService;
    @Autowired
    private PurchaseTenderNoticeItemService purchaseTenderNoticeItemService;

    @Operation(summary="\u5206\u9875\u5217\u8868\u67e5\u8be2", description="\u5206\u9875\u5217\u8868\u67e5\u8be2")
    @GetMapping(value={"/list"})
    @RequiresPermissions(value={"tender#tenderProject:list"})
    @TenderPermissions(value={TenderRoleEnum.PURCHASE_EXECUTOR, TenderRoleEnum.BIDING_USER})
    public Result<?> queryPageList(PurchaseTenderNoticeHead purchaseTenderNoticeHead, @RequestParam(name="pageNo", defaultValue="1") Integer pageNo, @RequestParam(name="pageSize", defaultValue="10") Integer pageSize, HttpServletRequest req) {
        QueryWrapper queryWrapper = QueryGenerator.initQueryWrapper((Object)((Object)purchaseTenderNoticeHead), (Map)req.getParameterMap());
        Page page = new Page((long)pageNo.intValue(), (long)pageSize.intValue());
        IPage pageList = this.purchaseTenderNoticeHeadService.page((IPage)page, (Wrapper)queryWrapper);
        return Result.ok((Object)pageList);
    }

    @Operation(summary="\u5217\u8868\u67e5\u8be2", description="\u5206\u9875\u5217\u8868\u67e5\u8be2")
    @GetMapping(value={"/sale/queryList"})
    @RequiresPermissions(value={"tender#tenderProject:list"})
    @TenderPermissions(value={TenderRoleEnum.BIDING_ORG})
    public Result<?> queryList(@RequestParam(name="subpackageId") String subpackageId, @RequestParam(name="noticeType") String noticeType) {
        List<PurchaseTenderNoticeHeadVO> purchaseTenderNoticeHeadVOList = this.purchaseTenderNoticeHeadService.queryList(subpackageId, noticeType, null);
        return Result.ok(purchaseTenderNoticeHeadVOList);
    }

    @AutoLog(busModule="\u91c7\u8d2d\u62db\u6807\u9879\u76ee\u516c\u544a\u5934", value="\u6dfb\u52a0")
    @Operation(summary="\u6dfb\u52a0", description="\u6dfb\u52a0")
    @PostMapping(value={"/add"})
    @SrmValidated
    @RequiresPermissions(value={"tender#tenderProject:add"})
    @ValidatedTenderStatus(value={TenderProjectSubpackageStatusEnum.BIDDING_HAS_ENDED})
    public Result<?> add(@RequestBody PurchaseTenderNoticeHeadVO purchaseTenderNoticeHeadPage) {
        PurchaseTenderNoticeHead purchaseTenderNoticeHead = new PurchaseTenderNoticeHead();
        BeanUtils.copyProperties((Object)((Object)purchaseTenderNoticeHeadPage), (Object)((Object)purchaseTenderNoticeHead));
        this.purchaseTenderNoticeHeadService.saveMain(purchaseTenderNoticeHead, purchaseTenderNoticeHeadPage.getPurchaseTenderNoticeItemList(), purchaseTenderNoticeHeadPage.getPurchaseTenderSupplierInvitation());
        return Result.ok((Object)((Object)purchaseTenderNoticeHead));
    }

    @AutoLog(busModule="\u91c7\u8d2d\u62db\u6807\u9879\u76ee\u516c\u544a\u5934", value="\u7f16\u8f91")
    @Operation(summary="\u7f16\u8f91", description="\u7f16\u8f91")
    @PostMapping(value={"/edit"})
    @SrmValidated
    @RequiresPermissions(value={"tender#tenderProject:edit"})
    @ValidatedTenderStatus(value={TenderProjectSubpackageStatusEnum.BIDDING_HAS_ENDED})
    public Result<?> edit(@RequestBody PurchaseTenderNoticeHeadVO purchaseTenderNoticeHeadPage) {
        PurchaseTenderNoticeHead purchaseTenderNoticeHead = new PurchaseTenderNoticeHead();
        BeanUtils.copyProperties((Object)((Object)purchaseTenderNoticeHeadPage), (Object)((Object)purchaseTenderNoticeHead));
        this.purchaseTenderNoticeHeadService.updateMain(purchaseTenderNoticeHead, purchaseTenderNoticeHeadPage.getPurchaseTenderNoticeItemList(), purchaseTenderNoticeHeadPage.getPurchaseTenderSupplierInvitation());
        String id = purchaseTenderNoticeHead.getId();
        return this.queryById(id);
    }

    @AutoLog(busModule="\u91c7\u8d2d\u62db\u6807\u9879\u76ee\u516c\u544a\u5934", value="\u7f16\u8f91")
    @Operation(summary="\u751f\u6210", description="\u751f\u6210")
    @PostMapping(value={"/generator"})
    @SrmValidated
    @RequiresPermissions(value={"tender#tenderProject:edit"})
    public Result<?> generate(@RequestBody PurchaseTenderNoticeHeadVO purchaseTenderNoticeHeadPage) {
        PurchaseTenderNoticeHead purchaseTenderNoticeHead = new PurchaseTenderNoticeHead();
        BeanUtils.copyProperties((Object)((Object)purchaseTenderNoticeHeadPage), (Object)((Object)purchaseTenderNoticeHead));
        this.purchaseTenderNoticeHeadService.generate(purchaseTenderNoticeHead, purchaseTenderNoticeHeadPage.getPurchaseTenderNoticeItemList(), purchaseTenderNoticeHeadPage.getPurchaseTenderSupplierInvitation());
        return Result.ok((Object)((Object)purchaseTenderNoticeHead));
    }

    @AutoLog(busModule="\u91c7\u8d2d\u62db\u6807\u9879\u76ee\u516c\u544a\u5934", value="\u901a\u8fc7id\u5220\u9664")
    @Operation(summary="\u901a\u8fc7id\u5220\u9664", description="\u901a\u8fc7id\u5220\u9664")
    @GetMapping(value={"/delete"})
    @RequiresPermissions(value={"tender#tenderProject:delete"})
    public Result<?> delete(@RequestParam(name="id") String id) {
        this.purchaseTenderNoticeHeadService.deleteMain(id);
        return this.commonSuccessResult(4);
    }

    @AutoLog(busModule="\u91c7\u8d2d\u62db\u6807\u9879\u76ee\u516c\u544a\u5934", value="\u6279\u91cf\u5220\u9664")
    @Operation(summary="\u6279\u91cf\u5220\u9664", description="\u6279\u91cf\u5220\u9664")
    @GetMapping(value={"/deleteBatch"})
    @RequiresPermissions(value={"tender#tenderProject:delete"})
    public Result<?> deleteBatch(@RequestParam(name="ids") String ids) {
        this.purchaseTenderNoticeHeadService.deleteBatchMain(Arrays.asList(ids.split(",")));
        return this.commonSuccessResult(4);
    }

    @Operation(summary="\u901a\u8fc7id\u67e5\u8be2", description="\u901a\u8fc7id\u67e5\u8be2")
    @GetMapping(value={"/queryById"})
    @RequiresPermissions(value={"tender#tenderProject:queryById"})
    @TenderPermissions(value={TenderRoleEnum.PURCHASE_EXECUTOR, TenderRoleEnum.BIDING_USER})
    public Result<?> queryById(@RequestParam(name="id") String id) {
        PurchaseTenderNoticeHeadVO purchaseTenderNoticeHeadVO = this.purchaseTenderNoticeHeadService.queryById(id);
        return Result.ok((Object)((Object)purchaseTenderNoticeHeadVO));
    }

    @Operation(summary="\u901a\u8fc7\u9879\u76ee\u5206\u5305id\u67e5\u8be2", description="\u901a\u8fc7\u9879\u76ee\u5206\u5305id\u67e5\u8be2")
    @GetMapping(value={"/queryBySubpackageId"})
    @RequiresPermissions(value={"tender#tenderProject:queryById"})
    @TenderPermissions(value={TenderRoleEnum.PURCHASE_EXECUTOR, TenderRoleEnum.BIDING_USER, TenderRoleEnum.BIDING_ORG})
    public Result<?> queryBySubpackageId(@RequestParam(name="subpackageId") String subpackageId, @RequestParam(name="noticeType") String noticeType) {
        PurchaseTenderNoticeHeadVO purchaseTenderNoticeHeadVO = this.purchaseTenderNoticeHeadService.queryBySubpackageId(subpackageId, noticeType);
        return Result.ok((Object)((Object)purchaseTenderNoticeHeadVO));
    }

    @Operation(summary="\u901a\u8fc7\u91c7\u8d2d\u62db\u6807\u9879\u76ee\u516c\u544a\u5934id\u67e5\u8be2\u91c7\u8d2d\u62db\u6807\u9879\u76ee\u516c\u544a\u884c", description="\u901a\u8fc7\u91c7\u8d2d\u62db\u6807\u9879\u76ee\u516c\u544a\u5934id\u67e5\u8be2\u91c7\u8d2d\u62db\u6807\u9879\u76ee\u516c\u544a\u884c")
    @GetMapping(value={"/queryPurchaseTenderNoticeItemByMainId"})
    @RequiresPermissions(value={"tender#tenderProject:queryById"})
    @TenderPermissions(value={TenderRoleEnum.PURCHASE_EXECUTOR, TenderRoleEnum.BIDING_USER})
    public Result<?> queryPurchaseTenderNoticeItemListByMainId(@RequestParam(name="id") String id) {
        List<PurchaseTenderNoticeItem> purchaseTenderNoticeItemList = this.purchaseTenderNoticeItemService.selectByMainId(id);
        return Result.ok(purchaseTenderNoticeItemList);
    }

    @Operation(summary="\u53d1\u5e03\u516c\u544a", description="\u53d1\u5e03\u516c\u544a")
    @PostMapping(value={"/publish"})
    @SrmValidated
    @RequiresPermissions(value={"tender#tenderProject:publish"})
    @ValidatedTenderStatus(value={TenderProjectSubpackageStatusEnum.BIDDING_HAS_ENDED})
    public Result<?> publish(@RequestBody PurchaseTenderNoticeHeadVO purchaseTenderNoticeHeadPage) {
        PurchaseTenderNoticeHead dbHead = new PurchaseTenderNoticeHead();
        BeanUtils.copyProperties((Object)((Object)purchaseTenderNoticeHeadPage), (Object)((Object)dbHead));
        this.purchaseTenderNoticeHeadService.saveOrUpdatePublish(dbHead, purchaseTenderNoticeHeadPage.getPurchaseTenderNoticeItemList(), purchaseTenderNoticeHeadPage.getPurchaseTenderSupplierInvitation());
        return this.commonSuccessResult(3);
    }
}

