/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.api.service.impl;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.StrUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.els.common.aspect.annotation.RpcService;
import com.els.common.system.base.entity.BaseEntity;
import com.els.common.system.query.QueryGenerator;
import com.els.common.system.util.PermissionDataQueryUtil;
import com.els.common.util.I18nUtil;
import com.els.common.util.SpringContextUtils;
import com.els.common.util.SysUtil;
import com.els.common.vo.CountVO;
import com.els.config.mybatis.TenantContext;
import com.els.modules.account.api.dto.LoginUserDTO;
import com.els.modules.api.service.InquiryTodoListRpcService;
import com.els.modules.base.api.dto.DictDTO;
import com.els.modules.bidding.entity.PurchaseBiddingHead;
import com.els.modules.bidding.entity.PurchaseBiddingSpecialist;
import com.els.modules.bidding.entity.SaleBiddingHead;
import com.els.modules.bidding.service.PurchaseBiddingHeadService;
import com.els.modules.bidding.service.PurchaseBiddingSpecialistService;
import com.els.modules.bidding.service.PurchaseMentoringHeadService;
import com.els.modules.bidding.service.SaleBiddingHeadService;
import com.els.modules.bidding.service.SaleClarificationInfoService;
import com.els.modules.bidding.service.SaleMentoringHeadService;
import com.els.modules.ebidding.entity.PurchaseEbiddingHead;
import com.els.modules.ebidding.entity.SaleEbiddingHead;
import com.els.modules.ebidding.service.PurchaseEbiddingHeadService;
import com.els.modules.ebidding.service.SaleEbiddingHeadService;
import com.els.modules.enquiry.entity.PurchaseEnquiryHead;
import com.els.modules.enquiry.entity.SaleEnquiryHead;
import com.els.modules.enquiry.service.PurchaseEnquiryHeadService;
import com.els.modules.enquiry.service.SaleEnquiryHeadService;
import com.els.modules.forecast.entity.SaleForecastHead;
import com.els.modules.forecast.service.SaleForecastHeadService;
import com.els.modules.inquiry.qualification.entity.PurchaseQualificationReview;
import com.els.modules.inquiry.qualification.service.PurchaseQualificationReviewService;
import com.els.modules.tender.project.service.PurchaseTenderProjectSubpackageInfoService;
import com.els.modules.tender.supplier.service.TenderProjectSignUpService;
import com.els.modules.tender.supplier.service.TenderProjectSupplierService;
import com.els.rpc.service.InvokeBaseRpcService;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.context.annotation.Lazy;

@RpcService
public class InquiryTodoListDubboServiceImpl
implements InquiryTodoListRpcService {
    @Resource
    private PurchaseEnquiryHeadService purchaseSampleHeadService;
    @Resource
    private SaleEnquiryHeadService saleEnquiryHeadService;
    @Resource
    private SaleEbiddingHeadService saleEbiddingHeadService;
    @Resource
    private PurchaseEbiddingHeadService purchaseEbiddingHeadService;
    @Resource
    private PurchaseBiddingHeadService purchaseBiddingHeadService;
    @Resource
    private SaleBiddingHeadService saleBiddingHeadService;
    @Resource
    private PurchaseQualificationReviewService purchaseQualificationReviewService;
    @Resource
    private PurchaseBiddingSpecialistService purchaseBiddingSpecialistService;
    @Resource
    private PermissionDataQueryUtil permissionDataQueryUtil;
    @Resource
    private PurchaseTenderProjectSubpackageInfoService subpackageInfoService;
    @Resource
    private TenderProjectSignUpService tenderProjectSignUpService;
    @Resource
    @Lazy
    private TenderProjectSupplierService supplierService;
    @Resource
    @Lazy
    private SaleForecastHeadService saleForecastHeadService;
    @Resource
    @Lazy
    private InvokeBaseRpcService invokeBaseRpcService;

    public Integer countPurchaseEnquiryList(String elsAccount, List<String> statusList, String accountBusinessType) {
        this.permissionDataQueryUtil.initPermissionData(accountBusinessType);
        QueryWrapper queryWrapper = QueryGenerator.initQueryWrapper((Object)((Object)new PurchaseEnquiryHead()), new HashMap());
        String accountAll = this.permissionDataQueryUtil.getAccountAll(accountBusinessType);
        if (!StrUtil.isBlank((CharSequence)accountAll)) {
            queryWrapper.eq((Object)"purchase_principal", (Object)accountAll);
        }
        queryWrapper.in((Object)"els_account", new Object[]{elsAccount});
        queryWrapper.in((Object)"enquiry_status", statusList);
        queryWrapper.in((Object)"is_deleted", new Object[]{0});
        int count = this.purchaseSampleHeadService.count((Wrapper)queryWrapper);
        return count;
    }

    public Integer countSaleEnquiryList(String elsAccount, List<String> statusList, String accountBusinessType) {
        this.permissionDataQueryUtil.initPermissionData(accountBusinessType);
        QueryWrapper queryWrapper = QueryGenerator.initQueryWrapper((Object)((Object)new SaleEnquiryHead()), new HashMap());
        queryWrapper.in((Object)"els_account", new Object[]{elsAccount});
        queryWrapper.in((Object)"enquiry_status", statusList);
        queryWrapper.in((Object)"is_deleted", new Object[]{0});
        int count = this.saleEnquiryHeadService.count((Wrapper)queryWrapper);
        return count;
    }

    public Integer countSaleEbiddingList(String elsAccount, List<String> statusList, String accountBusinessType) {
        this.permissionDataQueryUtil.initPermissionData(accountBusinessType);
        QueryWrapper queryWrapper = QueryGenerator.initQueryWrapper((Object)((Object)new SaleEbiddingHead()), new HashMap());
        queryWrapper.in((Object)"els_account", new Object[]{elsAccount});
        queryWrapper.in((Object)"ebidding_status", statusList);
        queryWrapper.in((Object)"is_deleted", new Object[]{0});
        int count = this.saleEbiddingHeadService.count((Wrapper)queryWrapper);
        return count;
    }

    public Integer countPurchaseEbiddingList(String elsAccount, List<String> statusList, String accountBusinessType) {
        this.permissionDataQueryUtil.initPermissionData(accountBusinessType);
        QueryWrapper queryWrapper = QueryGenerator.initQueryWrapper((Object)((Object)new PurchaseEbiddingHead()), new HashMap());
        String accountAll = this.permissionDataQueryUtil.getAccountAll(accountBusinessType);
        if (!StrUtil.isBlank((CharSequence)accountAll)) {
            queryWrapper.eq((Object)"purchase_principal", (Object)accountAll);
        }
        queryWrapper.in((Object)"els_account", new Object[]{elsAccount});
        queryWrapper.in((Object)"ebidding_status", statusList);
        queryWrapper.in((Object)"is_deleted", new Object[]{0});
        int count = this.purchaseEbiddingHeadService.count((Wrapper)queryWrapper);
        return count;
    }

    public Integer countPurchaseBiddingList(String elsAccount, List<String> statusList, String accountBusinessType) {
        this.permissionDataQueryUtil.initPermissionData(accountBusinessType);
        QueryWrapper queryWrapper = QueryGenerator.initQueryWrapper((Object)((Object)new PurchaseBiddingHead()), new HashMap());
        String accountNumber = this.permissionDataQueryUtil.getAccount(accountBusinessType);
        if (!StrUtil.isBlank((CharSequence)accountNumber)) {
            queryWrapper.eq((Object)"publish_user", (Object)accountNumber);
        }
        queryWrapper.eq((Object)"els_account", (Object)elsAccount);
        queryWrapper.in((Object)"bidding_status", statusList);
        queryWrapper.eq((Object)"is_deleted", (Object)0);
        if (statusList.contains("3")) {
            queryWrapper.eq((Object)"bid_evaluation_way", (Object)"1");
            LoginUserDTO currentUser = SysUtil.getLoginUser();
            List list = ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.purchaseBiddingSpecialistService.lambdaQuery().eq(PurchaseBiddingSpecialist::getSubAccount, (Object)currentUser.getSubAccount())).eq(PurchaseBiddingSpecialist::getName, (Object)currentUser.getRealname())).list();
            List collect = list.parallelStream().map(PurchaseBiddingSpecialist::getHeadId).distinct().collect(Collectors.toList());
            if (CollectionUtil.isNotEmpty(collect)) {
                queryWrapper.in((Object)"id", collect);
            } else {
                queryWrapper.lambda().eq(BaseEntity::getId, (Object)"*****");
            }
            return this.purchaseBiddingHeadService.count((Wrapper)queryWrapper);
        }
        queryWrapper.eq((Object)"create_type", (Object)"bidding");
        return this.purchaseBiddingHeadService.count((Wrapper)queryWrapper);
    }

    public Integer countSaleBiddingList(String elsAccount, List<String> statusList, String accountBusinessType) {
        this.permissionDataQueryUtil.initPermissionData(accountBusinessType);
        QueryWrapper queryWrapper = QueryGenerator.initQueryWrapper((Object)((Object)new SaleBiddingHead()), new HashMap());
        queryWrapper.eq((Object)"els_account", (Object)elsAccount);
        queryWrapper.in((Object)"bidding_status", statusList);
        queryWrapper.eq((Object)"is_deleted", (Object)0);
        int count = this.saleBiddingHeadService.count((Wrapper)queryWrapper);
        return count;
    }

    public Integer countPurchaseQualificationList(String elsAccount, List<String> statusList, String accountBusinessType) {
        this.permissionDataQueryUtil.initPermissionData(accountBusinessType);
        QueryWrapper queryWrapper = QueryGenerator.initQueryWrapper((Object)((Object)new PurchaseQualificationReview()), new HashMap());
        queryWrapper.in((Object)"els_account", new Object[]{elsAccount});
        queryWrapper.in((Object)"review_status", statusList);
        queryWrapper.in((Object)"is_deleted", new Object[]{0});
        int count = this.purchaseQualificationReviewService.count((Wrapper)queryWrapper);
        return count;
    }

    public List<CountVO> countPurchaseTenderProjectSubpackageList(String elsAccount, List<String> standardStatusList, String accountBusinessType) {
        String name = this.permissionDataQueryUtil.getName(accountBusinessType);
        List<CountVO> countVOList = this.subpackageInfoService.queryTabsCountByHomePage(elsAccount, null, name);
        return countVOList.stream().filter(countVO -> standardStatusList.contains(countVO.getValue()) && countVO.getTotal() > 0).collect(Collectors.toList());
    }

    public List<CountVO> countSaleTenderProjectSubpackageList(String elsAccount, List<String> standardStatusList, String accountBusinessType) {
        List<CountVO> countVOList = this.supplierService.queryTabsCount(elsAccount);
        return countVOList.stream().filter(countVO -> standardStatusList.contains(countVO.getValue()) && countVO.getTotal() > 0).collect(Collectors.toList());
    }

    public List<CountVO> countPurchaseBiddingProjectSubpackageList(String elsAccount, List<String> standardStatusList, String accountBusinessType) {
        TenantContext.setTenant((String)elsAccount);
        List<CountVO> countVOList = this.queryTabsCount();
        return countVOList.stream().filter(countVO -> standardStatusList.contains(countVO.getValue()) && countVO.getTotal() > 0).collect(Collectors.toList());
    }

    public List<CountVO> queryTabsCount() {
        ArrayList<CountVO> result = new ArrayList<CountVO>();
        QueryWrapper queryWrapper = QueryGenerator.initQueryWrapper((Object)((Object)new PurchaseBiddingHead()), new HashMap());
        queryWrapper.eq((Object)"create_type", (Object)"project");
        queryWrapper.select(new String[]{"bidding_status", "count(0) as participateQuantity"});
        queryWrapper.groupBy((Object)"bidding_status");
        List list = this.purchaseBiddingHeadService.list((Wrapper)queryWrapper);
        Map<String, Integer> countMap = list.stream().collect(Collectors.toMap(PurchaseBiddingHead::getBiddingStatus, PurchaseBiddingHead::getParticipateQuantity));
        Integer all = 0;
        for (Map.Entry<String, Integer> entry : countMap.entrySet()) {
            all = all + entry.getValue();
        }
        result.add(new CountVO(I18nUtil.translate((String)"i18n_title_all", (String)"\u5168\u90e8"), "biddingStatus", null, all));
        List srmRectificationAppealStatus = this.invokeBaseRpcService.queryDictItemsByCode("srmBiddingStatus", TenantContext.getTenant());
        for (DictDTO status : srmRectificationAppealStatus) {
            if (countMap.get(status.getValue()) == null) continue;
            result.add(new CountVO(I18nUtil.translate((String)status.getTextI18nKey(), (String)status.getText()), "biddingStatus", status.getValue(), countMap.get(status.getValue())));
        }
        return result;
    }

    public Integer countPurchaseMentoringHeadList(String elsAccount, List<String> statusList, String accountBusinessType) {
        this.permissionDataQueryUtil.initPermissionData(accountBusinessType);
        PurchaseMentoringHeadService purchaseMentoringHeadService = (PurchaseMentoringHeadService)SpringContextUtils.getBean(PurchaseMentoringHeadService.class);
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"els_account", (Object)elsAccount);
        queryWrapper.in((Object)"view_status", statusList);
        queryWrapper.eq((Object)"is_deleted", (Object)0);
        int count = purchaseMentoringHeadService.count((Wrapper)queryWrapper);
        return count;
    }

    public Integer countSaleClarificationInfoListList(String elsAccount, List<String> statusList, String accountBusinessType) {
        this.permissionDataQueryUtil.initPermissionData(accountBusinessType);
        SaleClarificationInfoService saleClarificationInfoService = (SaleClarificationInfoService)SpringContextUtils.getBean(SaleClarificationInfoService.class);
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"els_account", (Object)elsAccount);
        queryWrapper.in((Object)"view_status", statusList);
        queryWrapper.eq((Object)"is_deleted", (Object)0);
        int count = saleClarificationInfoService.count((Wrapper)queryWrapper);
        return count;
    }

    public Integer countSaleMentoringHeadList(String elsAccount, List<String> statusList, String accountBusinessType) {
        this.permissionDataQueryUtil.initPermissionData(accountBusinessType);
        SaleMentoringHeadService saleMentoringHeadService = (SaleMentoringHeadService)SpringContextUtils.getBean(SaleMentoringHeadService.class);
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"els_account", (Object)elsAccount);
        queryWrapper.in((Object)"submit_status", statusList);
        queryWrapper.eq((Object)"is_deleted", (Object)0);
        int count = saleMentoringHeadService.count((Wrapper)queryWrapper);
        return count;
    }

    public Integer countTenderProjectSignUpList(String elsAccount, List<String> statusList, String accountBusinessType) {
        this.permissionDataQueryUtil.initPermissionData(accountBusinessType);
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.in((Object)"status", statusList);
        queryWrapper.eq((Object)"els_account", (Object)elsAccount);
        queryWrapper.eq((Object)"is_deleted", (Object)0);
        return this.tenderProjectSignUpService.count((Wrapper)queryWrapper);
    }

    public Integer countSaleForecastSheetList(String elsAccount, List<String> standardStatusList, String accountBusinessType) {
        this.permissionDataQueryUtil.initPermissionData(accountBusinessType);
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.lambda().in(SaleForecastHead::getConfirm, standardStatusList);
        queryWrapper.eq((Object)"els_account", (Object)elsAccount);
        queryWrapper.eq((Object)"is_deleted", (Object)0);
        return this.saleForecastHeadService.count((Wrapper)queryWrapper);
    }
}

