/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.bidding.api.service.impl;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.text.CharSequenceUtil;
import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.els.common.aspect.annotation.RpcService;
import com.els.common.im.ImBaseUserRecordRpcService;
import com.els.modules.account.api.dto.ImUserDTO;
import com.els.modules.bidding.entity.BiddingSupplier;
import com.els.modules.bidding.entity.PurchaseBiddingHead;
import com.els.modules.bidding.entity.PurchaseBiddingSpecialist;
import com.els.modules.bidding.enumerate.BiddingStatusEnum;
import com.els.modules.bidding.enumerate.MemberTypeEnum;
import com.els.modules.bidding.service.BiddingSupplierService;
import com.els.modules.bidding.service.PurchaseBiddingHeadService;
import com.els.modules.bidding.service.PurchaseBiddingSpecialistService;
import com.els.modules.im.api.dto.ImRecordDto;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.beans.factory.annotation.Autowired;

@RpcService(value="purchaseBiddingProjectUserRecordServiceImpl")
public class PurchaseBiddingProjectUserRecordInvokeDubboServiceImpl
extends ImBaseUserRecordRpcService {
    @Autowired
    private PurchaseBiddingHeadService biddingHeadService;
    @Autowired
    private BiddingSupplierService biddingSupplierService;
    @Resource
    private PurchaseBiddingSpecialistService purchaseBiddingSpecialistService;

    public List<ImUserDTO> getRecordPersonInCharge(ImRecordDto imRecordDto) {
        ArrayList<ImUserDTO> resultList = new ArrayList<ImUserDTO>();
        List purchaseBiddingHeadList = ((LambdaQueryChainWrapper)this.biddingHeadService.lambdaQuery().eq(PurchaseBiddingHead::getProjectId, (Object)imRecordDto.getRecordId())).list();
        if (CollectionUtil.isEmpty((Collection)purchaseBiddingHeadList)) {
            return resultList;
        }
        for (PurchaseBiddingHead purchaseBiddingHead : purchaseBiddingHeadList) {
            List<ImUserDTO> userDTOList = this.getSupplier(purchaseBiddingHead);
            if (!CollectionUtil.isNotEmpty(userDTOList)) continue;
            resultList.addAll(userDTOList);
        }
        return resultList;
    }

    public List<ImUserDTO> getSupplier(PurchaseBiddingHead dbHead) {
        if (BiddingStatusEnum.CANCEL.getValue().equals(dbHead.getBiddingStatus()) || BiddingStatusEnum.NEW.getValue().equals(dbHead.getBiddingStatus())) {
            return null;
        }
        List<BiddingSupplier> biddingSupplierList = this.biddingSupplierService.selectByMainId(dbHead.getId());
        List<PurchaseBiddingSpecialist> purchaseBiddingSpecialistList = this.purchaseBiddingSpecialistService.selectByMainId(dbHead.getId());
        List supplierList = this.queryAllUserWithGroupChat(biddingSupplierList.stream().map(BiddingSupplier::getToElsAccount).filter(CharSequenceUtil::isNotEmpty).collect(Collectors.toList()));
        for (ImUserDTO dto : supplierList) {
            dto.setGroupName(dbHead.getBiddingDesc() + "\u4f9b\u5e94\u5546");
        }
        List memberList = purchaseBiddingSpecialistList.stream().map(supplier -> {
            ImUserDTO imUserDTO = new ImUserDTO();
            imUserDTO.setElsAccount(supplier.getElsAccount() + "_" + supplier.getSubAccount());
            imUserDTO.setGroupName(dbHead.getBiddingDesc() + MemberTypeEnum.getMemberTypeDesc(supplier.getMemberType()));
            return imUserDTO;
        }).collect(Collectors.toList());
        supplierList.addAll(memberList);
        return supplierList;
    }
}

