/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.bidding.api.service.impl;

import cn.hutool.core.text.CharSequenceUtil;
import com.els.common.aspect.annotation.RpcService;
import com.els.common.im.ImBaseUserRecordRpcService;
import com.els.common.util.I18nUtil;
import com.els.modules.account.api.dto.ImUserDTO;
import com.els.modules.bidding.entity.BiddingSupplier;
import com.els.modules.bidding.entity.PurchaseBiddingHead;
import com.els.modules.bidding.entity.PurchaseBiddingSpecialist;
import com.els.modules.bidding.enumerate.BiddingStatusEnum;
import com.els.modules.bidding.enumerate.MemberTypeEnum;
import com.els.modules.bidding.service.BiddingSupplierService;
import com.els.modules.bidding.service.PurchaseBiddingHeadService;
import com.els.modules.bidding.service.PurchaseBiddingSpecialistService;
import com.els.modules.im.api.dto.ImRecordDto;
import java.io.Serializable;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.util.Assert;

@RpcService(value="purchaseBiddingImUserRecordServiceImpl")
public class PurchaseBiddingUserRecordInvokeDubboServiceImpl
extends ImBaseUserRecordRpcService {
    @Resource
    private PurchaseBiddingHeadService purchaseBiddingHeadService;
    @Resource
    private BiddingSupplierService biddingSupplierService;
    @Resource
    private PurchaseBiddingSpecialistService purchaseBiddingSpecialistService;

    public List<ImUserDTO> getRecordPersonInCharge(ImRecordDto imRecordDto) {
        PurchaseBiddingHead dbHead = (PurchaseBiddingHead)((Object)this.purchaseBiddingHeadService.getById((Serializable)((Object)imRecordDto.getRecordId())));
        Assert.isTrue((null != dbHead ? 1 : 0) != 0, (String)I18nUtil.translate((String)"i18n_alert_fail_bidding_record_id_no_found_bidding", (String)("\u62db\u6807\u5355[" + imRecordDto.getRecordId() + "]\u4e0d\u5b58\u5728"), (String[])new String[]{imRecordDto.getRecordId()}));
        Assert.isTrue((!BiddingStatusEnum.CANCEL.getValue().equals(dbHead.getBiddingStatus()) ? 1 : 0) != 0, (String)I18nUtil.translate((String)"i18n_alert_fail_bidding_is_invalid_bidding", (String)"\u62db\u6807\u5355\u5df2\u4f5c\u5e9f\u72b6\u6001\uff0c\u65e0\u6cd5\u6c9f\u901a"));
        Assert.isTrue((!BiddingStatusEnum.NEW.getValue().equals(dbHead.getBiddingStatus()) ? 1 : 0) != 0, (String)I18nUtil.translate((String)"i18n_alert_fail_bidding_status_is_new_bidding", (String)"\u62db\u6807\u5355\u65b0\u5efa\u72b6\u6001\uff0c\u65e0\u6cd5\u6c9f\u901a"));
        List<BiddingSupplier> biddingSupplierList = this.biddingSupplierService.selectByMainId(dbHead.getId());
        List<PurchaseBiddingSpecialist> purchaseBiddingSpecialistList = this.purchaseBiddingSpecialistService.selectByMainId(dbHead.getId());
        List supplierList = this.queryAllUserWithGroupChat(biddingSupplierList.stream().map(BiddingSupplier::getToElsAccount).filter(CharSequenceUtil::isNotEmpty).collect(Collectors.toList()));
        for (ImUserDTO dto : supplierList) {
            dto.setGroupName("\u4f9b\u5e94\u5546");
        }
        List memberList = purchaseBiddingSpecialistList.stream().map(supplier -> {
            ImUserDTO imUserDTO = new ImUserDTO();
            imUserDTO.setElsAccount(supplier.getElsAccount() + "_" + supplier.getSubAccount());
            imUserDTO.setGroupName(MemberTypeEnum.getMemberTypeDesc(supplier.getMemberType()));
            return imUserDTO;
        }).collect(Collectors.toList());
        supplierList.addAll(memberList);
        return supplierList;
    }
}

