/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.bidding.excel;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.StrUtil;
import com.els.common.aspect.annotation.RpcService;
import com.els.common.excel.service.ErrorExcelHandlerService;
import com.els.common.util.ConvertUtils;
import com.els.common.util.I18nUtil;
import com.els.config.mybatis.TenantContext;
import com.els.modules.base.api.dto.ExcelImportDTO;
import com.els.modules.base.api.dto.TemplateConfigItemDTO;
import com.els.modules.base.api.dto.TemplateHeadDTO;
import com.els.modules.base.api.service.ExcelItemByConfigRpcService;
import com.els.modules.bidding.entity.PurchaseBiddingHead;
import com.els.modules.bidding.entity.PurchaseBiddingItem;
import com.els.modules.bidding.service.PurchaseBiddingHeadService;
import com.els.modules.bidding.service.PurchaseBiddingItemService;
import com.els.modules.demand.rpc.PurchaseMaterialHeadLocalRpcService;
import com.els.modules.material.api.dto.PurchaseMaterialHeadDTO;
import com.els.modules.system.dto.ExcelByConfigDTO;
import com.els.rpc.service.InvokeBaseRpcService;
import com.google.common.collect.Lists;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

@RpcService(value="purchaseBiddingItemExcelRpcServiceImpl")
public class PurchaseBiddingItemExcelServiceImpl
extends ErrorExcelHandlerService
implements ExcelItemByConfigRpcService {
    private static final Logger log = LoggerFactory.getLogger(PurchaseBiddingItemExcelServiceImpl.class);
    @Autowired
    private PurchaseBiddingHeadService purchaseBiddingHeadService;
    @Autowired
    private PurchaseBiddingItemService purchaseBiddingItemService;
    @Resource
    private InvokeBaseRpcService invokeBaseRpcService;
    @Resource
    private PurchaseMaterialHeadLocalRpcService purchaseMaterialHeadLocalRpcService;
    private String headId;
    private String groupCode;
    private static final List<String> MATER_STRING = Lists.newArrayList((Object[])new String[]{"materialNumber", "materialName", "materialDesc", "materialSpec", "materialGroup", "materialGroupName", "cateCode", "cateName"});

    public TemplateHeadDTO getTemplate(ExcelByConfigDTO excelByConfigDTO) {
        String templateAccount = excelByConfigDTO.getTemplateAccount();
        String templateVersion = excelByConfigDTO.getTemplateVersion();
        String templateNumber = excelByConfigDTO.getTemplateNumber();
        this.groupCode = excelByConfigDTO.getGroupCode();
        if (StrUtil.isNotBlank((CharSequence)excelByConfigDTO.getHeadId()) && !"undefined".equals(excelByConfigDTO.getHeadId())) {
            this.headId = excelByConfigDTO.getHeadId();
            PurchaseBiddingHead dbHead = (PurchaseBiddingHead)((Object)this.purchaseBiddingHeadService.getById((Serializable)((Object)this.headId)));
            if (dbHead != null) {
                templateAccount = StrUtil.isNotBlank((CharSequence)dbHead.getTemplateAccount()) ? dbHead.getTemplateAccount() : dbHead.getElsAccount();
                templateVersion = String.valueOf(dbHead.getTemplateVersion());
                templateNumber = String.valueOf(dbHead.getTemplateNumber());
            }
        }
        return this.invokeBaseRpcService.getTemplateConfig(templateAccount, templateNumber, templateVersion);
    }

    public List<Object> getExportData(ExcelByConfigDTO excelByConfigDTO) {
        List<PurchaseBiddingItem> itemList = this.purchaseBiddingItemService.selectByMainId(excelByConfigDTO.getHeadId());
        return new ArrayList<PurchaseBiddingItem>(itemList);
    }

    public List<Map<String, Object>> importExcel(ExcelImportDTO excelImportDTO) {
        List dataList = excelImportDTO.getDataList();
        int totalCount = 0 == excelImportDTO.getTotalCount() ? dataList.size() : excelImportDTO.getTotalCount();
        ExcelByConfigDTO excelByConfigDTO = excelImportDTO.getExcelByConfigDTO();
        List configItemList = this.getTemplate(excelByConfigDTO).getTemplateConfigItemList();
        String[] excludeColumn = new String[]{"materialNumber", "taxCode"};
        List editColumn = configItemList.stream().map(TemplateConfigItemDTO::getFieldName).collect(Collectors.toList());
        if (StrUtil.isNotBlank((CharSequence)this.groupCode)) {
            editColumn = configItemList.stream().map(TemplateConfigItemDTO::getFieldName).collect(Collectors.toList());
        }
        editColumn.addAll(Arrays.asList(excludeColumn));
        Map taxMap = this.invokeBaseRpcService.getAllTax(TenantContext.getTenant());
        ArrayList<String> materialNumberList = new ArrayList<String>();
        Iterator iteratorMap = dataList.iterator();
        while (iteratorMap.hasNext()) {
            Map data = (Map)iteratorMap.next();
            HashMap errorData = new HashMap(data);
            String taxCode = (String)data.get("taxCode");
            if (StrUtil.isNotBlank((CharSequence)taxCode) && !taxMap.containsKey(taxCode)) {
                String msg = I18nUtil.translate((String)"i18n_alert_foWWWWWWWxMK_e919daf8", (String)"\u7a0e\u7801\uff1a[${0}]\u4e0d\u5b58\u5728", (String[])new String[]{taxCode});
                this.errorAdd(excelImportDTO, msg, errorData);
                iteratorMap.remove();
                continue;
            }
            String materialNumber = (String)data.get("materialNumber");
            if (!StrUtil.isNotBlank((CharSequence)materialNumber) || materialNumberList.contains(materialNumber)) continue;
            materialNumberList.add(materialNumber);
        }
        List<Object> materialList = CollectionUtil.isNotEmpty(materialNumberList) ? this.purchaseMaterialHeadLocalRpcService.listByMaterialNumbers(materialNumberList) : Lists.newArrayList();
        Map materialMap = materialList.stream().collect(Collectors.toMap(PurchaseMaterialHeadDTO::getMaterialNumber, Function.identity(), (v1, v2) -> v2));
        Field[] fields = ConvertUtils.getAllFields(PurchaseMaterialHeadDTO.class);
        Iterator iterator = dataList.iterator();
        while (iterator.hasNext()) {
            String materialNumber;
            Map data = (Map)iterator.next();
            HashMap errorData = new HashMap(data);
            List finalEditColumn = editColumn;
            data.forEach((key, value) -> {
                if (!finalEditColumn.contains(key)) {
                    data.put(key, null);
                }
            });
            String taxCode = (String)data.get("taxCode");
            if (StrUtil.isNotBlank((CharSequence)taxCode)) {
                data.put("taxRate", taxMap.get(taxCode));
            }
            if (!StrUtil.isNotBlank((CharSequence)(materialNumber = (String)data.get("materialNumber")))) continue;
            PurchaseMaterialHeadDTO materialHead = (PurchaseMaterialHeadDTO)materialMap.get(materialNumber);
            if (null == materialHead) {
                String msg = I18nUtil.translate((String)"i18n_alert_SLAoWWWWWWWxMK_44822940", (String)"\u7269\u6599\u7f16\u7801\uff1a[${0}]\u4e0d\u5b58\u5728", (String[])new String[]{materialNumber});
                this.errorAdd(excelImportDTO, msg, errorData);
                iterator.remove();
                continue;
            }
            data.put("materialId", materialHead.getId());
            for (Field field : fields) {
                if (!data.containsKey(field.getName()) || !MATER_STRING.contains(field.getName())) continue;
                try {
                    field.setAccessible(true);
                    data.put(field.getName(), field.get(materialHead));
                }
                catch (IllegalAccessException e) {
                    log.error("\u53cd\u5c04\u83b7\u53d6\u503c\u5f02\u5e38", (Throwable)e);
                }
            }
        }
        this.errorHandle(true, excelImportDTO, TenantContext.getTenant(), totalCount);
        return dataList;
    }
}

