/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.demand.api.impl;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.convert.Convert;
import cn.hutool.core.text.CharSequenceUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.els.common.aspect.annotation.RpcService;
import com.els.common.constant.CommonConstant;
import com.els.common.excel.ExcelExportClassColumnDTO;
import com.els.common.exception.ELSBootException;
import com.els.common.system.base.entity.BaseEntity;
import com.els.common.util.ClassTypeBuilder;
import com.els.common.util.SysUtil;
import com.els.config.mybatis.TenantContext;
import com.els.modules.base.api.dto.TemplateConfigHeadDTO;
import com.els.modules.base.api.dto.TemplateConfigItemDTO;
import com.els.modules.base.api.dto.TemplateHeadDTO;
import com.els.modules.base.api.service.OpenApiRpcService;
import com.els.modules.demand.entity.PurchaseRequestHead;
import com.els.modules.demand.entity.PurchaseRequestItem;
import com.els.modules.demand.service.PurchaseRequestHeadService;
import com.els.modules.demand.service.PurchaseRequestItemService;
import com.els.modules.demand.vo.PurchaseRequestHeadVO;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

@RpcService(value="purchaseRequest_update")
public class PurchaseRequestUpdateOpenServiceImpl
implements OpenApiRpcService {
    private static final Logger log = LoggerFactory.getLogger(PurchaseRequestUpdateOpenServiceImpl.class);
    @Autowired
    private PurchaseRequestHeadService purchaseRequestHeadService;
    @Autowired
    private PurchaseRequestItemService purchaseRequestItemService;

    public JSONObject doCreateInvoke(JSONArray array, TemplateHeadDTO templateHead, Map<String, String> defaultHeadMap, Map<String, String> defaultItemMap) {
        String account = TenantContext.getTenant();
        Date currentTime = new Date();
        ArrayList<PurchaseRequestHead> headList = new ArrayList<PurchaseRequestHead>();
        ArrayList allItem = new ArrayList();
        JSONArray headArray = new JSONArray();
        for (Object obj : array) {
            JSONObject object = (JSONObject)Convert.convert(JSONObject.class, obj);
            if (object.size() == 0) continue;
            PurchaseRequestHead head = (PurchaseRequestHead)((Object)JSON.parseObject((String)object.toString(), PurchaseRequestHead.class));
            head.setElsAccount(account);
            head.setTemplateName(templateHead.getTemplateName());
            head.setTemplateNumber(templateHead.getTemplateNumber());
            head.setTemplateVersion("" + templateHead.getTemplateVersion());
            head.setTemplateAccount(templateHead.getElsAccount());
            if (CharSequenceUtil.isEmpty((CharSequence)head.getId())) {
                throw new ELSBootException("headId is empty!");
            }
            headList.add(head);
            JSONObject headObj = SysUtil.objectToJSON((Object)((Object)head));
            headArray.add((Object)headObj);
            List itemList = null;
            JSONArray itemListJsonArray = null;
            if (object.containsKey((Object)"purchaseRequestItemList")) {
                itemListJsonArray = object.getJSONArray("purchaseRequestItemList");
            } else if (object.containsKey((Object)"itemList")) {
                itemListJsonArray = object.getJSONArray("itemList");
            }
            try {
                if (null == itemListJsonArray || itemListJsonArray.isEmpty() || null == (itemList = JSON.parseArray((String)itemListJsonArray.toJSONString(), PurchaseRequestItem.class))) continue;
                for (PurchaseRequestItem item : itemList) {
                    item.setHeadId(head.getId());
                    item.setElsAccount(account);
                    item.setCreateTime(currentTime);
                    item.setHeadId(head.getId());
                    item.setDeleted(CommonConstant.DEL_FLAG_0);
                    BeanUtil.copyProperties(defaultItemMap, (Object)((Object)item), (String[])new String[0]);
                }
                allItem.addAll(itemList);
            }
            catch (Exception e) {
                log.error("{}==>ItemList\u6570\u636e\u683c\u5f0f\u5f02\u5e38:{}", (Object)this.getBusinessType(), (Object)e.getMessage());
            }
        }
        if (CollectionUtil.isNotEmpty(headList)) {
            List<String> headIds = headList.stream().map(BaseEntity::getId).collect(Collectors.toList());
            this.purchaseRequestItemService.deleteByHeadIds(headIds);
        }
        if (!headList.isEmpty()) {
            this.purchaseRequestHeadService.updateBatchById(headList, 2000);
        }
        if (!allItem.isEmpty()) {
            this.purchaseRequestItemService.saveBatch(allItem, 2000);
        }
        List collect = headList.stream().map(x -> (PurchaseRequestHeadVO)((Object)((Object)Convert.convert(PurchaseRequestHeadVO.class, (Object)x)))).collect(Collectors.toList());
        Map<String, List<PurchaseRequestItem>> itemMap = allItem.stream().collect(Collectors.groupingBy(PurchaseRequestItem::getHeadId));
        for (PurchaseRequestHeadVO vo : collect) {
            vo.setPurchaseRequestItemList(itemMap.get(vo.getId()));
        }
        JSONObject resultObj = new JSONObject();
        resultObj.put("headList", collect);
        return resultObj;
    }

    public void doParamCheck(JSONArray array, TemplateHeadDTO templateHead, Map<String, String> defaultHeadMap, Map<String, String> defaultItemMap, List<TemplateConfigHeadDTO> configHeadList, List<TemplateConfigItemDTO> configItemList) {
    }

    public String getBusinessType() {
        return "purchaseRequest";
    }

    public List<ExcelExportClassColumnDTO> getBusinessClass() {
        return ClassTypeBuilder.buildClassTypeList(PurchaseRequestHeadVO.class, null, null);
    }

    public List<String> supportItemList() {
        return Lists.newArrayList((Object[])new String[]{"purchaseRequestItemList"});
    }
}

