/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.demand.utils;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.els.common.aspect.annotation.SrmTransaction;
import com.els.common.enumerate.AuditStatusEnum;
import com.els.common.exception.ELSBootException;
import com.els.common.system.base.entity.BaseEntity;
import com.els.common.util.I18nUtil;
import com.els.common.util.SpringContextUtils;
import com.els.modules.demand.entity.PurchaseRequestHead;
import com.els.modules.demand.entity.PurchaseRequestItem;
import com.els.modules.demand.enumerate.PurchaseRequestStatusItemEnum;
import com.els.modules.demand.rpc.PurchaseInformationRecordsLocalRpcService;
import com.els.modules.demand.service.PurchaseRequestHeadService;
import com.els.modules.demand.service.PurchaseRequestItemService;
import com.els.modules.inquiry.rpc.service.InquiryInvokeMainDataRpcService;
import com.els.modules.inquiry.rpc.service.InquiryInvokeOrderRpcService;
import com.els.modules.material.api.dto.PurchaseMaterialHeadDTO;
import com.els.modules.material.api.dto.PurchaseMaterialItemDTO;
import com.els.modules.material.api.dto.PurchaseMaterialSourceDTO;
import com.els.modules.order.api.dto.PurchaseOrderGenarateConfigDTO;
import com.els.modules.price.api.dto.PurchaseInformationRecordsDTO;
import com.els.modules.price.api.enumerate.PriceStatusEnum;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;

@Component
public class RequestItemUtils {
    private static final Logger log = LoggerFactory.getLogger(RequestItemUtils.class);

    public void validRequestItemStatus(List<PurchaseRequestItem> purchaseRequestItemList) {
        for (PurchaseRequestItem requestItem : purchaseRequestItemList) {
            if (!PurchaseRequestStatusItemEnum.DEMAND_CLOSED.getValue().equals(requestItem.getItemStatus())) continue;
            throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_nRUV0c1IRl_ccc5986b", (String)"\u91c7\u8d2d\u7533\u8bf7${0}\u884c${1}\u5df2\u5173\u95ed", (String[])new String[]{requestItem.getRequestNumber(), requestItem.getItemNumber()}));
        }
    }

    @SrmTransaction(rollbackFor={Exception.class})
    public void toDemandPoolRules(List<PurchaseRequestItem> purchaseRequestItemList) {
        PurchaseRequestHeadService requestHeadService = (PurchaseRequestHeadService)SpringContextUtils.getBean(PurchaseRequestHeadService.class);
        Set headIdList = purchaseRequestItemList.stream().map(PurchaseRequestItem::getHeadId).collect(Collectors.toSet());
        List requestHeadList = ((LambdaQueryChainWrapper)requestHeadService.lambdaQuery().in(BaseEntity::getId, headIdList)).list();
        this.queryOrderGenrateConfigByMap(requestHeadList, purchaseRequestItemList, false);
        this.querySourceListControl(requestHeadList, purchaseRequestItemList);
        Map<String, PurchaseMaterialSourceDTO> sourceDTOMap = this.querySourceList(purchaseRequestItemList);
        this.queryPrice(sourceDTOMap, purchaseRequestItemList);
    }

    @SrmTransaction(rollbackFor={Exception.class})
    public void queryPrice(Map<String, PurchaseMaterialSourceDTO> sourceDTOMap, List<PurchaseRequestItem> purchaseRequestItemList) {
        PurchaseInformationRecordsLocalRpcService purchaseInformationRecordsService = (PurchaseInformationRecordsLocalRpcService)SpringContextUtils.getBean(PurchaseInformationRecordsLocalRpcService.class);
        PurchaseRequestItemService requestItemService = (PurchaseRequestItemService)SpringContextUtils.getBean(PurchaseRequestItemService.class);
        if (CollectionUtils.isEmpty(purchaseRequestItemList)) {
            return;
        }
        Map<String, List> requestItemMap = purchaseRequestItemList.stream().collect(Collectors.toMap(p -> p.getMaterialNumber() + "_," + p.getPurchaseOrg() + "_," + p.getFactory(), p -> {
            ArrayList<PurchaseRequestItem> getNameList = new ArrayList<PurchaseRequestItem>();
            getNameList.add((PurchaseRequestItem)((Object)p));
            return getNameList;
        }, (value1, value2) -> {
            value1.addAll(value2);
            return value1;
        }));
        log.info("matchPrice,stringList:{}", requestItemMap.keySet());
        if (CollectionUtil.isEmpty(requestItemMap)) {
            return;
        }
        ArrayList<PurchaseRequestItem> updateRequestItemList = new ArrayList<PurchaseRequestItem>();
        for (String key : requestItemMap.keySet()) {
            List requestItemList = requestItemMap.get(key);
            String materialNumber = ((PurchaseRequestItem)((Object)requestItemList.get(0))).getMaterialNumber();
            String purchaseOrg = ((PurchaseRequestItem)((Object)requestItemList.get(0))).getPurchaseOrg();
            String factory = ((PurchaseRequestItem)((Object)requestItemList.get(0))).getFactory();
            List<PurchaseInformationRecordsDTO> purchaseInformationRecordsDTOS = purchaseInformationRecordsService.selectList(null, AuditStatusEnum.AUDIT_FINISH.getValue(), PriceStatusEnum.NORMAL.getValue(), new Date(), new Date(), materialNumber, purchaseOrg, null);
            for (PurchaseRequestItem item : requestItemList) {
                PurchaseRequestItem requestItem = new PurchaseRequestItem();
                requestItem.setId(item.getId());
                requestItem.setPriceController(item.getPriceController());
                requestItem.setCatalog(item.getCatalog());
                requestItem.setSourceListControl(item.getSourceListControl());
                requestItem.setSourceListResult(item.getSourceListResult());
                List recordsDTOList = null;
                if ("1".equals(item.getSourceListControl())) {
                    PurchaseMaterialSourceDTO purchaseMaterialSourceDTO = sourceDTOMap.get(item.getId());
                    if (purchaseMaterialSourceDTO != null) {
                        recordsDTOList = purchaseInformationRecordsDTOS.stream().filter(record -> StrUtil.isBlank((CharSequence)factory) || StrUtil.isNotBlank((CharSequence)factory) && factory.equals(record.getFactory())).filter(record -> record.getToElsAccount().equals(purchaseMaterialSourceDTO.getToElsAccount())).collect(Collectors.toList());
                    }
                } else {
                    recordsDTOList = purchaseInformationRecordsDTOS.stream().filter(record -> StrUtil.isNotBlank((CharSequence)factory) && factory.equals(record.getFactory())).filter(record -> item.getPurchaseType().equals(record.getRecordType())).collect(Collectors.toList());
                    if (CollectionUtil.isEmpty(recordsDTOList)) {
                        recordsDTOList = purchaseInformationRecordsDTOS.stream().filter(record -> item.getPurchaseType().equals(record.getRecordType())).collect(Collectors.toList());
                    }
                }
                if (CollectionUtil.isNotEmpty(recordsDTOList)) {
                    requestItem.setPriceResult("1");
                    requestItem.setItemStatus(PurchaseRequestStatusItemEnum.WAIT_ORDER.getValue());
                    updateRequestItemList.add(requestItem);
                    continue;
                }
                requestItem.setPriceResult("0");
                requestItem.setItemStatus(PurchaseRequestStatusItemEnum.DEMAND_POOL.getValue());
                updateRequestItemList.add(requestItem);
            }
        }
        requestItemService.updateBatchById(updateRequestItemList);
    }

    public void addMaterialRequestInfoToMap(Map<String, List<PurchaseInformationRecordsDTO>> informationRecordsMap, List<PurchaseRequestItem> purchaseRequestItemList) {
        if (CollectionUtils.isEmpty(purchaseRequestItemList)) {
            return;
        }
        PurchaseInformationRecordsLocalRpcService purchaseInformationRecordsService = (PurchaseInformationRecordsLocalRpcService)SpringContextUtils.getBean(PurchaseInformationRecordsLocalRpcService.class);
        Map<String, PurchaseMaterialSourceDTO> sourceDTOMap = this.querySourceList(purchaseRequestItemList);
        Map<String, List> requestItemMap = purchaseRequestItemList.stream().collect(Collectors.toMap(p -> p.getMaterialNumber() + "_," + p.getPurchaseOrg() + "_," + p.getFactory(), p -> {
            ArrayList<PurchaseRequestItem> getNameList = new ArrayList<PurchaseRequestItem>();
            getNameList.add((PurchaseRequestItem)((Object)p));
            return getNameList;
        }, (value1, value2) -> {
            value1.addAll(value2);
            return value1;
        }));
        log.info("matchPrice,stringList:{}", requestItemMap.keySet());
        if (CollectionUtil.isEmpty(requestItemMap)) {
            return;
        }
        for (String key : requestItemMap.keySet()) {
            List requestItemList = requestItemMap.get(key);
            String materialNumber = ((PurchaseRequestItem)((Object)requestItemList.get(0))).getMaterialNumber();
            String purchaseOrg = ((PurchaseRequestItem)((Object)requestItemList.get(0))).getPurchaseOrg();
            String factory = ((PurchaseRequestItem)((Object)requestItemList.get(0))).getFactory();
            List<PurchaseInformationRecordsDTO> purchaseInformationRecordsDTOS = purchaseInformationRecordsService.selectList(null, AuditStatusEnum.AUDIT_FINISH.getValue(), PriceStatusEnum.NORMAL.getValue(), new Date(), new Date(), materialNumber, purchaseOrg, null);
            for (PurchaseRequestItem item : requestItemList) {
                PurchaseRequestItem requestItem = new PurchaseRequestItem();
                requestItem.setId(item.getId());
                requestItem.setPriceController(item.getPriceController());
                requestItem.setCatalog(item.getCatalog());
                requestItem.setSourceListControl(item.getSourceListControl());
                requestItem.setSourceListResult(item.getSourceListResult());
                List recordsDTOList = null;
                if ("1".equals(item.getSourceListControl())) {
                    PurchaseMaterialSourceDTO purchaseMaterialSourceDTO = sourceDTOMap.get(item.getId());
                    Assert.notNull((Object)purchaseMaterialSourceDTO, (String)I18nUtil.translate((String)"i18n_alert_SLy0AjSjVtVRBjYuSjVt_971c65b3", (String)"\u7269\u6599\u53f7${0}\u542f\u7528\u8d27\u6e90\u6e05\u5355\u63a7\u5236\uff0c\u6ca1\u6709\u627e\u5230\u8d27\u6e90\u6e05\u5355", (String[])new String[]{item.getMaterialNumber()}));
                    recordsDTOList = purchaseInformationRecordsDTOS.stream().filter(record -> StrUtil.isBlank((CharSequence)factory) || StrUtil.isNotBlank((CharSequence)factory) && factory.equals(record.getFactory())).filter(record -> record.getToElsAccount().equals(purchaseMaterialSourceDTO.getToElsAccount())).collect(Collectors.toList());
                    log.info("matchPrice-\u8d27\u6e90\u6e05\u5355\u63a7\u5236=Y:{}", (Object)JSON.toJSONString(recordsDTOList));
                } else {
                    recordsDTOList = purchaseInformationRecordsDTOS.stream().filter(record -> StrUtil.isNotBlank((CharSequence)factory) && factory.equals(record.getFactory())).filter(record -> item.getPurchaseType().equals(record.getRecordType())).collect(Collectors.toList());
                    log.info("matchPrice-\u8d27\u6e90\u6e05\u5355\u63a7\u5236=N,step1:{}", (Object)JSON.toJSONString(recordsDTOList));
                    if (CollectionUtil.isEmpty(recordsDTOList)) {
                        recordsDTOList = purchaseInformationRecordsDTOS.stream().filter(record -> item.getPurchaseType().equals(record.getRecordType())).collect(Collectors.toList());
                        log.info("matchPrice-\u8d27\u6e90\u6e05\u5355\u63a7\u5236=N,step2:{}", (Object)JSON.toJSONString(recordsDTOList));
                    }
                }
                informationRecordsMap.put(key, recordsDTOList);
            }
        }
    }

    public Map<String, PurchaseMaterialSourceDTO> querySourceList(List<PurchaseRequestItem> purchaseRequestItemList) {
        Set<String> materialNumberPurchaseOrg = purchaseRequestItemList.stream().map(item -> item.getMaterialNumber() + "_" + item.getPurchaseOrg()).collect(Collectors.toSet());
        InquiryInvokeMainDataRpcService mainDataRpcService = (InquiryInvokeMainDataRpcService)SpringContextUtils.getBean(InquiryInvokeMainDataRpcService.class);
        List<PurchaseMaterialSourceDTO> materialSourceDTOList = mainDataRpcService.selectSourceListByMaterialNumberPurchaseOrg(materialNumberPurchaseOrg);
        HashMap<CallSite, PurchaseMaterialSourceDTO> sourceMaterialNumberPurchaseOrgMap = new HashMap<CallSite, PurchaseMaterialSourceDTO>();
        HashMap<CallSite, PurchaseMaterialSourceDTO> sourceMaterialNumberPurchaseOrgFactoryMap = new HashMap<CallSite, PurchaseMaterialSourceDTO>();
        for (PurchaseMaterialSourceDTO purchaseMaterialSourceDTO : materialSourceDTOList) {
            sourceMaterialNumberPurchaseOrgMap.put((CallSite)((Object)(purchaseMaterialSourceDTO.getMaterialNumber() + "_" + purchaseMaterialSourceDTO.getPurchaseOrg())), purchaseMaterialSourceDTO);
            sourceMaterialNumberPurchaseOrgFactoryMap.put((CallSite)((Object)(purchaseMaterialSourceDTO.getMaterialNumber() + "_" + purchaseMaterialSourceDTO.getPurchaseOrg() + "_" + purchaseMaterialSourceDTO.getFactory())), purchaseMaterialSourceDTO);
        }
        HashMap<String, PurchaseMaterialSourceDTO> sourceDTOMap = new HashMap<String, PurchaseMaterialSourceDTO>();
        for (PurchaseRequestItem item2 : purchaseRequestItemList) {
            if (sourceMaterialNumberPurchaseOrgMap.containsKey(item2.getMaterialNumber() + "_" + item2.getPurchaseOrg())) {
                item2.setSourceListResult("1");
                sourceDTOMap.put(item2.getId(), (PurchaseMaterialSourceDTO)sourceMaterialNumberPurchaseOrgMap.get(item2.getMaterialNumber() + "_" + item2.getPurchaseOrg()));
                continue;
            }
            if (sourceMaterialNumberPurchaseOrgFactoryMap.containsKey(item2.getMaterialNumber() + "_" + item2.getPurchaseOrg() + "_" + item2.getFactory())) {
                item2.setSourceListResult("1");
                sourceDTOMap.put(item2.getId(), (PurchaseMaterialSourceDTO)sourceMaterialNumberPurchaseOrgFactoryMap.get(item2.getMaterialNumber() + "_" + item2.getPurchaseOrg() + "_" + item2.getFactory()));
                continue;
            }
            item2.setSourceListResult("0");
        }
        return sourceDTOMap;
    }

    public void querySourceListControl(List<PurchaseRequestHead> requestHeadList, List<PurchaseRequestItem> purchaseRequestItemList) {
        InquiryInvokeMainDataRpcService mainDataRpcService = (InquiryInvokeMainDataRpcService)SpringContextUtils.getBean(InquiryInvokeMainDataRpcService.class);
        List<String> materialNumberSet = purchaseRequestItemList.stream().map(PurchaseRequestItem::getMaterialNumber).distinct().collect(Collectors.toList());
        List<PurchaseMaterialItemDTO> materialItemDTOList = mainDataRpcService.selectItemByMaterialNumberList(materialNumberSet);
        Map materialItemDTOMap = materialItemDTOList.stream().collect(Collectors.toMap(item -> item.getMaterialNumber() + "_" + item.getFactory(), Function.identity(), (o1, o2) -> o2));
        List<PurchaseMaterialHeadDTO> headDTOList = mainDataRpcService.selectByMaterialNumberList(materialNumberSet);
        Map materialHeadDTOMap = headDTOList.stream().collect(Collectors.toMap(PurchaseMaterialHeadDTO::getMaterialNumber, Function.identity()));
        for (PurchaseRequestItem purchaseRequestItem : purchaseRequestItemList) {
            String key = purchaseRequestItem.getMaterialNumber() + "_" + purchaseRequestItem.getFactory();
            PurchaseMaterialItemDTO purchaseMaterialItemDTO = (PurchaseMaterialItemDTO)materialItemDTOMap.get(key);
            if (purchaseMaterialItemDTO != null) {
                purchaseRequestItem.setCatalog(purchaseMaterialItemDTO.getCatalog());
                purchaseRequestItem.setSourceListControl(purchaseMaterialItemDTO.getSource());
                continue;
            }
            PurchaseMaterialHeadDTO purchaseMaterialHeadDTO = (PurchaseMaterialHeadDTO)materialHeadDTOMap.get(purchaseRequestItem.getMaterialNumber());
            if (purchaseMaterialHeadDTO == null) continue;
            purchaseRequestItem.setCatalog(purchaseMaterialHeadDTO.getCatalog());
            purchaseRequestItem.setSourceListControl(purchaseMaterialHeadDTO.getSource());
        }
    }

    public Map<String, Map<PurchaseOrderGenarateConfigDTO, List>> queryOrderGenrateConfigByMap(List<PurchaseRequestHead> purchaseRequestHeadList, List<PurchaseRequestItem> requestItemList, boolean throwException) {
        Map orderGenarateConfigDTOListMap;
        InquiryInvokeOrderRpcService inquiryInvokeOrderRpcService = (InquiryInvokeOrderRpcService)SpringContextUtils.getBean(InquiryInvokeOrderRpcService.class);
        HashMap<String, Map<PurchaseOrderGenarateConfigDTO, List>> orderGenerateMap = new HashMap<String, Map<PurchaseOrderGenarateConfigDTO, List>>();
        ArrayList<String> keys = new ArrayList<String>();
        if (CollectionUtil.isEmpty(requestItemList)) {
            return orderGenerateMap;
        }
        Map requestHeadMap = purchaseRequestHeadList.stream().collect(Collectors.toMap(PurchaseRequestHead::getRequestNumber, Function.identity()));
        for (PurchaseRequestItem requestItem : requestItemList) {
            PurchaseRequestHead requestHead = (PurchaseRequestHead)((Object)requestHeadMap.get(requestItem.getRequestNumber()));
            if (!ObjectUtil.isNotEmpty((Object)((Object)requestHead)) || keys.contains(requestHead.getRequestType())) continue;
            keys.add(requestHead.getRequestType());
        }
        if (CollectionUtils.isEmpty(keys)) {
            return orderGenerateMap;
        }
        List<PurchaseOrderGenarateConfigDTO> orderGenarateConfigDTOList = inquiryInvokeOrderRpcService.queryOrderGenrateConfigByRequestType(keys);
        if (CollectionUtil.isEmpty(orderGenarateConfigDTOList)) {
            throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_RiujTVzEujItbLERLVWVImKQLDIdjItbLER_e66e10c9", (String)"\u52fe\u9009\u5230\u7684\u9700\u6c42\u5339\u914d\u5230\u7684\u8ba2\u5355\u751f\u6210\u914d\u7f6e\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5\u662f\u5426\u7ef4\u62a4\u5bf9\u5e94\u7684\u8ba2\u5355\u751f\u6210\u914d\u7f6e"));
        }
        for (PurchaseOrderGenarateConfigDTO purchaseOrderGenarateConfigDTO : orderGenarateConfigDTOList) {
            String orderGenarateKey = purchaseOrderGenarateConfigDTO.getConfigTypeValue() + "_" + purchaseOrderGenarateConfigDTO.getPurchaseRequestType() + "_" + purchaseOrderGenarateConfigDTO.getItemPurchaseType();
            orderGenarateConfigDTOListMap = new HashMap();
            orderGenarateConfigDTOListMap.put(purchaseOrderGenarateConfigDTO, new ArrayList());
            orderGenerateMap.put(orderGenarateKey, orderGenarateConfigDTOListMap);
        }
        for (PurchaseRequestItem purchaseRequestItem : requestItemList) {
            List list;
            Set purchaseOrderGenarateConfigDTOS;
            PurchaseRequestHead requestHead = (PurchaseRequestHead)((Object)requestHeadMap.get(purchaseRequestItem.getRequestNumber()));
            purchaseRequestItem.setPriceController("0");
            if (orderGenerateMap.containsKey(purchaseRequestItem.getMaterialGroup() + "_" + requestHead.getRequestType() + "_" + purchaseRequestItem.getPurchaseType())) {
                orderGenarateConfigDTOListMap = (Map)orderGenerateMap.get(purchaseRequestItem.getMaterialGroup() + "_" + requestHead.getRequestType() + "_" + purchaseRequestItem.getPurchaseType());
                purchaseOrderGenarateConfigDTOS = orderGenarateConfigDTOListMap.keySet();
                list = (List)orderGenarateConfigDTOListMap.get(purchaseOrderGenarateConfigDTOS.iterator().next());
                list.add(purchaseRequestItem);
                for (PurchaseOrderGenarateConfigDTO configDTO : purchaseOrderGenarateConfigDTOS) {
                    purchaseRequestItem.setPriceController(configDTO.getPriceInfo());
                }
                continue;
            }
            if (orderGenerateMap.containsKey("_" + requestHead.getRequestType() + "_" + purchaseRequestItem.getPurchaseType())) {
                orderGenarateConfigDTOListMap = (Map)orderGenerateMap.get("_" + requestHead.getRequestType() + "_" + purchaseRequestItem.getPurchaseType());
                purchaseOrderGenarateConfigDTOS = orderGenarateConfigDTOListMap.keySet();
                list = (List)orderGenarateConfigDTOListMap.get(purchaseOrderGenarateConfigDTOS.iterator().next());
                list.add(purchaseRequestItem);
                for (PurchaseOrderGenarateConfigDTO configDTO : purchaseOrderGenarateConfigDTOS) {
                    purchaseRequestItem.setPriceController(configDTO.getPriceInfo());
                }
                continue;
            }
            if (!throwException) continue;
            throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_SLAoWWWWWWWBjIdjItbLER_2e968a29", (String)"\u7269\u6599\u7f16\u7801:[${0}]\u6ca1\u6709\u5bf9\u5e94\u7684\u8ba2\u5355\u751f\u6210\u914d\u7f6e", (String[])new String[]{purchaseRequestItem.getMaterialNumber()}));
        }
        return orderGenerateMap;
    }
}

