/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.ebidding.adapter;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.els.aspect.param.DictTranslateAspectParam;
import com.els.common.aspect.annotation.RpcService;
import com.els.common.enumerate.AuditStatusEnum;
import com.els.common.service.DictTranslateService;
import com.els.common.system.vo.MsgParamsVO;
import com.els.common.util.I18nUtil;
import com.els.common.util.MqUtil;
import com.els.common.util.SpringContextUtils;
import com.els.common.util.SysUtil;
import com.els.config.mybatis.TenantContext;
import com.els.modules.account.api.dto.ElsSubAccountDTO;
import com.els.modules.demand.enumerate.PurchaseRequestStatusItemEnum;
import com.els.modules.ebidding.entity.PurchaseEbiddingHead;
import com.els.modules.ebidding.entity.PurchaseEbiddingItem;
import com.els.modules.ebidding.entity.PurchaseEbiddingItemHis;
import com.els.modules.ebidding.entity.PurchaseEbiddingSupplier;
import com.els.modules.ebidding.enumerate.EbiddingItemStatusEnum;
import com.els.modules.ebidding.enumerate.EbiddingMethodEnum;
import com.els.modules.ebidding.enumerate.EbiddingWayEnum;
import com.els.modules.ebidding.service.PurchaseEbiddingHeadService;
import com.els.modules.ebidding.service.PurchaseEbiddingItemHisService;
import com.els.modules.ebidding.service.PurchaseEbiddingItemService;
import com.els.modules.ebidding.service.PurchaseEbiddingSupplierService;
import com.els.modules.ebidding.vo.PurchaseEbiddingHeadVO;
import com.els.modules.inquiry.enumerate.PriceCreateWayEnum;
import com.els.modules.workflow.dto.AuditInputParamDTO;
import com.els.modules.workflow.dto.AuditOutputParamDTO;
import com.els.modules.workflow.enums.WorkFlowType;
import com.els.modules.workflow.rpc.service.AuditOptCallBackService;
import com.els.rpc.service.InvokeAccountRpcService;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.Assert;

@RpcService(value="resultEbiddingRpcAdapter")
public class ResultEbiddingAdapter
implements AuditOptCallBackService {
    @Autowired
    private PurchaseEbiddingHeadService purchaseEbiddingHeadService;
    @Autowired
    private PurchaseEbiddingItemService purchaseEbiddingItemService;
    @Autowired
    private PurchaseEbiddingItemHisService purchaseEbiddingItemHisService;
    @Autowired
    private PurchaseEbiddingSupplierService purchaseEbiddingSupplierService;
    @Resource
    private InvokeAccountRpcService invokeAccountRpcService;

    public void startCallBack(AuditInputParamDTO inputParamVO, AuditOutputParamDTO outputParamVO) {
        this.updateAuditStatus(inputParamVO, outputParamVO);
        Object operataion = "resultSubmitAudit";
        if (WorkFlowType.BPMN.getValue().equals(outputParamVO.getBpmnType())) {
            operataion = outputParamVO.getBpmnType() + "_resultSubmitAudit";
        }
        this.sendMsg(inputParamVO, outputParamVO, (String)operataion);
    }

    public void completeCallBack(AuditInputParamDTO inputParamVO, AuditOutputParamDTO outputParamVO) {
        this.updateAuditStatus(inputParamVO, outputParamVO);
        if (AuditStatusEnum.AUDIT_FINISH.getValue().equals(outputParamVO.getAuditStatus())) {
            PurchaseEbiddingHead dbHead = (PurchaseEbiddingHead)((Object)this.purchaseEbiddingHeadService.getById((Serializable)((Object)inputParamVO.getBusinessId())));
            if (EbiddingMethodEnum.DUTCH.getValue().equals(dbHead.getEbiddingMethod()) && "1".equals(dbHead.getAllowModifyQuantity()) && EbiddingWayEnum.SINGLE.getValue().equals(dbHead.getEbiddingWay())) {
                List<PurchaseEbiddingItemHis> itemList = this.purchaseEbiddingItemHisService.selectByMainId(dbHead.getId());
                if (PriceCreateWayEnum.AUTO.getValue().equals(dbHead.getPriceCreateWay())) {
                    List<PurchaseEbiddingItemHis> acceptList = itemList.stream().filter(item -> EbiddingItemStatusEnum.BID_WIN.getValue().equals(item.getItemStatus())).collect(Collectors.toList());
                    this.purchaseEbiddingHeadService.generatePriceRecordByHis(dbHead, acceptList);
                }
                List<PurchaseEbiddingSupplier> supplierList = this.purchaseEbiddingSupplierService.selectByMainId(dbHead.getId());
                this.purchaseEbiddingHeadService.pricedByHis(dbHead, itemList, supplierList);
                List ids = itemList.stream().map(PurchaseEbiddingItemHis::getItemId).distinct().collect(Collectors.toList());
                List byIds = this.purchaseEbiddingItemService.listByIds(ids);
                this.purchaseEbiddingHeadService.goBackDemand(byIds, PurchaseRequestStatusItemEnum.COMPLETION_OF_THE_AUCTION.getValue());
            } else {
                List<PurchaseEbiddingItem> itemList = this.purchaseEbiddingItemService.selectByMainId(dbHead.getId());
                if (PriceCreateWayEnum.AUTO.getValue().equals(dbHead.getPriceCreateWay())) {
                    List<PurchaseEbiddingItem> acceptList = itemList.stream().filter(item -> EbiddingItemStatusEnum.BID_WIN.getValue().equals(item.getItemStatus())).collect(Collectors.toList());
                    acceptList.forEach(item -> Assert.isTrue((item.getPrice() != null ? 1 : 0) != 0, (String)I18nUtil.translate((String)"i18n_import_SLBjtuxObLumdWF_b116e581", (String)"\u7269\u6599\u6ca1\u6709\u5355\u4ef7\uff0c\u4e0d\u80fd\u751f\u6210\u4ef7\u683c\u4e3b\u6570\u636e")));
                    this.purchaseEbiddingHeadService.generatePriceRecord(dbHead, acceptList);
                }
                List<PurchaseEbiddingSupplier> supplierList = this.purchaseEbiddingSupplierService.selectByMainId(dbHead.getId());
                this.purchaseEbiddingHeadService.priced(dbHead, itemList, supplierList);
                this.purchaseEbiddingHeadService.goBackDemand(itemList, PurchaseRequestStatusItemEnum.COMPLETION_OF_THE_AUCTION.getValue());
            }
            this.sendMsg(inputParamVO, outputParamVO, "resultAuditPass");
        } else {
            this.sendMsg(inputParamVO, outputParamVO, "resultSubmitAudit");
        }
    }

    public void rejectCallBack(AuditInputParamDTO inputParamVO, AuditOutputParamDTO outputParamVO) {
        this.updateAuditStatus(inputParamVO, outputParamVO);
        this.sendMsg(inputParamVO, outputParamVO, "resultAuditReject");
    }

    public void cancelCallBack(AuditInputParamDTO inputParamVO, AuditOutputParamDTO outputParamVO) {
        this.updateAuditStatus(inputParamVO, outputParamVO);
    }

    public JSONObject getDataById(String id) {
        PurchaseEbiddingHead head = (PurchaseEbiddingHead)((Object)this.purchaseEbiddingHeadService.getById((Serializable)((Object)id)));
        if (head != null) {
            PurchaseEbiddingHeadVO headVO = new PurchaseEbiddingHeadVO();
            BeanUtils.copyProperties((Object)((Object)head), (Object)((Object)headVO));
            List<PurchaseEbiddingItem> itemList = this.purchaseEbiddingItemService.selectByMainId(id);
            headVO.setPurchaseEbiddingItemList(itemList);
            return ((DictTranslateService)SpringContextUtils.getBean(DictTranslateService.class)).parseJson((Object)headVO, new DictTranslateAspectParam());
        }
        return null;
    }

    private void updateAuditStatus(AuditInputParamDTO inputParamVO, AuditOutputParamDTO outputParamVO) {
        String headId = inputParamVO.getBusinessId();
        String flowId = outputParamVO.getProcessRootId();
        String auditStatus = outputParamVO.getAuditStatus();
        PurchaseEbiddingHead updateHead = new PurchaseEbiddingHead();
        updateHead.setId(headId);
        updateHead.setResultFlowId(flowId);
        updateHead.setResultAuditStatus(auditStatus);
        updateHead.setWorkFlowType(outputParamVO.getBpmnType());
        this.purchaseEbiddingHeadService.updateById((Object)updateHead);
        this.purchaseEbiddingItemService.update((Wrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)new LambdaUpdateWrapper().eq(PurchaseEbiddingItem::getHeadId, (Object)headId)).set(PurchaseEbiddingItem::getFlowId, (Object)flowId)).set(PurchaseEbiddingItem::getAuditStatus, (Object)auditStatus));
    }

    private void sendMsg(AuditInputParamDTO inputParamVO, AuditOutputParamDTO outputParamVO, String optType) {
        String elsAccount = TenantContext.getTenant();
        if (AuditStatusEnum.AUDIT_FINISH.getValue().equals(outputParamVO.getAuditStatus()) || AuditStatusEnum.AUDIT_REJECT.getValue().equals(outputParamVO.getAuditStatus())) {
            MsgParamsVO msgParamsVO = this.parameterAssemble(inputParamVO, outputParamVO, outputParamVO.getSubmitUser());
            MqUtil.sendBusMsg((String)elsAccount, (String)"ebidding", (String)optType, (MsgParamsVO)msgParamsVO);
        } else {
            for (String account : outputParamVO.getNextAuditUserList()) {
                MsgParamsVO msgParamsVO = this.parameterAssemble(inputParamVO, outputParamVO, account);
                MqUtil.sendBusMsg((String)elsAccount, (String)"ebidding", (String)optType, (MsgParamsVO)msgParamsVO);
            }
        }
    }

    private MsgParamsVO parameterAssemble(AuditInputParamDTO inputParamVO, AuditOutputParamDTO outputParamVO, String account) {
        MsgParamsVO msgParamsVO = new MsgParamsVO();
        ArrayList<ElsSubAccountDTO> accountList = new ArrayList<ElsSubAccountDTO>();
        HashMap<String, ArrayList<ElsSubAccountDTO>> receiverMap = new HashMap<String, ArrayList<ElsSubAccountDTO>>();
        ElsSubAccountDTO subAccount = this.invokeAccountRpcService.getAccount(TenantContext.getTenant(), account.split("_")[1]);
        accountList.add(subAccount);
        receiverMap.put(TenantContext.getTenant(), accountList);
        msgParamsVO.setReceiverMap(receiverMap);
        String flowId = outputParamVO.getProcessRootId();
        String headId = inputParamVO.getBusinessId();
        String businessType = inputParamVO.getBusinessType();
        String outAuditPassUrl = SysUtil.getOutAuditPassUrl((ElsSubAccountDTO)subAccount, (String)flowId, (String)businessType, (String)headId);
        String outAuditRejectUrl = SysUtil.getOutAuditRejectUrl((ElsSubAccountDTO)subAccount, (String)flowId, (String)businessType, (String)headId);
        PurchaseEbiddingHead head = (PurchaseEbiddingHead)((Object)this.purchaseEbiddingHeadService.getById((Serializable)((Object)headId)));
        PurchaseEbiddingHeadVO headVO = new PurchaseEbiddingHeadVO();
        BeanUtils.copyProperties((Object)((Object)head), (Object)((Object)headVO));
        List<PurchaseEbiddingItem> itemList = this.purchaseEbiddingItemService.selectByMainId(headId);
        headVO.setPurchaseEbiddingItemList(itemList);
        JSONObject jsonObject = ((DictTranslateService)SpringContextUtils.getBean(DictTranslateService.class)).parseJson((Object)headVO, new DictTranslateAspectParam());
        Map paramMap = (Map)JSON.parse((String)jsonObject.toString());
        paramMap.put("userName", subAccount.getRealname());
        paramMap.put("outAuditPassUrl", outAuditPassUrl);
        paramMap.put("outAuditRejectUrl", outAuditRejectUrl);
        msgParamsVO.setParams((Object)paramMap);
        HashMap<String, JSONObject> receiveParamMap = new HashMap<String, JSONObject>();
        JSONObject paramObj = new JSONObject();
        paramObj.put("businessId", (Object)inputParamVO.getBusinessId());
        paramObj.put("Id", (Object)inputParamVO.getBusinessId());
        paramObj.put("businessType", (Object)inputParamVO.getBusinessType());
        if (account.split("_").length > 2) {
            paramObj.put("taskId", (Object)account.split("_")[2]);
        }
        if (account.split("_").length > 3) {
            paramObj.put("processInstanceId", (Object)account.split("_")[3]);
        }
        receiveParamMap.put(TenantContext.getTenant(), paramObj);
        msgParamsVO.setReceiveParamMap(receiveParamMap);
        return msgParamsVO;
    }
}

