/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.ebidding.service.impl;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.els.common.exception.ELSBootException;
import com.els.common.system.base.entity.BaseEntity;
import com.els.common.util.I18nUtil;
import com.els.common.util.SysUtil;
import com.els.config.mybatis.TenantContext;
import com.els.modules.bidding.enumerate.RiskTypeEnum;
import com.els.modules.bidding.vo.SupplierInvesttreeInfoVO;
import com.els.modules.bidding.vo.SupplierRelationFindResultVO;
import com.els.modules.ebidding.entity.PurchaseEbiddingHead;
import com.els.modules.ebidding.entity.PurchaseEbiddingSupplier;
import com.els.modules.ebidding.enumerate.EbiddingReplyStatusEnum;
import com.els.modules.ebidding.mapper.PurchaseEbiddingSupplierMapper;
import com.els.modules.ebidding.service.PurchaseEbiddingSupplierService;
import com.els.modules.ebidding.utils.LoadJsonUtils;
import com.els.modules.ebidding.vo.RelationShipVO;
import com.els.modules.inquiry.rpc.service.InquiryInvokeSupplierRpcService;
import com.els.modules.supplier.api.dto.EnterpriseRiskDTO;
import com.els.modules.supplier.api.dto.SupplierCompanyHoldingDTO;
import com.els.modules.supplier.api.dto.SupplierHumanHoldingDTO;
import com.els.modules.supplier.api.dto.SupplierMasterDataDTO;
import com.els.modules.supplier.api.service.SupplierMasterDataRpcService;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@Service
public class PurchaseEbiddingSupplierServiceImpl
extends ServiceImpl<PurchaseEbiddingSupplierMapper, PurchaseEbiddingSupplier>
implements PurchaseEbiddingSupplierService {
    @Resource
    private InquiryInvokeSupplierRpcService inquiryInvokeSupplierRpcService;
    @Resource
    private SupplierMasterDataRpcService supplierMasterDataRpcService;

    @Override
    public List<PurchaseEbiddingSupplier> selectByMainId(String mainId) {
        return ((PurchaseEbiddingSupplierMapper)this.baseMapper).selectByMainId(mainId);
    }

    @Override
    public void addBatch(PurchaseEbiddingHead head, List<PurchaseEbiddingSupplier> supplierList) {
        if (CollectionUtil.isNotEmpty(supplierList)) {
            int supplierItemNumber = 1;
            for (PurchaseEbiddingSupplier supplier : supplierList) {
                supplier.setId(IdWorker.getIdStr());
                supplier.setHeadId(head.getId());
                supplier.setEbiddingNumber(head.getEbiddingNumber());
                supplier.setItemNumber(String.valueOf(supplierItemNumber++));
                SysUtil.setSysParam((BaseEntity)supplier, (BaseEntity)head);
            }
            this.saveBatch(supplierList, 2000);
        }
    }

    @Override
    public void publish(PurchaseEbiddingHead head, List<PurchaseEbiddingSupplier> supplierList) {
        int supplierItemNumber = 1;
        for (PurchaseEbiddingSupplier supplier : supplierList) {
            SysUtil.setSysParam((BaseEntity)supplier, (BaseEntity)head);
            supplier.setId(IdWorker.getIdStr());
            supplier.setEbiddingNumber(head.getEbiddingNumber());
            supplier.setHeadId(head.getId());
            supplier.setReplyStatus("1".equals(head.getNeedEcho()) ? EbiddingReplyStatusEnum.WAIT_REPLY.getValue() : EbiddingReplyStatusEnum.NOT_NEED.getValue());
            supplier.setCurrentRound(head.getCurrentRound());
            supplier.setItemNumber(String.valueOf(supplierItemNumber++));
        }
        this.saveBatch(supplierList, 2000);
    }

    @Override
    public void updateBidResultBatch(List<PurchaseEbiddingSupplier> supplierList) {
        ((PurchaseEbiddingSupplierMapper)this.baseMapper).updateBidResultBatch(supplierList);
    }

    @Override
    public void deleteByMainId(String mainId) {
        ((PurchaseEbiddingSupplierMapper)this.baseMapper).deleteByMainId(mainId);
    }

    @Override
    public List<SupplierRelationFindResultVO> probe(Map<String, PurchaseEbiddingSupplier> supplierMap) {
        List<EnterpriseRiskDTO> riskList = this.inquiryInvokeSupplierRpcService.queryRiskRelationFind(supplierMap.keySet());
        if (riskList.isEmpty()) {
            return new ArrayList<SupplierRelationFindResultVO>();
        }
        ArrayList<SupplierRelationFindResultVO> relationFindResultList = new ArrayList<SupplierRelationFindResultVO>();
        Map riskMap = riskList.stream().collect(Collectors.toMap(EnterpriseRiskDTO::getElsAccount, Function.identity()));
        HashMap<String, Map<String, String>> supplierInvestTreeMap = new HashMap<String, Map<String, String>>();
        HashMap<String, Map<String, String>> supplierHumanHoldingMap = new HashMap<String, Map<String, String>>();
        HashMap<String, Map<String, String>> supplierCompanyHoldingMap = new HashMap<String, Map<String, String>>();
        for (Map.Entry entry : riskMap.entrySet()) {
            String elsAccount = entry.getKey();
            EnterpriseRiskDTO risk = (EnterpriseRiskDTO)riskMap.get(elsAccount);
            HashMap investTreeMap = new HashMap();
            risk.getSupplierInvesttreeList().forEach(dto -> {
                investTreeMap.put(dto.getCreditCode(), dto.getSupplierName());
                this.getAllSupplierCreditCode(investTreeMap, dto.getChildren());
            });
            supplierInvestTreeMap.put(elsAccount, investTreeMap);
            Map<String, String> humanHoldingMap = risk.getSupplierHumanHoldingList().stream().collect(Collectors.toMap(SupplierHumanHoldingDTO::getCid, SupplierHumanHoldingDTO::getName, (key1, key2) -> key2));
            supplierHumanHoldingMap.put(elsAccount, humanHoldingMap);
            Map<String, String> companyHoldingMap = risk.getSupplierCompanyHoldingList().stream().collect(Collectors.toMap(SupplierCompanyHoldingDTO::getCid, SupplierCompanyHoldingDTO::getName, (key1, key2) -> key2));
            supplierCompanyHoldingMap.put(elsAccount, companyHoldingMap);
        }
        relationFindResultList.addAll(this.analyseSupplierRelationRisk(supplierMap, supplierInvestTreeMap, RiskTypeEnum.INVESTTREE.getValue()));
        relationFindResultList.addAll(this.analyseSupplierRelationRisk(supplierMap, supplierHumanHoldingMap, RiskTypeEnum.HUMANHOLDING.getValue()));
        relationFindResultList.addAll(this.analyseSupplierRelationRisk(supplierMap, supplierCompanyHoldingMap, RiskTypeEnum.COMPANYHOLD.getValue()));
        return relationFindResultList;
    }

    private List<SupplierRelationFindResultVO> analyseSupplierRelationRisk(Map<String, PurchaseEbiddingSupplier> supplierMap, Map<String, Map<String, String>> riskMap, String type) {
        ArrayList<SupplierRelationFindResultVO> relationFindResultList = new ArrayList<SupplierRelationFindResultVO>();
        ArrayList<String> hadCheckedList = new ArrayList<String>();
        for (Map.Entry<String, Map<String, String>> entry : riskMap.entrySet()) {
            String elsAccount = entry.getKey();
            hadCheckedList.add(elsAccount);
            for (Map.Entry<String, Map<String, String>> nextEntry : riskMap.entrySet()) {
                String nextElsAccount = nextEntry.getKey();
                if (hadCheckedList.contains(nextElsAccount)) continue;
                Map<String, String> nextInvestTreeMap = nextEntry.getValue();
                for (String compareKey : nextInvestTreeMap.keySet()) {
                    if (!entry.getValue().containsKey(compareKey)) continue;
                    SupplierRelationFindResultVO findResultVO = new SupplierRelationFindResultVO();
                    findResultVO.setSourceName(supplierMap.get(elsAccount).getSupplierName());
                    findResultVO.setToName(supplierMap.get(nextElsAccount).getSupplierName());
                    findResultVO.setType(type);
                    findResultVO.setResult(nextInvestTreeMap.get(compareKey));
                    relationFindResultList.add(findResultVO);
                }
            }
        }
        return relationFindResultList;
    }

    private void getAllSupplierCreditCode(Map<String, String> supplierMap, String children) {
        if (StrUtil.isBlank((CharSequence)children) || "[]".equals(children)) {
            return;
        }
        List investTreeInfoList = JSON.parseArray((String)children, SupplierInvesttreeInfoVO.class);
        investTreeInfoList.forEach(info -> {
            if (StrUtil.isNotBlank((CharSequence)info.getCreditCode())) {
                supplierMap.put(info.getCreditCode(), info.getName());
            }
            this.getAllSupplierCreditCode(supplierMap, info.getChildren());
        });
    }

    @Override
    public List<SupplierRelationFindResultVO> probeSupplier(List<String> toElsAccounts) {
        HashSet<String> toElsAccountSet;
        List<SupplierMasterDataDTO> supplierList = this.inquiryInvokeSupplierRpcService.selectSupplerList(TenantContext.getTenant(), toElsAccounts);
        if (supplierList == null || supplierList.size() == 0) {
            throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_mhxuRdXWFW_df92b8b6", (String)"\u67e5\u8be2\u4e0d\u5230\u4f9b\u5e94\u5546\u6570\u636e\uff01"));
        }
        Map<String, SupplierMasterDataDTO> supplierMap = supplierList.stream().collect(Collectors.toMap(SupplierMasterDataDTO::getToElsAccount, Function.identity()));
        List<EnterpriseRiskDTO> riskList = this.inquiryInvokeSupplierRpcService.queryRiskRelationFind(supplierMap.keySet());
        ArrayList<SupplierRelationFindResultVO> relationFindResultList = new ArrayList<SupplierRelationFindResultVO>();
        if (!riskList.isEmpty()) {
            Map riskMap = riskList.stream().collect(Collectors.toMap(EnterpriseRiskDTO::getElsAccount, Function.identity()));
            HashMap<String, Map<String, String>> supplierInvestTreeMap = new HashMap<String, Map<String, String>>();
            HashMap<String, Map<String, String>> supplierHumanHoldingMap = new HashMap<String, Map<String, String>>();
            HashMap<String, Map<String, String>> supplierCompanyHoldingMap = new HashMap<String, Map<String, String>>();
            for (Map.Entry entry : riskMap.entrySet()) {
                String elsAccount = entry.getKey();
                EnterpriseRiskDTO risk = (EnterpriseRiskDTO)riskMap.get(elsAccount);
                HashMap investTreeMap = new HashMap();
                risk.getSupplierInvesttreeList().forEach(dto -> {
                    investTreeMap.put(dto.getCreditCode(), dto.getSupplierName());
                    this.getAllSupplierCreditCode(investTreeMap, dto.getChildren());
                });
                supplierInvestTreeMap.put(elsAccount, investTreeMap);
                Map<String, String> humanHoldingMap = risk.getSupplierHumanHoldingList().stream().collect(Collectors.toMap(SupplierHumanHoldingDTO::getCid, SupplierHumanHoldingDTO::getName, (key1, key2) -> key2));
                supplierHumanHoldingMap.put(elsAccount, humanHoldingMap);
                Map<String, String> companyHoldingMap = risk.getSupplierCompanyHoldingList().stream().collect(Collectors.toMap(SupplierCompanyHoldingDTO::getCid, SupplierCompanyHoldingDTO::getName, (key1, key2) -> key2));
                supplierCompanyHoldingMap.put(elsAccount, companyHoldingMap);
            }
            relationFindResultList.addAll(this.analyseSupplierRelationRiskNew(supplierMap, supplierInvestTreeMap, RiskTypeEnum.INVESTTREE.getValue()));
            relationFindResultList.addAll(this.analyseSupplierRelationRiskNew(supplierMap, supplierHumanHoldingMap, RiskTypeEnum.HUMANHOLDING.getValue()));
            relationFindResultList.addAll(this.analyseSupplierRelationRiskNew(supplierMap, supplierCompanyHoldingMap, RiskTypeEnum.COMPANYHOLD.getValue()));
        }
        if ((toElsAccountSet = new HashSet<String>(toElsAccounts)) != null && toElsAccountSet.size() > 1) {
            relationFindResultList.addAll(this.analyseSupplierBehindRelationShip(supplierMap));
        }
        return relationFindResultList;
    }

    private List<SupplierRelationFindResultVO> analyseSupplierRelationRiskNew(Map<String, SupplierMasterDataDTO> supplierMap, Map<String, Map<String, String>> riskMap, String type) {
        ArrayList<SupplierRelationFindResultVO> relationFindResultList = new ArrayList<SupplierRelationFindResultVO>();
        ArrayList<String> hadCheckedList = new ArrayList<String>();
        for (Map.Entry<String, Map<String, String>> entry : riskMap.entrySet()) {
            String elsAccount = entry.getKey();
            hadCheckedList.add(elsAccount);
            for (Map.Entry<String, Map<String, String>> nextEntry : riskMap.entrySet()) {
                String nextElsAccount = nextEntry.getKey();
                if (hadCheckedList.contains(nextElsAccount)) continue;
                Map<String, String> nextInvestTreeMap = nextEntry.getValue();
                for (String compareKey : nextInvestTreeMap.keySet()) {
                    if (!entry.getValue().containsKey(compareKey)) continue;
                    SupplierRelationFindResultVO findResultVO = new SupplierRelationFindResultVO();
                    findResultVO.setSourceName(supplierMap.get(elsAccount).getSupplierName());
                    findResultVO.setToName(supplierMap.get(nextElsAccount).getSupplierName());
                    findResultVO.setType(type);
                    findResultVO.setResult(nextInvestTreeMap.get(compareKey));
                    relationFindResultList.add(findResultVO);
                }
            }
        }
        return relationFindResultList;
    }

    private List<SupplierRelationFindResultVO> analyseSupplierBehindRelationShip(Map<String, SupplierMasterDataDTO> supplierMap) {
        ArrayList<String> supplierNameList = new ArrayList<String>();
        for (Map.Entry<String, SupplierMasterDataDTO> entry : supplierMap.entrySet()) {
            supplierNameList.add(entry.getValue().getSupplierName());
        }
        if (supplierNameList.size() > 20) {
            throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_RRumheOWWuRdXjISRHW_24a0a744", (String)"\u53ea\u652f\u6301\u67e5\u8be2\u6700\u591a20\u5bb6\u4f9b\u5e94\u5546\u7684\u5e55\u540e\u5173\u7cfb\uff01"));
        }
        JSONObject jsonObject = this.supplierMasterDataRpcService.queryBehindRelationship(supplierNameList);
        List<RelationShipVO> relationShipVOList = null;
        if (jsonObject != null) {
            if (jsonObject.getBoolean("success").booleanValue()) {
                String jsonUrl = jsonObject.getString("message");
                relationShipVOList = LoadJsonUtils.parseJsonDataFromURL(jsonUrl);
            } else {
                String message = jsonObject.getString("message");
                throw new ELSBootException(I18nUtil.translate((String)"", (String)message));
            }
        }
        ArrayList<SupplierRelationFindResultVO> relationFindResultList = new ArrayList<SupplierRelationFindResultVO>();
        if (relationShipVOList != null && relationShipVOList.size() > 0) {
            for (RelationShipVO relationShip : relationShipVOList) {
                SupplierRelationFindResultVO findResultVO = new SupplierRelationFindResultVO();
                findResultVO.setSourceName(relationShip.getStartNodeName());
                findResultVO.setToName(relationShip.getEndNodeName());
                if ("OWN".equals(relationShip.getType())) {
                    findResultVO.setType(RiskTypeEnum.OWN.getValue());
                    findResultVO.setResult(RiskTypeEnum.OWN.getDesc());
                } else if ("SERVE_ALL".equals(relationShip.getType())) {
                    findResultVO.setType(RiskTypeEnum.SERVE_ALL.getValue());
                    findResultVO.setResult(RiskTypeEnum.SERVE_ALL.getDesc());
                }
                if ("INVEST".equals(relationShip.getType())) {
                    findResultVO.setType(RiskTypeEnum.INVEST.getValue());
                    findResultVO.setResult(RiskTypeEnum.INVEST.getDesc());
                }
                if ("BRANCH".equals(relationShip.getType())) {
                    findResultVO.setType(RiskTypeEnum.BRANCH.getValue());
                    findResultVO.setResult(RiskTypeEnum.BRANCH.getDesc());
                }
                relationFindResultList.add(findResultVO);
            }
        }
        return relationFindResultList;
    }
}

