/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.enquiry.controller;

import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.conditions.query.QueryChainWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.els.aspect.DictTranslateAspect;
import com.els.common.api.vo.Result;
import com.els.common.constant.CommonConstant;
import com.els.common.system.base.controller.BaseController;
import com.els.common.system.base.entity.BaseEntity;
import com.els.common.system.query.QueryGenerator;
import com.els.common.util.ConvertUtils;
import com.els.common.util.SpringContextUtils;
import com.els.modules.base.api.dto.ElsInitialTableDTO;
import com.els.modules.enquiry.entity.PurchaseEnquiryHead;
import com.els.modules.enquiry.entity.PurchaseEnquiryItem;
import com.els.modules.enquiry.entity.PurchaseEnquiryItemHis;
import com.els.modules.enquiry.enumerate.EnquiryQuoteWayEnum;
import com.els.modules.enquiry.enumerate.EnquiryStatusEnum;
import com.els.modules.enquiry.excel.PurchaseEnquiryItemHisExportServiceImpl;
import com.els.modules.enquiry.service.PurchaseEnquiryHeadService;
import com.els.modules.enquiry.service.PurchaseEnquiryItemHisService;
import com.els.modules.enquiry.vo.CurrentQuoteTrendVO;
import com.els.rpc.service.InvokeBaseRpcService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.servlet.ModelAndView;

@Api(tags={"\u91c7\u8d2d\u8be2\u4ef7\u5386\u53f2\u884c"})
@RestController
@RequestMapping(value={"/enquiry/purchaseEnquiryItemHis"})
public class PurchaseEnquiryItemHisController
extends BaseController<PurchaseEnquiryItemHis, PurchaseEnquiryItemHisService> {
    @Resource
    private PurchaseEnquiryHeadService purchaseEnquiryHeadService;
    @Resource
    private InvokeBaseRpcService invokeBaseRpcService;

    @ApiOperation(value="\u5206\u9875\u5217\u8868\u67e5\u8be2", notes="\u5206\u9875\u5217\u8868\u67e5\u8be2")
    @GetMapping(value={"/list"})
    @RequiresPermissions(value={"enquiry#purchaseEnquiryHead:hisList"})
    public Result<?> queryPageList(PurchaseEnquiryItemHis purchaseEnquiryItemHis, @RequestParam(name="pageNo", defaultValue="1") Integer pageNo, @RequestParam(name="pageSize", defaultValue="10") Integer pageSize, HttpServletRequest req) {
        QueryWrapper queryWrapper = QueryGenerator.initQueryWrapper((Object)((Object)purchaseEnquiryItemHis), (Map)req.getParameterMap());
        Page page = new Page((long)pageNo.intValue(), (long)pageSize.intValue());
        IPage pageList = ((PurchaseEnquiryItemHisService)this.service).page((IPage)page, (Wrapper)queryWrapper);
        List records = pageList.getRecords();
        if (!CollectionUtils.isEmpty((Collection)records)) {
            List headIdList = records.stream().map(PurchaseEnquiryItemHis::getHeadId).distinct().collect(Collectors.toList());
            LambdaQueryWrapper queryWrapper1 = new LambdaQueryWrapper();
            queryWrapper1.in(BaseEntity::getId, headIdList);
            queryWrapper1.eq(BaseEntity::getDeleted, (Object)CommonConstant.DEL_FLAG_0);
            List dbHeadList = this.purchaseEnquiryHeadService.list((Wrapper)queryWrapper1);
            ArrayList hideHeadIdList = new ArrayList();
            dbHeadList.forEach(dbHead -> {
                boolean showPrice;
                boolean bl = showPrice = "1".equals(dbHead.getSeePrice()) || "1".equals(dbHead.getOpenBidStatus()) || new Date().after(dbHead.getQuoteEndTime());
                if (showPrice) {
                    hideHeadIdList.add(dbHead.getId());
                }
            });
            if (CollectionUtils.isEmpty(hideHeadIdList)) {
                Result.ok((Object)pageList);
            }
            List newRecordList = records.stream().filter(item -> hideHeadIdList.contains(item.getHeadId())).collect(Collectors.toList());
            pageList.setRecords(newRecordList);
            return Result.ok((Object)pageList);
        }
        return Result.ok((Object)pageList);
    }

    @ApiOperation(value="\u62a5\u4ef7\u5386\u53f2\u8d8b\u52bf\u56fe\u67e5\u8be2", notes="\u62a5\u4ef7\u5386\u53f2\u8d8b\u52bf\u56fe\u67e5\u8be2")
    @GetMapping(value={"/queryQuoteHisTrend"})
    @RequiresPermissions(value={"enquiry#purchaseEnquiryItemHis:queryById"})
    public Result<?> queryQuoteHisTrend(HttpServletRequest request) {
        CurrentQuoteTrendVO trendVO = ((PurchaseEnquiryItemHisService)this.service).findQuoteHis(request);
        return Result.ok((Object)trendVO);
    }

    @ApiOperation(value="\u6bd4\u4ef7\u62a5\u8868\u67e5\u8be2", notes="\u6bd4\u4ef7\u62a5\u8868\u67e5\u8be2")
    @GetMapping(value={"/queryCompare"})
    @RequiresPermissions(value={"enquiry#purchaseEnquiryItemHis:queryById"})
    public Result<?> queryCompare(HttpServletRequest request) {
        String headId = request.getParameter("headId");
        String compare = request.getParameter("compare");
        ArrayList<String> compareList = StrUtil.isBlank((CharSequence)compare) ? new ArrayList() : Arrays.asList(compare.split(","));
        String toElsAccount = request.getParameter("toElsAccount");
        ArrayList<String> toElsAccountList = StrUtil.isBlank((CharSequence)toElsAccount) ? new ArrayList() : Arrays.asList(toElsAccount.split(","));
        PurchaseEnquiryHead dbHead = (PurchaseEnquiryHead)((Object)this.purchaseEnquiryHeadService.getById((Serializable)((Object)headId)));
        if (!EnquiryStatusEnum.NEW.getValue().equals(dbHead.getEnquiryStatus())) {
            boolean showPrice;
            boolean bl = showPrice = "1".equals(dbHead.getSeePrice()) || "1".equals(dbHead.getOpenBidStatus()) || new Date().after(dbHead.getQuoteEndTime());
            if (!showPrice) {
                JSONObject result = new JSONObject();
                result.put("normalList", new ArrayList());
                result.put("ladderList", new ArrayList());
                result.put("costList", new ArrayList());
                result.put("supplierList", new ArrayList());
                return Result.ok((Object)result);
            }
        }
        JSONObject result = ((PurchaseEnquiryItemHisService)this.service).queryCompare(dbHead, compareList, toElsAccountList);
        return Result.ok((Object)result);
    }

    @ApiOperation(value="\u6bd4\u4ef7\u62a5\u8868\u67e5\u8be2-\u5e38\u89c4\u6bd4\u4ef7", notes="\u6bd4\u4ef7\u62a5\u8868\u67e5\u8be2-\u5e38\u89c4\u6bd4\u4ef7")
    @GetMapping(value={"/queryCompareNormalPage"})
    @RequiresPermissions(value={"enquiry#purchaseEnquiryItemHis:queryById"})
    public Result<?> queryCompareNormalPage(@RequestParam(name="headId", required=true) String headId) {
        List total = ((QueryChainWrapper)((PurchaseEnquiryItemHisService)this.service).query().select(new String[]{"COUNT(DISTINCT(to_els_account)) to_els_account", "COUNT(DISTINCT(quote_count)) quote_count"}).eq((Object)"head_id", (Object)headId)).list();
        ElsInitialTableDTO elsInitialTableDTO = this.invokeBaseRpcService.selectElsInitialTableOne(headId);
        List jsonArrayTolist = JSONArray.parseArray((String)elsInitialTableDTO.getBusinessInfoJson(), PurchaseEnquiryItem.class);
        Integer quoteCount = ((PurchaseEnquiryItemHis)((Object)total.get(0))).getQuoteCount();
        String toElsAccount = ((PurchaseEnquiryItemHis)((Object)total.get(0))).getToElsAccount();
        HashMap<String, Object> objectMap = new HashMap<String, Object>();
        objectMap.put("itemList", jsonArrayTolist);
        objectMap.put("supplierCount", toElsAccount);
        objectMap.put("quoteCount", quoteCount);
        int i = Integer.valueOf(toElsAccount) != 0 ? 200 / (quoteCount * Integer.valueOf(toElsAccount)) : 0;
        objectMap.put("pageMaterialCount", i);
        return Result.ok(objectMap);
    }

    @ApiOperation(value="\u6bd4\u4ef7\u62a5\u8868\u67e5\u8be2-\u5e38\u89c4\u6bd4\u4ef7", notes="\u6bd4\u4ef7\u62a5\u8868\u67e5\u8be2-\u5e38\u89c4\u6bd4\u4ef7")
    @PostMapping(value={"/queryCompareNormalNewList"})
    @RequiresPermissions(value={"enquiry#purchaseEnquiryItemHis:queryById"})
    public Result<?> queryCompareNormalNewList(@RequestBody PurchaseEnquiryItemHis request) {
        List<Object> stringList;
        PurchaseEnquiryHead dbHead = (PurchaseEnquiryHead)((Object)this.purchaseEnquiryHeadService.getById((Serializable)((Object)request.getHeadId())));
        if (!EnquiryStatusEnum.NEW.getValue().equals(dbHead.getEnquiryStatus())) {
            boolean showPrice;
            boolean bl = showPrice = "1".equals(dbHead.getSeePrice()) || "1".equals(dbHead.getOpenBidStatus()) || new Date().after(dbHead.getQuoteEndTime());
            if (!showPrice) {
                return Result.ok(null);
            }
        }
        QueryWrapper queryWrapper = new QueryWrapper();
        String materialNumber = request.getMaterialNumber();
        String materialName = request.getMaterialName();
        String materialDesc = request.getMaterialDesc();
        String groupType = "materialNumber";
        HashMap map = new HashMap();
        if (materialName != null) {
            stringList = StrUtil.isBlank((CharSequence)materialName) ? new ArrayList() : Arrays.asList(materialName.split(","));
            groupType = "materialName";
            map.put("materialName", stringList);
        }
        if (materialDesc != null) {
            stringList = StrUtil.isBlank((CharSequence)materialDesc) ? new ArrayList() : Arrays.asList(materialDesc.split(","));
            groupType = "materialDesc";
            map.put("materialDesc", stringList);
        }
        if (materialNumber != null) {
            stringList = StrUtil.isBlank((CharSequence)materialNumber) ? new ArrayList() : Arrays.asList(materialNumber.split(","));
            groupType = "materialNumber";
            map.put("materialNumber", stringList);
        }
        if (!CollectionUtils.isEmpty(map)) {
            queryWrapper.and(q -> PurchaseEnquiryItemHisController.createQW(q, map));
        }
        ((LambdaQueryWrapper)queryWrapper.lambda().eq(PurchaseEnquiryItemHis::getHeadId, (Object)request.getHeadId())).eq(PurchaseEnquiryItemHis::getQuotePriceWay, (Object)EnquiryQuoteWayEnum.NORMAL.getValue());
        List list = ((PurchaseEnquiryItemHisService)this.service).list((Wrapper)queryWrapper);
        Map<String, List<PurchaseEnquiryItemHis>> groupItem = list.stream().collect(Collectors.groupingBy(item -> item.getMaterialNumber() + "_" + item.getQuoteCount()));
        if ("materialName".equals(groupType)) {
            groupItem = list.stream().collect(Collectors.groupingBy(item -> item.getMaterialName() + "_" + item.getQuoteCount()));
        }
        if ("materialDesc".equals(groupType)) {
            groupItem = list.stream().collect(Collectors.groupingBy(item -> item.getMaterialDesc() + "_" + item.getQuoteCount()));
        }
        list.clear();
        for (Map.Entry<String, List<PurchaseEnquiryItemHis>> entry : groupItem.entrySet()) {
            ((PurchaseEnquiryItemHisService)this.service).initCompareMsg(dbHead, entry.getValue());
            list.addAll((Collection)entry.getValue());
        }
        Result dbResult = Result.ok((Object)list);
        ((DictTranslateAspect)SpringContextUtils.getBean(DictTranslateAspect.class)).dictTranslate((Object)dbResult);
        List dataList = (List)dbResult.getResult();
        JSONObject jsonObject = new JSONObject();
        ((PurchaseEnquiryItemHisService)this.service).compareNormal(dataList, jsonObject);
        return Result.ok((Object)dataList);
    }

    @ApiOperation(value="\u6bd4\u4ef7\u62a5\u8868\u67e5\u8be2-\u5e38\u89c4\u6bd4\u4ef7", notes="\u6bd4\u4ef7\u62a5\u8868\u67e5\u8be2-\u5e38\u89c4\u6bd4\u4ef7")
    @GetMapping(value={"/queryCompareNormalList"})
    @RequiresPermissions(value={"enquiry#purchaseEnquiryItemHis:queryById"})
    public Result<?> queryCompareNormalList(@RequestParam(name="pageNo", defaultValue="1") Integer pageNo, @RequestParam(name="pageSize", defaultValue="10") Integer pageSize, HttpServletRequest request) {
        String headId = request.getParameter("headId");
        String toElsAccount = request.getParameter("toElsAccount");
        ArrayList<String> toElsAccountList = StrUtil.isBlank((CharSequence)toElsAccount) ? new ArrayList() : Arrays.asList(toElsAccount.split(","));
        PurchaseEnquiryHead dbHead = (PurchaseEnquiryHead)((Object)this.purchaseEnquiryHeadService.getById((Serializable)((Object)headId)));
        if (!EnquiryStatusEnum.NEW.getValue().equals(dbHead.getEnquiryStatus())) {
            boolean showPrice;
            boolean bl = showPrice = "1".equals(dbHead.getSeePrice()) || "1".equals(dbHead.getOpenBidStatus()) || new Date().after(dbHead.getQuoteEndTime());
            if (!showPrice) {
                return Result.ok(null);
            }
        }
        Page page = new Page((long)pageNo.intValue(), (long)pageSize.intValue());
        IPage<JSONObject> result = ((PurchaseEnquiryItemHisService)this.service).queryCompareNormalList(dbHead, (Page<PurchaseEnquiryItemHis>)page, toElsAccountList);
        return Result.ok(result);
    }

    @ApiOperation(value="\u6bd4\u4ef7\u62a5\u8868\u67e5\u8be2-\u9636\u68af\u6bd4\u4ef7", notes="\u6bd4\u4ef7\u62a5\u8868\u67e5\u8be2-\u9636\u68af\u6bd4\u4ef7")
    @PostMapping(value={"/queryCompareLadderNewList"})
    @RequiresPermissions(value={"enquiry#purchaseEnquiryItemHis:queryById"})
    public Result<?> queryCompareLadderNewList(@RequestBody PurchaseEnquiryItemHis request) {
        List<Object> stringList;
        PurchaseEnquiryHead dbHead = (PurchaseEnquiryHead)((Object)this.purchaseEnquiryHeadService.getById((Serializable)((Object)request.getHeadId())));
        if (!EnquiryStatusEnum.NEW.getValue().equals(dbHead.getEnquiryStatus())) {
            boolean showPrice;
            boolean bl = showPrice = "1".equals(dbHead.getSeePrice()) || "1".equals(dbHead.getOpenBidStatus()) || new Date().after(dbHead.getQuoteEndTime());
            if (!showPrice) {
                return Result.ok(null);
            }
        }
        QueryWrapper queryWrapper = new QueryWrapper();
        String materialNumber = request.getMaterialNumber();
        String materialName = request.getMaterialName();
        String materialDesc = request.getMaterialDesc();
        String groupType = "materialNumber";
        HashMap map = new HashMap();
        if (materialName != null) {
            stringList = StrUtil.isBlank((CharSequence)materialName) ? new ArrayList() : Arrays.asList(materialName.split(","));
            groupType = "materialName";
            map.put("materialName", stringList);
        }
        if (materialDesc != null) {
            stringList = StrUtil.isBlank((CharSequence)materialDesc) ? new ArrayList() : Arrays.asList(materialDesc.split(","));
            groupType = "materialDesc";
            map.put("materialDesc", stringList);
        }
        if (materialNumber != null) {
            stringList = StrUtil.isBlank((CharSequence)materialNumber) ? new ArrayList() : Arrays.asList(materialNumber.split(","));
            groupType = "materialNumber";
            map.put("materialNumber", stringList);
        }
        if (!CollectionUtils.isEmpty(map)) {
            queryWrapper.and(q -> PurchaseEnquiryItemHisController.createQW(q, map));
        }
        ((LambdaQueryWrapper)queryWrapper.lambda().eq(PurchaseEnquiryItemHis::getHeadId, (Object)request.getHeadId())).eq(PurchaseEnquiryItemHis::getQuotePriceWay, (Object)EnquiryQuoteWayEnum.LADDER.getValue());
        List list = ((PurchaseEnquiryItemHisService)this.service).list((Wrapper)queryWrapper);
        Map<String, List<PurchaseEnquiryItemHis>> groupItem = list.stream().collect(Collectors.groupingBy(item -> item.getMaterialNumber() + "_" + item.getQuoteCount()));
        if ("materialName".equals(groupType)) {
            groupItem = list.stream().collect(Collectors.groupingBy(item -> item.getMaterialName() + "_" + item.getQuoteCount()));
        }
        if ("materialDesc".equals(groupType)) {
            groupItem = list.stream().collect(Collectors.groupingBy(item -> item.getMaterialDesc() + "_" + item.getQuoteCount()));
        }
        list.clear();
        for (Map.Entry<String, List<PurchaseEnquiryItemHis>> entry : groupItem.entrySet()) {
            ((PurchaseEnquiryItemHisService)this.service).initCompareMsg(dbHead, entry.getValue());
            list.addAll((Collection)entry.getValue());
        }
        Result dbResult = Result.ok((Object)list);
        ((DictTranslateAspect)SpringContextUtils.getBean(DictTranslateAspect.class)).dictTranslate((Object)dbResult);
        List dataList = (List)dbResult.getResult();
        JSONObject jsonObject = new JSONObject();
        List<JSONObject> jsonObjects = ((PurchaseEnquiryItemHisService)this.service).compareLadder(dataList, jsonObject);
        return Result.ok(jsonObjects);
    }

    @ApiOperation(value="\u6bd4\u4ef7\u62a5\u8868\u67e5\u8be2-\u9636\u68af\u6bd4\u4ef7", notes="\u6bd4\u4ef7\u62a5\u8868\u67e5\u8be2-\u9636\u68af\u6bd4\u4ef7")
    @GetMapping(value={"/queryCompareLadderList"})
    @RequiresPermissions(value={"enquiry#purchaseEnquiryItemHis:queryById"})
    public Result<?> queryCompareLadderList(@RequestParam(name="pageNo", defaultValue="1") Integer pageNo, @RequestParam(name="pageSize", defaultValue="10") Integer pageSize, HttpServletRequest request) {
        String headId = request.getParameter("headId");
        String toElsAccount = request.getParameter("toElsAccount");
        ArrayList<String> toElsAccountList = StrUtil.isBlank((CharSequence)toElsAccount) ? new ArrayList() : Arrays.asList(toElsAccount.split(","));
        PurchaseEnquiryHead dbHead = (PurchaseEnquiryHead)((Object)this.purchaseEnquiryHeadService.getById((Serializable)((Object)headId)));
        if (!EnquiryStatusEnum.NEW.getValue().equals(dbHead.getEnquiryStatus())) {
            boolean showPrice;
            boolean bl = showPrice = "1".equals(dbHead.getSeePrice()) || "1".equals(dbHead.getOpenBidStatus()) || new Date().after(dbHead.getQuoteEndTime());
            if (!showPrice) {
                return Result.ok(null);
            }
        }
        Page page = new Page((long)pageNo.intValue(), (long)pageSize.intValue());
        IPage<JSONObject> result = ((PurchaseEnquiryItemHisService)this.service).queryCompareLadderList(dbHead, (Page<PurchaseEnquiryItemHis>)page, toElsAccountList);
        return Result.ok(result);
    }

    @ApiOperation(value="\u6bd4\u4ef7\u62a5\u8868\u67e5\u8be2-\u6210\u672c\u6bd4\u4ef7", notes="\u6bd4\u4ef7\u62a5\u8868\u67e5\u8be2-\u6210\u672c\u6bd4\u4ef7")
    @PostMapping(value={"/queryCompareCostNewList"})
    @RequiresPermissions(value={"enquiry#purchaseEnquiryItemHis:queryById"})
    public Result<?> queryCompareCostNewList(@RequestBody PurchaseEnquiryItemHis request) {
        List<Object> stringList;
        PurchaseEnquiryHead dbHead = (PurchaseEnquiryHead)((Object)this.purchaseEnquiryHeadService.getById((Serializable)((Object)request.getHeadId())));
        if (!EnquiryStatusEnum.NEW.getValue().equals(dbHead.getEnquiryStatus())) {
            boolean showPrice;
            boolean bl = showPrice = "1".equals(dbHead.getSeePrice()) || "1".equals(dbHead.getOpenBidStatus()) || new Date().after(dbHead.getQuoteEndTime());
            if (!showPrice) {
                return Result.ok(null);
            }
        }
        QueryWrapper queryWrapper = new QueryWrapper();
        String materialNumber = request.getMaterialNumber();
        String materialName = request.getMaterialName();
        String materialDesc = request.getMaterialDesc();
        String groupType = "materialNumber";
        HashMap map = new HashMap();
        if (materialName != null) {
            stringList = StrUtil.isBlank((CharSequence)materialName) ? new ArrayList() : Arrays.asList(materialName.split(","));
            groupType = "materialName";
            map.put("materialName", stringList);
        }
        if (materialDesc != null) {
            stringList = StrUtil.isBlank((CharSequence)materialDesc) ? new ArrayList() : Arrays.asList(materialDesc.split(","));
            groupType = "materialDesc";
            map.put("materialDesc", stringList);
        }
        if (materialNumber != null) {
            stringList = StrUtil.isBlank((CharSequence)materialNumber) ? new ArrayList() : Arrays.asList(materialNumber.split(","));
            groupType = "materialNumber";
            map.put("materialNumber", stringList);
        }
        if (!CollectionUtils.isEmpty(map)) {
            queryWrapper.and(q -> PurchaseEnquiryItemHisController.createQW(q, map));
        }
        ((LambdaQueryWrapper)queryWrapper.lambda().eq(PurchaseEnquiryItemHis::getHeadId, (Object)request.getHeadId())).eq(PurchaseEnquiryItemHis::getQuotePriceWay, (Object)EnquiryQuoteWayEnum.COST.getValue());
        List list = ((PurchaseEnquiryItemHisService)this.service).list((Wrapper)queryWrapper);
        Map<String, List<PurchaseEnquiryItemHis>> groupItem = list.stream().collect(Collectors.groupingBy(item -> item.getMaterialNumber() + "_" + item.getQuoteCount()));
        if ("materialName".equals(groupType)) {
            groupItem = list.stream().collect(Collectors.groupingBy(item -> item.getMaterialName() + "_" + item.getQuoteCount()));
        }
        if ("materialDesc".equals(groupType)) {
            groupItem = list.stream().collect(Collectors.groupingBy(item -> item.getMaterialDesc() + "_" + item.getQuoteCount()));
        }
        list.clear();
        for (Map.Entry<String, List<PurchaseEnquiryItemHis>> entry : groupItem.entrySet()) {
            ((PurchaseEnquiryItemHisService)this.service).initCompareMsg(dbHead, entry.getValue());
            list.addAll((Collection)entry.getValue());
        }
        Result dbResult = Result.ok((Object)list);
        ((DictTranslateAspect)SpringContextUtils.getBean(DictTranslateAspect.class)).dictTranslate((Object)dbResult);
        List dataList = (List)dbResult.getResult();
        JSONObject jsonObject = new JSONObject();
        List<JSONObject> jsonObjects = ((PurchaseEnquiryItemHisService)this.service).compareCost(dataList, jsonObject);
        return Result.ok(jsonObjects);
    }

    public static <T> void createQW(QueryWrapper<T> qw, Map<String, List<String>> collect) {
        int index = 0;
        for (String key : collect.keySet()) {
            List<String> strings = collect.get(key);
            if (CollectionUtils.isEmpty(strings)) continue;
            if (index == 0) {
                qw.nested(qw1 -> qw1.in((Object)ConvertUtils.camelToUnderline((String)key), (Collection)strings));
                ++index;
                continue;
            }
            qw.or(qw1 -> qw1.in((Object)ConvertUtils.camelToUnderline((String)key), (Collection)strings));
        }
    }

    @ApiOperation(value="\u6bd4\u4ef7\u62a5\u8868\u67e5\u8be2-\u6210\u672c\u6bd4\u4ef7", notes="\u6bd4\u4ef7\u62a5\u8868\u67e5\u8be2-\u6210\u672c\u6bd4\u4ef7")
    @GetMapping(value={"/queryCompareCostList"})
    @RequiresPermissions(value={"enquiry#purchaseEnquiryItemHis:queryById"})
    public Result<?> queryCompareCostList(@RequestParam(name="pageNo", defaultValue="1") Integer pageNo, @RequestParam(name="pageSize", defaultValue="10") Integer pageSize, HttpServletRequest request) {
        String headId = request.getParameter("headId");
        String toElsAccount = request.getParameter("toElsAccount");
        ArrayList<String> toElsAccountList = StrUtil.isBlank((CharSequence)toElsAccount) ? new ArrayList() : Arrays.asList(toElsAccount.split(","));
        PurchaseEnquiryHead dbHead = (PurchaseEnquiryHead)((Object)this.purchaseEnquiryHeadService.getById((Serializable)((Object)headId)));
        if (!EnquiryStatusEnum.NEW.getValue().equals(dbHead.getEnquiryStatus())) {
            boolean showPrice;
            boolean bl = showPrice = "1".equals(dbHead.getSeePrice()) || "1".equals(dbHead.getOpenBidStatus()) || new Date().after(dbHead.getQuoteEndTime());
            if (!showPrice) {
                return Result.ok(null);
            }
        }
        Page page = new Page((long)pageNo.intValue(), (long)pageSize.intValue());
        IPage<JSONObject> result = ((PurchaseEnquiryItemHisService)this.service).queryCompareCostList(dbHead, (Page<PurchaseEnquiryItemHis>)page, toElsAccountList);
        return Result.ok(result);
    }

    @ApiOperation(value="\u6bd4\u4ef7\u62a5\u8868\u67e5\u8be2-\u6253\u5305\u6bd4\u4ef7", notes="\u6bd4\u4ef7\u62a5\u8868\u67e5\u8be2-\u6253\u5305\u6bd4\u4ef7")
    @GetMapping(value={"/queryCompareSupplierList"})
    @RequiresPermissions(value={"enquiry#purchaseEnquiryItemHis:queryById"})
    public Result<?> queryCompareCostList(HttpServletRequest request) {
        String headId = request.getParameter("headId");
        String toElsAccount = request.getParameter("toElsAccount");
        ArrayList<String> toElsAccountList = StrUtil.isBlank((CharSequence)toElsAccount) ? new ArrayList() : Arrays.asList(toElsAccount.split(","));
        PurchaseEnquiryHead dbHead = (PurchaseEnquiryHead)((Object)this.purchaseEnquiryHeadService.getById((Serializable)((Object)headId)));
        if (!EnquiryStatusEnum.NEW.getValue().equals(dbHead.getEnquiryStatus())) {
            boolean showPrice;
            boolean bl = showPrice = "1".equals(dbHead.getSeePrice()) || "1".equals(dbHead.getOpenBidStatus()) || new Date().after(dbHead.getQuoteEndTime());
            if (!showPrice) {
                return Result.ok(null);
            }
        }
        List<?> objects = ((PurchaseEnquiryItemHisService)this.service).queryCompareSupplierList(dbHead, toElsAccountList);
        return Result.ok(objects);
    }

    @ApiOperation(value="\u6bd4\u4ef7\u62a5\u8868\u6700\u65b0\u4e00\u6b21\u62a5\u4ef7\u6570\u636e\u67e5\u8be2", notes="\u6bd4\u4ef7\u62a5\u8868\u6700\u65b0\u4e00\u6b21\u62a5\u4ef7\u6570\u636e\u67e5\u8be2")
    @GetMapping(value={"/queryCompareForLast"})
    @RequiresPermissions(value={"enquiry#purchaseEnquiryItemHis:queryById"})
    public Result<?> queryCompareForLast(HttpServletRequest request) {
        String headId = request.getParameter("headId");
        String compare = request.getParameter("compare");
        ArrayList<String> compareList = StrUtil.isBlank((CharSequence)compare) ? new ArrayList() : Arrays.asList(compare.split(","));
        String toElsAccount = request.getParameter("toElsAccount");
        ArrayList<String> toElsAccountList = StrUtil.isBlank((CharSequence)toElsAccount) ? new ArrayList() : Arrays.asList(toElsAccount.split(","));
        PurchaseEnquiryHead dbHead = (PurchaseEnquiryHead)((Object)this.purchaseEnquiryHeadService.getById((Serializable)((Object)headId)));
        if (!EnquiryStatusEnum.NEW.getValue().equals(dbHead.getEnquiryStatus())) {
            boolean showPrice;
            boolean bl = showPrice = "1".equals(dbHead.getSeePrice()) || "1".equals(dbHead.getOpenBidStatus()) || new Date().after(dbHead.getQuoteEndTime());
            if (!showPrice) {
                JSONObject result = new JSONObject();
                result.put("normalList", new ArrayList());
                result.put("ladderList", new ArrayList());
                result.put("costList", new ArrayList());
                result.put("supplierList", new ArrayList());
                return Result.ok((Object)result);
            }
        }
        JSONObject result = ((PurchaseEnquiryItemHisService)this.service).queryCompareForLast(dbHead, compareList, toElsAccountList);
        return Result.ok((Object)result);
    }

    @PostMapping(value={"/exportXls"})
    @RequiresPermissions(value={"enquiry#purchaseEnquiryItemHis:queryById"})
    public ModelAndView exportXls(HttpServletRequest request, @RequestBody Map<String, Object> object) {
        return super.exportXls(request, object, PurchaseEnquiryItemHisExportServiceImpl.class);
    }
}

