/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.enquiry.excel;

import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.els.common.api.vo.Result;
import com.els.common.aspect.annotation.RpcService;
import com.els.common.constant.CommonConstant;
import com.els.common.excel.service.BaseExportService;
import com.els.common.system.base.entity.BaseEntity;
import com.els.modules.base.api.service.ExportDataLoaderService;
import com.els.modules.enquiry.entity.PurchaseEnquiryItemHis;
import com.els.modules.enquiry.service.PurchaseEnquiryHeadService;
import com.els.modules.enquiry.service.PurchaseEnquiryItemHisService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;

@RpcService(value="purchaseEnquiryItemHisExportExcelDataBatchQueryLoader")
public class PurchaseEnquiryItemHisExportServiceImpl
extends BaseExportService<PurchaseEnquiryItemHis, PurchaseEnquiryItemHis, PurchaseEnquiryItemHis>
implements ExportDataLoaderService {
    @Autowired
    private PurchaseEnquiryItemHisService purchaseEnquiryItemHisService;
    @Autowired
    private PurchaseEnquiryHeadService purchaseEnquiryHeadService;

    public List<PurchaseEnquiryItemHis> queryExportData(QueryWrapper<PurchaseEnquiryItemHis> queryWrapper, PurchaseEnquiryItemHis map, Map<String, String[]> paramMap) {
        List list = this.purchaseEnquiryItemHisService.list((Wrapper)queryWrapper);
        if (!CollectionUtils.isEmpty((Collection)list)) {
            List headIdList = list.stream().map(PurchaseEnquiryItemHis::getHeadId).distinct().collect(Collectors.toList());
            LambdaQueryWrapper queryWrapper1 = new LambdaQueryWrapper();
            queryWrapper1.in(BaseEntity::getId, headIdList);
            queryWrapper1.eq(BaseEntity::getDeleted, (Object)CommonConstant.DEL_FLAG_0);
            List dbHeadList = this.purchaseEnquiryHeadService.list((Wrapper)queryWrapper1);
            ArrayList hideHeadIdList = new ArrayList();
            dbHeadList.forEach(dbHead -> {
                boolean showPrice;
                boolean bl = showPrice = "1".equals(dbHead.getSeePrice()) || "1".equals(dbHead.getOpenBidStatus()) || new Date().after(dbHead.getQuoteEndTime());
                if (showPrice) {
                    hideHeadIdList.add(dbHead.getId());
                }
            });
            if (CollectionUtils.isEmpty(hideHeadIdList)) {
                return list;
            }
            List<PurchaseEnquiryItemHis> newRecordList = list.stream().filter(item -> hideHeadIdList.contains(item.getHeadId())).collect(Collectors.toList());
            return newRecordList;
        }
        return list;
    }

    public long queryExportDataCount(QueryWrapper<PurchaseEnquiryItemHis> queryWrapper, PurchaseEnquiryItemHis map, Map<String, String[]> paramMap) {
        return this.purchaseEnquiryItemHisService.count((Wrapper)queryWrapper);
    }

    public String getBusinessType() {
        return "PurchaseEnquiryItemHis";
    }

    public String getBeanName() {
        return "purchaseEnquiryItemHisExportExcelDataBatchQueryLoader";
    }

    public String loadData(Integer pageNumber, Integer pageSize, Map<String, Object> entityMap, Map<String, String[]> requestParamMap) {
        QueryWrapper queryWrapper = this.builderWrapper(entityMap, requestParamMap);
        Page page = new Page((long)pageNumber.intValue(), (long)pageSize.intValue());
        IPage pageList = this.purchaseEnquiryItemHisService.page((IPage)page, (Wrapper)queryWrapper);
        List records = pageList.getRecords();
        if (!CollectionUtils.isEmpty((Collection)records)) {
            List headIdList = records.stream().map(PurchaseEnquiryItemHis::getHeadId).distinct().collect(Collectors.toList());
            LambdaQueryWrapper queryWrapper1 = new LambdaQueryWrapper();
            queryWrapper1.in(BaseEntity::getId, headIdList);
            queryWrapper1.eq(BaseEntity::getDeleted, (Object)CommonConstant.DEL_FLAG_0);
            List dbHeadList = this.purchaseEnquiryHeadService.list((Wrapper)queryWrapper1);
            ArrayList hideHeadIdList = new ArrayList();
            dbHeadList.forEach(dbHead -> {
                boolean showPrice;
                boolean bl = showPrice = "1".equals(dbHead.getSeePrice()) || "1".equals(dbHead.getOpenBidStatus()) || new Date().after(dbHead.getQuoteEndTime());
                if (showPrice) {
                    hideHeadIdList.add(dbHead.getId());
                }
            });
            if (CollectionUtils.isEmpty(hideHeadIdList)) {
                Result.ok((Object)pageList);
            }
            List newRecordList = records.stream().filter(item -> hideHeadIdList.contains(item.getHeadId())).collect(Collectors.toList());
            pageList.setRecords(newRecordList);
        }
        return JSON.toJSONString((Object)pageList.getRecords());
    }
}

