/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.enquiry.excel;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.els.common.aspect.annotation.RpcService;
import com.els.common.excel.poi.excel.entity.vo.ExcelTemplateGroupVO;
import com.els.common.excel.poi.excel.entity.vo.ExcelTemplateHeadVO;
import com.els.common.excel.service.ErrorExcelHandlerService;
import com.els.common.util.FormulaUtil;
import com.els.common.util.I18nUtil;
import com.els.common.util.SysUtil;
import com.els.modules.base.api.dto.ExcelImportDTO;
import com.els.modules.base.api.dto.TemplateConfigItemDTO;
import com.els.modules.base.api.dto.TemplateHeadDTO;
import com.els.modules.base.api.service.ExcelItemByConfigRpcService;
import com.els.modules.enquiry.entity.SaleEnquiryHead;
import com.els.modules.enquiry.entity.SaleEnquiryItem;
import com.els.modules.enquiry.enumerate.EnquiryQuoteWayEnum;
import com.els.modules.enquiry.service.SaleEnquiryHeadService;
import com.els.modules.enquiry.service.SaleEnquiryItemService;
import com.els.modules.inquiry.enumerate.QuoteTypeEnum;
import com.els.modules.system.dto.ExcelByConfigDTO;
import com.els.rpc.service.InvokeBaseRpcService;
import java.io.Serializable;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

@RpcService(value="saleEnquiryItemExcelRpcServiceImpl")
public class SaleEnquiryItemExcelServiceImpl
extends ErrorExcelHandlerService
implements ExcelItemByConfigRpcService {
    private static final Logger log = LoggerFactory.getLogger(SaleEnquiryItemExcelServiceImpl.class);
    @Autowired
    private SaleEnquiryHeadService saleEnquiryHeadService;
    @Autowired
    private SaleEnquiryItemService saleEnquiryItemService;
    @Resource
    private InvokeBaseRpcService invokeBaseRpcService;
    private String headId;

    public TemplateHeadDTO getTemplate(ExcelByConfigDTO excelByConfigDTO) {
        String templateAccount = excelByConfigDTO.getTemplateAccount();
        String templateVersion = excelByConfigDTO.getTemplateVersion();
        String templateNumber = excelByConfigDTO.getTemplateNumber();
        if (StrUtil.isNotBlank((CharSequence)excelByConfigDTO.getHeadId()) && !"undefined".equals(excelByConfigDTO.getHeadId())) {
            this.headId = excelByConfigDTO.getHeadId();
            SaleEnquiryHead dbHead = (SaleEnquiryHead)((Object)this.saleEnquiryHeadService.getById((Serializable)((Object)excelByConfigDTO.getHeadId())));
            templateAccount = StrUtil.isNotBlank((CharSequence)dbHead.getTemplateAccount()) ? dbHead.getTemplateAccount() : dbHead.getElsAccount();
            templateVersion = String.valueOf(dbHead.getTemplateVersion());
            templateNumber = String.valueOf(dbHead.getTemplateNumber());
        }
        return this.invokeBaseRpcService.getTemplateConfig(templateAccount, templateNumber, templateVersion);
    }

    public List<Object> getExportData(ExcelByConfigDTO excelByConfigDTO) {
        List<SaleEnquiryItem> itemList = this.saleEnquiryItemService.selectByMainId(excelByConfigDTO.getHeadId());
        return new ArrayList<SaleEnquiryItem>(itemList);
    }

    public List<Map<String, Object>> importExcel(ExcelImportDTO excelImportDTO) {
        List dataList = excelImportDTO.getDataList();
        int totalCount = 0 == excelImportDTO.getTotalCount() ? dataList.size() : excelImportDTO.getTotalCount();
        ArrayList oldList = new ArrayList();
        for (Map data : dataList) {
            oldList.add(new HashMap(data));
            if (data.get("quotePrice") == null || !"0".equals(data.get("quotePrice").toString())) continue;
            for (Map.Entry entry : data.entrySet()) {
                String key = (String)entry.getKey();
                if ("itemNumber".equals(key) || "quotePrice".equals(key)) continue;
                data.put((String)entry.getKey(), null);
            }
        }
        List quotePriceList = null;
        Map costPriceMap = null;
        if (((Map)dataList.get(dataList.size() - 1)).get("otherSheetList") != null) {
            quotePriceList = (List)((Map)dataList.get(dataList.size() - 1)).get("otherSheetList");
            dataList.remove(dataList.size() - 1);
            oldList.remove(oldList.size() - 1);
            if (((Map)quotePriceList.get(quotePriceList.size() - 1)).get("costPrice") != null) {
                costPriceMap = (Map)((Map)quotePriceList.get(quotePriceList.size() - 1)).get("costPrice");
                quotePriceList.remove(quotePriceList.size() - 1);
            }
        }
        SaleEnquiryHead dbHead = (SaleEnquiryHead)((Object)this.saleEnquiryHeadService.getById((Serializable)((Object)this.headId)));
        List<SaleEnquiryItem> dbItemList = this.saleEnquiryItemService.selectByMainId(this.headId);
        List<String> excludeColumn = Arrays.asList("price", "netPrice", "taxCode", "taxRate", "taxAmount", "netAmount");
        TemplateHeadDTO template = this.getTemplate(excelImportDTO.getExcelByConfigDTO());
        Map editColumnMap = template.getTemplateConfigItemList().stream().filter(item -> !excludeColumn.contains(item.getFieldName())).collect(Collectors.toMap(TemplateConfigItemDTO::getFieldName, Function.identity(), (v1, v2) -> v2));
        List editColumn = template.getTemplateConfigItemList().stream().filter(item -> "1".equals(item.getSaleEdit())).map(TemplateConfigItemDTO::getFieldName).filter(s -> !excludeColumn.contains(s)).collect(Collectors.toList());
        if ("1".equals(dbHead.getSupplierTaxRate())) {
            editColumn.add("taxCode");
        }
        if (QuoteTypeEnum.TAX_EXCLUDING.getValue().equals(dbHead.getQuoteType())) {
            editColumn.add("netPrice");
        } else {
            editColumn.add("price");
        }
        Map taxMap = this.invokeBaseRpcService.getAllTax(dbHead.getToElsAccount());
        Iterator iterator = dataList.iterator();
        Iterator oldIterator = oldList.iterator();
        while (iterator.hasNext()) {
            String msg;
            String taxCode;
            List list;
            Map data = (Map)iterator.next();
            Map errorData = (Map)oldIterator.next();
            boolean flag = this.checkDisableConfigItemData(excelImportDTO, iterator, editColumnMap, editColumn, errorData);
            if (!flag || CollectionUtil.isEmpty(list = dbItemList.stream().filter(s -> s.getItemNumber().equals(data.get("itemNumber"))).collect(Collectors.toList()))) continue;
            SaleEnquiryItem dbItem = (SaleEnquiryItem)((Object)list.get(0));
            BigDecimal requireQuantity = dbItem.getRequireQuantity() != null ? dbItem.getRequireQuantity() : BigDecimal.ONE;
            for (Map.Entry entry : data.entrySet()) {
                if (!(editColumn.contains(entry.getKey()) || "itemNumber".equals(entry.getKey()) || "quotePrice".equals(entry.getKey()))) {
                    data.put((String)entry.getKey(), null);
                    continue;
                }
                data.put((String)entry.getKey(), entry.getValue());
            }
            if (!EnquiryQuoteWayEnum.NORMAL.getValue().equals(dbItem.getQuotePriceWay())) {
                data.put("price", null);
                data.put("netPrice", null);
            }
            if (data.get("quotePrice") != null && "0".equals(data.get("quotePrice").toString())) continue;
            String string = taxCode = "1".equals(dbHead.getSupplierTaxRate()) ? (String)data.get("taxCode") : dbItem.getTaxCode();
            if ("1".equals(dbHead.getSupplierTaxRate()) && StrUtil.isBlank((CharSequence)taxCode)) {
                msg = I18nUtil.translate((String)"i18n_alert_foxOLV_79b3243", (String)"\u7a0e\u7801\u4e0d\u80fd\u4e3a\u7a7a");
                this.errorAdd(excelImportDTO, msg, errorData);
                iterator.remove();
                continue;
            }
            if (!taxMap.containsKey(taxCode)) {
                msg = I18nUtil.translate((String)"i18n_alert_foWWWWWWWxMK_e919daf8", (String)"\u7a0e\u7801\uff1a[${0}]\u4e0d\u5b58\u5728", (String[])new String[]{taxCode});
                this.errorAdd(excelImportDTO, msg, errorData);
                iterator.remove();
                continue;
            }
            BigDecimal taxRate = (BigDecimal)taxMap.get(taxCode);
            data.put("taxRate", taxRate);
            if (EnquiryQuoteWayEnum.LADDER.getValue().equals(dbItem.getQuotePriceWay()) && quotePriceList != null) {
                List newQuotePriceList = quotePriceList.stream().filter(info -> dbItem.getItemNumber().equals(info.get("itemNumber"))).collect(Collectors.toList());
                boolean ltLadderQuantity = true;
                BigDecimal price = null;
                BigDecimal netPrice = null;
                for (Map ladder : newQuotePriceList) {
                    BigDecimal ladderQuantity = new BigDecimal((String)ladder.get("ladderQuantity"));
                    if (QuoteTypeEnum.TAX_EXCLUDING.getValue().equals(dbHead.getQuoteType()) && ladder.get("netPrice") != null) {
                        temp = taxRate.divide(new BigDecimal("100")).add(BigDecimal.ONE);
                        result = new BigDecimal((String)ladder.get("netPrice")).multiply(temp);
                        result = result.setScale(6, RoundingMode.HALF_UP);
                        ladder.put("price", result);
                    } else if (QuoteTypeEnum.TAX_INCLUDING.getValue().equals(dbHead.getQuoteType()) && ladder.get("price") != null) {
                        temp = taxRate.divide(new BigDecimal("100")).add(BigDecimal.ONE);
                        result = new BigDecimal((String)ladder.get("price")).divide(temp, 6, RoundingMode.HALF_UP);
                        result = result.setScale(6, RoundingMode.HALF_UP);
                        ladder.put("netPrice", result);
                    }
                    if (requireQuantity.compareTo(ladderQuantity) < 0) continue;
                    price = ladder.get("price") instanceof BigDecimal ? (BigDecimal)ladder.get("price") : new BigDecimal((String)ladder.get("price"));
                    netPrice = ladder.get("netPrice") instanceof BigDecimal ? (BigDecimal)ladder.get("netPrice") : new BigDecimal((String)ladder.get("netPrice"));
                    ltLadderQuantity = false;
                }
                if (ltLadderQuantity) {
                    Object priceObject = ((Map)newQuotePriceList.get(0)).get("price");
                    price = priceObject instanceof BigDecimal ? (BigDecimal)priceObject : new BigDecimal((String)priceObject);
                    Object netPriceObject = ((Map)newQuotePriceList.get(0)).get("netPrice");
                    netPrice = netPriceObject instanceof BigDecimal ? (BigDecimal)netPriceObject : new BigDecimal((String)netPriceObject);
                }
                data.put("price", price);
                data.put("netPrice", netPrice);
                data.put("ladderPriceJson", JSONArray.toJSONString(newQuotePriceList));
                data.put("netAmount", netPrice == null ? null : netPrice.multiply(requireQuantity).setScale(6, RoundingMode.HALF_UP));
                data.put("taxAmount", price == null ? null : price.multiply(requireQuantity).setScale(6, RoundingMode.HALF_UP));
                continue;
            }
            if (!EnquiryQuoteWayEnum.COST.getValue().equals(dbItem.getQuotePriceWay()) || quotePriceList == null) continue;
            List costList = (List)costPriceMap.get(dbItem.getMaterialNumber());
            log.info("cost-data:{}", (Object)costList);
            Map<Object, List<Map>> groupList = costList.stream().collect(Collectors.groupingBy(a -> a.get("groupName")));
            JSONObject costJson = JSONObject.parseObject((String)dbItem.getCostFormJson());
            ArrayList<JSONObject> newCostGroupJsonList = new ArrayList<JSONObject>();
            String templateNumber = costJson.getString("templateNumber");
            String templateAccount = costJson.getString("templateAccount");
            String templateVersion = costJson.getString("templateVersion");
            TemplateHeadDTO templateConfig = this.invokeBaseRpcService.getTemplateConfig(templateAccount, templateNumber, templateVersion);
            Map<String, List<TemplateConfigItemDTO>> configItemMap = templateConfig.getTemplateConfigItemList().stream().collect(Collectors.groupingBy(TemplateConfigItemDTO::getGroupCode));
            ExcelTemplateHeadVO excelTemplateHeadVO = this.invokeBaseRpcService.selectVoById(templateConfig.getId());
            BigDecimal totalPrice = BigDecimal.ZERO;
            BigDecimal totalNetPrice = BigDecimal.ZERO;
            BigDecimal totalTaxRate = BigDecimal.ONE.add(taxRate.divide(new BigDecimal("100")));
            for (ExcelTemplateGroupVO templateGroupDTO : excelTemplateHeadVO.getTemplateGroupList()) {
                BigDecimal groupPrice;
                BigDecimal groupNetPrice;
                BigDecimal groupTotalValue = BigDecimal.ZERO;
                JSONObject group = new JSONObject();
                group.put("groupType", (Object)"item");
                group.put("groupName", (Object)templateGroupDTO.getGroupName());
                group.put("groupCode", (Object)templateGroupDTO.getGroupCode());
                List<TemplateConfigItemDTO> templateConfigItemDTOS = configItemMap.get(templateGroupDTO.getGroupCode());
                if (CollectionUtil.isEmpty(templateConfigItemDTOS)) continue;
                List<Map> itemListMaps = groupList.get(templateGroupDTO.getGroupCode());
                List formulaTemplateConfigItemDTOS = templateConfigItemDTOS.stream().filter(templateConfigItemDTO -> StrUtil.isNotBlank((CharSequence)templateConfigItemDTO.getFormula())).collect(Collectors.toList());
                Map<String, String> formulaMap = formulaTemplateConfigItemDTOS.stream().collect(Collectors.toMap(TemplateConfigItemDTO::getFieldName, TemplateConfigItemDTO::getFormula, (o1, o2) -> o1));
                TemplateConfigItemDTO sumTemplateConfigItemDTO = templateConfigItemDTOS.stream().filter(templateConfigItemDTO -> "1".equals(templateConfigItemDTO.getSum())).findFirst().orElse(null);
                if (CollectionUtil.isNotEmpty(itemListMaps) && sumTemplateConfigItemDTO != null) {
                    for (Map itemListMap : itemListMaps) {
                        itemListMap.putIfAbsent(sumTemplateConfigItemDTO.getFieldName(), BigDecimal.ZERO);
                        for (String fieldName : itemListMap.keySet()) {
                            FormulaUtil.compute((String)fieldName, formulaMap, (Map)itemListMap);
                        }
                        BigDecimal itemTotalValue = itemListMap.get(sumTemplateConfigItemDTO.getFieldName()) == null ? BigDecimal.ZERO : new BigDecimal(itemListMap.get(sumTemplateConfigItemDTO.getFieldName()).toString());
                        groupTotalValue = groupTotalValue.add(itemTotalValue);
                    }
                }
                if (QuoteTypeEnum.TAX_EXCLUDING.getValue().equals(dbHead.getQuoteType())) {
                    groupNetPrice = groupTotalValue;
                    groupPrice = groupNetPrice.multiply(totalTaxRate).setScale(6, RoundingMode.HALF_UP);
                } else {
                    groupPrice = groupTotalValue;
                    groupNetPrice = groupPrice.divide(totalTaxRate, 6, RoundingMode.HALF_UP);
                }
                totalPrice = totalPrice.add(groupPrice);
                totalNetPrice = totalNetPrice.add(groupNetPrice);
                group.put("price", (Object)groupPrice);
                group.put("netPrice", (Object)groupNetPrice);
                group.put("totalValue", (Object)groupTotalValue);
                newCostGroupJsonList.add(group);
            }
            data.put("price", totalPrice.toString());
            data.put("netPrice", totalNetPrice.toString());
            data.put("taxAmount", dbItem.getRequireQuantity().multiply(totalPrice).setScale(6, RoundingMode.HALF_UP).toString());
            data.put("netAmount", dbItem.getRequireQuantity().multiply(totalNetPrice).setScale(6, RoundingMode.HALF_UP).toString());
            String newDataJsonStr = JSONObject.toJSONString(groupList);
            costJson.put("data", JSONObject.parse((String)newDataJsonStr));
            costJson.put("groups", newCostGroupJsonList);
            data.put("costFormJson", JSONObject.toJSONString((Object)costJson));
        }
        this.errorHandle(true, excelImportDTO, SysUtil.getLoginUser().getElsAccount(), totalCount);
        return dataList;
    }
}

