/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.enquiry.job.utils;

import com.alibaba.fastjson.JSONObject;
import com.els.common.constant.CommonConstant;
import com.els.common.exception.ELSBootException;
import com.els.common.util.DateUtils;
import com.els.common.util.SpringContextUtils;
import com.els.config.mybatis.TenantContext;
import com.els.modules.enquiry.entity.PurchaseEnquiryHead;
import com.els.modules.inquiry.rpc.service.InquriyInvokeJobRpcService;
import com.els.modules.job.api.dto.QuartzJobDTO;
import java.util.Date;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EnquiryJobUtil {
    private static final Logger log = LoggerFactory.getLogger(EnquiryJobUtil.class);
    private static InquriyInvokeJobRpcService inquriyInvokeJobRpcService = (InquriyInvokeJobRpcService)SpringContextUtils.getBean(InquriyInvokeJobRpcService.class);
    private static final String ENQUIRY_END_JOB = "srmEnquiryEndJobServiceImpl";

    public static void updateOrCreateJob(PurchaseEnquiryHead head, Date quoteEndTime) {
        String elsAccount = TenantContext.getTenant();
        String jobNameKey = "srmEnquiryEndJobServiceImpl_" + head.getEnquiryNumber() + "_" + elsAccount;
        String cron = DateUtils.formatDate((Date)quoteEndTime, (String)"ss mm HH dd MM ? yyyy");
        QuartzJobDTO job = new QuartzJobDTO();
        job.setCronExpression(cron);
        job.setJobClassName("com.els.modules.quartz.job.BusinessJob");
        job.setStatus(CommonConstant.STATUS_NORMAL);
        job.setJobNameKey(jobNameKey);
        JSONObject paramObj = new JSONObject();
        paramObj.put("id", (Object)head.getId());
        paramObj.put("jobKey", (Object)job.getJobNameKey());
        paramObj.put("tenantId", (Object)TenantContext.getTenant());
        paramObj.put("jobImplName", (Object)ENQUIRY_END_JOB);
        job.setParameter(paramObj.toJSONString());
        job.setElsAccount(elsAccount);
        List<QuartzJobDTO> jobList = inquriyInvokeJobRpcService.findJobList(jobNameKey);
        try {
            if (jobList.isEmpty()) {
                inquriyInvokeJobRpcService.createJob(job);
            } else {
                job.setId(jobList.get(0).getId());
                inquriyInvokeJobRpcService.updateJob(job);
            }
        }
        catch (Exception e) {
            throw new ELSBootException((Throwable)e);
        }
    }

    public static void deleteJob(String jobKey) {
        List<QuartzJobDTO> jobList = inquriyInvokeJobRpcService.findJobList(jobKey);
        if (!jobList.isEmpty()) {
            inquriyInvokeJobRpcService.deleteJob(jobList.get(0));
        }
    }

    public static void deleteJob(PurchaseEnquiryHead dbHead) {
        String jobKey = "srmEnquiryEndJobServiceImpl_" + dbHead.getEnquiryNumber() + "_" + dbHead.getElsAccount();
        EnquiryJobUtil.deleteJob(jobKey);
    }

    public static void createJob(QuartzJobDTO job) {
        List<QuartzJobDTO> jobList = inquriyInvokeJobRpcService.findJobList(job.getJobNameKey());
        try {
            if (jobList.isEmpty()) {
                inquriyInvokeJobRpcService.createJob(job);
            } else {
                job.setId(jobList.get(0).getId());
                inquriyInvokeJobRpcService.updateJob(job);
            }
        }
        catch (Exception e) {
            throw new ELSBootException((Throwable)e);
        }
    }
}

