/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.forecast.service.impl;

import cn.hutool.core.util.StrUtil;
import com.els.common.exception.ELSBootException;
import com.els.common.system.base.service.impl.BaseServiceImpl;
import com.els.common.util.I18nUtil;
import com.els.config.mybatis.TenantContext;
import com.els.modules.forecast.entity.PurchaseForecastWhitelist;
import com.els.modules.forecast.enumerate.WhitelistStatusEnum;
import com.els.modules.forecast.mapper.PurchaseForecastWhitelistMapper;
import com.els.modules.forecast.service.PurchaseForecastWhitelistService;
import com.els.rpc.service.InvokeBaseRpcService;
import java.io.Serializable;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@Service
public class PurchaseForecastWhitelistServiceImpl
extends BaseServiceImpl<PurchaseForecastWhitelistMapper, PurchaseForecastWhitelist>
implements PurchaseForecastWhitelistService {
    @Resource
    private InvokeBaseRpcService invokeBaseRpcService;

    @Override
    public void add(PurchaseForecastWhitelist whitelist) {
        whitelist.setElsAccount(TenantContext.getTenant());
        whitelist.setBusAccount(TenantContext.getTenant());
        String whitelistNumber = this.invokeBaseRpcService.getNextCode("srmForecastWhitelistNumber", (Object)whitelist);
        whitelist.setWhitelistNumber(whitelistNumber);
        whitelist.setWhitelistStatus(WhitelistStatusEnum.NEW.getValue());
        ((PurchaseForecastWhitelistMapper)this.baseMapper).insert((Object)whitelist);
    }

    @Override
    public void submit(PurchaseForecastWhitelist whitelist) {
        whitelist.setElsAccount(TenantContext.getTenant());
        whitelist.setBusAccount(TenantContext.getTenant());
        whitelist.setWhitelistStatus(WhitelistStatusEnum.ENABLE.getValue());
        whitelist.setMaterialGroup(StrUtil.isBlank((CharSequence)whitelist.getMaterialGroup()) ? "all" : whitelist.getMaterialGroup());
        ((PurchaseForecastWhitelistMapper)this.baseMapper).updateById((Object)whitelist);
    }

    @Override
    public void delete(String id) {
        ((PurchaseForecastWhitelistMapper)this.baseMapper).deleteById((Serializable)((Object)id));
    }

    @Override
    public void enable(String id) {
        PurchaseForecastWhitelist whitelist = new PurchaseForecastWhitelist();
        whitelist.setId(id);
        whitelist.setWhitelistStatus(WhitelistStatusEnum.ENABLE.getValue());
        int count = ((PurchaseForecastWhitelistMapper)this.baseMapper).updateById((Object)whitelist);
        if (count == 0) {
            throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_APWFIKXWVVVXVSDJHrW_2fe92d52", (String)"\u5f53\u524d\u6570\u636e\u5df2\u5931\u6548\uff0c\u8bf7\u91cd\u65b0\u5237\u65b0\u540e\u63d0\u4ea4\u66f4\u6539"));
        }
    }

    @Override
    public void disable(String id) {
        PurchaseForecastWhitelist whitelist = new PurchaseForecastWhitelist();
        whitelist.setId(id);
        whitelist.setWhitelistStatus(WhitelistStatusEnum.DISABLE.getValue());
        int count = ((PurchaseForecastWhitelistMapper)this.baseMapper).updateById((Object)whitelist);
        if (count == 0) {
            throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_APWFIKXWVVVXVSDJHrW_2fe92d52", (String)"\u5f53\u524d\u6570\u636e\u5df2\u5931\u6548\uff0c\u8bf7\u91cd\u65b0\u5237\u65b0\u540e\u63d0\u4ea4\u66f4\u6539"));
        }
    }
}

