/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.logisticspurchase.base.controller;

import cn.hutool.core.convert.Convert;
import cn.hutool.core.util.StrUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.els.common.api.vo.Result;
import com.els.common.aspect.annotation.AutoLog;
import com.els.common.aspect.annotation.PermissionDataOpt;
import com.els.common.aspect.annotation.PermissionDataView;
import com.els.common.aspect.annotation.SrmValidated;
import com.els.common.enumerate.AuditStatusEnum;
import com.els.common.exception.ELSBootException;
import com.els.common.system.base.controller.BaseController;
import com.els.common.system.query.QueryGenerator;
import com.els.common.util.I18nUtil;
import com.els.common.vo.CountVO;
import com.els.config.mybatis.TenantContext;
import com.els.modules.base.api.dto.DictDTO;
import com.els.modules.logisticspurchase.base.entity.LogisticsPurchasePriceRecords;
import com.els.modules.logisticspurchase.base.excel.LogisticsPurchasePriceRecordsExportServiceImpl;
import com.els.modules.logisticspurchase.base.service.LogisticsPurchasePriceRecordsService;
import com.els.modules.logisticspurchase.base.vo.LogisticsPurchasePriceRecordsVO;
import com.els.modules.price.api.enumerate.PriceStatusEnum;
import com.els.rpc.service.InvokeBaseRpcService;
import com.google.common.collect.Lists;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.servlet.ModelAndView;

@Api(tags={"\u7269\u6d41\u91c7\u8d2d\u4ef7\u683c\u4e3b\u6570\u636e"})
@RestController
@RequestMapping(value={"/lpbase/lpPriceRecords"})
public class LogisticsPurchasePriceRecordsController
extends BaseController<LogisticsPurchasePriceRecords, LogisticsPurchasePriceRecordsService> {
    @Autowired
    private LogisticsPurchasePriceRecordsService logisticsPurchasePriceRecordsService;
    @Autowired
    private InvokeBaseRpcService invokeBaseRpcService;

    @ApiOperation(value="\u5206\u9875\u5217\u8868\u67e5\u8be2", notes="\u5206\u9875\u5217\u8868\u67e5\u8be2")
    @GetMapping(value={"/list"})
    @RequiresPermissions(value={"lpbase#lpPriceRecords:list"})
    @PermissionDataView(businessType="price")
    public Result<?> queryPageList(LogisticsPurchasePriceRecords logisticsPurchasePriceRecords, @RequestParam(name="pageNo", defaultValue="1") Integer pageNo, @RequestParam(name="pageSize", defaultValue="10") Integer pageSize, HttpServletRequest req) {
        QueryWrapper queryWrapper = QueryGenerator.initQueryWrapper((Object)((Object)logisticsPurchasePriceRecords), (Map)req.getParameterMap());
        Page page = new Page((long)pageNo.intValue(), (long)pageSize.intValue());
        IPage pageList = this.logisticsPurchasePriceRecordsService.page((IPage)page, (Wrapper)queryWrapper);
        return Result.ok((Object)pageList);
    }

    @ApiOperation(value="\u5206\u9875\u5217\u8868\u67e5\u8be2", notes="\u5206\u9875\u5217\u8868\u67e5\u8be2")
    @GetMapping(value={"/itemList"})
    @RequiresPermissions(value={"lpbase#lpPriceRecords:list"})
    @PermissionDataView(businessType="price")
    public Result<?> queryPageItemList(LogisticsPurchasePriceRecords logisticsPurchasePriceRecords, @RequestParam(name="pageNo", defaultValue="1") Integer pageNo, @RequestParam(name="pageSize", defaultValue="10") Integer pageSize, HttpServletRequest req) {
        QueryWrapper queryWrapper = QueryGenerator.initQueryWrapper((Object)((Object)logisticsPurchasePriceRecords), (Map)req.getParameterMap());
        ((LambdaQueryWrapper)queryWrapper.lambda().in(LogisticsPurchasePriceRecords::getRecordStatus, (Collection)Lists.newArrayList((Object[])new String[]{PriceStatusEnum.EFFECTIVE.getValue(), PriceStatusEnum.NORMAL.getValue()}))).in(LogisticsPurchasePriceRecords::getAuditStatus, (Collection)Lists.newArrayList((Object[])new String[]{AuditStatusEnum.NO_AUDIT_REQUIRED.getValue(), AuditStatusEnum.AUDIT_FINISH.getValue()}));
        Page page = new Page((long)pageNo.intValue(), (long)pageSize.intValue());
        IPage pageList = this.logisticsPurchasePriceRecordsService.page((IPage)page, (Wrapper)queryWrapper);
        return Result.ok((Object)pageList);
    }

    @AutoLog(value="\u4ef7\u683c\u4e3b\u6570\u636e-\u5206\u9875\u67e5\u8be2\u6709\u6548\u671f\u5185\u7684\u4ef7\u683c")
    @ApiOperation(value="\u5206\u9875\u67e5\u8be2\u6709\u6548\u671f\u5185\u7684\u4ef7\u683c", notes="\u5206\u9875\u67e5\u8be2\u6709\u6548\u671f\u5185\u7684\u4ef7\u683c")
    @GetMapping(value={"/avliabledPrice"})
    @RequiresPermissions(value={"lpbase#lpPriceRecords:list"})
    public Result<?> queryPageAvliabledPriceList(LogisticsPurchasePriceRecords logisticsPurchasePriceRecords, @RequestParam(name="pageNo", defaultValue="1") Integer pageNo, @RequestParam(name="pageSize", defaultValue="10") Integer pageSize, HttpServletRequest req) {
        QueryWrapper queryWrapper = QueryGenerator.initQueryWrapper((Object)((Object)logisticsPurchasePriceRecords), (Map)req.getParameterMap());
        queryWrapper.eq((Object)"purchase_org", (Object)logisticsPurchasePriceRecords.getPurchaseOrg());
        queryWrapper.eq((Object)"to_els_account", (Object)logisticsPurchasePriceRecords.getToElsAccount());
        queryWrapper.eq((Object)"material_number", (Object)logisticsPurchasePriceRecords.getMaterialNumber());
        if (StrUtil.isNotBlank((CharSequence)logisticsPurchasePriceRecords.getFactory())) {
            queryWrapper.eq((Object)"factory", (Object)logisticsPurchasePriceRecords.getFactory());
        }
        if (StrUtil.isNotBlank((CharSequence)logisticsPurchasePriceRecords.getToCompany())) {
            queryWrapper.eq((Object)"to_company", (Object)logisticsPurchasePriceRecords.getToCompany());
        }
        queryWrapper.and(qw -> ((QueryWrapper)qw.eq((Object)"record_status", (Object)PriceStatusEnum.NORMAL.getValue())).or(qw1 -> qw1.eq((Object)"record_status", (Object)PriceStatusEnum.EFFECTIVE.getValue())));
        queryWrapper.le((Object)"effective_date", (Object)new Date());
        ((QueryWrapper)((QueryWrapper)queryWrapper.ge((Object)"expiry_date", (Object)new Date())).isNotNull((Object)"effective_date")).isNotNull((Object)"expiry_date");
        Page page = new Page((long)pageNo.intValue(), (long)pageSize.intValue());
        IPage pageList = this.logisticsPurchasePriceRecordsService.page((IPage)page, (Wrapper)queryWrapper);
        return Result.ok((Object)pageList);
    }

    @SrmValidated
    @AutoLog(value="\u4ef7\u683c\u4e3b\u6570\u636e-\u6dfb\u52a0")
    @ApiOperation(value="\u6dfb\u52a0", notes="\u6dfb\u52a0")
    @PostMapping(value={"/add"})
    @RequiresPermissions(value={"lpbase#lpPriceRecords:add"})
    @PermissionDataOpt(businessType="price", beanClass=LogisticsPurchasePriceRecordsService.class)
    public Result<?> add(@RequestBody LogisticsPurchasePriceRecordsVO logisticsPurchasePriceRecords) {
        if (StrUtil.isNotBlank((CharSequence)logisticsPurchasePriceRecords.getToElsAccount()) && logisticsPurchasePriceRecords.getToElsAccount().equals(logisticsPurchasePriceRecords.getElsAccount()) && StrUtil.isNotBlank((CharSequence)logisticsPurchasePriceRecords.getToCompany()) && StrUtil.isNotBlank((CharSequence)logisticsPurchasePriceRecords.getCompany()) && logisticsPurchasePriceRecords.getCompany().equals(logisticsPurchasePriceRecords.getToCompany())) {
            throw new ELSBootException("\u516c\u53f8\u95f4\u5355\u636e\uff0c\u516c\u53f8\u4ee3\u7801\u548c\u4f9b\u5e94\u5546\u516c\u53f8\u4ee3\u7801\u4e0d\u80fd\u76f8\u540c");
        }
        this.logisticsPurchasePriceRecordsService.saveLogisticsPurchasePriceRecords(logisticsPurchasePriceRecords, logisticsPurchasePriceRecords.getAttachmentList());
        return Result.ok((Object)((Object)logisticsPurchasePriceRecords));
    }

    @SrmValidated
    @AutoLog(value="\u4ef7\u683c\u4e3b\u6570\u636e-\u7f16\u8f91")
    @ApiOperation(value="\u7f16\u8f91", notes="\u7f16\u8f91")
    @PostMapping(value={"/edit"})
    @RequiresPermissions(value={"lpbase#lpPriceRecords:add"})
    @PermissionDataOpt(businessType="price", beanClass=LogisticsPurchasePriceRecordsService.class)
    public Result<?> edit(@RequestBody LogisticsPurchasePriceRecordsVO logisticsPurchasePriceRecords) {
        if (StrUtil.isNotBlank((CharSequence)logisticsPurchasePriceRecords.getToElsAccount()) && logisticsPurchasePriceRecords.getToElsAccount().equals(logisticsPurchasePriceRecords.getElsAccount()) && StrUtil.isNotBlank((CharSequence)logisticsPurchasePriceRecords.getToCompany()) && StrUtil.isNotBlank((CharSequence)logisticsPurchasePriceRecords.getCompany()) && logisticsPurchasePriceRecords.getCompany().equals(logisticsPurchasePriceRecords.getToCompany())) {
            throw new ELSBootException("\u516c\u53f8\u95f4\u5355\u636e\uff0c\u516c\u53f8\u4ee3\u7801\u548c\u4f9b\u5e94\u5546\u516c\u53f8\u4ee3\u7801\u4e0d\u80fd\u76f8\u540c");
        }
        this.logisticsPurchasePriceRecordsService.updateLogisticsPurchasePriceRecords(logisticsPurchasePriceRecords, logisticsPurchasePriceRecords.getAttachmentList());
        return Result.ok((Object)((Object)logisticsPurchasePriceRecords));
    }

    @AutoLog(value="\u4ef7\u683c\u4e3b\u6570\u636e-\u901a\u8fc7id\u51bb\u7ed3")
    @ApiOperation(value="\u901a\u8fc7id\u51bb\u7ed3", notes="\u901a\u8fc7id\u51bb\u7ed3")
    @GetMapping(value={"/frozen"})
    @RequiresPermissions(value={"lpbase#lpPriceRecords:frozen"})
    @PermissionDataOpt(businessType="price", beanClass=LogisticsPurchasePriceRecordsService.class)
    public Result<?> frozen(@RequestParam(name="id") String id) {
        this.logisticsPurchasePriceRecordsService.frozenLogisticsPurchasePriceRecords(id);
        return this.commonSuccessResult(3);
    }

    @AutoLog(value="\u4ef7\u683c\u4e3b\u6570\u636e-\u901a\u8fc7id\u89e3\u51bb")
    @ApiOperation(value="\u901a\u8fc7id\u89e3\u51bb", notes="\u901a\u8fc7id\u89e3\u51bb")
    @GetMapping(value={"/thaw"})
    @RequiresPermissions(value={"lpbase#lpPriceRecords:thaw"})
    @PermissionDataOpt(businessType="price", beanClass=LogisticsPurchasePriceRecordsService.class)
    public Result<?> thaw(@RequestParam(name="id") String id) {
        this.logisticsPurchasePriceRecordsService.thawLogisticsPurchasePriceRecords(id);
        return this.commonSuccessResult(3);
    }

    @AutoLog(value="\u4ef7\u683c\u4e3b\u6570\u636e-\u901a\u8fc7id\u4f5c\u5e9f")
    @ApiOperation(value="\u901a\u8fc7id\u4f5c\u5e9f", notes="\u901a\u8fc7id\u4f5c\u5e9f")
    @GetMapping(value={"/cancel"})
    @RequiresPermissions(value={"lpbase#lpPriceRecords:cancel"})
    @PermissionDataOpt(businessType="price", beanClass=LogisticsPurchasePriceRecordsService.class)
    public Result<?> cancel(@RequestParam(name="id") String id) {
        this.logisticsPurchasePriceRecordsService.cancelLogisticsPurchasePriceRecords(id);
        return this.commonSuccessResult(3);
    }

    @AutoLog(value="\u4ef7\u683c\u4e3b\u6570\u636e-\u901a\u8fc7id\u5220\u9664")
    @ApiOperation(value="\u901a\u8fc7id\u5220\u9664", notes="\u901a\u8fc7id\u5220\u9664")
    @GetMapping(value={"/delete"})
    @RequiresPermissions(value={"lpbase#lpPriceRecords:delete"})
    @PermissionDataOpt(businessType="price", beanClass=LogisticsPurchasePriceRecordsService.class)
    public Result<?> delete(@RequestParam(name="id") String id) {
        this.logisticsPurchasePriceRecordsService.delLogisticsPurchasePriceRecords(id);
        return this.commonSuccessResult(4);
    }

    @AutoLog(value="\u4ef7\u683c\u4e3b\u6570\u636e-\u6279\u91cf\u5220\u9664")
    @ApiOperation(value="\u6279\u91cf\u5220\u9664", notes="\u6279\u91cf\u5220\u9664")
    @GetMapping(value={"/deleteBatch"})
    @RequiresPermissions(value={"lpbase#lpPriceRecords:delete"})
    public Result<?> deleteBatch(@RequestParam(name="ids") String ids) {
        List<String> idList = Arrays.asList(ids.split(","));
        this.logisticsPurchasePriceRecordsService.delBatchLogisticsPurchasePriceRecords(idList);
        return this.commonSuccessResult(4);
    }

    @ApiOperation(value="\u901a\u8fc7id\u67e5\u8be2", notes="\u901a\u8fc7id\u67e5\u8be2")
    @GetMapping(value={"/queryById"})
    @RequiresPermissions(value={"lpbase#lpPriceRecords:view"})
    public Result<?> queryById(@RequestParam(name="id") String id) {
        LogisticsPurchasePriceRecords logisticsPurchasePriceRecords = (LogisticsPurchasePriceRecords)((Object)this.logisticsPurchasePriceRecordsService.getById((Serializable)((Object)id)));
        List attachmentDTOS = this.invokeBaseRpcService.selectPurchaseAttachmentByMainId(id);
        LogisticsPurchasePriceRecordsVO vo = (LogisticsPurchasePriceRecordsVO)((Object)Convert.convert(LogisticsPurchasePriceRecordsVO.class, (Object)((Object)logisticsPurchasePriceRecords)));
        vo.setAttachmentList(attachmentDTOS);
        return Result.ok((Object)((Object)vo));
    }

    @ApiOperation(value="\u901a\u8fc7\u5217\u8868\u9875\u9875\u7b7e\u6570\u91cf\u67e5\u8be2", notes="\u5217\u8868\u9875\u9875\u7b7e\u6570\u91cf\u67e5\u8be2")
    @GetMapping(value={"/counts"})
    @RequiresPermissions(value={"lpbase#lpPriceRecords:list"})
    public Result<?> queryTabsCount(LogisticsPurchasePriceRecords logisticsPurchasePriceRecords, HttpServletRequest req) {
        ArrayList<CountVO> result = new ArrayList<CountVO>();
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.select(new String[]{"record_status", "count(0) as participateQuantity"});
        queryWrapper.groupBy((Object)"record_status");
        List list = ((LogisticsPurchasePriceRecordsService)this.service).list((Wrapper)queryWrapper);
        Map<String, Integer> countMap = list.stream().collect(Collectors.toMap(LogisticsPurchasePriceRecords::getRecordStatus, LogisticsPurchasePriceRecords::getParticipateQuantity));
        Integer all = 0;
        for (Map.Entry<String, Integer> entry : countMap.entrySet()) {
            all = all + entry.getValue();
        }
        result.add(new CountVO(I18nUtil.translate((String)"i18n_title_all", (String)"\u5168\u90e8"), "recordStatus", null, all));
        List srmRectificationAppealStatus = this.invokeBaseRpcService.queryDictItemsByCode("priceStatus", TenantContext.getTenant());
        for (DictDTO status : srmRectificationAppealStatus) {
            Integer total = countMap.get(status.getValue()) == null ? 0 : countMap.get(status.getValue());
            result.add(new CountVO(I18nUtil.translate((String)status.getTextI18nKey(), (String)status.getText()), "recordStatus", status.getValue(), total));
        }
        return Result.ok(result);
    }

    @ApiOperation(value="\u4ef7\u683c\u4e3b\u6570\u636e", notes="\u4f9b\u5e94\u5546\u4fe1\u606f\u5217\u8868\u67e5\u8be2")
    @GetMapping(value={"/querySupplierList"})
    @RequiresPermissions(value={"lpbase#lpPriceRecords:export"})
    public Result<?> querySupplierList(@RequestParam(name="sourceType", required=false) String sourceType, @RequestParam(name="subjectNumber", required=false) String subjectNumber, @RequestParam(name="subjectYear", required=false) String subjectYear) {
        return Result.ok(this.logisticsPurchasePriceRecordsService.getInformationRecordsSupplierList(sourceType, subjectNumber, subjectYear));
    }

    @PostMapping(value={"/exportXls"})
    @PermissionDataView(businessType="price")
    @RequiresPermissions(value={"lpbase#lpPriceRecords:export"})
    public ModelAndView exportXls(HttpServletRequest request, @RequestBody Map<String, Object> object) {
        return super.exportXls(request, object, LogisticsPurchasePriceRecordsExportServiceImpl.class);
    }
}

