/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.logisticspurchase.base.service.impl;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.date.DateTime;
import cn.hutool.core.date.DateUtil;
import cn.hutool.core.util.StrUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.els.common.aspect.annotation.SrmTransaction;
import com.els.common.constant.CommonConstant;
import com.els.common.enumerate.AuditStatusEnum;
import com.els.common.exception.ELSBootException;
import com.els.common.system.base.entity.BaseEntity;
import com.els.common.system.base.service.impl.BaseOpenServiceImpl;
import com.els.common.util.I18nUtil;
import com.els.config.mybatis.TenantContext;
import com.els.modules.base.api.dto.DictDTO;
import com.els.modules.base.api.dto.PurchaseAttachmentDTO;
import com.els.modules.logisticspurchase.base.entity.LogisticsPurchasePriceRecords;
import com.els.modules.logisticspurchase.base.mapper.LogisticsPurchasePriceRecordsMapper;
import com.els.modules.logisticspurchase.base.service.LogisticsPurchasePriceRecordsService;
import com.els.modules.price.api.enumerate.PriceSourceTypeEnum;
import com.els.modules.price.api.enumerate.PriceStatusEnum;
import com.els.rpc.service.InvokeBaseRpcService;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;

@Service
public class LogisticsPurchasePriceRecordsServiceImpl
extends BaseOpenServiceImpl<LogisticsPurchasePriceRecordsMapper, LogisticsPurchasePriceRecords, LogisticsPurchasePriceRecords>
implements LogisticsPurchasePriceRecordsService {
    @Autowired
    private InvokeBaseRpcService baseRpcService;
    @Autowired
    private InvokeBaseRpcService invokeBaseRpcService;

    @Override
    @SrmTransaction
    public void saveLogisticsPurchasePriceRecords(LogisticsPurchasePriceRecords records, List<PurchaseAttachmentDTO> attachmentDTOList) {
        if (null != records.getExpiryDate() && null != records.getEffectiveDate() && records.getExpiryDate().before(records.getEffectiveDate())) {
            throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_umtHjXyRBAxOQUumtHjXAKBA_95550107", (String)"\u4ef7\u683c\u8bb0\u5f55\u6709\u6548\u622a\u6b62\u65e5\u671f\u4e0d\u80fd\u65e9\u4e8e\u4ef7\u683c\u8bb0\u5f55\u6709\u6548\u8d77\u59cb\u65e5\u671f"));
        }
        if (StrUtil.isBlank((CharSequence)records.getInfoRecordNumber())) {
            records.setInfoRecordNumber(this.baseRpcService.getNextCode("srmPriceNumber", (Object)records));
        }
        records.setSourceType(PriceSourceTypeEnum.SRM.getValue());
        if (StrUtil.isEmpty((CharSequence)records.getAuditStatus())) {
            records.setAuditStatus(AuditStatusEnum.AUDIT_NEW.getValue());
        }
        records.setRecordStatus(PriceStatusEnum.NEW.getValue());
        records.setQuoteDate(records.getQuoteDate() == null ? new Date() : records.getQuoteDate());
        if (AuditStatusEnum.NO_AUDIT_REQUIRED.getValue().equals(records.getAuditStatus())) {
            records.setRecordStatus(PriceStatusEnum.NORMAL.getValue());
            this.checkStatus(records);
        }
        this.calculatePrice(records);
        ((LogisticsPurchasePriceRecordsMapper)this.baseMapper).insert((Object)records);
        this.insertAttachmentData(records, attachmentDTOList);
    }

    @Override
    public void calculatePrice(LogisticsPurchasePriceRecords records) {
        BigDecimal taxRate = StrUtil.isBlank((CharSequence)records.getTaxRate()) ? BigDecimal.ZERO : new BigDecimal(records.getTaxRate()).divide(BigDecimal.valueOf(100L));
        BigDecimal price = records.getPrice() == null ? BigDecimal.ZERO : records.getPrice();
        BigDecimal freight = records.getFreight() == null ? BigDecimal.ZERO : records.getFreight();
        BigDecimal discount = records.getDiscount() == null ? BigDecimal.ZERO : records.getDiscount();
        BigDecimal netPrice = price.divide(BigDecimal.ONE.add(taxRate), 6, 4);
        BigDecimal theNetPrice = price.add(freight).subtract(discount);
        records.setNetPrice(netPrice);
        records.setTheNetPrice(theNetPrice);
    }

    private void insertAttachmentData(LogisticsPurchasePriceRecords head, List<PurchaseAttachmentDTO> attachmentList) {
        if (CollectionUtil.isNotEmpty(attachmentList)) {
            for (PurchaseAttachmentDTO entity : attachmentList) {
                entity.setId(null);
                entity.setHeadId(head.getId());
                entity.setElsAccount(head.getElsAccount());
                entity.setCreateBy(head.getCreateBy());
                entity.setCreateTime(head.getCreateTime());
                entity.setUpdateBy(head.getUpdateBy());
                entity.setUpdateTime(head.getUpdateTime());
                entity.setDeleted(CommonConstant.DEL_FLAG_0);
            }
        }
        if (CollectionUtil.isNotEmpty(attachmentList)) {
            this.invokeBaseRpcService.insertPurchaseAttachmentBatchSomeColumn(attachmentList);
        }
    }

    @Override
    @SrmTransaction
    public void updateLogisticsPurchasePriceRecords(LogisticsPurchasePriceRecords purchaseInformationRecords, List<PurchaseAttachmentDTO> attachmentList) {
        if (null != purchaseInformationRecords.getPrice() && purchaseInformationRecords.getPrice().compareTo(BigDecimal.ZERO) < 0) {
            throw new IllegalArgumentException(I18nUtil.translate((String)"i18n_alert_xfuxOXU0_feacb714", (String)"\u542b\u7a0e\u4ef7\u4e0d\u80fd\u5c0f\u4e8e0\uff01"));
        }
        if (null != purchaseInformationRecords.getExpiryDate() && null != purchaseInformationRecords.getEffectiveDate() && purchaseInformationRecords.getExpiryDate().before(purchaseInformationRecords.getEffectiveDate())) {
            throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_umtHjXyRBAxOQUumtHjXAKBA_95550107", (String)"\u4ef7\u683c\u8bb0\u5f55\u6709\u6548\u622a\u6b62\u65e5\u671f\u4e0d\u80fd\u65e9\u4e8e\u4ef7\u683c\u8bb0\u5f55\u6709\u6548\u8d77\u59cb\u65e5\u671f"));
        }
        Assert.isTrue((boolean)StrUtil.isNotBlank((CharSequence)purchaseInformationRecords.getPriceType()), (String)I18nUtil.translate((String)"i18n_alert_umAclS_b641dd5b", (String)"\u4ef7\u683c\u7c7b\u578b\u5fc5\u586b"));
        if ("1".equals(purchaseInformationRecords.getRecordType())) {
            Assert.isTrue((boolean)StrUtil.isNotBlank((CharSequence)purchaseInformationRecords.getMaterialNumber()), (String)I18nUtil.translate((String)"i18n_alert_umAcLSLKWSLAylS_a87995e2", (String)"\u4ef7\u683c\u7c7b\u578b\u4e3a\u7269\u6599\u65f6\uff0c\u7269\u6599\u7f16\u53f7\u5fc5\u586b"));
        } else if ("2".equals(purchaseInformationRecords.getRecordType())) {
            Assert.isTrue((boolean)StrUtil.isNotBlank((CharSequence)purchaseInformationRecords.getMaterialGroup()), (String)I18nUtil.translate((String)"i18n_alert_umAcLSLVKWSLVlS_dce240f5", (String)"\u4ef7\u683c\u7c7b\u578b\u4e3a\u7269\u6599\u7ec4\u65f6\uff0c\u7269\u6599\u7ec4\u5fc5\u586b"));
        }
        purchaseInformationRecords.setSourceType(PriceSourceTypeEnum.SRM.getValue());
        if (AuditStatusEnum.NO_AUDIT_REQUIRED.getValue().equals(purchaseInformationRecords.getAuditStatus())) {
            this.checkStatus(purchaseInformationRecords);
        }
        this.calculatePrice(purchaseInformationRecords);
        this.invokeBaseRpcService.deletePurchaseAttachmentByMainId(purchaseInformationRecords.getId());
        int count = ((LogisticsPurchasePriceRecordsMapper)this.baseMapper).updateById((Object)purchaseInformationRecords);
        if (count == 0) {
            throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_APWFIKXWVVVXVSDJHrW_2fe92d52", (String)"\u5f53\u524d\u6570\u636e\u5df2\u5931\u6548\uff0c\u8bf7\u91cd\u65b0\u5237\u65b0\u540e\u63d0\u4ea4\u66f4\u6539\uff01"));
        }
        this.insertAttachmentData(purchaseInformationRecords, attachmentList);
    }

    private void rebuildPriceStatus(LogisticsPurchasePriceRecords y, Calendar cal, Date calTime, int dateOfSet) {
        cal.setTime(calTime);
        cal.add(5, dateOfSet);
        y.setRecordStatus(PriceStatusEnum.NORMAL.getValue());
    }

    @Override
    public void frozenLogisticsPurchasePriceRecords(String id) {
        LogisticsPurchasePriceRecords record = (LogisticsPurchasePriceRecords)((Object)((LogisticsPurchasePriceRecordsMapper)this.baseMapper).selectById((Serializable)((Object)id)));
        record.setRecordStatus(PriceStatusEnum.FROZEN.getValue());
        int count = ((LogisticsPurchasePriceRecordsMapper)this.baseMapper).updateById((Object)record);
        if (count == 0) {
            throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_APWFIKXWVVVXVSDJHrW_2fe92d52", (String)"\u5f53\u524d\u6570\u636e\u5df2\u5931\u6548\uff0c\u8bf7\u91cd\u65b0\u5237\u65b0\u540e\u63d0\u4ea4\u66f4\u6539\uff01"));
        }
    }

    @Override
    public void checkStatus(LogisticsPurchasePriceRecords record) {
        DateTime date = DateUtil.date();
        if (null != record.getEffectiveDate() && record.getEffectiveDate().before((Date)date)) {
            record.setRecordStatus(PriceStatusEnum.EFFECTIVE.getValue());
        }
        DateTime toDay = DateUtil.parseDate((CharSequence)DateUtil.today());
        if (null != record.getExpiryDate() && record.getExpiryDate().before((Date)toDay)) {
            record.setRecordStatus(PriceStatusEnum.INVALID.getValue());
        }
    }

    @Override
    public void thawLogisticsPurchasePriceRecords(String id) {
        LogisticsPurchasePriceRecords record = (LogisticsPurchasePriceRecords)((Object)((LogisticsPurchasePriceRecordsMapper)this.baseMapper).selectById((Serializable)((Object)id)));
        record.setRecordStatus(PriceStatusEnum.NORMAL.getValue());
        this.checkStatus(record);
        int count = ((LogisticsPurchasePriceRecordsMapper)this.baseMapper).updateById((Object)record);
        if (count == 0) {
            throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_APWFIKXWVVVXVSDJHrW_2fe92d52", (String)"\u5f53\u524d\u6570\u636e\u5df2\u5931\u6548\uff0c\u8bf7\u91cd\u65b0\u5237\u65b0\u540e\u63d0\u4ea4\u66f4\u6539\uff01"));
        }
    }

    @Override
    public void cancelLogisticsPurchasePriceRecords(String id) {
        LogisticsPurchasePriceRecords record = (LogisticsPurchasePriceRecords)((Object)((LogisticsPurchasePriceRecordsMapper)this.baseMapper).selectById((Serializable)((Object)id)));
        record.setRecordStatus(PriceStatusEnum.CANCEL.getValue());
        int count = ((LogisticsPurchasePriceRecordsMapper)this.baseMapper).updateById((Object)record);
        if (count == 0) {
            throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_APWFIKXWVVVXVSDJHrW_2fe92d52", (String)"\u5f53\u524d\u6570\u636e\u5df2\u5931\u6548\uff0c\u8bf7\u91cd\u65b0\u5237\u65b0\u540e\u63d0\u4ea4\u66f4\u6539\uff01"));
        }
    }

    @Override
    public void cancelBySourceNumber(String sourceType, String sourceNumber, List<String> itemNumberList) {
        String elsAccount = TenantContext.getTenant();
        LambdaUpdateWrapper updateWrapper = new LambdaUpdateWrapper();
        ((LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)updateWrapper.eq(BaseEntity::getElsAccount, (Object)elsAccount)).eq(LogisticsPurchasePriceRecords::getSourceNumber, (Object)sourceNumber)).eq(LogisticsPurchasePriceRecords::getSourceType, (Object)sourceType)).in(LogisticsPurchasePriceRecords::getSourceItemNumber, itemNumberList);
        LogisticsPurchasePriceRecords records = new LogisticsPurchasePriceRecords();
        records.setRecordStatus(PriceStatusEnum.CANCEL.getValue());
        ((LogisticsPurchasePriceRecordsMapper)this.baseMapper).update((Object)records, (Wrapper)updateWrapper);
    }

    @Override
    @SrmTransaction
    public void delLogisticsPurchasePriceRecords(String id) {
        ((LogisticsPurchasePriceRecordsMapper)this.baseMapper).deleteById((Serializable)((Object)id));
        this.invokeBaseRpcService.deletePurchaseAttachmentByMainId(id);
    }

    @Override
    @SrmTransaction
    public void delBatchLogisticsPurchasePriceRecords(List<String> idList) {
        ((LogisticsPurchasePriceRecordsMapper)this.baseMapper).deleteBatchIds(idList);
        this.invokeBaseRpcService.deletePurchaseAttachmentByBatchId(idList);
    }

    @Override
    public List<DictDTO> getInformationRecordsSupplierList(String sourceType, String subjectNumber, String subjectYear) {
        ArrayList<DictDTO> supplierDicts = new ArrayList<DictDTO>();
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.select(new String[]{"DISTINCT to_els_account, supplier_name"});
        queryWrapper.eq(StrUtil.isNotBlank((CharSequence)sourceType), (Object)"source_type", (Object)sourceType);
        queryWrapper.eq(StrUtil.isNotBlank((CharSequence)subjectNumber), (Object)"subject_number", (Object)subjectNumber);
        queryWrapper.eq(StrUtil.isNotBlank((CharSequence)subjectYear), (Object)"subject_year", (Object)subjectYear);
        List hisList = this.list((Wrapper)queryWrapper);
        Map<String, String> supplierDictMap = hisList.stream().collect(Collectors.toMap(LogisticsPurchasePriceRecords::getToElsAccount, LogisticsPurchasePriceRecords::getSupplierName, (o, n) -> o));
        supplierDictMap.forEach((key, value) -> {
            DictDTO dto = new DictDTO();
            dto.setValue(key);
            dto.setText(value);
            supplierDicts.add(dto);
        });
        return supplierDicts;
    }
}

