/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.logisticspurchase.base.service.impl;

import cn.hutool.core.util.StrUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.els.common.constant.CommonConstant;
import com.els.common.exception.ELSBootException;
import com.els.common.system.base.entity.BaseEntity;
import com.els.common.system.base.service.impl.BaseServiceImpl;
import com.els.common.util.Assert;
import com.els.common.util.I18nUtil;
import com.els.common.util.SpringContextUtils;
import com.els.common.util.SysUtil;
import com.els.modules.logisticspurchase.base.entity.SubjectFileHead;
import com.els.modules.logisticspurchase.base.entity.SubjectFileItem;
import com.els.modules.logisticspurchase.base.enumerate.AddressTypeEnum;
import com.els.modules.logisticspurchase.base.enumerate.StatusEnum;
import com.els.modules.logisticspurchase.base.mapper.SubjectFileHeadMapper;
import com.els.modules.logisticspurchase.base.mapper.SubjectFileItemMapper;
import com.els.modules.logisticspurchase.base.service.SubjectFileHeadService;
import com.els.modules.logisticspurchase.base.service.SubjectFileItemService;
import com.els.rpc.service.InvokeBaseRpcService;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.compress.utils.Lists;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Service
public class SubjectFileHeadServiceImpl
extends BaseServiceImpl<SubjectFileHeadMapper, SubjectFileHead>
implements SubjectFileHeadService {
    @Autowired
    private SubjectFileHeadMapper subjectFileHeadMapper;
    @Autowired
    private SubjectFileItemMapper subjectFileItemMapper;
    @Autowired
    private InvokeBaseRpcService baseRpcService;
    @Autowired
    @Lazy
    private SubjectFileItemService subjectFileItemService;

    @Override
    @Transactional(rollbackFor={RuntimeException.class})
    public void saveMain(SubjectFileHead subjectFileHead, List<SubjectFileItem> subjectFileItemList) {
        SubjectFileHead dbSubjectFileHead;
        this.check(subjectFileHead, subjectFileItemList);
        if (StrUtil.isBlank((CharSequence)subjectFileHead.getSubjectNumber())) {
            subjectFileHead.setSubjectNumber(this.baseRpcService.getNextCode("srmSubjectNumber", (Object)subjectFileHead));
        }
        if ((dbSubjectFileHead = (SubjectFileHead)((Object)this.getOne((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(SubjectFileHead::getSubjectNumber, (Object)subjectFileHead.getSubjectNumber())).eq(SubjectFileHead::getSubjectYear, (Object)subjectFileHead.getSubjectYear())))) != null) {
            throw new ELSBootException("\u8be5\u6807\u7684\u7f16\u7801\u5df2\u5b58\u5728\uff0c\u8bf7\u68c0\u67e5\uff01");
        }
        subjectFileHead.setDeleted(CommonConstant.DEL_FLAG_0);
        this.subjectFileHeadMapper.insert((Object)subjectFileHead);
        super.setHeadDefaultValue((BaseEntity)subjectFileHead);
        this.insertData(subjectFileHead, subjectFileItemList);
    }

    private void check(SubjectFileHead subjectFileHead, List<SubjectFileItem> subjectFileItemList) {
        Assert.isNotBlank((String)subjectFileHead.getSubjectName(), (String)I18nUtil.translate((String)"i18n_field_BnRLxOLV_6787b0", (String)"\u6807\u7684\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a"));
        Assert.isNotBlank((String)subjectFileHead.getSubjectType(), (String)I18nUtil.translate((String)"i18n_field_BnAcxOLV_19470c1d", (String)"\u6807\u7684\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a"));
        Assert.isNotEmpty(subjectFileItemList, (String)I18nUtil.translate((String)"i18n_alert_cVHxOLV_c6f5290a", (String)"\u884c\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a"));
        subjectFileItemList.forEach(row -> {
            Assert.isNotBlank((String)row.getSectionNumber(), (String)I18nUtil.translate((String)"i18n_field_BOAoxOLV_906bf449", (String)"\u6807\u6bb5\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a"));
            Assert.isNotBlank((String)row.getSectionName(), (String)I18nUtil.translate((String)"i18n_field_BORLxOLV_3bed1421", (String)"\u6807\u6bb5\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a"));
            Assert.isNotNull((Object)row.getTrafficVolumeProportion(), (String)I18nUtil.translate((String)"i18n_field_BOiRXlxOLV_aa7185d1", (String)"\u6807\u6bb5\u8fd0\u91cf\u5360\u6bd4\u4e0d\u80fd\u4e3a\u7a7a"));
            if (AddressTypeEnum.HIGHWAY.getValue().equals(subjectFileHead.getSubjectType())) {
                Assert.isNotNull((Object)row.getIntervalRatio1(), (String)I18nUtil.translate((String)"i18n_field_010NLMIXlxOLV_f7609dff", (String)"0-10\u5428\u4f4d\u533a\u95f4\u5360\u6bd4\u4e0d\u80fd\u4e3a\u7a7a"));
                Assert.isNotNull((Object)row.getIntervalRatio2(), (String)I18nUtil.translate((String)"i18n_field_20x30NLMIXlxOLV_b38e0765", (String)"10(\u542b)-20\u5428\u4f4d\u533a\u95f4\u5360\u6bd4\u4e0d\u80fd\u4e3a\u7a7a"));
                Assert.isNotNull((Object)row.getIntervalRatio3(), (String)I18nUtil.translate((String)"i18n_field_20x30NLMIXlxOLV_b38e0765", (String)"20(\u542b)-30\u5428\u4f4d\u533a\u95f4\u5360\u6bd4\u4e0d\u80fd\u4e3a\u7a7a"));
                Assert.isNotNull((Object)row.getIntervalRatio4(), (String)I18nUtil.translate((String)"i18n_field_30NLMIXlxOLV_4915577f", (String)">=30\u5428\u4f4d\u533a\u95f4\u5360\u6bd4\u4e0d\u80fd\u4e3a\u7a7a"));
            }
        });
    }

    @Override
    @Transactional(rollbackFor={RuntimeException.class})
    public void updateMain(SubjectFileHead subjectFileHead, List<SubjectFileItem> subjectFileItemList) {
        this.check(subjectFileHead, subjectFileItemList);
        SubjectFileHead dbSubjectFileHead = (SubjectFileHead)((Object)this.getOne((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(SubjectFileHead::getSubjectNumber, (Object)subjectFileHead.getSubjectNumber())).eq(SubjectFileHead::getSubjectYear, (Object)subjectFileHead.getSubjectYear())));
        if (dbSubjectFileHead != null && !dbSubjectFileHead.getId().equals(subjectFileHead.getId())) {
            throw new ELSBootException("\u8be5\u6807\u7684\u7f16\u7801\u5df2\u5b58\u5728\uff0c\u8bf7\u68c0\u67e5\uff01");
        }
        this.subjectFileHeadMapper.updateById((Object)subjectFileHead);
        this.subjectFileItemMapper.deleteByMainId(subjectFileHead.getId());
        this.insertData(subjectFileHead, subjectFileItemList);
    }

    private void insertData(SubjectFileHead subjectFileHead, List<SubjectFileItem> subjectFileItemList) {
        if (!CollectionUtils.isEmpty(subjectFileItemList)) {
            int itemNumber = 1;
            BigDecimal totalTrafficVolumeProportion = BigDecimal.ZERO;
            ArrayList subjectNumber = Lists.newArrayList();
            for (SubjectFileItem entity : subjectFileItemList) {
                if (subjectNumber.contains(entity.getSectionNumber())) {
                    throw new ELSBootException("\u6807\u6bb5" + entity.getSectionNumber() + "\u91cd\u590d\uff01\u8bf7\u68c0\u67e5\uff01");
                }
                subjectNumber.add(entity.getSectionNumber());
                totalTrafficVolumeProportion = totalTrafficVolumeProportion.add(entity.getTrafficVolumeProportion() == null ? BigDecimal.ZERO : entity.getTrafficVolumeProportion());
                entity.setHeadId(subjectFileHead.getId());
                entity.setItemNumber(String.valueOf(itemNumber++));
                entity.setSubjectNumber(subjectFileHead.getSubjectNumber());
                SysUtil.setSysParam((BaseEntity)entity, (BaseEntity)subjectFileHead);
                if (!AddressTypeEnum.HIGHWAY.getValue().equals(subjectFileHead.getSubjectType())) continue;
                BigDecimal totalIntervalRatio = BigDecimal.ZERO;
                if ((totalIntervalRatio = totalIntervalRatio.add(entity.getIntervalRatio1()).add(entity.getIntervalRatio2()).add(entity.getIntervalRatio3()).add(entity.getIntervalRatio4())).compareTo(new BigDecimal("100")) == 0) continue;
                throw new ELSBootException("\u6807\u6bb5" + entity.getSectionName() + "\u5428\u4f4d\u533a\u95f4\u4e4b\u548c\u5e94\u4e3a100\uff0c\u73b0\u4e3a" + totalIntervalRatio + ", \u4e0d\u53ef\u4fdd\u5b58");
            }
            if (totalTrafficVolumeProportion.compareTo(new BigDecimal("100")) != 0) {
                throw new ELSBootException("\u6807\u6bb5\u8fd0\u91cf\u5360\u6bd4\u4e4b\u548c\u5e94\u4e3a100\uff0c\u73b0\u5728\u662f" + totalTrafficVolumeProportion + ", \u8bf7\u68c0\u67e5\uff01");
            }
            if (!subjectFileItemList.isEmpty()) {
                ((SubjectFileItemService)SpringContextUtils.getBean(SubjectFileItemService.class)).saveBatch(subjectFileItemList);
            }
        }
    }

    @Override
    @Transactional(rollbackFor={RuntimeException.class})
    public void delMain(String id) {
        this.subjectFileItemMapper.deleteByMainId(id);
        this.subjectFileHeadMapper.deleteById((Serializable)((Object)id));
    }

    @Override
    @Transactional(rollbackFor={RuntimeException.class})
    public void delBatchMain(List<String> idList) {
        for (Serializable serializable : idList) {
            this.subjectFileItemMapper.deleteByMainId(serializable.toString());
            this.subjectFileHeadMapper.deleteById(serializable);
        }
    }

    @Override
    public void frozenSubjectFileHead(String id) {
        SubjectFileHead subjectFileHead = new SubjectFileHead();
        subjectFileHead.setId(id);
        subjectFileHead.setStatus(StatusEnum.FROZEN.getValue());
        int count = ((SubjectFileHeadMapper)this.baseMapper).updateById((Object)subjectFileHead);
        if (count == 0) {
            throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_APWFIKXWVVVXVSDJHrW_2fe92d52", (String)"\u5f53\u524d\u6570\u636e\u5df2\u5931\u6548\uff0c\u8bf7\u91cd\u65b0\u5237\u65b0\u540e\u63d0\u4ea4\u66f4\u6539\uff01"));
        }
    }

    @Override
    public void thawSubjectFileHead(String id) {
        SubjectFileHead subjectFileHead = new SubjectFileHead();
        subjectFileHead.setId(id);
        subjectFileHead.setStatus(StatusEnum.EFFECTIVE.getValue());
        int count = ((SubjectFileHeadMapper)this.baseMapper).updateById((Object)subjectFileHead);
        if (count == 0) {
            throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_APWFIKXWVVVXVSDJHrW_2fe92d52", (String)"\u5f53\u524d\u6570\u636e\u5df2\u5931\u6548\uff0c\u8bf7\u91cd\u65b0\u5237\u65b0\u540e\u63d0\u4ea4\u66f4\u6539\uff01"));
        }
    }

    @Override
    public List<SubjectFileHead> selectBySubjectNumber(String subjectNumber, String subjectYear) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"subject_number", (Object)subjectNumber);
        queryWrapper.eq((Object)"subject_year", (Object)subjectYear);
        return this.list((Wrapper)queryWrapper);
    }
}

