/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.logisticspurchase.ebidding.impl;

import cn.hutool.core.text.CharSequenceUtil;
import com.els.common.aspect.annotation.RpcService;
import com.els.common.im.ImBaseUserRecordRpcService;
import com.els.common.util.I18nUtil;
import com.els.modules.account.api.dto.ImUserDTO;
import com.els.modules.ebidding.entity.PurchaseEbiddingSupplier;
import com.els.modules.ebidding.service.PurchaseEbiddingSupplierService;
import com.els.modules.im.api.dto.ImRecordDto;
import com.els.modules.im.api.enumerate.ImRecordTypeEnum;
import com.els.modules.logisticspurchase.ebidding.entity.PurchaseEbiddingHeadLp;
import com.els.modules.logisticspurchase.ebidding.entity.SaleEbiddingHeadLp;
import com.els.modules.logisticspurchase.ebidding.enumerate.EbiddingLpStatusEnum;
import com.els.modules.logisticspurchase.ebidding.service.PurchaseEbiddingHeadLpService;
import com.els.modules.logisticspurchase.ebidding.service.SaleEbiddingHeadLpService;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.util.Assert;

@RpcService(value="ebiddingLpImUserRecordServiceImpl")
public class EbiddingLpUserRecordInvokeBeanServiceImpl
extends ImBaseUserRecordRpcService {
    @Resource
    private PurchaseEbiddingHeadLpService purchaseEbiddingHeadLpService;
    @Resource
    private SaleEbiddingHeadLpService saleEbiddingHeadLpService;
    @Resource
    private PurchaseEbiddingSupplierService purchaseEbiddingSupplierService;

    public List<ImUserDTO> getRecordPersonInCharge(ImRecordDto imRecordDto) {
        ArrayList<ImUserDTO> resultList = new ArrayList<ImUserDTO>();
        if (ImRecordTypeEnum.EBIDDING_LP.getValue().equals(imRecordDto.getType())) {
            PurchaseEbiddingHeadLp dbHead = (PurchaseEbiddingHeadLp)((Object)this.purchaseEbiddingHeadLpService.getById((Serializable)((Object)imRecordDto.getRecordId())));
            Assert.isTrue((null != dbHead ? 1 : 0) != 0, (String)String.format(I18nUtil.translate((String)"i18n_alert_OutWWWWxMK_536c140d", (String)"\u7269\u6d41\u7ade\u4ef7\u5355[%s]\u4e0d\u5b58\u5728"), imRecordDto.getRecordId()));
            Assert.isTrue((!EbiddingLpStatusEnum.NEW.getValue().equals(dbHead.getEbiddingStatus()) ? 1 : 0) != 0, (String)I18nUtil.translate((String)"i18n_alert_OutVIzEWShRe_d64caf4b", (String)"\u7ade\u4ef7\u5355\u65b0\u5efa\u72b6\u6001\uff0c\u65e0\u6cd5\u6c9f\u901a"));
            List<PurchaseEbiddingSupplier> supplierList = this.purchaseEbiddingSupplierService.selectByMainId(dbHead.getId());
            return this.queryAllUserWithGroupChat(supplierList.stream().map(PurchaseEbiddingSupplier::getToElsAccount).filter(CharSequenceUtil::isNotEmpty).collect(Collectors.toList()));
        }
        if (ImRecordTypeEnum.SALE_EBIDDING_LP.getValue().equals(imRecordDto.getType())) {
            SaleEbiddingHeadLp dbHead = (SaleEbiddingHeadLp)((Object)this.saleEbiddingHeadLpService.getById((Serializable)((Object)imRecordDto.getRecordId())));
            Assert.isTrue((null != dbHead ? 1 : 0) != 0, (String)String.format(I18nUtil.translate((String)"i18n_alert_OutWWWWxMK_536c140d", (String)"\u7269\u6d41\u7ade\u4ef7\u5355[%s]\u4e0d\u5b58\u5728"), imRecordDto.getRecordId()));
            String toElsAccount = dbHead.getToElsAccount();
            String purchasePrincipal = dbHead.getPurchasePrincipal();
            String subAccount = dbHead.getUpdateBy().split("_")[0];
            if (CharSequenceUtil.isNotEmpty((CharSequence)purchasePrincipal)) {
                subAccount = purchasePrincipal.split("_")[0];
            }
            ImUserDTO e = new ImUserDTO();
            e.setElsAccount(toElsAccount + "_" + subAccount);
            resultList.add(e);
        }
        return resultList;
    }
}

