/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.logisticspurchase.ebidding.service.impl;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.text.CharSequenceUtil;
import cn.hutool.core.util.StrUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.els.common.exception.ELSBootException;
import com.els.common.system.base.entity.BaseEntity;
import com.els.common.util.I18nUtil;
import com.els.common.util.SpringContextUtils;
import com.els.common.util.SysUtil;
import com.els.config.mybatis.TenantContext;
import com.els.modules.bidding.vo.SupplierRelationFindResultVO;
import com.els.modules.demand.service.PurchaseRequestItemService;
import com.els.modules.ebidding.utils.CompareIPUtils;
import com.els.modules.inquiry.enumerate.SourceTypeEnum;
import com.els.modules.logisticspurchase.base.service.LineDifferenceHeadService;
import com.els.modules.logisticspurchase.ebidding.entity.PurchaseEbiddingHeadLp;
import com.els.modules.logisticspurchase.ebidding.entity.PurchaseEbiddingItemLp;
import com.els.modules.logisticspurchase.ebidding.entity.PurchaseEbiddingSupplierLp;
import com.els.modules.logisticspurchase.ebidding.enumerate.EbiddingItemLpStatusEnum;
import com.els.modules.logisticspurchase.ebidding.mapper.PurchaseEbiddingItemLpMapper;
import com.els.modules.logisticspurchase.ebidding.service.PurchaseEbiddingItemLpService;
import com.els.modules.logisticspurchase.ebidding.service.SaleEbiddingItemLpService;
import com.els.modules.logisticspurchase.ebidding.service.impl.SaleEbiddingItemLpServiceImpl;
import com.els.modules.material.api.dto.PurchaseMaterialRelationDTO;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class PurchaseEbiddingItemLpServiceImpl
extends ServiceImpl<PurchaseEbiddingItemLpMapper, PurchaseEbiddingItemLp>
implements PurchaseEbiddingItemLpService {
    private static final Logger log = LoggerFactory.getLogger(PurchaseEbiddingItemLpServiceImpl.class);
    @Autowired
    @Lazy
    private PurchaseRequestItemService purchaseRequestItemService;
    @Autowired
    private LineDifferenceHeadService nbeLineDifferenceHeadService;

    @Override
    public List<PurchaseEbiddingItemLp> selectByMainId(String mainId) {
        return ((PurchaseEbiddingItemLpMapper)this.baseMapper).selectByMainId(mainId);
    }

    @Override
    public void deleteByMainId(String mainId) {
        ((PurchaseEbiddingItemLpMapper)this.baseMapper).deleteByMainId(mainId);
    }

    @Override
    public void addBatch(PurchaseEbiddingHeadLp head, List<PurchaseEbiddingItemLp> itemList) {
        if (CollectionUtil.isNotEmpty(itemList)) {
            int itemNumber = 1;
            for (PurchaseEbiddingItemLp item : itemList) {
                item.setId(IdWorker.getIdStr());
                item.setHeadId(head.getId());
                item.setDocumentId(head.getDocumentId());
                item.setEbiddingNumber(head.getEbiddingNumber());
                item.setItemStatus(EbiddingItemLpStatusEnum.NEW.getValue());
                item.setAuditStatus(head.getResultAuditStatus());
                item.setSendStatus("0");
                item.setItemNumber(String.valueOf(itemNumber++));
                item.setSourceType(StrUtil.isBlank((CharSequence)item.getSourceType()) ? SourceTypeEnum.MANUAL.getValue() : item.getSourceType());
                SysUtil.setSysParam((BaseEntity)item, (BaseEntity)head);
            }
            this.saveBatch(itemList, 2000);
        }
    }

    @Override
    public List<PurchaseEbiddingItemLp> publish(PurchaseEbiddingHeadLp head, List<PurchaseEbiddingItemLp> itemList, List<PurchaseEbiddingSupplierLp> supplierList, Map<String, PurchaseMaterialRelationDTO> relationMap) {
        itemList.forEach(item -> {
            item.setId(null);
            item.setItemStatus(EbiddingItemLpStatusEnum.PUBLISHED.getValue());
            item.setCurrentRound(head.getCurrentRound());
        });
        this.saveBatch(itemList, 2000);
        return itemList;
    }

    @Override
    public void updateBidByHeadId(List<PurchaseEbiddingItemLp> purchaseItemList) {
        ((PurchaseEbiddingItemLpMapper)this.baseMapper).updateBidByHeadId(purchaseItemList);
    }

    @Override
    public PurchaseEbiddingItemLp selectOneByMainIdAndItemNumber(String headId, String itemNumber) {
        return ((PurchaseEbiddingItemLpMapper)this.baseMapper).selectOneByMainIdAndItemNumber(headId, itemNumber);
    }

    @Override
    public void replenishMaterialNumber(PurchaseEbiddingItemLp webItem) {
        List<PurchaseEbiddingItemLp> itemList = this.selectByMainId(webItem.getHeadId());
        this.checkMaterialNumber(webItem, itemList);
        List<PurchaseEbiddingItemLp> items = itemList.stream().filter(item -> item.getItemNumber().equals(webItem.getItemNumber())).collect(Collectors.toList());
        items.forEach(item -> {
            item.setMaterialNumber(webItem.getMaterialNumber());
            item.setMaterialDesc(webItem.getMaterialDesc());
            item.setMaterialGroup(webItem.getMaterialGroup());
            item.setMaterialSpec(webItem.getMaterialSpec());
            item.setMaterialGroupName(webItem.getMaterialGroupName());
        });
        this.updateBatchById(items);
        SaleEbiddingItemLpService saleEbiddingItemService = (SaleEbiddingItemLpService)SpringContextUtils.getBean(SaleEbiddingItemLpServiceImpl.class);
        saleEbiddingItemService.replenishMaterialNumber(items);
        PurchaseEbiddingItemLp item2 = items.get(0);
        if (SourceTypeEnum.REQUEST.getValue().equals(item2.getSourceType()) && StrUtil.isNotBlank((CharSequence)item2.getSourceItemId())) {
            this.purchaseRequestItemService.replenishMaterial(item2.getSourceItemId(), item2.getMaterialNumber(), item2.getMaterialDesc(), item2.getMaterialGroup(), item2.getMaterialSpec());
        }
    }

    private void checkMaterialNumber(PurchaseEbiddingItemLp webItem, List<PurchaseEbiddingItemLp> itemList) {
        List materialNumbers = itemList.stream().map(PurchaseEbiddingItemLp::getMaterialNumber).filter(CharSequenceUtil::isNotBlank).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(materialNumbers)) {
            return;
        }
        boolean b = materialNumbers.stream().anyMatch(item -> item.equals(webItem.getMaterialNumber()));
        if (b) {
            throw new ELSBootException(I18nUtil.translate((String)"i18n__SLAoxOVB_f1d5e3eb", (String)"\u7269\u6599\u7f16\u7801\u4e0d\u80fd\u91cd\u590d"));
        }
    }

    @Override
    public Map<String, Long> getSupplierPortraitCount(String toElsAccount) {
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.eq(PurchaseEbiddingItemLp::getToElsAccount, (Object)toElsAccount);
        queryWrapper.eq(BaseEntity::getElsAccount, (Object)TenantContext.getTenant());
        List allList = this.list((Wrapper)queryWrapper);
        long participationCount = allList.stream().map(PurchaseEbiddingItemLp::getHeadId).distinct().count();
        long biddingWinCount = allList.stream().filter(item -> EbiddingItemLpStatusEnum.BID_WIN.getValue().equals(item.getItemStatus())).map(PurchaseEbiddingItemLp::getHeadId).distinct().count();
        HashMap<String, Long> returnMap = new HashMap<String, Long>();
        returnMap.put("participationCount", participationCount);
        returnMap.put("biddingWinCount", biddingWinCount);
        return returnMap;
    }

    @Override
    public List<SupplierRelationFindResultVO> probeIP(String headId, Map<String, PurchaseEbiddingSupplierLp> supplierMap) {
        ArrayList<SupplierRelationFindResultVO> result = new ArrayList<SupplierRelationFindResultVO>();
        List<PurchaseEbiddingItemLp> dbItemList = ((PurchaseEbiddingItemLpMapper)this.baseMapper).selectByMainId(headId);
        List accountIpList = dbItemList.stream().filter(item -> StrUtil.isNotBlank((CharSequence)item.getQuoteIp())).map(item -> item.getToElsAccount() + "_" + item.getQuoteIp()).distinct().collect(Collectors.toList());
        for (String sourceAccountIp : accountIpList) {
            for (String targetAccountIp : accountIpList) {
                if (sourceAccountIp.equals(targetAccountIp)) continue;
                CompareIPUtils.compareEbiddingIpLp(sourceAccountIp, targetAccountIp, supplierMap, result);
            }
        }
        return result;
    }

    @Override
    public List<PurchaseEbiddingItemLp> queryEbiddingByDesc(List<String> materialDescs) {
        LambdaQueryWrapper lambdaQueryWrapper = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)((LambdaQueryWrapper)lambdaQueryWrapper.eq(PurchaseEbiddingItemLp::getItemStatus, (Object)EbiddingItemLpStatusEnum.BID_WIN.getValue())).in(PurchaseEbiddingItemLp::getMaterialDesc, materialDescs)).and(qw -> ((LambdaQueryWrapper)((LambdaQueryWrapper)qw.isNull(PurchaseEbiddingItemLp::getMaterialNumber)).or()).eq(PurchaseEbiddingItemLp::getMaterialNumber, (Object)""));
        return ((PurchaseEbiddingItemLpMapper)this.baseMapper).selectList((Wrapper)lambdaQueryWrapper);
    }

    @Override
    public List<PurchaseEbiddingItemLp> selectWithoutElsAccountByRelationId(List<String> relationIds) {
        return ((PurchaseEbiddingItemLpMapper)this.baseMapper).selectWithoutElsAccountByRelationId(relationIds);
    }

    @Override
    public List<PurchaseEbiddingItemLp> findBySourceItemId(List<String> headIdList, List<String> sourceIdList) {
        return ((PurchaseEbiddingItemLpMapper)this.baseMapper).findBySourceItemId(headIdList, sourceIdList);
    }
}

