/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.logisticspurchase.enquiry.service.impl;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.els.aspect.param.DictTranslateAspectParam;
import com.els.common.api.vo.Result;
import com.els.common.service.DictTranslateService;
import com.els.common.util.I18nUtil;
import com.els.common.util.SpringContextUtils;
import com.els.modules.enquiry.enumerate.EnquiryQuoteWayEnum;
import com.els.modules.enquiry.vo.CurrentQuoteTrendVO;
import com.els.modules.logisticspurchase.enquiry.entity.PurchaseEnquiryHeadLp;
import com.els.modules.logisticspurchase.enquiry.entity.PurchaseEnquiryItemHisLp;
import com.els.modules.logisticspurchase.enquiry.entity.SaleEnquiryHeadLp;
import com.els.modules.logisticspurchase.enquiry.entity.SaleEnquiryItemLp;
import com.els.modules.logisticspurchase.enquiry.mapper.PurchaseEnquiryItemHisLpMapper;
import com.els.modules.logisticspurchase.enquiry.service.PurchaseEnquiryHeadLpService;
import com.els.modules.logisticspurchase.enquiry.service.PurchaseEnquiryItemHisLpService;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.PostConstruct;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;

@Service
public class PurchaseEnquiryItemHisLpServiceImpl
extends ServiceImpl<PurchaseEnquiryItemHisLpMapper, PurchaseEnquiryItemHisLp>
implements PurchaseEnquiryItemHisLpService {
    private String priceType = "price";
    private BigDecimal ladderQuantity = BigDecimal.ONE;
    private String costGroup;
    private Map<String, Function<List<PurchaseEnquiryItemHisLp>, CurrentQuoteTrendVO>> functionMap = new HashMap<String, Function<List<PurchaseEnquiryItemHisLp>, CurrentQuoteTrendVO>>();

    @PostConstruct
    public void init() {
        this.functionMap.put(EnquiryQuoteWayEnum.NORMAL.getValue(), this::getNormalQuoteHis);
        this.functionMap.put(EnquiryQuoteWayEnum.LADDER.getValue(), this::getLadderQuoteHis);
        this.functionMap.put(EnquiryQuoteWayEnum.COST.getValue(), this::getCostQuoteHis);
    }

    @Override
    public void saveQuoteItemHis(SaleEnquiryHeadLp saleHead, List<SaleEnquiryItemLp> needRecordList) {
        ArrayList<PurchaseEnquiryItemHisLp> purchaseItemHisList = new ArrayList<PurchaseEnquiryItemHisLp>();
        for (SaleEnquiryItemLp saleItem : needRecordList) {
            PurchaseEnquiryItemHisLp purchaseHis = new PurchaseEnquiryItemHisLp();
            BeanUtils.copyProperties((Object)((Object)saleItem), (Object)((Object)purchaseHis));
            purchaseHis.setId(null);
            purchaseHis.setElsAccount(saleItem.getToElsAccount());
            purchaseHis.setRelationId(null);
            purchaseHis.setHeadId(saleHead.getRelationId());
            purchaseHis.setItemId(saleItem.getRelationId());
            purchaseHis.setToElsAccount(saleItem.getElsAccount());
            purchaseItemHisList.add(purchaseHis);
        }
        this.saveBatch(purchaseItemHisList, 20000);
    }

    @Override
    public CurrentQuoteTrendVO findQuoteHis(HttpServletRequest request) {
        String headId = request.getParameter("headId");
        String itemNumber = request.getParameter("itemNumber");
        this.priceType = request.getParameter("priceType");
        this.ladderQuantity = StrUtil.isBlank((CharSequence)request.getParameter("ladderQuantity")) ? null : new BigDecimal(request.getParameter("ladderQuantity"));
        this.costGroup = request.getParameter("costGroup");
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.eq(PurchaseEnquiryItemHisLp::getHeadId, (Object)headId);
        if (StrUtil.isNotBlank((CharSequence)itemNumber)) {
            queryWrapper.eq(PurchaseEnquiryItemHisLp::getItemNumber, (Object)itemNumber);
        }
        queryWrapper.orderByAsc(PurchaseEnquiryItemHisLp::getQuoteCount);
        List list = ((PurchaseEnquiryItemHisLpMapper)this.baseMapper).selectList((Wrapper)queryWrapper);
        this.hidePrice(list);
        return this.functionMap.get(((PurchaseEnquiryItemHisLp)((Object)list.get(0))).getQuotePriceWay()).apply(list);
    }

    private void hidePrice(List<PurchaseEnquiryItemHisLp> list) {
        if (CollectionUtil.isNotEmpty(list)) {
            boolean showPrice;
            PurchaseEnquiryHeadLp dbHead = (PurchaseEnquiryHeadLp)((Object)((PurchaseEnquiryHeadLpService)SpringContextUtils.getBean(PurchaseEnquiryHeadLpService.class)).getById((Serializable)((Object)list.get(0).getHeadId())));
            boolean bl = showPrice = !"0".equals(dbHead.getSeePrice()) || "1".equals(dbHead.getOpenBidStatus()) || dbHead.getQuoteEndTime().before(new Date());
            if (!showPrice) {
                for (PurchaseEnquiryItemHisLp item : list) {
                    Object object2;
                    item.setPrice(null);
                    item.setNetPrice(null);
                    item.setTaxAmount(null);
                    item.setNetAmount(null);
                    if (EnquiryQuoteWayEnum.LADDER.getValue().equals(item.getQuotePriceWay())) {
                        JSONArray ladderPriceJson = StrUtil.isNotBlank((CharSequence)item.getLadderPriceJson()) ? JSONArray.parseArray((String)item.getLadderPriceJson()) : new JSONArray();
                        for (Object object2 : ladderPriceJson) {
                            JSONObject ladderItem = (JSONObject)object2;
                            ladderItem.put("netPrice", null);
                            ladderItem.put("price", null);
                            ladderItem.put("taxAmount", null);
                            ladderItem.put("netAmount", null);
                        }
                        item.setLadderPriceJson(ladderPriceJson.toJSONString());
                    }
                    if (!EnquiryQuoteWayEnum.COST.getValue().equals(item.getQuotePriceWay())) continue;
                    JSONObject costFormJson = StrUtil.isNotBlank((CharSequence)item.getCostFormJson()) ? JSONObject.parseObject((String)item.getCostFormJson()) : new JSONObject();
                    JSONObject data = costFormJson.getJSONObject("data") == null ? new JSONObject() : costFormJson.getJSONObject("data");
                    object2 = data.keySet().iterator();
                    while (object2.hasNext()) {
                        String key = (String)object2.next();
                        data.put(key, (Object)new JSONArray());
                    }
                    JSONArray groups = costFormJson.getJSONArray("groups") == null ? new JSONArray() : costFormJson.getJSONArray("groups");
                    for (Object object3 : groups) {
                        JSONObject group = (JSONObject)object3;
                        group.put("totalValue", null);
                    }
                    item.setCostFormJson(costFormJson.toJSONString());
                }
            }
        }
    }

    private CurrentQuoteTrendVO getTrend(List<PurchaseEnquiryItemHisLp> dataList) {
        CurrentQuoteTrendVO trendVO = new CurrentQuoteTrendVO();
        List<String> legendData = dataList.stream().map(PurchaseEnquiryItemHisLp::getSupplierName).distinct().collect(Collectors.toList());
        trendVO.setLegendData(legendData);
        List<Integer> xAxisData = dataList.stream().map(PurchaseEnquiryItemHisLp::getQuoteCount).distinct().collect(Collectors.toList());
        trendVO.setXAxisData(xAxisData);
        return trendVO;
    }

    private CurrentQuoteTrendVO getNormalQuoteHis(List<PurchaseEnquiryItemHisLp> dataList) {
        CurrentQuoteTrendVO trendVO = this.getTrend(dataList);
        Map<String, List<PurchaseEnquiryItemHisLp>> itemMap = dataList.stream().collect(Collectors.groupingBy(PurchaseEnquiryItemHisLp::getSupplierName));
        JSONArray array = new JSONArray();
        for (String supplierName : itemMap.keySet()) {
            JSONObject object = new JSONObject();
            object.put("name", (Object)supplierName);
            object.put("type", (Object)"bar");
            List<PurchaseEnquiryItemHisLp> itemList = itemMap.get(supplierName);
            List priceList = "netPrice".equals(this.priceType) ? itemList.stream().map(PurchaseEnquiryItemHisLp::getNetPrice).collect(Collectors.toList()) : itemList.stream().map(PurchaseEnquiryItemHisLp::getPrice).collect(Collectors.toList());
            object.put("data", priceList);
            array.add((Object)object);
        }
        trendVO.setSeries(array);
        return trendVO;
    }

    private CurrentQuoteTrendVO getLadderQuoteHis(List<PurchaseEnquiryItemHisLp> dataList) {
        Assert.notNull((Object)this.ladderQuantity, (String)I18nUtil.translate((String)"i18n_alert_yDWRxOLV_cff2a168", (String)"\u9636\u68af\u6570\u91cf\u4e0d\u80fd\u4e3a\u7a7a"));
        CurrentQuoteTrendVO trendVO = this.getTrend(dataList);
        Map<String, List<PurchaseEnquiryItemHisLp>> itemMap = dataList.stream().collect(Collectors.groupingBy(PurchaseEnquiryItemHisLp::getSupplierName));
        JSONArray array = new JSONArray();
        for (String supplierName : itemMap.keySet()) {
            JSONObject object = new JSONObject();
            object.put("name", (Object)supplierName);
            object.put("type", (Object)"bar");
            List<PurchaseEnquiryItemHisLp> itemList = itemMap.get(supplierName);
            ArrayList<BigDecimal> priceList = new ArrayList<BigDecimal>();
            for (PurchaseEnquiryItemHisLp item : itemList) {
                BigDecimal price = null;
                if (StrUtil.isNotBlank((CharSequence)item.getLadderPriceJson())) {
                    JSONArray ladderArray = JSONArray.parseArray((String)item.getLadderPriceJson());
                    for (Object ladderObject : ladderArray) {
                        JSONObject ladder = (JSONObject)ladderObject;
                        BigDecimal ladderQuantity = ladder.getBigDecimal("ladderQuantity");
                        if (this.ladderQuantity.compareTo(ladderQuantity) < 0) continue;
                        price = "netPrice".equals(this.priceType) ? ladder.getBigDecimal("netPrice") : ladder.getBigDecimal("price");
                    }
                }
                priceList.add(price);
            }
            object.put("data", priceList);
            array.add((Object)object);
        }
        trendVO.setSeries(array);
        return trendVO;
    }

    private CurrentQuoteTrendVO getCostQuoteHis(List<PurchaseEnquiryItemHisLp> dataList) {
        Assert.hasText((String)this.costGroup, (String)I18nUtil.translate((String)"i18n_alert_LvdxOLV_956826d", (String)"\u6210\u672c\u9879\u4e0d\u80fd\u4e3a\u7a7a"));
        CurrentQuoteTrendVO trendVO = this.getTrend(dataList);
        Map<String, List<PurchaseEnquiryItemHisLp>> itemMap = dataList.stream().collect(Collectors.groupingBy(PurchaseEnquiryItemHisLp::getSupplierName));
        JSONArray array = new JSONArray();
        for (String supplierName : itemMap.keySet()) {
            JSONObject object = new JSONObject();
            object.put("name", (Object)supplierName);
            object.put("type", (Object)"bar");
            List<PurchaseEnquiryItemHisLp> itemList = itemMap.get(supplierName);
            ArrayList<BigDecimal> priceList = new ArrayList<BigDecimal>();
            for (PurchaseEnquiryItemHisLp item : itemList) {
                BigDecimal price = null;
                if (StrUtil.isNotBlank((CharSequence)item.getCostFormJson())) {
                    JSONObject costObject = JSONObject.parseObject((String)item.getCostFormJson());
                    JSONArray groups = costObject.getJSONArray("groups") == null ? new JSONArray() : costObject.getJSONArray("groups");
                    for (Object groupObject : groups) {
                        JSONObject group = (JSONObject)groupObject;
                        if (!this.costGroup.equals(group.getString("groupCode"))) continue;
                        price = group.getBigDecimal("totalValue");
                    }
                }
                priceList.add(price);
            }
            object.put("data", priceList);
            array.add((Object)object);
        }
        trendVO.setSeries(array);
        return trendVO;
    }

    @Override
    public JSONObject queryCompare(String headId, List<String> compareList, List<String> toElsAccountList) {
        JSONObject result = new JSONObject();
        List dbList = this.list((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(PurchaseEnquiryItemHisLp::getHeadId, (Object)headId)).in(CollectionUtil.isNotEmpty(toElsAccountList), PurchaseEnquiryItemHisLp::getToElsAccount, toElsAccountList));
        Result dbResult = Result.ok((Object)dbList);
        ((DictTranslateService)SpringContextUtils.getBean(DictTranslateService.class)).parseJson((Object)dbResult, new DictTranslateAspectParam());
        List dataList = (List)dbResult.getResult();
        this.compareNormal(dataList, result);
        this.compareLadder(dataList, result);
        this.compareCost(dataList, result);
        this.compareSupplier(dataList, result);
        return result;
    }

    private void compareNormal(List<JSONObject> dataList, JSONObject result) {
        JSONObject object;
        int i;
        List sortList;
        Map<String, List<JSONObject>> dataMap = dataList.stream().collect(Collectors.groupingBy(item -> item.getString("itemNumber") + "_" + item.getInteger("quoteCount")));
        for (Map.Entry<String, List<JSONObject>> entry : dataMap.entrySet()) {
            sortList = entry.getValue().stream().filter(item -> item.getBigDecimal("price") != null && item.getDate("quoteTime") != null).sorted(Comparator.comparing(newVal -> newVal.getBigDecimal("price")).thenComparing(newVal -> newVal.getDate("quoteTime"))).collect(Collectors.toList());
            for (i = 0; i < sortList.size(); ++i) {
                object = (JSONObject)sortList.get(i);
                object.put("minPrice", (Object)(i == 0 ? 1 : 0));
                object.put("maxPrice", (Object)(i == sortList.size() - 1 ? 1 : 0));
            }
        }
        for (Map.Entry<String, List<JSONObject>> entry : dataMap.entrySet()) {
            sortList = entry.getValue().stream().filter(item -> item.getBigDecimal("netPrice") != null && item.getDate("quoteTime") != null).sorted(Comparator.comparing(newVal -> newVal.getBigDecimal("netPrice")).thenComparing(newVal -> newVal.getDate("quoteTime"))).collect(Collectors.toList());
            for (i = 0; i < sortList.size(); ++i) {
                object = (JSONObject)sortList.get(i);
                object.put("minNetPrice", (Object)(i == 0 ? 1 : 0));
                object.put("maxNetPrice", (Object)(i == sortList.size() - 1 ? 1 : 0));
            }
        }
        result.put("normalList", dataList);
    }

    private void compareLadder(List<JSONObject> dataList, JSONObject result) {
        List<JSONObject> newList = this.getNewList(dataList);
        List ladderList = newList.stream().filter(item -> EnquiryQuoteWayEnum.LADDER.getValue().equals(item.getString("quotePriceWay"))).collect(Collectors.toList());
        if (CollectionUtil.isNotEmpty(ladderList)) {
            String ladder;
            HashMap<String, List<JSONObject>> dataMap = new HashMap<String, List<JSONObject>>();
            for (JSONObject jSONObject : ladderList) {
                JSONArray ladderArray = JSONArray.parseArray((String)jSONObject.getString("ladderPriceJson"));
                for (Object object : ladderArray) {
                    JSONObject ladderItem = (JSONObject)object;
                    String ladder2 = ladderItem.getString("ladder");
                    jSONObject.put(ladder2, (Object)ladderItem);
                    String mapKey = ladder2 + "_" + jSONObject.getString("itemNumber") + "_" + jSONObject.getInteger("quoteCount");
                    this.getDataMap(dataMap, mapKey, jSONObject);
                }
            }
            for (Map.Entry entry : dataMap.entrySet()) {
                ladder = ((String)entry.getKey()).split("_")[0];
                this.setMinPriceAndMaxPrice((List)entry.getValue(), ladder);
            }
            for (Map.Entry entry : dataMap.entrySet()) {
                ladder = ((String)entry.getKey()).split("_")[0];
                this.setMinNetPriceAndMaxNetPrice((List)entry.getValue(), ladder);
            }
            for (JSONObject jSONObject : ladderList) {
                JSONObject newItem = JSONObject.parseObject((String)jSONObject.toJSONString());
                JSONArray ladderArray = JSONArray.parseArray((String)jSONObject.getString("ladderPriceJson"));
                JSONArray ladderPriceJson = new JSONArray();
                for (Object object : ladderArray) {
                    JSONObject ladderItem = (JSONObject)object;
                    ladderPriceJson.add((Object)newItem.getJSONObject(ladderItem.getString("ladder")));
                }
                jSONObject.put("ladderPriceJson", (Object)ladderPriceJson);
            }
            result.put("ladderList", ladderList);
        }
    }

    private void getDataMap(Map<String, List<JSONObject>> dataMap, String key, JSONObject item) {
        if (dataMap.containsKey(key)) {
            dataMap.get(key).add(item);
        } else {
            ArrayList<JSONObject> list = new ArrayList<JSONObject>();
            list.add(item);
            dataMap.put(key, list);
        }
    }

    private void setMinPriceAndMaxPrice(List<JSONObject> needSortList, String mapKey) {
        List sortList = needSortList.stream().filter(item -> item.getJSONObject(mapKey).getBigDecimal("price") != null && item.getDate("quoteTime") != null).sorted(Comparator.comparing(item -> item.getJSONObject(mapKey).getBigDecimal("price")).thenComparing(item -> item.getDate("quoteTime"))).collect(Collectors.toList());
        for (int i = 0; i < sortList.size(); ++i) {
            JSONObject item2 = (JSONObject)sortList.get(i);
            item2.getJSONObject(mapKey).put("minPrice", (Object)(i == 0 ? 1 : 0));
            item2.getJSONObject(mapKey).put("maxPrice", (Object)(i == sortList.size() - 1 ? 1 : 0));
        }
    }

    private void setMinNetPriceAndMaxNetPrice(List<JSONObject> needSortList, String mapKey) {
        List sortList = needSortList.stream().filter(item -> item.getJSONObject(mapKey).getBigDecimal("netPrice") != null && item.getDate("quoteTime") != null).sorted(Comparator.comparing(item -> item.getJSONObject(mapKey).getBigDecimal("netPrice")).thenComparing(item -> item.getDate("quoteTime"))).collect(Collectors.toList());
        for (int i = 0; i < sortList.size(); ++i) {
            JSONObject item2 = (JSONObject)sortList.get(i);
            item2.getJSONObject(mapKey).put("minNetPrice", (Object)(i == 0 ? 1 : 0));
            item2.getJSONObject(mapKey).put("maxNetPrice", (Object)(i == sortList.size() - 1 ? 1 : 0));
        }
    }

    private void compareCost(List<JSONObject> dataList, JSONObject result) {
        List<JSONObject> newList = this.getNewList(dataList);
        List costList = newList.stream().filter(item -> EnquiryQuoteWayEnum.COST.getValue().equals(item.getString("quotePriceWay"))).collect(Collectors.toList());
        if (CollectionUtil.isNotEmpty(costList)) {
            String groupCode;
            HashMap<String, List<JSONObject>> dataMap = new HashMap<String, List<JSONObject>>();
            for (JSONObject jSONObject : costList) {
                JSONObject costObject = JSONObject.parseObject((String)jSONObject.getString("costFormJson"));
                JSONArray costGroups = costObject.getJSONArray("groups");
                for (Object object : costGroups) {
                    JSONObject costItem = (JSONObject)object;
                    String groupCode2 = costItem.getString("groupCode");
                    jSONObject.put(groupCode2, (Object)costItem);
                    String mapKey = groupCode2 + "_" + jSONObject.getString("itemNumber") + "_" + jSONObject.getInteger("quoteCount");
                    this.getDataMap(dataMap, mapKey, jSONObject);
                }
            }
            for (Map.Entry entry : dataMap.entrySet()) {
                groupCode = ((String)entry.getKey()).split("_")[0];
                this.setMinPriceAndMaxPrice((List)entry.getValue(), groupCode);
            }
            for (Map.Entry entry : dataMap.entrySet()) {
                groupCode = ((String)entry.getKey()).split("_")[0];
                this.setMinNetPriceAndMaxNetPrice((List)entry.getValue(), groupCode);
            }
            for (JSONObject jSONObject : costList) {
                JSONObject newItem = JSONObject.parseObject((String)jSONObject.toJSONString());
                JSONObject costObject = JSONObject.parseObject((String)jSONObject.getString("costFormJson"));
                JSONArray costGroups = costObject.getJSONArray("groups");
                JSONArray costFormJson = new JSONArray();
                for (Object object : costGroups) {
                    JSONObject costItem = (JSONObject)object;
                    costFormJson.add((Object)newItem.getJSONObject(costItem.getString("groupCode")));
                }
                jSONObject.put("costFormJson", (Object)costFormJson);
            }
            result.put("costList", costList);
        }
    }

    private void compareSupplier(List<JSONObject> dataList, JSONObject result) {
        List<JSONObject> supplierList = this.getNewList(dataList);
        Map dataMap = supplierList.stream().collect(Collectors.toMap(item -> item.getString("toElsAccount") + "_" + item.getInteger("quoteCount"), Function.identity(), (newVal, oldVal) -> {
            BigDecimal newTaxAmount = newVal.getBigDecimal("taxAmount") == null ? BigDecimal.ZERO : newVal.getBigDecimal("taxAmount");
            BigDecimal oldTaxAmount = oldVal.getBigDecimal("taxAmount") == null ? BigDecimal.ZERO : oldVal.getBigDecimal("taxAmount");
            BigDecimal taxAmount = oldTaxAmount.add(newTaxAmount);
            oldVal.put("taxAmount", (Object)taxAmount);
            oldVal.put("price", (Object)taxAmount);
            BigDecimal newNetAmount = newVal.getBigDecimal("netAmount") == null ? BigDecimal.ZERO : newVal.getBigDecimal("netAmount");
            BigDecimal oldNetAmount = oldVal.getBigDecimal("netAmount") == null ? BigDecimal.ZERO : oldVal.getBigDecimal("netAmount");
            BigDecimal netAmount = oldNetAmount.add(newNetAmount);
            oldVal.put("netAmount", (Object)netAmount);
            oldVal.put("netPrice", (Object)netAmount);
            return oldVal;
        }));
        List taxAmountSortList = dataMap.values().stream().sorted(Comparator.comparing(item -> item.getBigDecimal("taxAmount")).thenComparing(item -> item.getDate("quoteTime"))).collect(Collectors.toList());
        for (int i = 0; i < taxAmountSortList.size(); ++i) {
            JSONObject item2 = (JSONObject)taxAmountSortList.get(i);
            item2.put("minTaxAmount", (Object)(i == 0 ? 1 : 0));
            item2.put("maxTaxAmount", (Object)(i == taxAmountSortList.size() - 1 ? 1 : 0));
        }
        List netAmountSortList = dataMap.values().stream().sorted(Comparator.comparing(item -> item.getBigDecimal("netAmount")).thenComparing(item -> item.getDate("quoteTime"))).collect(Collectors.toList());
        for (int i = 0; i < netAmountSortList.size(); ++i) {
            JSONObject item3 = (JSONObject)netAmountSortList.get(i);
            item3.put("minNetAmount", (Object)(i == 0 ? 1 : 0));
            item3.put("maxNetAmount", (Object)(i == netAmountSortList.size() - 1 ? 1 : 0));
        }
        result.put("supplierList", new ArrayList(dataMap.values()));
    }

    private List<JSONObject> getNewList(List<JSONObject> dataList) {
        ArrayList<JSONObject> newList = new ArrayList<JSONObject>();
        dataList.forEach(item -> {
            JSONObject supplier = JSONObject.parseObject((String)item.toJSONString());
            newList.add(supplier);
        });
        return newList;
    }
}

