/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.logisticspurchase.enquiry.service.impl;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.bean.copier.CopyOptions;
import cn.hutool.core.date.DateUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.els.common.aspect.annotation.SrmTransaction;
import com.els.common.exception.ELSBootException;
import com.els.common.system.base.service.impl.BaseServiceImpl;
import com.els.common.util.IPUtils;
import com.els.common.util.LoginUserContext;
import com.els.common.util.RedisUtil;
import com.els.common.util.SpringContextUtils;
import com.els.common.util.SysUtil;
import com.els.config.mybatis.TenantContext;
import com.els.modules.account.api.dto.LoginUserDTO;
import com.els.modules.base.api.dto.ElsInitialTableDTO;
import com.els.modules.inquiry.rpc.service.InquiryInvokeSupplierRpcService;
import com.els.modules.logisticspurchase.base.entity.LineDifferenceHead;
import com.els.modules.logisticspurchase.base.entity.SubjectFileItem;
import com.els.modules.logisticspurchase.base.service.LineDifferenceHeadService;
import com.els.modules.logisticspurchase.base.service.SubjectFileItemService;
import com.els.modules.logisticspurchase.enquiry.entity.EnquirySupplierListLp;
import com.els.modules.logisticspurchase.enquiry.entity.PurchaseEnquiryItemLp;
import com.els.modules.logisticspurchase.enquiry.entity.SaleEnquiryHeadLp;
import com.els.modules.logisticspurchase.enquiry.entity.SaleEnquiryItemLp;
import com.els.modules.logisticspurchase.enquiry.enumerate.EnquiryLpStatusEnum;
import com.els.modules.logisticspurchase.enquiry.mapper.SaleEnquiryHeadLpMapper;
import com.els.modules.logisticspurchase.enquiry.service.EnquirySupplierListLpService;
import com.els.modules.logisticspurchase.enquiry.service.PurchaseEnquiryHeadLpService;
import com.els.modules.logisticspurchase.enquiry.service.PurchaseEnquiryItemLpService;
import com.els.modules.logisticspurchase.enquiry.service.SaleEnquiryHeadLpService;
import com.els.modules.logisticspurchase.enquiry.service.SaleEnquiryItemLpService;
import com.els.modules.logisticspurchase.enquiry.service.SaleEnquiryLpOperationService;
import com.els.modules.logisticspurchase.enquiry.vo.SaleEnquiryHeadLpVO;
import com.els.modules.supplier.api.dto.SupplierMasterDataDTO;
import com.els.rpc.service.InvokeBaseRpcService;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.compress.utils.Lists;
import org.springframework.stereotype.Service;

@Service
public class SaleEnquiryLpOperationServiceImpl
extends BaseServiceImpl<SaleEnquiryHeadLpMapper, SaleEnquiryHeadLp>
implements SaleEnquiryLpOperationService {
    @Resource
    private PurchaseEnquiryHeadLpService purchaseEnquiryHeadLpService;
    @Resource
    private PurchaseEnquiryItemLpService purchaseEnquiryItemLpService;
    @Resource
    private InvokeBaseRpcService invokeBaseRpcService;
    @Resource
    private SaleEnquiryHeadLpService saleEnquiryHeadLpService;
    @Resource
    private SaleEnquiryItemLpService saleEnquiryItemLpService;
    @Resource
    private EnquirySupplierListLpService enquirySupplierListLpService;
    @Resource
    private SubjectFileItemService subjectFileItemService;
    @Resource
    private LineDifferenceHeadService lineDifferenceHeadService;
    @Resource
    private RedisUtil redisUtil;
    private static final String APPLY_KEY = "sys:enquiry:quote";
    @Resource(name="srmPoolExecutor")
    public ThreadPoolExecutor executor;

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void publish(final SaleEnquiryHeadLpVO headVO) {
        this.setHeadParamAndCheck(headVO);
        if (!this.redisUtil.tryGetDistributedLock(APPLY_KEY, headVO.getId(), 3600000L)) {
            throw new ELSBootException("\u62a5\u4ef7\u8bf7\u6c42\u5df2\u7ecf\u63d0\u4ea4\uff0c\u7cfb\u7edf\u6b63\u5728\u5904\u7406\u4e2d\uff0c\u65e0\u9700\u91cd\u590d\u63d0\u4ea4\u62a5\u4ef7\uff0c\u8bf7\u7a0d\u540e\u5728\u9500\u552e\u534f\u540c-\u5bfb\u6e90\u534f\u540c-\u62a5\u4ef7\u7ba1\u7406\u4e2d\u67e5\u770b\u62a5\u4ef7\u7ed3\u679c");
        }
        SaleEnquiryHeadLp updateHead = new SaleEnquiryHeadLp();
        BeanUtil.copyProperties((Object)((Object)headVO), (Object)((Object)updateHead), (String[])new String[0]);
        this.saleEnquiryHeadLpService.updateById((Object)updateHead);
        final LoginUserDTO loginUser = SysUtil.getLoginUser();
        headVO.setFbk2(IPUtils.getIpAddr());
        headVO.setFbk3(loginUser.getCompanyName());
        this.executor.execute(new Runnable(){

            @Override
            public void run() {
                LoginUserContext.setUser((LoginUserDTO)loginUser);
                TenantContext.setTenant((String)loginUser.getElsAccount());
                try {
                    ((SaleEnquiryLpOperationService)SpringContextUtils.getBean(SaleEnquiryLpOperationService.class)).asynPublish(headVO);
                }
                catch (Exception e) {
                    SaleEnquiryLpOperationServiceImpl.this.log.error("asynPublish_faild:", (Throwable)e);
                    SaleEnquiryHeadLp updateHead = new SaleEnquiryHeadLp();
                    updateHead.setEnquiryStatus(EnquiryLpStatusEnum.QOUTE_FAILED.getValue());
                    updateHead.setId(headVO.getId());
                    updateHead.setFbk3(e.getMessage());
                    SaleEnquiryLpOperationServiceImpl.this.saleEnquiryHeadLpService.updateById((Object)updateHead);
                }
                finally {
                    SaleEnquiryLpOperationServiceImpl.this.redisUtil.releaseDistributedLock(SaleEnquiryLpOperationServiceImpl.APPLY_KEY, headVO.getId());
                    LoginUserContext.clear();
                    TenantContext.clear();
                }
            }
        });
    }

    private void setHeadParamAndCheck(SaleEnquiryHeadLpVO headVO) {
        SaleEnquiryHeadLp dbHead = (SaleEnquiryHeadLp)((Object)this.getById((Serializable)((Object)headVO.getId())));
        if (dbHead.getQuoteEndTime().before(new Date())) {
            throw new ELSBootException("\u62a5\u4ef7\u622a\u6b62\u65f6\u95f4\u5df2\u8fc7\uff0c\u4e0d\u80fd\u8fdb\u884c\u62a5\u4ef7\u64cd\u4f5c\uff01");
        }
        if (StrUtil.isBlank((CharSequence)headVO.getTaxCode()) || StrUtil.isBlank((CharSequence)headVO.getTaxRate())) {
            throw new ELSBootException("\u8bf7\u5148\u7ef4\u62a4\u62a5\u4ef7\u7a0e\u7387\u540e\u518d\u63d0\u4ea4\u62a5\u4ef7");
        }
        this.checkItem(dbHead.getSubjectType(), headVO.getSaleEnquiryItemList());
        headVO.setSupplierListId(dbHead.getSupplierListId());
        headVO.setEnquiryStatus(EnquiryLpStatusEnum.QOUTE_SUBMITING.getValue());
        headVO.setSubjectFileHeadId(dbHead.getSubjectFileHeadId());
        headVO.setSubjectType(dbHead.getSubjectType());
        this.checkSubject(dbHead.getSubjectFileHeadId(), headVO.getSaleEnquiryItemList());
    }

    private void checkSubject(String subjectId, List<SaleEnquiryItemLp> itemList) {
        Map<String, List<SaleEnquiryItemLp>> itemListMap = itemList.stream().collect(Collectors.groupingBy(SaleEnquiryItemLp::getSectionNumber));
        List<SubjectFileItem> subjectItemList = this.subjectFileItemService.selectByMainId(subjectId);
        Map subjectMap = subjectItemList.stream().collect(Collectors.toMap(SubjectFileItem::getSectionNumber, Function.identity()));
        for (String sectionNumber : itemListMap.keySet()) {
            SubjectFileItem subjectItem = (SubjectFileItem)((Object)subjectMap.get(sectionNumber));
            if (subjectItem == null) {
                throw new ELSBootException("\u6807\u6bb5\u7f16\u7801\uff1a" + sectionNumber + " \u5728\u6807\u7684\u4fe1\u606f\u4e2d\u4e0d\u5b58\u5728\uff01");
            }
            if (subjectItem.getTrafficVolumeProportion() != null) continue;
            throw new ELSBootException("\u6807\u6bb5\u7f16\u7801\uff1a" + sectionNumber + " \u7684\u8fd0\u91cf\u5360\u6bd4\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
    }

    private void checkItem(String subjectType, List<SaleEnquiryItemLp> itemList) {
        List enquiryNumberList = itemList.stream().map(SaleEnquiryItemLp::getEnquiryNumber).distinct().collect(Collectors.toList());
        if (enquiryNumberList.size() > 1) {
            throw new ELSBootException("\u5b58\u5728\u591a\u4e2a\u8be2\u4ef7\u5355\u53f7\uff0c\u8bf7\u68c0\u67e5\u6570\u636e");
        }
        List itemNumberList = itemList.stream().map(o -> o.getSectionNumber() + o.getItemNumber()).distinct().collect(Collectors.toList());
        if (itemList.size() != itemNumberList.size()) {
            throw new ELSBootException("\u540c\u4e00\u4e2a\u6807\u6bb5\u4e0b\u5b58\u5728\u76f8\u540c\u7684\u8be2\u4ef7\u5355\u884c\u53f7\uff0c\u8bf7\u68c0\u67e5\u6570\u636e");
        }
        for (SaleEnquiryItemLp item : itemList) {
            if (StrUtil.isBlank((CharSequence)item.getItemNumber())) {
                throw new ELSBootException("\u5b58\u5728\u8be2\u4ef7\u5355\u884c\u53f7\u4e3a\u7a7a\u7684\u884c\u6570\u636e\uff0c\u8bf7\u68c0\u67e5");
            }
            if (StrUtil.isBlank((CharSequence)item.getSectionNumber())) {
                throw new ELSBootException("\u5b58\u5728\u6807\u6bb5\u7f16\u7801\u4e3a\u7a7a\u7684\u884c\u6570\u636e\uff0c\u8bf7\u68c0\u67e5");
            }
            if ("2".equals(subjectType)) {
                if (item.getIntervalRatioPrice1() == null) {
                    throw new ELSBootException("\u5b58\u5728 0-10 \u62a5\u4ef7\u4e3a\u7a7a\u7684\u884c\u6570\u636e\uff0c\u8bf7\u68c0\u67e5");
                }
                if (item.getIntervalRatioPrice2() == null) {
                    throw new ELSBootException("\u5b58\u5728 10\uff08\u542b\uff09-20 \u62a5\u4ef7\u4e3a\u7a7a\u7684\u884c\u6570\u636e\uff0c\u8bf7\u68c0\u67e5");
                }
                if (item.getIntervalRatioPrice3() == null) {
                    throw new ELSBootException("\u5b58\u5728 20\uff08\u542b\uff09- 30 \u62a5\u4ef7\u4e3a\u7a7a\u7684\u884c\u6570\u636e\uff0c\u8bf7\u68c0\u67e5");
                }
                if (item.getIntervalRatioPrice4() == null) {
                    throw new ELSBootException("\u5b58\u5728 >=30 \u62a5\u4ef7\u4e3a\u7a7a\u7684\u884c\u6570\u636e\uff0c\u8bf7\u68c0\u67e5");
                }
                if (item.getIntervalRatioPrice2().compareTo(item.getIntervalRatioPrice1()) >= 0) {
                    throw new ELSBootException("\u5b58\u5728 10\uff08\u542b\uff09-20 \u62a5\u4ef7 \u5927\u4e8e\u7b49\u4e8e 0-10 \u62a5\u4ef7 \u7684\u6570\u636e\uff0c\u8bf7\u68c0\u67e5");
                }
                if (item.getIntervalRatioPrice3().compareTo(item.getIntervalRatioPrice2()) >= 0) {
                    throw new ELSBootException("\u5b58\u5728 20\uff08\u542b\uff09- 30 \u62a5\u4ef7 \u5927\u4e8e\u7b49\u4e8e 10\uff08\u542b\uff09-20 \u62a5\u4ef7 \u7684\u6570\u636e\uff0c\u8bf7\u68c0\u67e5");
                }
                if (item.getIntervalRatioPrice4().compareTo(item.getIntervalRatioPrice3()) < 0) continue;
                throw new ELSBootException("\u5b58\u5728 >=30 \u62a5\u4ef7 \u5927\u4e8e\u7b49\u4e8e 20\uff08\u542b\uff09- 30 \u62a5\u4ef7 \u7684\u6570\u636e\uff0c\u8bf7\u68c0\u67e5");
            }
            if ("1".equals(subjectType)) {
                if (item.getToDoorPrice() == null) {
                    throw new ELSBootException("\u5b58\u5728\u95e8\u5230\u95e8\u4ef7\u683c\uff08\u5143/\u53ea\uff09\u62a5\u4ef7\u4e3a\u7a7a\u7684\u884c\u6570\u636e\uff0c\u8bf7\u68c0\u67e5");
                }
                if (StrUtil.isBlank((CharSequence)item.getToDoorDate())) {
                    throw new ELSBootException("\u5b58\u5728\u95e8-\u95e8\u7269\u6d41\u65f6\u95f4\uff08\u5929\uff09\u4e3a\u7a7a\u7684\u884c\u6570\u636e\uff0c\u8bf7\u68c0\u67e5");
                }
                try {
                    new BigDecimal(item.getToDoorDate());
                    continue;
                }
                catch (Exception e) {
                    throw new ELSBootException("\u95e8-\u95e8\u7269\u6d41\u65f6\u95f4\uff08\u5929\uff09\u6570 \u5fc5\u987b\u662f\u6570\u5b57");
                }
            }
            if ("3".equals(subjectType)) {
                if (item.getToDoorTonsPrice() == null) {
                    throw new ELSBootException("\u5b58\u5728 \u95e8\u5230\u95e8\u4ef7\u683c\uff08\u5143/\u5428\uff09\u62a5\u4ef7\u4e3a\u7a7a\u7684\u884c\u6570\u636e\uff0c\u8bf7\u68c0\u67e5");
                }
                if (StrUtil.isBlank((CharSequence)item.getToDoorTonsDate())) {
                    throw new ELSBootException("\u5b58\u5728 \u95e8-\u95e8\u65f6\u6548\uff08\u5929\uff09\u4e3a\u7a7a\u7684\u884c\u6570\u636e\uff0c\u8bf7\u68c0\u67e5");
                }
                try {
                    new BigDecimal(item.getToDoorTonsDate());
                    continue;
                }
                catch (Exception e) {
                    throw new ELSBootException("\u95e8-\u95e8\u65f6\u6548\uff08\u5929\uff09\u6570 \u5fc5\u987b\u662f\u6570\u5b57");
                }
            }
            if (!"4".equals(subjectType)) continue;
            if (item.getToStationPrice() == null) {
                throw new ELSBootException("\u5b58\u5728 \u95e8\u5230\u7ad9\u4ef7\u683c\uff08\u5143/\u53ea\uff09\u62a5\u4ef7\u4e3a\u7a7a\u7684\u884c\u6570\u636e\uff0c\u8bf7\u68c0\u67e5");
            }
            if (StrUtil.isBlank((CharSequence)item.getToSta())) {
                throw new ELSBootException("\u5b58\u5728 \u95e8-\u7ad9\u7269\u6d41\u65f6\u95f4\uff08\u5929\uff09\u4e3a\u7a7a\u7684\u884c\u6570\u636e\uff0c\u8bf7\u68c0\u67e5");
            }
            try {
                new BigDecimal(item.getToSta());
            }
            catch (Exception e) {
                throw new ELSBootException("\u95e8-\u7ad9\u7269\u6d41\u65f6\u95f4\uff08\u5929\uff09\u6570 \u5fc5\u987b\u662f\u6570\u5b57");
            }
        }
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void asynPublish(SaleEnquiryHeadLpVO headVO) {
        long time = System.currentTimeMillis();
        SaleEnquiryHeadLp dbHead = (SaleEnquiryHeadLp)((Object)this.getById((Serializable)((Object)headVO.getId())));
        int itemCount = this.saleEnquiryItemLpService.count((Wrapper)new QueryWrapper().eq((Object)"head_id", (Object)headVO.getId()));
        List dbItemList = Lists.newArrayList();
        if (itemCount == 0) {
            List initTableList = this.invokeBaseRpcService.getInitTableListByRelationId(dbHead.getRelationId());
            for (ElsInitialTableDTO table : initTableList) {
                SaleEnquiryItemLp saleEnquiryItem = (SaleEnquiryItemLp)((Object)JSONObject.parseObject((String)table.getBusinessInfoJson(), SaleEnquiryItemLp.class));
                dbItemList.add(saleEnquiryItem);
            }
        } else {
            dbItemList = this.saleEnquiryItemLpService.list((Wrapper)new QueryWrapper().select(new String[]{"id", "relation_id", "head_id", "item_number", "section_number", "traffic_volume_proportion,kilometre"}).eq((Object)"head_id", (Object)headVO.getId()));
        }
        Map<String, List<SaleEnquiryItemLp>> dbItemMap = dbItemList.stream().collect(Collectors.groupingBy(o -> o.getSectionNumber() + o.getItemNumber()));
        List<SaleEnquiryItemLp> enquiryItemList = headVO.getSaleEnquiryItemList();
        if (dbItemList.size() != enquiryItemList.size()) {
            throw new ELSBootException("\u5f53\u524d\u5bfc\u5165\u62a5\u4ef7\u884c\u6570" + enquiryItemList.size() + "\u4e0d\u7b49\u4e8e\u8981\u6c42\u62a5\u4ef7\u884c\u6570" + dbItemList.size() + "\uff0c\u8bf7\u68c0\u67e5");
        }
        ArrayList<SaleEnquiryItemLp> saleItemList = new ArrayList<SaleEnquiryItemLp>();
        ArrayList<PurchaseEnquiryItemLp> purchaseItemList = new ArrayList<PurchaseEnquiryItemLp>();
        Map<String, List<SaleEnquiryItemLp>> itemListMap = enquiryItemList.stream().collect(Collectors.groupingBy(SaleEnquiryItemLp::getSectionNumber));
        String subjectType = headVO.getSubjectType();
        List<SubjectFileItem> subjectItemList = this.subjectFileItemService.selectByMainId(headVO.getSubjectFileHeadId());
        Map subjectMap = subjectItemList.stream().collect(Collectors.toMap(SubjectFileItem::getSectionNumber, Function.identity()));
        BigDecimal totalAmount = BigDecimal.ZERO;
        for (String sectionNumber : itemListMap.keySet()) {
            List<SaleEnquiryItemLp> itemList = itemListMap.get(sectionNumber);
            SubjectFileItem subjectItem = (SubjectFileItem)((Object)subjectMap.get(sectionNumber));
            BigDecimal subjectAmount = BigDecimal.ZERO;
            for (SaleEnquiryItemLp item : itemList) {
                SaleEnquiryItemLp dbItem = dbItemMap.get(item.getSectionNumber() + item.getItemNumber()).get(0);
                if (dbItem == null) {
                    this.log.error("asynPublish_faild:\u5b58\u5728\u5e93\u4e2d\u6ca1\u6709\u7684\u884c\u9879\u76ee\uff1a" + headVO.getId() + "_" + item.getSectionNumber() + "_" + item.getItemNumber());
                    continue;
                }
                BeanUtil.copyProperties((Object)((Object)dbItem), (Object)((Object)item), (CopyOptions)CopyOptions.create().setIgnoreNullValue(true).setIgnoreError(true));
                this.computeNetPrice(headVO, item);
                if ("2".equals(subjectType)) {
                    BigDecimal netPrice1 = item.getIntervalRatioNetPrice1().multiply(subjectItem.getIntervalRatio1().divide(new BigDecimal(100), 6, 4));
                    BigDecimal netPrice2 = item.getIntervalRatioNetPrice2().multiply(subjectItem.getIntervalRatio2().divide(new BigDecimal(100), 6, 4));
                    BigDecimal netPrice3 = item.getIntervalRatioNetPrice3().multiply(subjectItem.getIntervalRatio3().divide(new BigDecimal(100), 6, 4));
                    BigDecimal netPrice4 = item.getIntervalRatioNetPrice4().multiply(subjectItem.getIntervalRatio4().divide(new BigDecimal(100), 6, 4));
                    BigDecimal netAmount = netPrice1.add(netPrice2).add(netPrice3).add(netPrice4);
                    item.setNetPrice(netAmount);
                    item.setNetAmount(netAmount.multiply(dbItem.getTrafficVolumeProportion().divide(new BigDecimal(100), 6, 4)));
                } else if ("1".equals(subjectType)) {
                    item.setNetAmount(item.getToDoorNetPrice().multiply(dbItem.getTrafficVolumeProportion().divide(new BigDecimal(100), 6, 4)));
                } else if ("3".equals(subjectType)) {
                    item.setNetAmount(item.getToDoorTonsNetPrice().multiply(dbItem.getTrafficVolumeProportion().divide(new BigDecimal(100), 6, 4)));
                } else if ("4".equals(subjectType)) {
                    item.setNetAmount(item.getToStationNetPrice().multiply(dbItem.getTrafficVolumeProportion().divide(new BigDecimal(100), 6, 4)));
                }
                subjectAmount = subjectAmount.add(item.getNetAmount());
                item.setId(IdWorker.getIdStr());
                item.setRelationId(IdWorker.getIdStr());
                item.setQuoteIp(headVO.getFbk2());
                item.setQuoteTime(new Date());
                item.setTaxCode(headVO.getTaxCode());
                item.setTaxRate(headVO.getTaxRate());
                item.setItemStatus(EnquiryLpStatusEnum.QUOTED.getValue());
                item.setEffectiveDate(dbHead.getEffectiveDate());
                item.setExpiryDate(dbHead.getExpiryDate());
                item.setElsAccount(dbHead.getElsAccount());
                item.setToElsAccount(dbHead.getToElsAccount());
                item.setSupplierName(headVO.getFbk3());
                item.setHeadId(dbHead.getId());
                saleItemList.add(item);
                PurchaseEnquiryItemLp purchaseItem = new PurchaseEnquiryItemLp();
                BeanUtil.copyProperties((Object)((Object)item), (Object)((Object)purchaseItem), (String[])new String[0]);
                purchaseItem.setId(item.getRelationId());
                purchaseItem.setRelationId(item.getId());
                purchaseItem.setElsAccount(dbHead.getToElsAccount());
                purchaseItem.setHeadId(dbHead.getRelationId());
                purchaseItem.setSupplierId(dbHead.getSupplierListId());
                purchaseItem.setToElsAccount(dbHead.getElsAccount());
                purchaseItemList.add(purchaseItem);
            }
            BigDecimal trafficVolumeProportion = subjectItem.getTrafficVolumeProportion();
            totalAmount = totalAmount.add(subjectAmount.multiply(trafficVolumeProportion.divide(new BigDecimal(100), 4, 4)));
        }
        SaleEnquiryHeadLp updateHead = new SaleEnquiryHeadLp();
        updateHead.setEnquiryStatus(EnquiryLpStatusEnum.QUOTED.getValue());
        updateHead.setId(headVO.getId());
        updateHead.setFbk2(totalAmount.setScale(2, 4).toString());
        updateHead.setFbk3("");
        this.saleEnquiryHeadLpService.updateById((Object)updateHead);
        EnquirySupplierListLp supplierList = new EnquirySupplierListLp();
        supplierList.setId(dbHead.getSupplierListId());
        supplierList.setFbk1("\u5df2\u62a5\u4ef7");
        supplierList.setFbk3(DateUtil.formatDateTime((Date)new Date()));
        this.enquirySupplierListLpService.updateById((Object)supplierList);
        SupplierMasterDataDTO supplierMasterDataDTO = ((InquiryInvokeSupplierRpcService)SpringContextUtils.getBean(InquiryInvokeSupplierRpcService.class)).getByAccount(dbHead.getToElsAccount(), dbHead.getElsAccount());
        LineDifferenceHead differenceHead = new LineDifferenceHead();
        differenceHead.setElsAccount(dbHead.getToElsAccount());
        differenceHead.setSourceId(dbHead.getId());
        differenceHead.setSourceNumber(dbHead.getEnquiryNumber());
        differenceHead.setSourceType("1");
        differenceHead.setToElsAccount(dbHead.getElsAccount());
        if (supplierMasterDataDTO != null && !ObjectUtil.isEmpty((Object)supplierMasterDataDTO.getSupplierName())) {
            differenceHead.setSupplierName(supplierMasterDataDTO.getSupplierName());
        } else {
            differenceHead.setSupplierName(dbHead.getSupplierName());
        }
        differenceHead.setSubjectNumber(dbHead.getSubjectNumber());
        differenceHead.setSubjectName(dbHead.getSubjectName());
        differenceHead.setSubjectFileHeadId(dbHead.getSubjectFileHeadId());
        differenceHead.setTransportType(dbHead.getSubjectType());
        differenceHead.setTotalNetAmount(totalAmount.setScale(2, 4));
        differenceHead.setSubjectYear(DateUtil.format((Date)new Date(), (String)"yyyy"));
        LineDifferenceHead dbDifferenceHead = (LineDifferenceHead)((Object)this.lineDifferenceHeadService.getOne((Wrapper)new QueryWrapper().eq((Object)"source_id", (Object)dbHead.getId())));
        if (dbDifferenceHead == null) {
            this.lineDifferenceHeadService.save((Object)differenceHead);
        } else {
            differenceHead.setId(dbDifferenceHead.getId());
            this.lineDifferenceHeadService.updateById((Object)differenceHead);
        }
        this.saleEnquiryItemLpService.deleteByMainId(dbHead.getId());
        this.purchaseEnquiryItemLpService.deleteByMainIdAndAccount(dbHead.getRelationId(), dbHead.getElsAccount());
        this.saleEnquiryItemLpService.saveBatch(saleItemList, 2000);
        this.purchaseEnquiryItemLpService.saveBatch(purchaseItemList, 2000);
        this.log.error("toElsAccount_enquiryNumber_quote_cost:" + dbHead.getElsAccount() + "_" + dbHead.getEnquiryNumber() + "_" + (System.currentTimeMillis() - time));
    }

    private void computeNetPrice(SaleEnquiryHeadLpVO headVO, SaleEnquiryItemLp item) {
        BigDecimal taxRate = new BigDecimal(headVO.getTaxRate());
        if (item.getIntervalRatioPrice1() != null) {
            item.setIntervalRatioPrice1(item.getIntervalRatioPrice1().setScale(0, 4));
            item.setIntervalRatioNetPrice1(item.getIntervalRatioPrice1().divide(BigDecimal.ONE.add(taxRate.divide(new BigDecimal(100), 4, 4)), 2, 4));
        }
        if (item.getIntervalRatioPrice2() != null) {
            item.setIntervalRatioPrice2(item.getIntervalRatioPrice2().setScale(0, 4));
            item.setIntervalRatioNetPrice2(item.getIntervalRatioPrice2().divide(BigDecimal.ONE.add(taxRate.divide(new BigDecimal(100), 4, 4)), 2, 4));
        }
        if (item.getIntervalRatioPrice3() != null) {
            item.setIntervalRatioPrice3(item.getIntervalRatioPrice3().setScale(0, 4));
            item.setIntervalRatioNetPrice3(item.getIntervalRatioPrice3().divide(BigDecimal.ONE.add(taxRate.divide(new BigDecimal(100), 4, 4)), 2, 4));
        }
        if (item.getIntervalRatioPrice4() != null) {
            item.setIntervalRatioPrice4(item.getIntervalRatioPrice4().setScale(0, 4));
            item.setIntervalRatioNetPrice4(item.getIntervalRatioPrice4().divide(BigDecimal.ONE.add(taxRate.divide(new BigDecimal(100), 4, 4)), 2, 4));
        }
        if (item.getToDoorPrice() != null) {
            item.setToDoorPrice(item.getToDoorPrice().setScale(0, 4));
            item.setToDoorNetPrice(item.getToDoorPrice().divide(BigDecimal.ONE.add(taxRate.divide(new BigDecimal(100), 4, 4)), 2, 4));
        }
        if (item.getToStationPrice() != null) {
            item.setToStationPrice(item.getToStationPrice().setScale(0, 4));
            item.setToStationNetPrice(item.getToStationPrice().divide(BigDecimal.ONE.add(taxRate.divide(new BigDecimal(100), 4, 4)), 2, 4));
        }
        if (item.getToDoorTonsPrice() != null) {
            item.setToDoorTonsPrice(item.getToDoorTonsPrice().setScale(0, 4));
            item.setToDoorTonsNetPrice(item.getToDoorTonsPrice().divide(BigDecimal.ONE.add(taxRate.divide(new BigDecimal(100), 4, 4)), 2, 4));
        }
        if (item.getToDoorDate() != null) {
            BigDecimal toDoorDate = new BigDecimal(item.getToDoorDate()).setScale(0, 4);
            item.setToDoorDate(toDoorDate.toString());
        }
        if (item.getToSta() != null) {
            BigDecimal toSta = new BigDecimal(item.getToSta()).setScale(0, 4);
            item.setToSta(toSta.toString());
        }
        if (item.getToDoorTonsDate() != null) {
            BigDecimal toDoorTonsDate = new BigDecimal(item.getToDoorTonsDate()).setScale(0, 4);
            item.setToDoorTonsDate(toDoorTonsDate.toString());
        }
    }
}

