/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.logisticspurchase.enquiry.utils;

import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.els.common.service.DictTranslateOldService;
import com.els.common.util.ConvertUtils;
import com.els.common.util.SpringContextUtils;
import com.els.config.mybatis.TenantContext;
import com.els.modules.enquiry.enumerate.EnquiryQuoteWayEnum;
import com.els.modules.logisticspurchase.enquiry.entity.PurchaseEnquiryItemLp;
import com.els.rpc.service.InvokeBaseRpcService;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class CostTranslateDictUtil {
    private String HEAD = "head";
    private String type;
    private String groupCode;

    private CostTranslateDictUtil() {
    }

    public static CostTranslateDictUtil build() {
        return new CostTranslateDictUtil();
    }

    public void translate(PurchaseEnquiryItemLp item) {
        ArrayList<PurchaseEnquiryItemLp> itemList = new ArrayList<PurchaseEnquiryItemLp>();
        itemList.add(item);
        this.translate(itemList);
    }

    public void translate(List<PurchaseEnquiryItemLp> itemList) {
        for (PurchaseEnquiryItemLp item : itemList) {
            String costJsonString = item.getCostFormJson();
            if (!EnquiryQuoteWayEnum.COST.getValue().equals(item.getQuotePriceWay()) || !StrUtil.isNotBlank((CharSequence)costJsonString)) continue;
            JSONObject costJson = JSONObject.parseObject((String)costJsonString);
            String templateAccount = costJson.getString("templateAccount");
            String busAccount = costJson.getString("busAccount");
            String templateNumber = costJson.getString("templateNumber");
            String templateVersion = costJson.getString("templateVersion");
            JSONObject data = costJson.getJSONObject("data") == null ? new JSONObject() : costJson.getJSONObject("data");
            for (String groupCode : data.keySet()) {
                Object value = data.get((Object)groupCode);
                this.groupCode = groupCode;
                if (value instanceof JSONArray) {
                    this.type = "item";
                    JSONArray array = (JSONArray)value;
                    this.translate(array, templateAccount, busAccount, templateNumber, templateVersion);
                    continue;
                }
                if (!(value instanceof JSONObject)) continue;
                this.type = this.HEAD;
                JSONObject result = this.translate((JSONObject)value, templateAccount, busAccount, templateNumber, templateVersion);
                data.put(groupCode, (Object)result);
            }
            item.setCostFormJson(costJson.toJSONString());
        }
    }

    private void translate(JSONArray array, String templateAccount, String busAccount, String templateNumber, String templateVersion) {
        for (int i = 0; i < array.size(); ++i) {
            JSONObject result = this.translate(array.getJSONObject(i), templateAccount, busAccount, templateNumber, templateVersion);
            array.set(i, (Object)result);
        }
    }

    private JSONObject translate(JSONObject object, String templateAccount, String busAccount, String templateNumber, String templateVersion) {
        busAccount = StrUtil.isBlank((CharSequence)busAccount) ? TenantContext.getTenant() : busAccount;
        String account = StrUtil.isBlank((CharSequence)templateAccount) ? busAccount : templateAccount;
        InvokeBaseRpcService baseRpcService = (InvokeBaseRpcService)SpringContextUtils.getBean(InvokeBaseRpcService.class);
        Map dictMap = this.HEAD.equals(this.type) ? baseRpcService.getHeadDictMap(account, templateNumber, templateVersion) : baseRpcService.getItemDictMap(account, templateNumber, templateVersion);
        JSONObject result = new JSONObject();
        for (String fieldName : object.keySet()) {
            result.put(fieldName, object.get((Object)fieldName));
            String dictCode = (String)dictMap.get(fieldName);
            if (!StrUtil.isNotBlank((CharSequence)dictCode)) continue;
            String code = "";
            String text = null;
            String table = null;
            String valueText = null;
            if (dictCode.contains(",") || dictCode.contains("#")) {
                String[] dictCodeArray = dictCode.contains("#") ? dictCode.split("#") : dictCode.split(",");
                switch (dictCodeArray.length) {
                    case 4: {
                        code = dictCodeArray[3];
                        break;
                    }
                    case 3: {
                        valueText = dictCodeArray[2];
                        break;
                    }
                    case 2: {
                        text = dictCodeArray[1];
                        break;
                    }
                    case 1: {
                        table = dictCodeArray[0];
                        break;
                    }
                }
            } else {
                code = dictCode;
            }
            String value = result.getString(fieldName);
            if (ConvertUtils.isEmpty((Object)value)) {
                result.put(fieldName + "_dictText", null);
                continue;
            }
            String textValue = this.getDictValue(code, text, table, value, busAccount, valueText);
            result.put(fieldName + "_dictText", (Object)textValue);
        }
        return result;
    }

    private String getDictValue(String code, String text, String table, String value, String busAccount, String valueText) {
        String[] values;
        DictTranslateOldService dictTranslateService = (DictTranslateOldService)SpringContextUtils.getBean(DictTranslateOldService.class);
        StringBuilder textValue = new StringBuilder();
        for (String val : values = value.split(",")) {
            String tmpValue;
            if (val.trim().length() == 0 || (tmpValue = StrUtil.isNotBlank((CharSequence)valueText) ? dictTranslateService.queryTableDictTextByFilterSql(busAccount, val, table, text, value, code) : dictTranslateService.queryDictTextByKey(code, val.trim(), busAccount)) == null) continue;
            if (StrUtil.isNotBlank((CharSequence)textValue)) {
                textValue.append(",");
            }
            textValue.append(tmpValue);
        }
        return textValue.toString();
    }
}

