/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.priceEvaluationManagement.excel;

import com.alibaba.fastjson.JSON;
import com.els.common.aspect.annotation.RpcService;
import com.els.common.aspect.annotation.SrmTransaction;
import com.els.common.excel.service.ErrorExcelHandlerService;
import com.els.common.util.I18nUtil;
import com.els.common.util.SysUtil;
import com.els.config.mybatis.TenantContext;
import com.els.modules.account.api.dto.LoginUserDTO;
import com.els.modules.base.api.dto.ExcelImportDTO;
import com.els.modules.base.api.dto.TemplateHeadDTO;
import com.els.modules.base.api.service.ExcelImportRpcService;
import com.els.modules.priceEvaluationManagement.entity.PurchaseManagementClassify;
import com.els.modules.priceEvaluationManagement.enumerate.PurchaseManagementClassifyStatusEnum;
import com.els.modules.priceEvaluationManagement.service.PurchaseManagementClassifyService;
import com.els.rpc.service.InvokeBaseRpcService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.Assert;

@RpcService(value="managementClassifyExcelHandler")
public class PurchaseManagementClassifyExcelHandler
extends ErrorExcelHandlerService
implements ExcelImportRpcService {
    private static final Logger log = LoggerFactory.getLogger(PurchaseManagementClassifyExcelHandler.class);
    @Resource
    private InvokeBaseRpcService invokeBaseRpcService;
    @Autowired
    private PurchaseManagementClassifyService purchaseManagementClassifyService;

    @SrmTransaction(rollbackFor={Exception.class})
    public List<Map<String, Object>> importExcel(ExcelImportDTO excelImportDTO) {
        LoginUserDTO loginUser = SysUtil.getLoginUser();
        List dataList = excelImportDTO.getDataList();
        int totalCount = 0 == excelImportDTO.getTotalCount() ? dataList.size() : excelImportDTO.getTotalCount();
        List templateList = this.invokeBaseRpcService.getDefaultTemplateByType("purchaseManagementClassify");
        Assert.notEmpty((Collection)templateList, (String)I18nUtil.translate((String)"i18n_alert_RvHWBjCLjESIrPKxOuNcIRvHW_34160e0a", (String)"\u7ba1\u7406\u7cfb\u6570\u6ca1\u6709\u9ed8\u8ba4\u7684\u4e1a\u52a1\u6a21\u677f,\u6682\u65f6\u4e0d\u80fd\u5bfc\u5165\u521b\u5efa\u7ba1\u7406\u7cfb\u6570!"));
        TemplateHeadDTO templateHeadDTO = (TemplateHeadDTO)templateList.get(0);
        ArrayList<PurchaseManagementClassify> purchaseManagementClassifyList = new ArrayList<PurchaseManagementClassify>();
        List nextCodes = this.invokeBaseRpcService.getNextCodes("purchaseManagementClassifyNumber", null, totalCount);
        for (Map data : dataList) {
            PurchaseManagementClassify managementClassify = (PurchaseManagementClassify)((Object)JSON.parseObject((String)JSON.toJSONString((Object)data), PurchaseManagementClassify.class));
            purchaseManagementClassifyList.add(managementClassify);
        }
        int i = 0;
        for (PurchaseManagementClassify managementClassify : purchaseManagementClassifyList) {
            managementClassify.setTemplateAccount(templateHeadDTO.getElsAccount());
            managementClassify.setTemplateVersion("" + templateHeadDTO.getTemplateVersion());
            managementClassify.setTemplateNumber(templateHeadDTO.getTemplateNumber());
            managementClassify.setTemplateName(templateHeadDTO.getTemplateName());
            managementClassify.setDocumentNumber((String)nextCodes.get(i));
            managementClassify.setBusAccount(loginUser.getElsAccount());
            managementClassify.setDocumentStatus(PurchaseManagementClassifyStatusEnum.NEW.getValue());
            ++i;
        }
        this.errorHandle(true, excelImportDTO, TenantContext.getTenant(), totalCount);
        this.purchaseManagementClassifyService.saveBatch(purchaseManagementClassifyList, 200);
        return dataList;
    }
}

