/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.quotaProcotol.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.els.common.enumerate.AuditStatusEnum;
import com.els.common.exception.ELSBootException;
import com.els.common.system.base.entity.BaseEntity;
import com.els.common.system.base.service.impl.BaseOpenServiceImpl;
import com.els.common.util.I18nUtil;
import com.els.common.util.SysUtil;
import com.els.modules.account.api.dto.LoginUserDTO;
import com.els.modules.quotaProcotol.entity.PurchaseQuotaProtocolHead;
import com.els.modules.quotaProcotol.entity.PurchaseQuotaProtocolItem;
import com.els.modules.quotaProcotol.enumerate.PurchaseQuotaProcotolStatusEnum;
import com.els.modules.quotaProcotol.mapper.PurchaseQuotaProtocolHeadMapper;
import com.els.modules.quotaProcotol.service.PurchaseQuotaProtocolHeadService;
import com.els.modules.quotaProcotol.service.PurchaseQuotaProtocolItemService;
import com.els.modules.quotaProcotol.vo.PurchaseQuotaProtocolHeadVO;
import com.els.rpc.service.InvokeBaseRpcService;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;

@Service
public class PurchaseQuotaProtocolHeadServiceImpl
extends BaseOpenServiceImpl<PurchaseQuotaProtocolHeadMapper, PurchaseQuotaProtocolHead, PurchaseQuotaProtocolHeadVO>
implements PurchaseQuotaProtocolHeadService {
    @Autowired
    private PurchaseQuotaProtocolItemService purchaseQuotaProtocolItemService;
    @Resource
    private InvokeBaseRpcService baseRpcService;

    @Override
    @Transactional(rollbackFor={RuntimeException.class})
    public void saveMain(PurchaseQuotaProtocolHead purchaseQuotaProtocolHead, List<PurchaseQuotaProtocolItem> purchaseQuotaProtocolItemList) {
        purchaseQuotaProtocolHead.setDocumentNumber(this.baseRpcService.getNextCode("quotaProcotol", (Object)purchaseQuotaProtocolHead));
        if ("1".equals(purchaseQuotaProtocolHead.getPublishStatus())) {
            purchaseQuotaProtocolHead.setAuditStatus(AuditStatusEnum.AUDIT_NEW.getValue());
        } else {
            purchaseQuotaProtocolHead.setAuditStatus(AuditStatusEnum.NO_AUDIT_REQUIRED.getValue());
        }
        ((PurchaseQuotaProtocolHeadMapper)this.baseMapper).insert((Object)purchaseQuotaProtocolHead);
        super.setHeadDefaultValue((BaseEntity)purchaseQuotaProtocolHead);
        this.insertData(purchaseQuotaProtocolHead, purchaseQuotaProtocolItemList);
    }

    @Override
    @Transactional(rollbackFor={RuntimeException.class})
    public void updateMain(PurchaseQuotaProtocolHead purchaseQuotaProtocolHead, List<PurchaseQuotaProtocolItem> purchaseQuotaProtocolItemList) {
        if ("1".equals(purchaseQuotaProtocolHead.getPublishStatus())) {
            purchaseQuotaProtocolHead.setAuditStatus(AuditStatusEnum.AUDIT_NEW.getValue());
        } else {
            purchaseQuotaProtocolHead.setAuditStatus(AuditStatusEnum.NO_AUDIT_REQUIRED.getValue());
        }
        int count = ((PurchaseQuotaProtocolHeadMapper)this.baseMapper).updateById((Object)purchaseQuotaProtocolHead);
        Assert.isTrue((count != 0 ? 1 : 0) != 0, (String)I18nUtil.translate((String)"i18n_alert_APWFIKXWVVVXVSDJHrW_2fe92d52", (String)"\u5f53\u524d\u6570\u636e\u5df2\u5931\u6548\uff0c\u8bf7\u91cd\u65b0\u5237\u65b0\u540e\u63d0\u4ea4\u66f4\u6539\uff01"));
        if (!CollectionUtils.isEmpty(purchaseQuotaProtocolItemList)) {
            BigDecimal quotaSum = BigDecimal.ZERO;
            for (PurchaseQuotaProtocolItem purchaseQuotaProtocolItem : purchaseQuotaProtocolItemList) {
                BigDecimal quota = purchaseQuotaProtocolItem.getQuota() == null ? BigDecimal.ZERO : purchaseQuotaProtocolItem.getQuota();
                quotaSum = quotaSum.add(quota);
            }
            BigDecimal oneHundred = new BigDecimal("100");
            if (oneHundred.compareTo(quotaSum) != 0) {
                throw new ELSBootException("\u914d\u989d\u534f\u8bae\u884c\u7684\u914d\u989d\u6570\u91cf\u4e4b\u548c\u5fc5\u987b\u7b49\u4e8e100");
            }
        }
        this.purchaseQuotaProtocolItemService.deleteByMainId(purchaseQuotaProtocolHead.getId());
        this.insertData(purchaseQuotaProtocolHead, purchaseQuotaProtocolItemList);
    }

    private void checkQuotaProcotolDate(PurchaseQuotaProtocolHead purchaseQuotaProtocolHead) {
        if (purchaseQuotaProtocolHead.getEffectiveDate() == null) {
            return;
        }
        LambdaQueryWrapper lambdaQueryWrapper = new QueryWrapper().lambda();
        lambdaQueryWrapper.eq(PurchaseQuotaProtocolHead::getMaterialNumber, (Object)purchaseQuotaProtocolHead.getMaterialNumber());
        lambdaQueryWrapper.ge(PurchaseQuotaProtocolHead::getEffectiveDate, (Object)purchaseQuotaProtocolHead.getEffectiveDate());
        List purchaseQuotaProtocolHeadList = this.list((Wrapper)lambdaQueryWrapper);
        if (!CollectionUtils.isEmpty((Collection)purchaseQuotaProtocolHeadList)) {
            throw new ELSBootException("\u7269\u6599\u7f16\u7801:" + purchaseQuotaProtocolHead.getMaterialNumber() + "\u5df2\u7ecf\u5b58\u5728\u5f53\u524d\u6709\u6548\u671f\u5185\u7684\u914d\u989d\u534f\u8bae");
        }
    }

    private void insertData(PurchaseQuotaProtocolHead purchaseQuotaProtocolHead, List<PurchaseQuotaProtocolItem> purchaseQuotaProtocolItemList) {
        if (!CollectionUtils.isEmpty(purchaseQuotaProtocolItemList)) {
            for (PurchaseQuotaProtocolItem entity : purchaseQuotaProtocolItemList) {
                entity.setHeadId(purchaseQuotaProtocolHead.getId());
                SysUtil.setSysParam((BaseEntity)entity, (BaseEntity)purchaseQuotaProtocolHead);
                entity.setId(IdWorker.getIdStr());
            }
            this.purchaseQuotaProtocolItemService.saveBatch(purchaseQuotaProtocolItemList, 2000);
        }
    }

    @Override
    @Transactional(rollbackFor={RuntimeException.class})
    public void deleteMain(String id) {
        this.purchaseQuotaProtocolItemService.deleteByMainId(id);
        ((PurchaseQuotaProtocolHeadMapper)this.baseMapper).deleteById((Serializable)((Object)id));
    }

    @Override
    @Transactional(rollbackFor={RuntimeException.class})
    public void deleteBatchMain(List<String> idList) {
        for (Serializable serializable : idList) {
            this.purchaseQuotaProtocolItemService.deleteByMainId(serializable.toString());
            ((PurchaseQuotaProtocolHeadMapper)this.baseMapper).deleteById(serializable);
        }
    }

    @Override
    public void submit(PurchaseQuotaProtocolHead purchaseQuotaProtocolHead, List<PurchaseQuotaProtocolItem> purchaseQuotaProtocolItemList) {
        PurchaseQuotaProtocolHead dbPurchaseQuotaProtocolHead = (PurchaseQuotaProtocolHead)((Object)this.getById((Serializable)((Object)purchaseQuotaProtocolHead.getId())));
        if (dbPurchaseQuotaProtocolHead == null) {
            throw new ELSBootException("\u7cfb\u7edf\u4e2d\u67e5\u8be2\u4e0d\u5230\u8be5\u5355\u636e\uff0c\u8bf7\u4ed4\u7ec6\u68c0\u67e5!");
        }
        PurchaseQuotaProtocolHead paramPurchaseQuotaProcotolHead = new PurchaseQuotaProtocolHead();
        paramPurchaseQuotaProcotolHead.setId(dbPurchaseQuotaProtocolHead.getId());
        if (new Date().compareTo(dbPurchaseQuotaProtocolHead.getEffectiveDate()) >= 0 && new Date().compareTo(dbPurchaseQuotaProtocolHead.getExpiryDate()) <= 0) {
            paramPurchaseQuotaProcotolHead.setDocumentStatus(PurchaseQuotaProcotolStatusEnum.EFFECTIVE.getValue());
        } else if (new Date().compareTo(dbPurchaseQuotaProtocolHead.getEffectiveDate()) < 0) {
            paramPurchaseQuotaProcotolHead.setDocumentStatus(PurchaseQuotaProcotolStatusEnum.UN_EFFECTIVE.getValue());
        } else if (new Date().compareTo(dbPurchaseQuotaProtocolHead.getExpiryDate()) > 0) {
            paramPurchaseQuotaProcotolHead.setDocumentStatus(PurchaseQuotaProcotolStatusEnum.EXPIRE.getValue());
        }
        this.updateById((Object)paramPurchaseQuotaProcotolHead);
    }

    @Override
    public void cancel(PurchaseQuotaProtocolHead purchaseQuotaProtocolHead, List<PurchaseQuotaProtocolItem> purchaseQuotaProtocolItemList) {
        PurchaseQuotaProtocolHead dbPurchaseQuotaProtocolHead = (PurchaseQuotaProtocolHead)((Object)this.getById((Serializable)((Object)purchaseQuotaProtocolHead.getId())));
        if (dbPurchaseQuotaProtocolHead == null) {
            throw new ELSBootException("\u7cfb\u7edf\u4e2d\u67e5\u8be2\u4e0d\u5230\u8be5\u5355\u636e\uff0c\u8bf7\u4ed4\u7ec6\u68c0\u67e5!");
        }
        PurchaseQuotaProtocolHead paramPurchaseQuotaProcotolHead = new PurchaseQuotaProtocolHead();
        paramPurchaseQuotaProcotolHead.setId(dbPurchaseQuotaProtocolHead.getId());
        paramPurchaseQuotaProcotolHead.setDocumentStatus(PurchaseQuotaProcotolStatusEnum.CANCEL.getValue());
        this.updateById((Object)paramPurchaseQuotaProcotolHead);
    }

    @Override
    public void copyDocument(PurchaseQuotaProtocolHead purchaseQuotaProtocolHead, List<PurchaseQuotaProtocolItem> purchaseQuotaProtocolItemList) {
        PurchaseQuotaProtocolHead dbPurchaseQuotaProtocolHead = (PurchaseQuotaProtocolHead)((Object)this.getById((Serializable)((Object)purchaseQuotaProtocolHead.getId())));
        if (dbPurchaseQuotaProtocolHead == null) {
            throw new ELSBootException("\u7cfb\u7edf\u4e2d\u67e5\u8be2\u4e0d\u5230\u8be5\u5355\u636e\uff0c\u8bf7\u4ed4\u7ec6\u68c0\u67e5!");
        }
        LoginUserDTO loginUser = SysUtil.getLoginUser();
        List<PurchaseQuotaProtocolItem> purchaseQuotaProtocolItems = this.purchaseQuotaProtocolItemService.selectByMainId(purchaseQuotaProtocolHead.getId());
        PurchaseQuotaProtocolHead paramPurchaseQuotaProtocolHead = new PurchaseQuotaProtocolHead();
        BeanUtils.copyProperties((Object)((Object)dbPurchaseQuotaProtocolHead), (Object)((Object)paramPurchaseQuotaProtocolHead));
        paramPurchaseQuotaProtocolHead.setDocumentStatus(PurchaseQuotaProcotolStatusEnum.NEW.getValue());
        paramPurchaseQuotaProtocolHead.setId(IdWorker.getIdStr());
        paramPurchaseQuotaProtocolHead.setDocumentNumber(this.baseRpcService.getNextCode("quotaProcotol", (Object)purchaseQuotaProtocolHead));
        if ("1".equals(dbPurchaseQuotaProtocolHead.getPublishStatus())) {
            paramPurchaseQuotaProtocolHead.setAuditStatus(AuditStatusEnum.AUDIT_NEW.getValue());
        } else {
            paramPurchaseQuotaProtocolHead.setAuditStatus(AuditStatusEnum.NO_AUDIT_REQUIRED.getValue());
        }
        paramPurchaseQuotaProtocolHead.setCreateTime(new Date());
        paramPurchaseQuotaProtocolHead.setUpdateTime(new Date());
        paramPurchaseQuotaProtocolHead.setCreateBy(loginUser.getSubAccount());
        paramPurchaseQuotaProtocolHead.setUpdateBy(loginUser.getSubAccount());
        this.save((Object)paramPurchaseQuotaProtocolHead);
        ArrayList<PurchaseQuotaProtocolItem> paramPurchaseQuotaProtocolItemList = new ArrayList<PurchaseQuotaProtocolItem>();
        if (!CollectionUtils.isEmpty(purchaseQuotaProtocolItems)) {
            for (PurchaseQuotaProtocolItem purchaseQuotaProtocolItem : purchaseQuotaProtocolItems) {
                PurchaseQuotaProtocolItem paramPurchaseQuotaProtocolItem = new PurchaseQuotaProtocolItem();
                BeanUtils.copyProperties((Object)((Object)purchaseQuotaProtocolItem), (Object)((Object)paramPurchaseQuotaProtocolItem));
                paramPurchaseQuotaProtocolItem.setId(IdWorker.getIdStr());
                paramPurchaseQuotaProtocolItem.setHeadId(paramPurchaseQuotaProtocolHead.getId());
                paramPurchaseQuotaProtocolItem.setDocumentNumber(paramPurchaseQuotaProtocolHead.getDocumentNumber());
                paramPurchaseQuotaProtocolItemList.add(paramPurchaseQuotaProtocolItem);
            }
            this.purchaseQuotaProtocolItemService.saveBatch(paramPurchaseQuotaProtocolItemList);
        }
    }

    protected List<PurchaseQuotaProtocolHeadVO> queryDetailByOpenApi(List<PurchaseQuotaProtocolHead> headList) {
        List headIds = headList.stream().map(BaseEntity::getId).collect(Collectors.toList());
        LambdaQueryWrapper wrapperItem = Wrappers.lambdaQuery();
        wrapperItem.in(PurchaseQuotaProtocolItem::getHeadId, headIds);
        List purchaseMaterialItemList = this.purchaseQuotaProtocolItemService.list((Wrapper)wrapperItem);
        Map<String, List<PurchaseQuotaProtocolItem>> itemMap = purchaseMaterialItemList.stream().collect(Collectors.groupingBy(PurchaseQuotaProtocolItem::getHeadId));
        ArrayList<PurchaseQuotaProtocolHeadVO> result = new ArrayList<PurchaseQuotaProtocolHeadVO>();
        for (PurchaseQuotaProtocolHead head : headList) {
            PurchaseQuotaProtocolHeadVO vo = new PurchaseQuotaProtocolHeadVO();
            BeanUtils.copyProperties((Object)((Object)head), (Object)((Object)vo));
            vo.setPurchaseQuotaProtocolItemList(itemMap.get(vo.getId()));
            result.add(vo);
        }
        return result;
    }

    public void deleteDetailByOpenApi(List<String> headIds, String halfDelete) {
        ((PurchaseQuotaProtocolHeadMapper)this.baseMapper).deleteBatchIds(headIds);
        for (String id : headIds) {
            this.purchaseQuotaProtocolItemService.deleteByMainId(id);
        }
    }
}

