/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.tender.archive.service.impl;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.StrUtil;
import com.els.api.dto.ParentEntityDTO;
import com.els.common.aspect.annotation.SrmTransaction;
import com.els.common.system.base.service.impl.BaseServiceImpl;
import com.els.common.util.SysUtil;
import com.els.modules.account.api.dto.ElsTenantDTO;
import com.els.modules.base.api.dto.PurchaseAttachmentDTO;
import com.els.modules.tender.archive.entity.TenderProjectArchiveAttachmentHead;
import com.els.modules.tender.archive.entity.TenderProjectArchiveAttachmentInfo;
import com.els.modules.tender.archive.enumerate.TenderProjectArchiveAttachmentEnum;
import com.els.modules.tender.archive.enumerate.TenderProjectArchiveStatusEnum;
import com.els.modules.tender.archive.mapper.TenderProjectArchiveAttachmentHeadMapper;
import com.els.modules.tender.archive.service.TenderProjectArchiveAttachmentHeadService;
import com.els.modules.tender.archive.service.TenderProjectArchiveAttachmentInfoService;
import com.els.modules.tender.archive.utils.ArchiveUtil;
import com.els.modules.tender.archive.vo.TenderProjectArchiveAttachmentHeadView;
import com.els.modules.tender.archive.vo.TenderProjectArchiveAttachmentHeadVo;
import com.els.modules.tender.archive.vo.TenderProjectArchiveAttachmentInfoVo;
import com.els.modules.tender.project.entity.PurchaseTenderProjectHead;
import com.els.modules.tender.project.service.PurchaseTenderProjectHeadService;
import com.els.rpc.service.InvokeAccountRpcService;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class TenderProjectArchiveAttachmentHeadServiceImpl
extends BaseServiceImpl<TenderProjectArchiveAttachmentHeadMapper, TenderProjectArchiveAttachmentHead>
implements TenderProjectArchiveAttachmentHeadService {
    @Autowired
    private TenderProjectArchiveAttachmentInfoService archiveAttachmentInfoService;
    @Autowired
    private PurchaseTenderProjectHeadService tenderProjectHeadService;
    @Resource
    private InvokeAccountRpcService accountRpcService;

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void add(TenderProjectArchiveAttachmentHead tenderProjectArchiveAttachmentHead, List<TenderProjectArchiveAttachmentInfo> infoList) {
        this.insertData(tenderProjectArchiveAttachmentHead, infoList);
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void edit(TenderProjectArchiveAttachmentHead tenderProjectArchiveAttachmentHead, List<TenderProjectArchiveAttachmentInfo> infoList) {
        this.insertData(tenderProjectArchiveAttachmentHead, infoList);
    }

    private void insertData(TenderProjectArchiveAttachmentHead tenderProjectArchiveAttachmentHead, List<TenderProjectArchiveAttachmentInfo> infoList) {
        if (CollectionUtil.isEmpty(infoList)) {
            return;
        }
        ArrayList purchaseAttachmentDTOList = SysUtil.copyProperties(infoList, PurchaseAttachmentDTO.class);
        ArchiveUtil.saveArchiveByPurchaseAttachmentDTO(purchaseAttachmentDTOList, tenderProjectArchiveAttachmentHead.getId(), tenderProjectArchiveAttachmentHead.getSubpackageId(), tenderProjectArchiveAttachmentHead.getTenderProjectId(), TenderProjectArchiveAttachmentEnum.ARCHIVE_ATTACHMENT_PREFIX.getValue());
    }

    @Override
    public void delete(String id) {
        ((TenderProjectArchiveAttachmentHeadMapper)this.baseMapper).deleteById((Serializable)((Object)id));
    }

    @Override
    public void deleteBatch(List<String> idList) {
        ((TenderProjectArchiveAttachmentHeadMapper)this.baseMapper).deleteBatchIds(idList);
    }

    @Override
    public List<TenderProjectArchiveAttachmentInfoVo> queryByProjectId(String tenderProjectId) {
        List<TenderProjectArchiveAttachmentInfo> archiveAttachmentInfoList = this.archiveAttachmentInfoService.selectByTenderProjectIds(Arrays.asList(tenderProjectId), null);
        PurchaseTenderProjectHead purchaseTenderProjectHead = (PurchaseTenderProjectHead)((Object)this.tenderProjectHeadService.getBaseMapper().selectById((Serializable)((Object)tenderProjectId)));
        String projectId = purchaseTenderProjectHead.getProjectId();
        List<TenderProjectArchiveAttachmentInfo> archiveAttachmentInfoByApprpvalList = null;
        if (StrUtil.isNotBlank((CharSequence)projectId)) {
            archiveAttachmentInfoByApprpvalList = this.archiveAttachmentInfoService.selectByMainIds(Arrays.asList(projectId));
        }
        if (CollectionUtil.isNotEmpty(archiveAttachmentInfoList) && CollectionUtil.isNotEmpty(archiveAttachmentInfoByApprpvalList)) {
            archiveAttachmentInfoList.addAll(archiveAttachmentInfoByApprpvalList);
        }
        if (CollectionUtil.isNotEmpty(archiveAttachmentInfoList)) {
            archiveAttachmentInfoList = archiveAttachmentInfoList.stream().filter(item -> !TenderProjectArchiveAttachmentEnum.ARCHIVE_ATTACHMENT_PREFIX.getValue().equals(item.getBusinessType())).collect(Collectors.toList());
        }
        List<TenderProjectArchiveAttachmentInfoVo> archiveAttachmentInfoVoList = this.dataConvert(archiveAttachmentInfoList);
        return archiveAttachmentInfoVoList;
    }

    @Override
    public List<TenderProjectArchiveAttachmentInfoVo> queryBySubpackageId(String subpackageId) {
        List<TenderProjectArchiveAttachmentInfo> archiveAttachmentInfoList = this.archiveAttachmentInfoService.selectBySubpackageId(subpackageId, null);
        if (CollectionUtil.isNotEmpty(archiveAttachmentInfoList)) {
            archiveAttachmentInfoList = archiveAttachmentInfoList.stream().filter(item -> !TenderProjectArchiveAttachmentEnum.ARCHIVE_ATTACHMENT_PREFIX.getValue().equals(item.getBusinessType())).collect(Collectors.toList());
        }
        List<TenderProjectArchiveAttachmentInfoVo> archiveAttachmentInfoVoList = this.dataConvert(archiveAttachmentInfoList);
        return archiveAttachmentInfoVoList;
    }

    @Override
    public List<TenderProjectArchiveAttachmentHeadView> queryProjectArchiveInfo(List<TenderProjectArchiveAttachmentHead> headList) {
        if (CollectionUtil.isEmpty(headList)) {
            return null;
        }
        ArrayList tenderProjectArchiveAttachmentHeadViewList = SysUtil.copyProperties(headList, TenderProjectArchiveAttachmentHeadView.class);
        List<String> tenderProjectIds = headList.parallelStream().map(TenderProjectArchiveAttachmentHead::getTenderProjectId).collect(Collectors.toList());
        List<TenderProjectArchiveAttachmentInfo> projectArchiveAttachmentInfoList = this.archiveAttachmentInfoService.selectByTenderProjectIds(tenderProjectIds, null);
        List purchaseTenderProjectHeadList = this.tenderProjectHeadService.getBaseMapper().selectBatchIds(tenderProjectIds);
        List<String> tenderApprovalIds = purchaseTenderProjectHeadList.parallelStream().map(PurchaseTenderProjectHead::getProjectId).collect(Collectors.toList());
        List<TenderProjectArchiveAttachmentInfo> approvalArchiveInfoList = null;
        if (CollectionUtil.isNotEmpty(tenderApprovalIds)) {
            approvalArchiveInfoList = this.archiveAttachmentInfoService.selectByMainIds(tenderApprovalIds);
        }
        Map<String, List<TenderProjectArchiveAttachmentInfo>> projectMap = null;
        Map<String, List<TenderProjectArchiveAttachmentInfo>> approvalMap = null;
        if (CollectionUtil.isNotEmpty(projectArchiveAttachmentInfoList)) {
            projectMap = projectArchiveAttachmentInfoList.parallelStream().collect(Collectors.groupingBy(TenderProjectArchiveAttachmentInfo::getTenderProjectId));
        }
        if (CollectionUtil.isNotEmpty(approvalArchiveInfoList)) {
            approvalMap = approvalArchiveInfoList.parallelStream().collect(Collectors.groupingBy(TenderProjectArchiveAttachmentInfo::getTenderProjectId));
        }
        for (TenderProjectArchiveAttachmentHeadView headVo : tenderProjectArchiveAttachmentHeadViewList) {
            List<TenderProjectArchiveAttachmentInfo> infos;
            int count = 0;
            if (null != projectMap && CollectionUtil.isNotEmpty(infos = projectMap.get(headVo.getTenderProjectId()))) {
                count += infos.size();
            }
            if (null != approvalMap && CollectionUtil.isNotEmpty(infos = approvalMap.get(headVo.getTenderApprovalId()))) {
                count += infos.size();
            }
            headVo.setFileCount(count);
        }
        return tenderProjectArchiveAttachmentHeadViewList;
    }

    private List<TenderProjectArchiveAttachmentInfoVo> dataConvert(List<TenderProjectArchiveAttachmentInfo> archiveAttachmentInfoList) {
        if (CollectionUtil.isEmpty(archiveAttachmentInfoList)) {
            return null;
        }
        List elsAccountList = archiveAttachmentInfoList.stream().filter(archiveAttachmentInfo -> StrUtil.isBlank((CharSequence)archiveAttachmentInfo.getUploadEnterpriseName()) && StrUtil.isNotBlank((CharSequence)archiveAttachmentInfo.getUploadElsAccount())).map(TenderProjectArchiveAttachmentInfo::getUploadElsAccount).collect(Collectors.toList());
        if (CollectionUtil.isNotEmpty(elsAccountList)) {
            List tenantList = this.accountRpcService.getTenantList(elsAccountList);
            Map tenantListMap = tenantList.stream().collect(Collectors.toMap(ParentEntityDTO::getElsAccount, Function.identity()));
            for (TenderProjectArchiveAttachmentInfo tenderProjectArchiveAttachmentInfo2 : archiveAttachmentInfoList) {
                ElsTenantDTO tenantDTO = (ElsTenantDTO)tenantListMap.get(tenderProjectArchiveAttachmentInfo2.getUploadElsAccount());
                if (tenantDTO == null) continue;
                tenderProjectArchiveAttachmentInfo2.setUploadEnterpriseAccount(tenantDTO.getElsAccount());
                tenderProjectArchiveAttachmentInfo2.setUploadEnterpriseName(tenantDTO.getCompanyName());
            }
        }
        List preArchiveAttachmentInfo = archiveAttachmentInfoList.stream().filter(item -> "0".equals(item.getCheckType())).collect(Collectors.toList());
        Map<String, List<TenderProjectArchiveAttachmentInfo>> map = archiveAttachmentInfoList.stream().filter(item -> !"0".equals(item.getCheckType())).collect(Collectors.groupingBy(tenderProjectArchiveAttachmentInfo -> TenderProjectArchiveAttachmentEnum.getAttachmentStatusStage(tenderProjectArchiveAttachmentInfo.getBusinessType()) + "_" + TenderProjectArchiveAttachmentEnum.getAttachmentStatusSort(tenderProjectArchiveAttachmentInfo.getBusinessType())));
        if (CollectionUtil.isNotEmpty(preArchiveAttachmentInfo)) {
            map.put("\u9884\u5ba1_0", preArchiveAttachmentInfo);
        }
        ArrayList<TenderProjectArchiveAttachmentInfoVo> archiveAttachmentInfoVoList = new ArrayList<TenderProjectArchiveAttachmentInfoVo>();
        for (String key : map.keySet()) {
            TenderProjectArchiveAttachmentInfoVo tenderProjectArchiveAttachmentInfoVo = new TenderProjectArchiveAttachmentInfoVo();
            String[] split = key.split("_");
            tenderProjectArchiveAttachmentInfoVo.setTitle(split[0]);
            tenderProjectArchiveAttachmentInfoVo.setSort(Integer.valueOf(split[1]));
            tenderProjectArchiveAttachmentInfoVo.setInfoList(map.get(key));
            archiveAttachmentInfoVoList.add(tenderProjectArchiveAttachmentInfoVo);
        }
        Collections.sort(archiveAttachmentInfoVoList, Comparator.comparing(TenderProjectArchiveAttachmentInfoVo::getSort));
        return archiveAttachmentInfoVoList;
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void transfer(TenderProjectArchiveAttachmentHeadVo headVo) {
        TenderProjectArchiveAttachmentHead archiveAttachmentHead = (TenderProjectArchiveAttachmentHead)((Object)((TenderProjectArchiveAttachmentHeadMapper)this.baseMapper).selectById((Serializable)((Object)headVo.getId())));
        archiveAttachmentHead.setStatus(TenderProjectArchiveStatusEnum.TRANSFER.getValue());
        ((TenderProjectArchiveAttachmentHeadMapper)this.baseMapper).updateById((Object)archiveAttachmentHead);
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void archive(TenderProjectArchiveAttachmentHeadVo headVo) {
        TenderProjectArchiveAttachmentHead archiveAttachmentHead = (TenderProjectArchiveAttachmentHead)((Object)((TenderProjectArchiveAttachmentHeadMapper)this.baseMapper).selectById((Serializable)((Object)headVo.getId())));
        archiveAttachmentHead.setStatus(TenderProjectArchiveStatusEnum.ARCHIVE.getValue());
        ((TenderProjectArchiveAttachmentHeadMapper)this.baseMapper).updateById((Object)archiveAttachmentHead);
    }

    @Override
    public List<TenderProjectArchiveAttachmentInfo> queryBySubpackageIdSupplement(String subpackageId) {
        List<TenderProjectArchiveAttachmentInfo> archiveAttachmentInfoList = this.archiveAttachmentInfoService.selectBySubpackageId(subpackageId, TenderProjectArchiveAttachmentEnum.ARCHIVE_ATTACHMENT_PREFIX.getValue());
        List elsAccountList = archiveAttachmentInfoList.stream().filter(archiveAttachmentInfo -> StrUtil.isBlank((CharSequence)archiveAttachmentInfo.getUploadEnterpriseName()) && StrUtil.isNotBlank((CharSequence)archiveAttachmentInfo.getUploadElsAccount())).map(TenderProjectArchiveAttachmentInfo::getUploadElsAccount).collect(Collectors.toList());
        if (CollectionUtil.isNotEmpty(elsAccountList)) {
            List tenantList = this.accountRpcService.getTenantList(elsAccountList);
            Map tenantListMap = tenantList.stream().collect(Collectors.toMap(ParentEntityDTO::getElsAccount, Function.identity()));
            for (TenderProjectArchiveAttachmentInfo tenderProjectArchiveAttachmentInfo : archiveAttachmentInfoList) {
                ElsTenantDTO tenantDTO = (ElsTenantDTO)tenantListMap.get(tenderProjectArchiveAttachmentInfo.getUploadElsAccount());
                if (tenantDTO == null) continue;
                tenderProjectArchiveAttachmentInfo.setUploadEnterpriseAccount(tenantDTO.getElsAccount());
                tenderProjectArchiveAttachmentInfo.setUploadEnterpriseName(tenantDTO.getCompanyName());
            }
        }
        return archiveAttachmentInfoList;
    }

    @Override
    public List<TenderProjectArchiveAttachmentInfo> queryByProjectIdSupplement(String projectId) {
        List<TenderProjectArchiveAttachmentInfo> archiveAttachmentInfoList = this.archiveAttachmentInfoService.selectByTenderProjectIds(Arrays.asList(projectId), TenderProjectArchiveAttachmentEnum.ARCHIVE_ATTACHMENT_PREFIX.getValue());
        return archiveAttachmentInfoList;
    }
}

