/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.tender.attachment.service.impl;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.StrUtil;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.els.common.aspect.annotation.SrmTransaction;
import com.els.common.constant.CommonConstant;
import com.els.common.system.base.entity.BaseEntity;
import com.els.common.system.base.service.impl.BaseServiceImpl;
import com.els.common.util.I18nUtil;
import com.els.common.util.SysUtil;
import com.els.modules.tender.attachment.entity.CustomColumnModel;
import com.els.modules.tender.attachment.entity.PurchaseTenderBidLetter;
import com.els.modules.tender.attachment.entity.PurchaseTenderBidLetterFormatGroup;
import com.els.modules.tender.attachment.entity.PurchaseTenderPriceOpeningsTemplate;
import com.els.modules.tender.attachment.entity.PurchaseTenderProjectAttachmentHead;
import com.els.modules.tender.attachment.entity.PurchaseTenderQuoteMaterial;
import com.els.modules.tender.attachment.enumerate.BidLetterFormatTypeEnum;
import com.els.modules.tender.attachment.mapper.PurchaseTenderBidLetterFormatGroupMapper;
import com.els.modules.tender.attachment.service.PurchaseTenderBidLetterFormatGroupService;
import com.els.modules.tender.attachment.service.PurchaseTenderBidLetterService;
import com.els.modules.tender.attachment.service.PurchaseTenderPriceOpeningsTemplateService;
import com.els.modules.tender.attachment.service.PurchaseTenderProjectAttachmentHeadService;
import com.els.modules.tender.attachment.service.PurchaseTenderQuoteMaterialService;
import com.els.modules.tender.attachment.vo.PurchaseQuoteMaterialDataVO;
import com.els.modules.tender.attachment.vo.PurchaseTenderBidLetterFormatGroupVO;
import com.els.modules.tender.attachment.vo.PurchaseTenderBidLetterVO;
import com.els.modules.tender.attachment.vo.PurchaseTenderProjectAttachmentHeadViewVO;
import com.els.modules.tender.common.interceptor.TenderFlagInjectionContext;
import com.els.modules.tender.common.utils.FastJsonUtils;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;

@Service
public class PurchaseTenderBidLetterFormatGroupServiceImpl
extends BaseServiceImpl<PurchaseTenderBidLetterFormatGroupMapper, PurchaseTenderBidLetterFormatGroup>
implements PurchaseTenderBidLetterFormatGroupService {
    @Autowired
    @Lazy
    private PurchaseTenderProjectAttachmentHeadService attachmentHeadService;
    @Autowired
    private PurchaseTenderBidLetterService bidLetterService;
    @Autowired
    private PurchaseTenderPriceOpeningsTemplateService priceOpeningsTemplateService;
    @Autowired
    private PurchaseTenderQuoteMaterialService quoteMaterialService;

    @Override
    public void add(PurchaseTenderBidLetterFormatGroup purchaseTenderBidLetterFormatGroup) {
        ((PurchaseTenderBidLetterFormatGroupMapper)this.baseMapper).insert((Object)purchaseTenderBidLetterFormatGroup);
    }

    @Override
    public void edit(PurchaseTenderBidLetterFormatGroup purchaseTenderBidLetterFormatGroup) {
        int count = ((PurchaseTenderBidLetterFormatGroupMapper)this.baseMapper).updateById((Object)purchaseTenderBidLetterFormatGroup);
        Assert.isTrue((count != 0 ? 1 : 0) != 0, (String)I18nUtil.translate((String)"i18n_alert_APWFIKXWVVVXVSDJHrW_2fe92d52", (String)"\u5f53\u524d\u6570\u636e\u5df2\u5931\u6548\uff0c\u8bf7\u91cd\u65b0\u5237\u65b0\u540e\u63d0\u4ea4\u66f4\u6539\uff01"));
    }

    @Override
    public void delete(String id) {
        ((PurchaseTenderBidLetterFormatGroupMapper)this.baseMapper).deleteById((Serializable)((Object)id));
    }

    @Override
    public void deleteBatch(List<String> idList) {
        ((PurchaseTenderBidLetterFormatGroupMapper)this.baseMapper).deleteBatchIds(idList);
    }

    @Override
    public void deleteByMainId(String headId) {
        ((PurchaseTenderBidLetterFormatGroupMapper)this.baseMapper).deleteByMainId(headId);
        this.quoteMaterialService.deleteByMainId(headId);
    }

    @Override
    public void addTenderBidLetter(PurchaseTenderProjectAttachmentHead attachmentHead, PurchaseTenderBidLetterFormatGroupVO bidLetterFormatGroupVo) {
        bidLetterFormatGroupVo.setSubpackageId(attachmentHead.getSubpackageId());
        bidLetterFormatGroupVo.setTenderProjectId(attachmentHead.getTenderProjectId());
        bidLetterFormatGroupVo.setHeadId(attachmentHead.getId());
        bidLetterFormatGroupVo.setDeleted(CommonConstant.DEL_FLAG_0);
        PurchaseTenderBidLetterFormatGroup bidLetterFormatGroup = (PurchaseTenderBidLetterFormatGroup)((Object)SysUtil.copyProperties((Object)((Object)bidLetterFormatGroupVo), PurchaseTenderBidLetterFormatGroup.class));
        ((PurchaseTenderBidLetterFormatGroupMapper)this.baseMapper).insert((Object)bidLetterFormatGroup);
        List<PurchaseTenderBidLetterVO> tenderBidLetterVoList = bidLetterFormatGroupVo.getTenderBidTetterVoList();
        ArrayList<PurchaseTenderPriceOpeningsTemplate> priceOpeningsList = new ArrayList<PurchaseTenderPriceOpeningsTemplate>(10);
        ArrayList<PurchaseTenderBidLetter> tenderBidLetterList = new ArrayList<PurchaseTenderBidLetter>();
        ArrayList<PurchaseTenderQuoteMaterial> materialDataAllList = new ArrayList<PurchaseTenderQuoteMaterial>();
        for (PurchaseTenderBidLetterVO tenderBidLetterVo : tenderBidLetterVoList) {
            PurchaseTenderBidLetter tenderBidLetter = (PurchaseTenderBidLetter)((Object)SysUtil.copyProperties((Object)((Object)tenderBidLetterVo), PurchaseTenderBidLetter.class));
            if (tenderBidLetter.getId() == null) {
                tenderBidLetter.setId(IdWorker.getIdStr());
            }
            tenderBidLetter.setSubpackageId(attachmentHead.getSubpackageId());
            tenderBidLetter.setTenderProjectId(attachmentHead.getTenderProjectId());
            tenderBidLetter.setHeadId(attachmentHead.getId());
            tenderBidLetter.setQuoteColumnSource(bidLetterFormatGroupVo.getQuoteColumnSource());
            tenderBidLetter.setDeleted(CommonConstant.DEL_FLAG_0);
            tenderBidLetter.setProcessType(TenderFlagInjectionContext.getTenderProcessType());
            tenderBidLetter.setCheckType(attachmentHead.getCheckType());
            if ("1".equals(attachmentHead.getCheckType()) && "1".equals(TenderFlagInjectionContext.getTenderProcessType())) {
                String formatType = tenderBidLetter.getFormatType();
                if (!BidLetterFormatTypeEnum.OTHER.getValue().equals(formatType)) {
                    tenderBidLetter.setCurrentStep(formatType);
                }
            }
            tenderBidLetter.setGroupId(bidLetterFormatGroup.getId());
            tenderBidLetterList.add(tenderBidLetter);
            PurchaseTenderPriceOpeningsTemplate tenderPriceOpenings = tenderBidLetterVo.getPriceOpenings();
            if (StrUtil.isBlank((CharSequence)tenderPriceOpenings.getId())) {
                tenderPriceOpenings.setId(IdWorker.getIdStr());
            }
            tenderPriceOpenings.setSubpackageId(attachmentHead.getSubpackageId());
            tenderPriceOpenings.setTenderProjectId(attachmentHead.getTenderProjectId());
            tenderPriceOpenings.setHeadId(attachmentHead.getId());
            tenderPriceOpenings.setBidLetterId(tenderBidLetter.getId());
            tenderPriceOpenings.setDeleted(CommonConstant.DEL_FLAG_0);
            priceOpeningsList.add(tenderPriceOpenings);
            List<PurchaseQuoteMaterialDataVO> quoteColumnList = tenderBidLetterVo.getQuoteColumnList();
            if (CollectionUtil.isEmpty(quoteColumnList)) continue;
            for (PurchaseQuoteMaterialDataVO purchaseQuoteMaterialDataVO : quoteColumnList) {
                List<PurchaseTenderQuoteMaterial> materialDataList = purchaseQuoteMaterialDataVO.getMaterialDataList();
                if (CollectionUtil.isEmpty(materialDataList)) continue;
                materialDataList.stream().forEach(materialData -> {
                    materialData.setId(IdWorker.getIdStr());
                    materialData.setQuoteColumnSource(bidLetterFormatGroupVo.getQuoteColumnSource());
                    materialData.setSubpackageId(attachmentHead.getSubpackageId());
                    materialData.setTenderProjectId(attachmentHead.getTenderProjectId());
                    materialData.setHeadId(attachmentHead.getId());
                    materialData.setPriceOpeningsId(tenderPriceOpenings.getId());
                    materialData.setBidLetterId(tenderBidLetter.getId());
                    materialData.setDeleted(CommonConstant.DEL_FLAG_0);
                    materialData.setElsAccount(attachmentHead.getElsAccount());
                    materialData.setQuoteTitle(purchaseQuoteMaterialDataVO.getTitle());
                    materialData.setQuoteField(purchaseQuoteMaterialDataVO.getField());
                });
                materialDataAllList.addAll(materialDataList);
            }
        }
        this.bidLetterService.saveBatch(tenderBidLetterList, 1000);
        this.priceOpeningsTemplateService.saveBatch(priceOpeningsList, 1000);
        this.quoteMaterialService.saveBatch(materialDataAllList, 1000);
    }

    @Override
    public void updateTenderBidLetter(PurchaseTenderProjectAttachmentHead attachmentHead, PurchaseTenderBidLetterFormatGroupVO tenderBidLetterFormatGroupVo) {
        PurchaseTenderBidLetterFormatGroup purchaseTenderBidLetterFormatGroup = new PurchaseTenderBidLetterFormatGroup();
        BeanUtils.copyProperties((Object)((Object)tenderBidLetterFormatGroupVo), (Object)((Object)purchaseTenderBidLetterFormatGroup));
        this.updateById((Object)purchaseTenderBidLetterFormatGroup);
        List<PurchaseTenderBidLetterVO> tenderBidLetterVoList = tenderBidLetterFormatGroupVo.getTenderBidTetterVoList();
        ArrayList<PurchaseTenderPriceOpeningsTemplate> priceOpeningsList = new ArrayList<PurchaseTenderPriceOpeningsTemplate>(10);
        ArrayList<PurchaseTenderBidLetter> tenderBidLetterList = new ArrayList<PurchaseTenderBidLetter>();
        ArrayList<PurchaseTenderQuoteMaterial> materialDataAllList = new ArrayList<PurchaseTenderQuoteMaterial>();
        for (PurchaseTenderBidLetterVO tenderBidLetterVo : tenderBidLetterVoList) {
            PurchaseTenderBidLetter tenderBidLetter = new PurchaseTenderBidLetter();
            if (StrUtil.isBlank((CharSequence)tenderBidLetter.getId())) {
                tenderBidLetter.setId(IdWorker.getIdStr());
            }
            BeanUtils.copyProperties((Object)((Object)tenderBidLetterVo), (Object)((Object)tenderBidLetter));
            tenderBidLetterList.add(tenderBidLetter);
            PurchaseTenderPriceOpeningsTemplate tenderPriceOpenings = tenderBidLetterVo.getPriceOpenings();
            tenderPriceOpenings.setHeadId(attachmentHead.getId());
            tenderPriceOpenings.setBidLetterId(tenderBidLetter.getId());
            tenderPriceOpenings.setSubpackageId(tenderBidLetter.getSubpackageId());
            tenderPriceOpenings.setTenderProjectId(tenderBidLetter.getTenderProjectId());
            priceOpeningsList.add(tenderPriceOpenings);
            List<PurchaseQuoteMaterialDataVO> quoteColumnList = tenderBidLetterVo.getQuoteColumnList();
            for (PurchaseQuoteMaterialDataVO purchaseQuoteMaterialDataVO : quoteColumnList) {
                List<PurchaseTenderQuoteMaterial> materialDataList = purchaseQuoteMaterialDataVO.getMaterialDataList();
                materialDataList.stream().forEach(materialData -> {
                    materialData.setSubpackageId(attachmentHead.getSubpackageId());
                    materialData.setTenderProjectId(attachmentHead.getTenderProjectId());
                    materialData.setHeadId(attachmentHead.getId());
                    materialData.setBidLetterId(tenderBidLetterVo.getId());
                    materialData.setDeleted(CommonConstant.DEL_FLAG_0);
                    materialData.setElsAccount(attachmentHead.getElsAccount());
                    materialData.setQuoteTitle(purchaseQuoteMaterialDataVO.getTitle());
                    materialData.setQuoteField(purchaseQuoteMaterialDataVO.getField());
                });
                materialDataAllList.addAll(materialDataList);
            }
        }
        this.bidLetterService.saveBatch(tenderBidLetterList, 1000);
        this.priceOpeningsTemplateService.saveBatch(priceOpeningsList, 1000);
        this.quoteMaterialService.saveBatch(materialDataAllList, 1000);
    }

    @Override
    public List<PurchaseTenderBidLetterFormatGroup> selectByMainId(String headId) {
        return ((PurchaseTenderBidLetterFormatGroupMapper)this.baseMapper).selectByMainId(headId);
    }

    @Override
    public List<PurchaseTenderBidLetterFormatGroup> selectByBidLetterId(String bidLetterId) {
        return ((PurchaseTenderBidLetterFormatGroupMapper)this.baseMapper).selectByBidLetterId(bidLetterId);
    }

    @Override
    public PurchaseTenderBidLetterFormatGroupVO queryPurchaseTenderBidLetterFormatGroupVoInfo(PurchaseTenderProjectAttachmentHead purchaseTenderProjectAttachmentHead) {
        List<PurchaseTenderBidLetterFormatGroup> purchaseTenderBidLetterFormatGroupList = this.selectByMainId(purchaseTenderProjectAttachmentHead.getId());
        if (purchaseTenderBidLetterFormatGroupList.isEmpty()) {
            return null;
        }
        PurchaseTenderBidLetterFormatGroupVO groupVo = new PurchaseTenderBidLetterFormatGroupVO();
        PurchaseTenderBidLetterFormatGroup purchaseTenderBidLetterFormatGroup = purchaseTenderBidLetterFormatGroupList.get(0);
        BeanUtils.copyProperties((Object)((Object)purchaseTenderBidLetterFormatGroup), (Object)((Object)groupVo));
        List<PurchaseTenderBidLetter> PurchaseTenderBidLetters = this.bidLetterService.selectByMainId(purchaseTenderBidLetterFormatGroup.getId());
        if (CollectionUtil.isEmpty(PurchaseTenderBidLetters)) {
            return groupVo;
        }
        List<String> bidLetterIds = PurchaseTenderBidLetters.stream().map(BaseEntity::getId).collect(Collectors.toList());
        List<PurchaseTenderPriceOpeningsTemplate> priceOpenings = this.priceOpeningsTemplateService.selectByMainIds(bidLetterIds);
        List<PurchaseTenderQuoteMaterial> materialDataAllList = this.quoteMaterialService.selectByMainIds(bidLetterIds);
        Map<String, List<PurchaseTenderQuoteMaterial>> materialDataAllGroupByBidLetterId = materialDataAllList.stream().collect(Collectors.groupingBy(PurchaseTenderQuoteMaterial::getBidLetterId));
        List<PurchaseTenderBidLetterVO> bidLetterVoList = PurchaseTenderBidLetters.stream().map(bidLetter -> {
            List quoteMaterialList;
            List priceOpeningsList;
            PurchaseTenderBidLetterVO bidLetterVO = new PurchaseTenderBidLetterVO();
            BeanUtils.copyProperties((Object)bidLetter, (Object)((Object)bidLetterVO));
            if (CollectionUtil.isNotEmpty((Collection)priceOpenings) && CollectionUtil.isNotEmpty(priceOpeningsList = priceOpenings.stream().filter(priceOpening -> bidLetter.getId().equals(priceOpening.getBidLetterId())).collect(Collectors.toList()))) {
                PurchaseTenderPriceOpeningsTemplate purchaseTenderPriceOpeningsTemplate = (PurchaseTenderPriceOpeningsTemplate)((Object)((Object)priceOpeningsList.get(0)));
                bidLetterVO.setPriceOpenings(purchaseTenderPriceOpeningsTemplate);
                bidLetterVO.setCustomizeFieldData(purchaseTenderPriceOpeningsTemplate.getCustomizeFieldData());
                bidLetterVO.setCustomizeFieldModel(purchaseTenderPriceOpeningsTemplate.getCustomizeFieldModel());
            }
            if (CollectionUtil.isNotEmpty((Collection)(quoteMaterialList = (List)materialDataAllGroupByBidLetterId.get(bidLetter.getId())))) {
                ArrayList<PurchaseQuoteMaterialDataVO> quoteColumnList = new ArrayList<PurchaseQuoteMaterialDataVO>();
                Map<String, List<PurchaseTenderQuoteMaterial>> materialDataAllGroupByQuoteField = quoteMaterialList.stream().collect(Collectors.groupingBy(PurchaseTenderQuoteMaterial::getQuoteField));
                for (String quoteField : materialDataAllGroupByQuoteField.keySet()) {
                    PurchaseQuoteMaterialDataVO purchaseQuoteMaterialDataVO = new PurchaseQuoteMaterialDataVO();
                    purchaseQuoteMaterialDataVO.setField(quoteField);
                    List<CustomColumnModel> columnModelList = FastJsonUtils.toList(bidLetterVO.getCustomizeFieldModel(), CustomColumnModel.class);
                    if (CollectionUtil.isNotEmpty(columnModelList)) {
                        for (CustomColumnModel customColumnModel : columnModelList) {
                            if (!quoteField.equals(customColumnModel.getField())) continue;
                            purchaseQuoteMaterialDataVO.setTitle(customColumnModel.getTitle());
                            break;
                        }
                    }
                    List<PurchaseTenderQuoteMaterial> materialList = materialDataAllGroupByQuoteField.get(quoteField);
                    purchaseQuoteMaterialDataVO.setMaterialDataList(materialList);
                    quoteColumnList.add(purchaseQuoteMaterialDataVO);
                }
                bidLetterVO.setQuoteColumnList(quoteColumnList);
            }
            return bidLetterVO;
        }).collect(Collectors.toList());
        groupVo.setTenderBidTetterVoList(bidLetterVoList);
        return groupVo;
    }

    @Override
    public PurchaseTenderProjectAttachmentHeadViewVO queryBidLetterFormatGroup(String subpackageId) {
        PurchaseTenderProjectAttachmentHeadViewVO headViewVO = new PurchaseTenderProjectAttachmentHeadViewVO();
        PurchaseTenderProjectAttachmentHead attachmentHead = this.attachmentHeadService.getAttachmentHeadBySubpackageId(subpackageId);
        BeanUtils.copyProperties((Object)((Object)attachmentHead), (Object)((Object)headViewVO));
        PurchaseTenderBidLetterFormatGroupVO purchaseTenderBidLetterFormatGroupVO = this.queryPurchaseTenderBidLetterFormatGroupVoInfo(attachmentHead);
        headViewVO.setTenderBidLetterFormatGroupVo(purchaseTenderBidLetterFormatGroupVO);
        return headViewVO;
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void addBidLetterFormatGroup(PurchaseTenderProjectAttachmentHead purchaseTenderProjectAttachmentHead, PurchaseTenderBidLetterFormatGroupVO bidLetterFormatGroupVo) {
        this.attachmentHeadService.saveOrUpdate((Object)purchaseTenderProjectAttachmentHead);
        this.addTenderBidLetter(purchaseTenderProjectAttachmentHead, bidLetterFormatGroupVo);
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void editBidLetterFormatGroup(PurchaseTenderProjectAttachmentHead purchaseTenderProjectAttachmentHead, PurchaseTenderBidLetterFormatGroupVO bidLetterFormatGroupVo) {
        this.attachmentHeadService.saveOrUpdate((Object)purchaseTenderProjectAttachmentHead);
        this.deleteByMainId(purchaseTenderProjectAttachmentHead.getId());
        this.bidLetterService.deleteByMainId(purchaseTenderProjectAttachmentHead.getId());
        this.priceOpeningsTemplateService.deleteByMainId(purchaseTenderProjectAttachmentHead.getId());
        this.addTenderBidLetter(purchaseTenderProjectAttachmentHead, bidLetterFormatGroupVo);
    }
}

