/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.tender.calibration.service.impl;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.els.common.aspect.annotation.SrmTransaction;
import com.els.common.enumerate.AuditStatusEnum;
import com.els.common.exception.ELSBootException;
import com.els.common.system.base.entity.BaseEntity;
import com.els.common.system.base.service.impl.BaseServiceImpl;
import com.els.common.util.I18nUtil;
import com.els.common.util.RedisUtil;
import com.els.common.util.SysUtil;
import com.els.config.mybatis.TenantContext;
import com.els.modules.base.api.dto.PurchaseAttachmentDTO;
import com.els.modules.demand.entity.PurchaseRequestItem;
import com.els.modules.demand.enumerate.PurchaseRequestStatusItemEnum;
import com.els.modules.demand.service.PurchaseRequestItemService;
import com.els.modules.inquiry.enumerate.SourceTypeEnum;
import com.els.modules.inquiry.rpc.service.InquiryInvokeMainDataRpcService;
import com.els.modules.inquiry.rpc.service.InquiryInvokeSupplierRpcService;
import com.els.modules.material.api.dto.PurchaseMaterialHeadDTO;
import com.els.modules.price.api.dto.PurchaseInformationRecordsDTO;
import com.els.modules.price.api.enumerate.PriceRecordTypeEnum;
import com.els.modules.price.api.enumerate.PriceSourceTypeEnum;
import com.els.modules.price.api.enumerate.PurchaseInformationPriceTypeEnum;
import com.els.modules.supplier.api.dto.SupplierMasterDataDTO;
import com.els.modules.tender.approval.entity.TenderProjectApprovalHead;
import com.els.modules.tender.approval.enumerate.TenderProjectApprovalStateEnum;
import com.els.modules.tender.approval.service.TenderProjectApprovalHeadService;
import com.els.modules.tender.archive.enumerate.TenderProjectArchiveAttachmentEnum;
import com.els.modules.tender.archive.utils.ArchiveUtil;
import com.els.modules.tender.attachment.entity.SaleTenderQuoteMaterial;
import com.els.modules.tender.attachment.service.PurchaseTenderProjectAttachmentHeadService;
import com.els.modules.tender.attachment.service.SaleTenderQuoteMaterialService;
import com.els.modules.tender.attachment.vo.PurchaseTenderBidLetterFormatGroupVO;
import com.els.modules.tender.calibration.entity.BidWinningAffirmHead;
import com.els.modules.tender.calibration.entity.BidWinningAffirmInform;
import com.els.modules.tender.calibration.entity.BidWinningAffirmItem;
import com.els.modules.tender.calibration.entity.PurchaseBidWinningAffirmMaterial;
import com.els.modules.tender.calibration.enumerate.BidWinningAffirmInformEnum;
import com.els.modules.tender.calibration.mapper.BidWinningAffirmInfomMapper;
import com.els.modules.tender.calibration.service.BidWinningAffirmHeadService;
import com.els.modules.tender.calibration.service.BidWinningAffirmInformService;
import com.els.modules.tender.calibration.service.BidWinningAffirmItemService;
import com.els.modules.tender.calibration.vo.BidWinningAffirmHeadVO;
import com.els.modules.tender.calibration.vo.BidWinningAffirmInformVo;
import com.els.modules.tender.calibration.vo.BidWinningAffirmItemVo;
import com.els.modules.tender.calibration.vo.BidWinningAffirmPriceItemVo;
import com.els.modules.tender.common.event.TenderWriteBackSubpackageInfoEventDTO;
import com.els.modules.tender.common.interceptor.TenderFlagInjectionContext;
import com.els.modules.tender.common.utils.PushEventUtils;
import com.els.modules.tender.project.entity.PurchaseTenderProjectHead;
import com.els.modules.tender.project.entity.PurchaseTenderProjectSubpackageInfo;
import com.els.modules.tender.project.enumerate.SubpackageEvaBidTypeEnum;
import com.els.modules.tender.project.enumerate.SubpackageInfoCheckTypeEnum;
import com.els.modules.tender.project.enumerate.TenderProjectSubpackageStatusEnum;
import com.els.modules.tender.project.service.PurchaseTenderProjectHeadService;
import com.els.modules.tender.project.service.PurchaseTenderProjectSubpackageInfoService;
import com.els.modules.tender.project.vo.PurchaseTenderProjectInfoVO;
import com.els.modules.tender.sale.entity.SaleTenderProjectBidWinningAffirmItem;
import com.els.modules.tender.sale.service.PurchaseTenderBidWinningServiceFeeHeadService;
import com.els.modules.tender.sale.service.SaleTenderProjectBidWinningAffirmItemService;
import com.els.modules.tender.supplier.service.TenderProjectSupplierService;
import com.els.modules.workflow.dto.AuditInputParamDTO;
import com.els.modules.workflow.dto.AuditOutputParamDTO;
import com.els.rpc.service.InvokeBaseRpcService;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;

@Service
public class BidWinningAffirmInformServiceImpl
extends BaseServiceImpl<BidWinningAffirmInfomMapper, BidWinningAffirmInform>
implements BidWinningAffirmInformService {
    @Resource
    private InvokeBaseRpcService invokeBaseRpcService;
    @Autowired
    private BidWinningAffirmHeadService bidWinningAffirmHeadService;
    @Autowired
    @Lazy
    private BidWinningAffirmItemService bidWinningAffirmItemService;
    @Autowired
    private SaleTenderProjectBidWinningAffirmItemService saleBidWinningAffirmItemService;
    @Autowired
    private PurchaseTenderProjectHeadService purchaseTenderProjectHeadService;
    @Autowired
    private PurchaseTenderBidWinningServiceFeeHeadService purchaseTenderBidWinningServiceFeeHeadService;
    @Resource
    @Lazy
    private PurchaseTenderProjectSubpackageInfoService subpackageInfoService;
    @Autowired
    @Lazy
    private PurchaseTenderProjectAttachmentHeadService attachmentHeadService;
    @Autowired
    @Lazy
    private SaleTenderQuoteMaterialService quoteMaterialService;
    @Autowired
    @Lazy
    private TenderProjectApprovalHeadService approvalHeadService;
    @Autowired
    @Lazy
    private PurchaseRequestItemService purchaseRequestItemService;
    @Autowired
    @Lazy
    private TenderProjectSupplierService tenderProjectSupplierService;
    @Resource
    private InquiryInvokeMainDataRpcService inquiryInvokeMainDataRpcService;
    @Resource
    private InquiryInvokeSupplierRpcService invokeSupplierRpcService;
    @Resource
    private RedisUtil redisUtil;

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void add(BidWinningAffirmInformVo purchaseTenderBidWinningAffirmInformVo) {
        BidWinningAffirmInform purchaseTenderBidWinningAffirmInform = new BidWinningAffirmInform();
        BeanUtils.copyProperties((Object)((Object)purchaseTenderBidWinningAffirmInformVo), (Object)((Object)purchaseTenderBidWinningAffirmInform));
        purchaseTenderBidWinningAffirmInform.setStatus(BidWinningAffirmInformEnum.NEW.getValue());
        ((BidWinningAffirmInfomMapper)this.baseMapper).insert((Object)purchaseTenderBidWinningAffirmInform);
        this.saveMain(purchaseTenderBidWinningAffirmInformVo, purchaseTenderBidWinningAffirmInform);
        List<BidWinningAffirmItemVo> bidWinningAffirmItemVoList = purchaseTenderBidWinningAffirmInformVo.getBidWinningAffirmItemVoList();
        ArrayList bidWinningAffirmList = SysUtil.copyProperties(bidWinningAffirmItemVoList, BidWinningAffirmPriceItemVo.class);
        this.tenderProjectSupplierService.updateWinnerAmount(purchaseTenderBidWinningAffirmInform.getSubpackageId(), bidWinningAffirmList);
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void edit(BidWinningAffirmInformVo purchaseTenderBidWinningAffirmInformVo) {
        BidWinningAffirmInform purchaseTenderBidWinningAffirmInform = new BidWinningAffirmInform();
        BeanUtils.copyProperties((Object)((Object)purchaseTenderBidWinningAffirmInformVo), (Object)((Object)purchaseTenderBidWinningAffirmInform));
        int count = ((BidWinningAffirmInfomMapper)this.baseMapper).updateById((Object)purchaseTenderBidWinningAffirmInform);
        Assert.isTrue((count != 0 ? 1 : 0) != 0, (String)I18nUtil.translate((String)"i18n_alert_APWFIKXWVVVXVSDJHrW_2fe92d52", (String)"\u5f53\u524d\u6570\u636e\u5df2\u5931\u6548\uff0c\u8bf7\u91cd\u65b0\u5237\u65b0\u540e\u63d0\u4ea4\u66f4\u6539\uff01"));
        this.saveMain(purchaseTenderBidWinningAffirmInformVo, purchaseTenderBidWinningAffirmInform);
        List<BidWinningAffirmItemVo> bidWinningAffirmItemVoList = purchaseTenderBidWinningAffirmInformVo.getBidWinningAffirmItemVoList();
        ArrayList bidWinningAffirmList = SysUtil.copyProperties(bidWinningAffirmItemVoList, BidWinningAffirmPriceItemVo.class);
        this.tenderProjectSupplierService.updateWinnerAmount(purchaseTenderBidWinningAffirmInform.getSubpackageId(), bidWinningAffirmList);
    }

    @Override
    public BidWinningAffirmInformVo queryBySubpackageId(String subpackageId) {
        List<BidWinningAffirmPriceItemVo> bidWinningAffirmItemList;
        BidWinningAffirmInformVo affirmInformVo = new BidWinningAffirmInformVo();
        List<BidWinningAffirmInform> bidWinningAffirmInformList = ((BidWinningAffirmInfomMapper)this.baseMapper).selectBySubpackageId(subpackageId);
        if (!bidWinningAffirmInformList.isEmpty()) {
            BeanUtils.copyProperties((Object)((Object)bidWinningAffirmInformList.get(0)), (Object)((Object)affirmInformVo));
        }
        TenderFlagInjectionContext.setTenderCheckType(SubpackageInfoCheckTypeEnum.POST_TRIAL.getValue());
        PurchaseTenderProjectSubpackageInfo subpackageInfo = (PurchaseTenderProjectSubpackageInfo)((Object)this.subpackageInfoService.getById((Serializable)((Object)subpackageId)));
        affirmInformVo.setEvaluationType(subpackageInfo.getEvaluationType());
        if (!SubpackageEvaBidTypeEnum.OFF_LINE.getValue().equals(subpackageInfo.getEvaluationType())) {
            PurchaseTenderBidLetterFormatGroupVO formatGroupVO = this.attachmentHeadService.queryBidLetterFormatGroup(subpackageId);
            String quoteType = formatGroupVO.getQuoteType();
            affirmInformVo.setQuoteType(quoteType);
        }
        if (CollectionUtil.isEmpty(bidWinningAffirmItemList = this.bidWinningAffirmHeadService.queryAffirmItemVoList(subpackageId, affirmInformVo.getQuoteType(), affirmInformVo.getEvaluationType()))) {
            return affirmInformVo;
        }
        List<BidWinningAffirmItemVo> bidWinningAffirmItemVoList = bidWinningAffirmItemList.stream().map(item -> {
            BidWinningAffirmItemVo itemVo = new BidWinningAffirmItemVo();
            BeanUtils.copyProperties((Object)item, (Object)((Object)itemVo));
            List PurchaseAttachmentDTOList = this.invokeBaseRpcService.selectPurchaseAttachmentByMainId(itemVo.getId());
            itemVo.setPurchaseAttachmentDemandDTOList(PurchaseAttachmentDTOList);
            return itemVo;
        }).collect(Collectors.toList());
        affirmInformVo.setBidWinningAffirmItemVoList(bidWinningAffirmItemVoList);
        return affirmInformVo;
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void publish(BidWinningAffirmInformVo affirmInformVo) {
        TenderProjectApprovalHead approvalHead;
        if (StrUtil.isNotBlank((CharSequence)affirmInformVo.getId())) {
            this.edit(affirmInformVo);
        } else {
            this.add(affirmInformVo);
        }
        BidWinningAffirmInformVo purchaseTenderBidWinningAffirmInformVo = this.queryBySubpackageId(affirmInformVo.getSubpackageId());
        this.checkParam(purchaseTenderBidWinningAffirmInformVo);
        List<BidWinningAffirmItemVo> bidWinningAffirmItemVoList = purchaseTenderBidWinningAffirmInformVo.getBidWinningAffirmItemVoList();
        ArrayList winningAffirmItems = SysUtil.copyProperties(bidWinningAffirmItemVoList, BidWinningAffirmItem.class);
        this.saveSaleBidWinningAffirmItem(purchaseTenderBidWinningAffirmInformVo.getSubpackageId(), winningAffirmItems);
        ArrayList<PurchaseAttachmentDTO> purchaseAttachmentDTOArray = new ArrayList<PurchaseAttachmentDTO>();
        for (BidWinningAffirmItemVo bidWinningAffirmItemVo : bidWinningAffirmItemVoList) {
            if (!CollectionUtil.isNotEmpty(bidWinningAffirmItemVo.getPurchaseAttachmentDemandDTOList())) continue;
            purchaseAttachmentDTOArray.addAll(bidWinningAffirmItemVo.getPurchaseAttachmentDemandDTOList());
        }
        ArchiveUtil.saveArchiveByPurchaseAttachmentDTO(purchaseAttachmentDTOArray, affirmInformVo.getId(), affirmInformVo.getSubpackageId(), affirmInformVo.getTenderProjectId(), TenderProjectArchiveAttachmentEnum.TENDER_WINNING_AFFIRM_INFORM_PREFIX.getValue());
        BidWinningAffirmInform bidWinningAffirmInform = (BidWinningAffirmInform)((Object)SysUtil.copyProperties((Object)((Object)purchaseTenderBidWinningAffirmInformVo), BidWinningAffirmInform.class));
        bidWinningAffirmInform.setStatus(BidWinningAffirmInformEnum.ISSUE.getValue());
        this.updateById((Object)bidWinningAffirmInform);
        this.updateTenderProjectSubpackageInfo(bidWinningAffirmInform, "" + TenderProjectSubpackageStatusEnum.BID_WINNING_AFFIRM_INFORM_FINISH.getValue());
        this.purchaseTenderBidWinningServiceFeeHeadService.saveMain(winningAffirmItems);
        PurchaseTenderProjectInfoVO purchaseTenderProjectInfoVO = this.purchaseTenderProjectHeadService.queryProjectInfoBySubpackageId(affirmInformVo.getSubpackageId());
        List<SaleTenderQuoteMaterial> quoteMaterialList = this.getWinningMaterial(affirmInformVo.getSubpackageId());
        if (CollectionUtil.isNotEmpty(quoteMaterialList) && (approvalHead = (TenderProjectApprovalHead)((Object)this.approvalHeadService.getById((Serializable)((Object)purchaseTenderProjectInfoVO.getProjectId())))) != null && TenderProjectApprovalStateEnum.ISSUE.getValue().equals(approvalHead.getSourceStatus())) {
            this.goBackDemand(quoteMaterialList, PurchaseRequestStatusItemEnum.TENDER_COMPLETED.getValue());
        }
        StringBuilder urlParams = new StringBuilder("tenderProjectId=").append(bidWinningAffirmInform.getTenderProjectId()).append("&subpackageId=").append(bidWinningAffirmInform.getSubpackageId()).append("&businessId=").append(bidWinningAffirmInform.getId());
        List toElsAccountList = bidWinningAffirmItemVoList.stream().map(BidWinningAffirmItem::getSupplierAccount).collect(Collectors.toList());
        String idStr = IdWorker.getIdStr();
        JSONObject jsonObject = JSONObject.parseObject((String)JSONObject.toJSONString((Object)purchaseTenderProjectInfoVO));
        jsonObject.put("urlParams", (Object)urlParams);
        this.redisUtil.set("sys:message:" + idStr, (Object)jsonObject, 172800L);
        super.sendMessage(TenantContext.getTenant(), "tender", "tenderBidWinningAffirmInfo", idStr, "tenderBusDataServiceImpl", toElsAccountList);
    }

    private List<SaleTenderQuoteMaterial> getWinningMaterial(String subpackageId) {
        BidWinningAffirmHead bidWinningAffirmHead = new BidWinningAffirmHead();
        bidWinningAffirmHead.setSubpackageId(subpackageId);
        bidWinningAffirmHead.setAffirmType("0");
        BidWinningAffirmHeadVO headVO = this.bidWinningAffirmHeadService.queryBidWinningConfirmInitInfoBySubpackageId(bidWinningAffirmHead, "0");
        List<PurchaseBidWinningAffirmMaterial> winningAffirmMaterialList = headVO.getWinningAffirmMaterialList();
        if (CollectionUtil.isEmpty(winningAffirmMaterialList)) {
            return null;
        }
        List<String> saleTenderPriceOpeningIdList = winningAffirmMaterialList.stream().map(PurchaseBidWinningAffirmMaterial::getPriceOpeningsId).collect(Collectors.toList());
        return this.quoteMaterialService.selectByMainIds(saleTenderPriceOpeningIdList, null);
    }

    @Override
    public void createPriceInfo(String subpackageId) {
        List<SaleTenderQuoteMaterial> quoteMaterialList = this.getWinningMaterial(subpackageId).stream().filter(item -> "1".equals(item.getAward())).collect(Collectors.toList());
        if (CollectionUtil.isNotEmpty(quoteMaterialList)) {
            List<String> materialNumberList = quoteMaterialList.stream().map(SaleTenderQuoteMaterial::getMaterialNumber).collect(Collectors.toList());
            List<PurchaseMaterialHeadDTO> purchaseMaterialHeadDTOList = this.inquiryInvokeMainDataRpcService.selectByMaterialNumberList(materialNumberList);
            Map<String, List<PurchaseMaterialHeadDTO>> purchaseMaterialHeadDTOListMap = purchaseMaterialHeadDTOList.stream().collect(Collectors.groupingBy(PurchaseMaterialHeadDTO::getMaterialNumber));
            ArrayList<String> noMaterialNameList = new ArrayList<String>();
            for (SaleTenderQuoteMaterial item2 : quoteMaterialList) {
                List<PurchaseMaterialHeadDTO> materialHeadDTOList = purchaseMaterialHeadDTOListMap.get(item2.getMaterialNumber());
                if (!CollectionUtil.isEmpty(materialHeadDTOList)) continue;
                noMaterialNameList.add(item2.getMaterialName());
            }
            Assert.isTrue((boolean)CollectionUtil.isEmpty(noMaterialNameList), (String)I18nUtil.translate((String)"i18n_alert_bLumdWFlTjSLAoWVnRBFLxVSLWWWWWjAoW_94388ee2", (String)"\u751f\u6210\u4ef7\u683c\u4e3b\u6570\u636e\u5fc5\u987b\u6709\u7269\u6599\u7f16\u7801\uff0c\u8bf7\u91c7\u8d2d\u8d1f\u8d23\u4eba\u8865\u5145\u7269\u6599\u3010{0}\u3011\u7684\u7f16\u7801\u3002", (String[])new String[]{StrUtil.join((CharSequence)",", noMaterialNameList)}));
            PurchaseTenderProjectSubpackageInfo subpackageInfo = (PurchaseTenderProjectSubpackageInfo)((Object)this.subpackageInfoService.getById((Serializable)((Object)subpackageId)));
            PurchaseTenderProjectHead projectHead = (PurchaseTenderProjectHead)((Object)this.purchaseTenderProjectHeadService.getById((Serializable)((Object)subpackageInfo.getHeadId())));
            this.createPriceInfo(projectHead, subpackageInfo, quoteMaterialList);
            this.goBackDemand(quoteMaterialList, PurchaseRequestStatusItemEnum.TENDER_COMPLETED.getValue());
        }
    }

    private void goBackDemand(List<SaleTenderQuoteMaterial> quoteMaterialList, String status) {
        ArrayList<PurchaseRequestItem> batchUpdatePurchaseRequestItemList = new ArrayList<PurchaseRequestItem>();
        for (SaleTenderQuoteMaterial item : quoteMaterialList) {
            String[] split;
            if (!StrUtil.isNotBlank((CharSequence)item.getSourceItemId()) || !SourceTypeEnum.REQUEST.getValue().equals(item.getSourceType())) continue;
            for (String id : split = item.getSourceItemId().split(",")) {
                PurchaseRequestItem requestItem = new PurchaseRequestItem();
                requestItem.setMaterialNumber(item.getMaterialNumber());
                requestItem.setMaterialId(item.getMaterialId());
                requestItem.setMaterialName(item.getMaterialName());
                requestItem.setMaterialDesc(item.getMaterialDesc());
                requestItem.setMaterialSpec(item.getMaterialSpec());
                requestItem.setBrand(item.getBrand());
                requestItem.setMaterialGroup(item.getMaterialGroup());
                requestItem.setCateCode(item.getCateCode());
                requestItem.setCateName(item.getCateName());
                requestItem.setId(id);
                requestItem.setItemStatus(status);
                batchUpdatePurchaseRequestItemList.add(requestItem);
            }
        }
        if (CollectionUtil.isNotEmpty(batchUpdatePurchaseRequestItemList)) {
            this.purchaseRequestItemService.updateBatchById(batchUpdatePurchaseRequestItemList, 2000);
        }
    }

    private void createPriceInfo(PurchaseTenderProjectHead projectHead, PurchaseTenderProjectSubpackageInfo subpackageInfo, List<SaleTenderQuoteMaterial> quoteMaterialList) {
        List<String> supplierAccount = quoteMaterialList.stream().map(SaleTenderQuoteMaterial::getSupplierAccount).collect(Collectors.toList());
        List<SupplierMasterDataDTO> supplerList = this.invokeSupplierRpcService.selectSupplerList(TenantContext.getTenant(), supplierAccount);
        Map masterDataDTOMap = supplerList.stream().collect(Collectors.toMap(SupplierMasterDataDTO::getToElsAccount, Function.identity(), (o1, o2) -> o1));
        ArrayList<PurchaseInformationRecordsDTO> recordsList = new ArrayList<PurchaseInformationRecordsDTO>();
        for (SaleTenderQuoteMaterial item : quoteMaterialList) {
            PurchaseInformationRecordsDTO records = new PurchaseInformationRecordsDTO();
            BeanUtils.copyProperties((Object)((Object)item), (Object)records);
            records.setElsAccount(TenantContext.getTenant());
            records.setToElsAccount(item.getElsAccount());
            SupplierMasterDataDTO supplierMasterDataDTO = (SupplierMasterDataDTO)masterDataDTOMap.get(item.getElsAccount());
            if (supplierMasterDataDTO != null) {
                records.setSupplierCode(supplierMasterDataDTO.getSupplierCode());
            }
            records.setMaterialId(item.getActualMaterialId());
            records.setSourceType(PriceSourceTypeEnum.BIDDING.getValue());
            records.setSourceNumber(subpackageInfo.getSubpackageNumber());
            records.setPurchaseUnit(item.getPurchaseUnit());
            records.setSourceItemNumber((String)(StrUtil.isNotBlank((CharSequence)item.getItemNumber()) ? item.getElsAccount() + "_" + item.getItemNumber() : item.getId()));
            records.setAuditStatus(AuditStatusEnum.AUDIT_FINISH.getValue());
            records.setPriceType(PurchaseInformationPriceTypeEnum.MATERIAL.getValue());
            records.setCompany(projectHead.getCompany());
            records.setPurchaseOrg(projectHead.getPurchaseOrg());
            records.setPurchaseGroup(projectHead.getPurchaseGroup());
            records.setCurrencyCode(item.getCurrency());
            records.setRecordType(PriceRecordTypeEnum.STANDARD.getValue());
            try {
                this.inquiryInvokeMainDataRpcService.checkPriceIfExistByBidding(records);
            }
            catch (ELSBootException exception) {
                this.log.error("\u4ef7\u683c\u4e3b\u6570\u636e\u5df2\u5b58\u5728\u66f4\u6539\u4e3a\u4f5c\u5e9f\u72b6\u6001\uff0c\u5206\u5305\u5355\u53f7\u4e3a\uff1a" + subpackageInfo.getSubpackageNumber() + " Id\u53f7\u4e3a\uff1a" + item.getId());
                this.inquiryInvokeMainDataRpcService.cancelPurchaseInformationBySourceNumber(PriceSourceTypeEnum.BIDDING.getValue(), subpackageInfo.getSubpackageNumber(), Arrays.asList(item.getId()));
            }
            recordsList.add(records);
        }
        if (CollectionUtil.isNotEmpty(recordsList)) {
            this.inquiryInvokeMainDataRpcService.cutOffPriceDates(recordsList);
            this.inquiryInvokeMainDataRpcService.addBatch(recordsList);
        }
    }

    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void publishSucceed(String id) {
        BidWinningAffirmInform bidWinningAffirmInform = (BidWinningAffirmInform)((Object)((BidWinningAffirmInfomMapper)this.baseMapper).selectById((Serializable)((Object)id)));
        BidWinningAffirmHeadVO bidWinningAffirmHeadVO = this.bidWinningAffirmHeadService.queryBidWinningAffirmBySubpackageId(bidWinningAffirmInform.getSubpackageId());
        List<BidWinningAffirmPriceItemVo> bidWinningAffirmPriceItemVoList = bidWinningAffirmHeadVO.getBidWinningAffirmPriceItemVoList();
        ArrayList bidWinningAffirmItems = SysUtil.copyProperties(bidWinningAffirmPriceItemVoList, BidWinningAffirmItem.class);
        this.saveSaleBidWinningAffirmItem(bidWinningAffirmInform.getSubpackageId(), bidWinningAffirmItems);
        this.purchaseTenderBidWinningServiceFeeHeadService.saveMain(bidWinningAffirmItems);
    }

    private void saveSaleBidWinningAffirmItem(String subpackageId, List<BidWinningAffirmItem> itemList) {
        List saleItemList = itemList.stream().map(item -> {
            SaleTenderProjectBidWinningAffirmItem saleTenderProjectBidWinningAffirmItem = new SaleTenderProjectBidWinningAffirmItem();
            BeanUtils.copyProperties((Object)item, (Object)((Object)saleTenderProjectBidWinningAffirmItem));
            saleTenderProjectBidWinningAffirmItem.setElsAccount(saleTenderProjectBidWinningAffirmItem.getSupplierAccount());
            return saleTenderProjectBidWinningAffirmItem;
        }).collect(Collectors.toList());
        this.saleBidWinningAffirmItemService.deleteBySubpackageId(subpackageId);
        this.saleBidWinningAffirmItemService.saveBatch(saleItemList);
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void updateAuditStatus(AuditInputParamDTO inputParamVO, AuditOutputParamDTO outputParamVO) {
        BidWinningAffirmInform purchaseTenderBidWinningAffirmInform = (BidWinningAffirmInform)((Object)this.getById((Serializable)((Object)inputParamVO.getBusinessId())));
        purchaseTenderBidWinningAffirmInform.setFlowId(outputParamVO.getProcessRootId());
        purchaseTenderBidWinningAffirmInform.setWorkFlowType(outputParamVO.getBpmnType());
        String auditStatus = outputParamVO.getAuditStatus();
        String subPackageStatus = null;
        String status = null;
        if (AuditStatusEnum.AUDIT_FINISH.getValue().equals(auditStatus)) {
            subPackageStatus = "" + TenderProjectSubpackageStatusEnum.BID_WINNING_AFFIRM_INFORM_FINISH.getValue();
            status = BidWinningAffirmInformEnum.ISSUE.getValue();
            this.publishSucceed(inputParamVO.getBusinessId());
        } else if (AuditStatusEnum.AUDIT_REJECT.getValue().equals(auditStatus)) {
            subPackageStatus = "" + TenderProjectSubpackageStatusEnum.BID_WINNING_AFFIRM_INFORM_REJECT.getValue();
            status = BidWinningAffirmInformEnum.NEW.getValue();
        } else if (AuditStatusEnum.AUDIT_NEW.getValue().equals(auditStatus)) {
            subPackageStatus = "" + TenderProjectSubpackageStatusEnum.BID_WINNING_AFFIRM_INFORM_EDIT.getValue();
            status = BidWinningAffirmInformEnum.NEW.getValue();
        } else {
            subPackageStatus = "" + TenderProjectSubpackageStatusEnum.BID_WINNING_AFFIRM_INFORM_AUDIT.getValue();
            status = BidWinningAffirmInformEnum.NOT_ISSUE.getValue();
        }
        purchaseTenderBidWinningAffirmInform.setAuditStatus(auditStatus);
        purchaseTenderBidWinningAffirmInform.setStatus(status);
        ((BidWinningAffirmInfomMapper)this.baseMapper).updateById((Object)purchaseTenderBidWinningAffirmInform);
        this.updateTenderProjectSubpackageInfo(purchaseTenderBidWinningAffirmInform, subPackageStatus);
    }

    @Override
    public BidWinningAffirmItemVo queryByBidWinningAffirmItemId(String bidWinningAffirmItemId) {
        BidWinningAffirmItem bidWinningAffirmItem = (BidWinningAffirmItem)((Object)this.bidWinningAffirmItemService.getById((Serializable)((Object)bidWinningAffirmItemId)));
        if (bidWinningAffirmItem == null) {
            return null;
        }
        BidWinningAffirmItemVo bidWinningAffirmItemVo = (BidWinningAffirmItemVo)((Object)SysUtil.copyProperties((Object)((Object)bidWinningAffirmItem), BidWinningAffirmItemVo.class));
        List PurchaseAttachmentDTOList = this.invokeBaseRpcService.selectPurchaseAttachmentByMainId(bidWinningAffirmItem.getId());
        bidWinningAffirmItemVo.setPurchaseAttachmentDemandDTOList(PurchaseAttachmentDTOList);
        return bidWinningAffirmItemVo;
    }

    @Override
    public BidWinningAffirmItem editBidWinningAffirmItem(BidWinningAffirmItem bidWinningAffirmItem) {
        LambdaUpdateWrapper updateWrapper = Wrappers.lambdaUpdate();
        ((LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)updateWrapper.set(BidWinningAffirmItem::getTemplateLibraryId, (Object)bidWinningAffirmItem.getTemplateLibraryId())).set(BidWinningAffirmItem::getTemplateTitle, (Object)bidWinningAffirmItem.getTemplateTitle())).set(BidWinningAffirmItem::getNoticeContent, (Object)bidWinningAffirmItem.getNoticeContent())).eq(BaseEntity::getId, (Object)bidWinningAffirmItem.getId());
        this.bidWinningAffirmItemService.update((Wrapper)updateWrapper);
        return bidWinningAffirmItem;
    }

    private void updateTenderProjectSubpackageInfo(BidWinningAffirmInform purchaseTenderBidWinningAffirmInform, String subPackageStatus) {
        TenderWriteBackSubpackageInfoEventDTO eventDTO = TenderWriteBackSubpackageInfoEventDTO.builder().event((Object)purchaseTenderBidWinningAffirmInform).subpackageId(purchaseTenderBidWinningAffirmInform.getSubpackageId()).subpackageStatus(subPackageStatus).build();
        PushEventUtils.updateSubpackageInfo(eventDTO);
    }

    @Override
    public BidWinningAffirmInform queryById(String id) {
        return (BidWinningAffirmInform)((Object)((BidWinningAffirmInfomMapper)this.baseMapper).selectById((Serializable)((Object)id)));
    }

    private void checkParam(BidWinningAffirmInformVo purchaseTenderBidWinningAffirmInformVo) {
        Assert.hasText((String)purchaseTenderBidWinningAffirmInformVo.getSubpackageId(), (String)I18nUtil.translate((String)"i18n_alert_zsAyxOLVW_ba7b51", (String)"\u5206\u5305\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a\uff01"));
        List<BidWinningAffirmItemVo> winningAffirmItemVoList = purchaseTenderBidWinningAffirmInformVo.getBidWinningAffirmItemVoList();
        Assert.isTrue((boolean)CollectionUtil.isNotEmpty(winningAffirmItemVoList), (String)I18nUtil.translate((String)"i18n_alert_sBeRLxOLVW_99104ebc", (String)"\u4e2d\u6807\u901a\u77e5\u4eba\u4e0d\u80fd\u4e3a\u7a7a\uff01"));
        winningAffirmItemVoList.forEach(itemVo -> {
            List<PurchaseAttachmentDTO> PurchaseAttachmentDTOList = itemVo.getPurchaseAttachmentDemandDTOList();
            Assert.isTrue((boolean)CollectionUtil.isNotEmpty(PurchaseAttachmentDTOList), (String)I18nUtil.translate((String)"i18n_alert_sBeRLBIxOLVW_540b760a", (String)"\u4e2d\u6807\u901a\u77e5\u4eba\u9644\u4ef6\u4e0d\u80fd\u4e3a\u7a7a\uff01"));
        });
    }

    private void saveMain(BidWinningAffirmInformVo purchaseTenderBidWinningAffirmInformVo, BidWinningAffirmInform purchaseTenderBidWinningAffirmInform) {
        List<BidWinningAffirmItemVo> bidWinningAffirmItemVoList = purchaseTenderBidWinningAffirmInformVo.getBidWinningAffirmItemVoList();
        ArrayList PurchaseAttachmentDTOList = new ArrayList();
        ArrayList headIds = new ArrayList();
        bidWinningAffirmItemVoList.stream().forEach(item -> {
            List<PurchaseAttachmentDTO> PurchaseAttachmentDTOArray = item.getPurchaseAttachmentDemandDTOList();
            headIds.add(item.getId());
            PurchaseAttachmentDTOArray.parallelStream().forEach(attachment -> attachment.setHeadId(item.getId()));
            PurchaseAttachmentDTOList.addAll(PurchaseAttachmentDTOArray);
        });
        this.invokeBaseRpcService.deletePurchaseAttachmentByMainIds(headIds);
        if (!PurchaseAttachmentDTOList.isEmpty()) {
            this.invokeBaseRpcService.insertPurchaseAttachmentBatchSomeColumn(PurchaseAttachmentDTOList);
        }
        this.updateTenderProjectSubpackageInfo(purchaseTenderBidWinningAffirmInform, "" + TenderProjectSubpackageStatusEnum.BID_WINNING_AFFIRM_INFORM_EDIT.getValue());
    }
}

