/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.tender.calibration.service.impl;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.els.common.aspect.annotation.SrmTransaction;
import com.els.common.enumerate.AuditStatusEnum;
import com.els.common.system.base.entity.BaseEntity;
import com.els.common.system.base.service.impl.BaseServiceImpl;
import com.els.common.util.I18nUtil;
import com.els.common.util.SpringContextUtils;
import com.els.common.util.SysUtil;
import com.els.modules.inquiry.api.enumerate.SourceTypeEnum;
import com.els.modules.inquiry.rpc.service.InquiryInvokeMessageRpcService;
import com.els.modules.inquiry.rpc.service.InquiryInvokeWorkFlowRpcService;
import com.els.modules.notice.api.dto.PurchaseNoticeDTO;
import com.els.modules.tender.attachment.service.PurchaseTenderProjectAttachmentHeadService;
import com.els.modules.tender.attachment.vo.PurchaseTenderBidLetterFormatGroupVO;
import com.els.modules.tender.calibration.entity.BidWinningAffirmItem;
import com.els.modules.tender.calibration.entity.BidWinningAffirmNotice;
import com.els.modules.tender.calibration.enumerate.BidWinningAffirmNoticeEnum;
import com.els.modules.tender.calibration.mapper.BidWinningAffirmNoticeMapper;
import com.els.modules.tender.calibration.service.BidWinningAffirmHeadService;
import com.els.modules.tender.calibration.service.BidWinningAffirmNoticeService;
import com.els.modules.tender.calibration.vo.BidWinningAffirmHeadVO;
import com.els.modules.tender.calibration.vo.BidWinningAffirmNoticeVo;
import com.els.modules.tender.calibration.vo.BidWinningAffirmPriceItemVo;
import com.els.modules.tender.common.event.TenderWriteBackSubpackageInfoEventDTO;
import com.els.modules.tender.common.interceptor.TenderFlagInjectionContext;
import com.els.modules.tender.common.utils.PushEventUtils;
import com.els.modules.tender.common.utils.TenderAuditSubjectUtils;
import com.els.modules.tender.common.vo.GenerateTemplateVO;
import com.els.modules.tender.common.vo.ParseTemplateParamVO;
import com.els.modules.tender.notice.enumerate.PurchaseSysNoticeStatusEnum;
import com.els.modules.tender.notice.enumerate.PurchaseSysNoticeTypeEnum;
import com.els.modules.tender.project.entity.PurchaseTenderProjectSubpackageInfo;
import com.els.modules.tender.project.enumerate.SubpackageEvaBidTypeEnum;
import com.els.modules.tender.project.enumerate.SubpackageInfoCheckTypeEnum;
import com.els.modules.tender.project.enumerate.TenderProjectSubpackageStatusEnum;
import com.els.modules.tender.project.service.PurchaseTenderProjectHeadService;
import com.els.modules.tender.project.service.PurchaseTenderProjectSubpackageInfoService;
import com.els.modules.tender.project.vo.PurchaseTenderProjectInfoVO;
import com.els.modules.tender.supplier.service.TenderProjectSupplierService;
import com.els.modules.tender.template.service.PurchaseTenderTemplateLibraryService;
import com.els.modules.workflow.dto.AuditInputParamDTO;
import com.els.modules.workflow.dto.AuditOutputParamDTO;
import com.els.rpc.service.InvokeBaseRpcService;
import java.io.Serializable;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;

@Service
public class BidWinningAffirmNoticeServiceImpl
extends BaseServiceImpl<BidWinningAffirmNoticeMapper, BidWinningAffirmNotice>
implements BidWinningAffirmNoticeService {
    @Autowired
    private BidWinningAffirmHeadService bidWinningAffirmService;
    @Resource
    private InquiryInvokeWorkFlowRpcService inquiryInvokeWorkFlowRpcService;
    @Resource
    private InquiryInvokeMessageRpcService inquiryInvokeMessageRpcService;
    @Resource
    private InvokeBaseRpcService invokeBaseRpcService;
    @Resource
    @Lazy
    private PurchaseTenderProjectSubpackageInfoService subpackageInfoService;
    @Autowired
    @Lazy
    private PurchaseTenderProjectAttachmentHeadService attachmentHeadService;
    @Autowired
    @Lazy
    private PurchaseTenderTemplateLibraryService purchaseTenderTemplateLibraryService;
    @Autowired
    @Lazy
    private TenderProjectSupplierService tenderProjectSupplierService;
    @Autowired
    @Lazy
    private PurchaseTenderProjectHeadService projectHeadService;

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void add(BidWinningAffirmNoticeVo bidWinningAffirmNoticeVo) {
        BidWinningAffirmNotice bidWinningAffirmNotice = (BidWinningAffirmNotice)((Object)SysUtil.copyProperties((Object)((Object)bidWinningAffirmNoticeVo), BidWinningAffirmNotice.class));
        bidWinningAffirmNotice.setAffirmNoticeNumber(this.invokeBaseRpcService.getNextCode("tenderAffirmNoticeNumber", (Object)bidWinningAffirmNotice));
        ((BidWinningAffirmNoticeMapper)this.baseMapper).insert((Object)bidWinningAffirmNotice);
        bidWinningAffirmNoticeVo.setId(bidWinningAffirmNotice.getId());
        bidWinningAffirmNoticeVo.setAffirmNoticeNumber(bidWinningAffirmNotice.getAffirmNoticeNumber());
        List<BidWinningAffirmPriceItemVo> bidWinningAffirmList = bidWinningAffirmNoticeVo.getBidWinningAffirmList();
        this.tenderProjectSupplierService.updateWinnerAmount(bidWinningAffirmNotice.getSubpackageId(), bidWinningAffirmList);
        this.updateTenderProjectSubpackageInfo(bidWinningAffirmNotice, "" + TenderProjectSubpackageStatusEnum.BID_NOTICE_PUBLICITY_EDIT.getValue());
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void edit(BidWinningAffirmNoticeVo bidWinningAffirmNoticeVo) {
        BidWinningAffirmNotice bidWinningAffirmNotice = (BidWinningAffirmNotice)((Object)SysUtil.copyProperties((Object)((Object)bidWinningAffirmNoticeVo), BidWinningAffirmNotice.class));
        int count = ((BidWinningAffirmNoticeMapper)this.baseMapper).updateById((Object)bidWinningAffirmNotice);
        Assert.isTrue((count != 0 ? 1 : 0) != 0, (String)I18nUtil.translate((String)"i18n_alert_APWFIKXWVVVXVSDJHrW_2fe92d52", (String)"\u5f53\u524d\u6570\u636e\u5df2\u5931\u6548\uff0c\u8bf7\u91cd\u65b0\u5237\u65b0\u540e\u63d0\u4ea4\u66f4\u6539\uff01"));
        List<BidWinningAffirmPriceItemVo> bidWinningAffirmList = bidWinningAffirmNoticeVo.getBidWinningAffirmList();
        this.tenderProjectSupplierService.updateWinnerAmount(bidWinningAffirmNotice.getSubpackageId(), bidWinningAffirmList);
        this.updateTenderProjectSubpackageInfo(bidWinningAffirmNotice, "" + TenderProjectSubpackageStatusEnum.BID_NOTICE_PUBLICITY_EDIT.getValue());
    }

    @Override
    public void delete(String id) {
        ((BidWinningAffirmNoticeMapper)this.baseMapper).deleteById((Serializable)((Object)id));
    }

    @Override
    public void deleteBatch(List<String> idList) {
        ((BidWinningAffirmNoticeMapper)this.baseMapper).deleteBatchIds(idList);
    }

    @Override
    public BidWinningAffirmNoticeVo queryBySubpackageId(String subpackageId) {
        BidWinningAffirmNoticeVo vo = new BidWinningAffirmNoticeVo();
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.eq(BidWinningAffirmNotice::getSubpackageId, (Object)subpackageId);
        List bidWinningAffirmNotice = this.list((Wrapper)queryWrapper);
        if (!bidWinningAffirmNotice.isEmpty()) {
            BeanUtils.copyProperties(bidWinningAffirmNotice.get(0), (Object)((Object)vo));
        }
        PurchaseTenderProjectSubpackageInfo subpackageInfo = (PurchaseTenderProjectSubpackageInfo)((Object)this.subpackageInfoService.getById((Serializable)((Object)subpackageId)));
        vo.setEvaluationType(subpackageInfo.getEvaluationType());
        TenderFlagInjectionContext.setTenderCheckType(SubpackageInfoCheckTypeEnum.POST_TRIAL.getValue());
        if (!SubpackageEvaBidTypeEnum.OFF_LINE.getValue().equals(subpackageInfo.getEvaluationType())) {
            PurchaseTenderBidLetterFormatGroupVO formatGroupVO = this.attachmentHeadService.queryBidLetterFormatGroup(subpackageId);
            String quoteType = formatGroupVO.getQuoteType();
            vo.setQuoteType(quoteType);
        }
        List<BidWinningAffirmPriceItemVo> winningAffirmPriceItemVos = this.bidWinningAffirmService.queryAffirmItemVoList(subpackageId, vo.getQuoteType(), vo.getEvaluationType());
        vo.setBidWinningAffirmList(winningAffirmPriceItemVos);
        return vo;
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void updateAuditStatus(AuditInputParamDTO inputParamVO, AuditOutputParamDTO outputParamVO) {
        BidWinningAffirmNotice bidWinningAffirmNotice = (BidWinningAffirmNotice)((Object)this.getById((Serializable)((Object)inputParamVO.getBusinessId())));
        bidWinningAffirmNotice.setAuditStatus(outputParamVO.getAuditStatus());
        bidWinningAffirmNotice.setFlowId(outputParamVO.getProcessRootId());
        bidWinningAffirmNotice.setWorkFlowType(outputParamVO.getBpmnType());
        String auditStatus = outputParamVO.getAuditStatus();
        String subPackageStatus = null;
        if (AuditStatusEnum.AUDIT_FINISH.getValue().equals(auditStatus)) {
            bidWinningAffirmNotice.setStatus(BidWinningAffirmNoticeEnum.ISSUE.getValue());
            subPackageStatus = "" + TenderProjectSubpackageStatusEnum.BID_NOTICE_PUBLICITY_FINISH.getValue();
        } else if (AuditStatusEnum.AUDIT_REJECT.getValue().equals(auditStatus)) {
            bidWinningAffirmNotice.setStatus(BidWinningAffirmNoticeEnum.NEW.getValue());
            subPackageStatus = "" + TenderProjectSubpackageStatusEnum.BID_NOTICE_PUBLICITY_REJECT.getValue();
        } else if (AuditStatusEnum.AUDIT_NEW.getValue().equals(auditStatus)) {
            bidWinningAffirmNotice.setStatus(BidWinningAffirmNoticeEnum.NEW.getValue());
            subPackageStatus = "" + TenderProjectSubpackageStatusEnum.BID_NOTICE_PUBLICITY_REJECT.getValue();
        } else {
            bidWinningAffirmNotice.setStatus(BidWinningAffirmNoticeEnum.NOT_ISSUE.getValue());
            subPackageStatus = "" + TenderProjectSubpackageStatusEnum.BID_NOTICE_PUBLICITY_AUDIT.getValue();
        }
        ((BidWinningAffirmNoticeMapper)this.baseMapper).updateById((Object)bidWinningAffirmNotice);
        this.updateTenderProjectSubpackageInfo(bidWinningAffirmNotice, subPackageStatus);
        if (AuditStatusEnum.AUDIT_FINISH.getValue().equals(auditStatus) && "1".equals(bidWinningAffirmNotice.getNotice())) {
            this.publishSysNotice(bidWinningAffirmNotice);
        }
    }

    private void updateTenderProjectSubpackageInfo(BidWinningAffirmNotice attachmentHead, String subPackageStatus) {
        TenderWriteBackSubpackageInfoEventDTO eventDTO = TenderWriteBackSubpackageInfoEventDTO.builder().event((Object)attachmentHead).subpackageId(attachmentHead.getSubpackageId()).subpackageStatus(subPackageStatus).build();
        PushEventUtils.updateSubpackageInfo(eventDTO);
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void publish(BidWinningAffirmNoticeVo winningAffirmNoticeVo) {
        BidWinningAffirmNotice bidWinningAffirmNotice = (BidWinningAffirmNotice)((Object)((BidWinningAffirmNoticeMapper)this.baseMapper).selectById((Serializable)((Object)winningAffirmNoticeVo.getId())));
        BidWinningAffirmNoticeVo noticeVo = this.queryBySubpackageId(bidWinningAffirmNotice.getSubpackageId());
        this.checkParam(noticeVo);
        if ("1".equals(bidWinningAffirmNotice.getAudited())) {
            PurchaseTenderProjectInfoVO purchaseTenderProjectInfoVO = this.projectHeadService.queryProjectInfoBySubpackageId(bidWinningAffirmNotice.getSubpackageId());
            String subject = TenderAuditSubjectUtils.getTenderAuditSubject("bidWinningAffirmNotice", "\u4e2d\u6807\u516c\u544a", purchaseTenderProjectInfoVO.getTenderProjectNumber(), null, purchaseTenderProjectInfoVO.getSubpackageName());
            AuditInputParamDTO dto = new AuditInputParamDTO();
            dto.setBusinessId(winningAffirmNoticeVo.getId());
            dto.setBusinessType("bidWinningAffirmNotice");
            dto.setAuditSubject(subject);
            dto.setParams(JSONObject.toJSONString((Object)((Object)bidWinningAffirmNotice)));
            this.inquiryInvokeWorkFlowRpcService.submit(dto);
        } else {
            bidWinningAffirmNotice.setStatus(BidWinningAffirmNoticeEnum.ISSUE.getValue());
            ((BidWinningAffirmNoticeMapper)this.baseMapper).updateById((Object)bidWinningAffirmNotice);
            this.updateTenderProjectSubpackageInfo(bidWinningAffirmNotice, "" + TenderProjectSubpackageStatusEnum.BID_NOTICE_PUBLICITY_FINISH.getValue());
            if ("1".equals(bidWinningAffirmNotice.getNotice())) {
                this.publishSysNotice(bidWinningAffirmNotice);
            }
        }
    }

    public void backFillWinner(String id) {
        BidWinningAffirmNotice bidWinningAffirmNotice = (BidWinningAffirmNotice)((Object)((BidWinningAffirmNoticeMapper)this.baseMapper).selectById((Serializable)((Object)id)));
        BidWinningAffirmHeadVO bidWinningAffirmHeadVO = this.bidWinningAffirmService.queryBidWinningAffirmBySubpackageId(bidWinningAffirmNotice.getSubpackageId());
        List<BidWinningAffirmPriceItemVo> winningAffirmPriceItemVos = bidWinningAffirmHeadVO.getBidWinningAffirmPriceItemVoList();
        List<String> supplierAccountList = winningAffirmPriceItemVos.stream().map(BidWinningAffirmItem::getSupplierAccount).collect(Collectors.toList());
        TenderProjectSupplierService projectSupplierService = (TenderProjectSupplierService)SpringContextUtils.getBean(TenderProjectSupplierService.class);
        projectSupplierService.updateWinnerById(supplierAccountList, bidWinningAffirmNotice.getSubpackageId());
    }

    @Override
    public void publishSysNotice(BidWinningAffirmNotice bidWinningAffirmNotice) {
        PurchaseNoticeDTO notice = new PurchaseNoticeDTO();
        notice.setBusAccount(bidWinningAffirmNotice.getElsAccount());
        notice.setBusinessType(SourceTypeEnum.TENDER_WINBULLETIN.getValue());
        notice.setBusinessId(bidWinningAffirmNotice.getSubpackageId());
        notice.setTemplateNumber(bidWinningAffirmNotice.getTemplateNumber());
        notice.setTemplateVersion(bidWinningAffirmNotice.getTemplateVersion());
        notice.setTemplateAccount(bidWinningAffirmNotice.getTemplateAccount());
        notice.setNoticeTitle(bidWinningAffirmNotice.getNoticeTitle());
        notice.setNoticeContent(bidWinningAffirmNotice.getNoticeContent());
        notice.setNoticeType(PurchaseSysNoticeTypeEnum.CONVENTION_NOTICE.getValue());
        notice.setNoticeStatus(PurchaseSysNoticeStatusEnum.ISSUE.getValue());
        notice.setNoticeScope(bidWinningAffirmNotice.getNoticeRange());
        notice.setTop("1");
        Date newDate = new Date();
        notice.setEffectiveTime(bidWinningAffirmNotice.getNoticeStartTime());
        notice.setPublishTime(newDate);
        Date expiryTime = bidWinningAffirmNotice.getNoticeEndTime();
        notice.setExpiryTime(expiryTime);
        List emptyList = Collections.EMPTY_LIST;
        notice.setElsAccount(bidWinningAffirmNotice.getElsAccount());
        this.inquiryInvokeMessageRpcService.publish(notice, emptyList, emptyList);
    }

    @Override
    public BidWinningAffirmNotice queryById(String id) {
        return (BidWinningAffirmNotice)((Object)((BidWinningAffirmNoticeMapper)this.baseMapper).selectById((Serializable)((Object)id)));
    }

    public void checkParam(BidWinningAffirmNoticeVo winningAffirmNoticeVo) {
        List<BidWinningAffirmPriceItemVo> bidWinningAffirmList = winningAffirmNoticeVo.getBidWinningAffirmList();
        Assert.isTrue((boolean)CollectionUtils.isNotEmpty(bidWinningAffirmList), (String)I18nUtil.translate((String)"i18n_alert_YBLWFxOLVW_35ac4165", (String)"\u62db\u6807\u4eba\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a!"));
        Assert.hasText((String)winningAffirmNoticeVo.getSubpackageId(), (String)I18nUtil.translate((String)"i18n_alert_zsAyxOLVW_b97c71", (String)"\u5206\u5305\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a!"));
        Assert.hasText((String)winningAffirmNoticeVo.getNotice(), (String)I18nUtil.translate((String)"i18n_alert_KQRKW_c7747d5c", (String)"\u662f\u5426\u516c\u544a!"));
        if ("1".equals(winningAffirmNoticeVo.getNotice())) {
            Assert.isTrue((null != winningAffirmNoticeVo.getNoticeEndTime() ? 1 : 0) != 0, (String)I18nUtil.translate((String)"i18n_alert_RxyWKIxOLVW_d2cb09", (String)"\u516c\u544a\u7ed3\u675f\u65f6\u95f4\u4e0d\u80fd\u4e3a\u7a7a!"));
            Assert.hasText((String)winningAffirmNoticeVo.getNoticeTitle(), (String)I18nUtil.translate((String)"i18n_alert_RKBDxOLVW_114c4232", (String)"\u516c\u544a\u6807\u9898\u4e0d\u80fd\u4e3a\u7a7a!"));
            Assert.hasText((String)winningAffirmNoticeVo.getNoticeRange(), (String)I18nUtil.translate((String)"i18n_alert_RKvLxOLVW_83180b52", (String)"\u516c\u544a\u8303\u56f4\u4e0d\u80fd\u4e3a\u7a7a!"));
            Assert.hasText((String)winningAffirmNoticeVo.getNoticeContent(), (String)I18nUtil.translate((String)"i18n_alert_RKCcxOLVW_8bfc9eaf", (String)"\u516c\u544a\u5185\u5bb9\u4e0d\u80fd\u4e3a\u7a7a!"));
        }
    }

    @Override
    public BidWinningAffirmNoticeVo selectBySubpackageId(String subpackageId) {
        BidWinningAffirmNoticeVo vo = new BidWinningAffirmNoticeVo();
        List<BidWinningAffirmNotice> affirmNoticeList = ((BidWinningAffirmNoticeMapper)this.baseMapper).selectBySubpackageId(subpackageId);
        if (CollectionUtil.isEmpty(affirmNoticeList)) {
            return null;
        }
        if (TenderFlagInjectionContext.getTenderCheckType() == null) {
            TenderFlagInjectionContext.setTenderCheckType(SubpackageInfoCheckTypeEnum.POST_TRIAL.getValue());
        }
        BidWinningAffirmNotice purchaseTenderProjectBidWinningAffirmNotice = affirmNoticeList.get(0);
        BeanUtils.copyProperties((Object)((Object)purchaseTenderProjectBidWinningAffirmNotice), (Object)((Object)vo));
        PurchaseTenderProjectSubpackageInfo subpackageInfo = (PurchaseTenderProjectSubpackageInfo)((Object)this.subpackageInfoService.getById((Serializable)((Object)subpackageId)));
        vo.setEvaluationType(subpackageInfo.getEvaluationType());
        List<BidWinningAffirmPriceItemVo> winningAffirmItemList = this.bidWinningAffirmService.queryAffirmItemVoList(subpackageId, null, vo.getEvaluationType());
        vo.setBidWinningAffirmList(winningAffirmItemList);
        return vo;
    }

    @Override
    public BidWinningAffirmNoticeVo queryInfoById(String id) {
        BidWinningAffirmNoticeVo bidWinningAffirmNoticeVo = new BidWinningAffirmNoticeVo();
        BidWinningAffirmNotice bidWinningAffirmNotice = (BidWinningAffirmNotice)((Object)((BidWinningAffirmNoticeMapper)this.baseMapper).selectById((Serializable)((Object)id)));
        if (bidWinningAffirmNotice == null) {
            return bidWinningAffirmNoticeVo;
        }
        BeanUtils.copyProperties((Object)((Object)bidWinningAffirmNotice), (Object)((Object)bidWinningAffirmNoticeVo));
        TenderFlagInjectionContext.setTenderCheckType(SubpackageInfoCheckTypeEnum.POST_TRIAL.getValue());
        PurchaseTenderProjectSubpackageInfo subpackageInfo = (PurchaseTenderProjectSubpackageInfo)((Object)this.subpackageInfoService.getById((Serializable)((Object)bidWinningAffirmNotice.getSubpackageId())));
        bidWinningAffirmNoticeVo.setEvaluationType(subpackageInfo.getEvaluationType());
        if (!SubpackageEvaBidTypeEnum.OFF_LINE.getValue().equals(subpackageInfo.getEvaluationType())) {
            PurchaseTenderBidLetterFormatGroupVO formatGroupVO = this.attachmentHeadService.queryBidLetterFormatGroup(bidWinningAffirmNotice.getSubpackageId());
            String quoteType = formatGroupVO.getQuoteType();
            bidWinningAffirmNoticeVo.setQuoteType(quoteType);
        }
        List<BidWinningAffirmPriceItemVo> winningAffirmItemList = this.bidWinningAffirmService.queryAffirmItemVoList(bidWinningAffirmNotice.getSubpackageId(), bidWinningAffirmNoticeVo.getQuoteType(), bidWinningAffirmNoticeVo.getEvaluationType());
        bidWinningAffirmNoticeVo.setBidWinningAffirmList(winningAffirmItemList);
        return bidWinningAffirmNoticeVo;
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public BidWinningAffirmNotice generate(BidWinningAffirmNoticeVo purchaseTenderProjectBidWinningAffirmNotice) {
        if (StrUtil.isNotBlank((CharSequence)purchaseTenderProjectBidWinningAffirmNotice.getId())) {
            this.edit(purchaseTenderProjectBidWinningAffirmNotice);
        } else {
            this.add(purchaseTenderProjectBidWinningAffirmNotice);
        }
        if (purchaseTenderProjectBidWinningAffirmNotice.getTemplateLibraryId() != null) {
            ParseTemplateParamVO parseTemplateParamVO = new ParseTemplateParamVO();
            parseTemplateParamVO.setBusinessId(purchaseTenderProjectBidWinningAffirmNotice.getSubpackageId());
            parseTemplateParamVO.setTemplateLibraryId(purchaseTenderProjectBidWinningAffirmNotice.getTemplateLibraryId());
            GenerateTemplateVO generate = this.purchaseTenderTemplateLibraryService.generate(parseTemplateParamVO);
            LambdaUpdateWrapper updateWrapper = new LambdaUpdateWrapper();
            ((LambdaUpdateWrapper)updateWrapper.set(BidWinningAffirmNotice::getNoticeContent, (Object)generate.getContent())).eq(BaseEntity::getId, (Object)purchaseTenderProjectBidWinningAffirmNotice.getId());
            this.update((Wrapper)updateWrapper);
        }
        return purchaseTenderProjectBidWinningAffirmNotice;
    }
}

