/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.tender.common.service.impl;

import cn.hutool.core.collection.CollectionUtil;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.els.modules.tender.common.service.PurchaseTenderDataParse;
import com.els.modules.tender.common.service.impl.PurchaseTenderTemplateParsetImpl;
import com.els.modules.tender.common.utils.TenderOperationFieldUtils;
import com.els.modules.tender.project.entity.PurchaseTenderProjectHead;
import com.els.modules.tender.project.entity.PurchaseTenderProjectSubpackageInfo;
import com.els.modules.tender.project.enumerate.SubpackageInfoCheckTypeEnum;
import com.els.modules.tender.project.enumerate.SubpackageInfoCurrentStepEnum;
import com.els.modules.tender.project.enumerate.SubpackageInfoProcessTypeEnum;
import com.els.modules.tender.project.service.PurchaseTenderProjectHeadService;
import com.els.modules.tender.project.service.PurchaseTenderProjectSubpackageInfoService;
import com.els.modules.tender.sale.vo.SaleTenderPriceOpeningsVO;
import com.els.modules.tender.supplier.entity.TenderProjectSupplier;
import com.els.modules.tender.supplier.service.TenderProjectSupplierService;
import com.els.modules.tender.template.entity.PurchaseTenderVariableLibrary;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class PurchaseTenderDataParseOpenBiddingImpl
implements PurchaseTenderDataParse {
    private static final Logger log = LoggerFactory.getLogger(PurchaseTenderDataParseOpenBiddingImpl.class);
    @Autowired
    private PurchaseTenderProjectSubpackageInfoService subpackageInfoService;
    @Autowired
    private TenderProjectSupplierService projectSupplierService;
    @Autowired
    private PurchaseTenderProjectHeadService purchaseTenderProjectHeadService;

    @Override
    public void parse(String businessId, Map<String, Object> dataSource, List<String> variableList, List<PurchaseTenderVariableLibrary> lists, Map<String, Object> paramMap) {
        TenderProjectSupplier querySupplier = new TenderProjectSupplier();
        querySupplier.setSubpackageId(businessId);
        List<TenderProjectSupplier> tenderProjectSuppliers = this.projectSupplierService.selectBySubpackageId(querySupplier);
        PurchaseTenderProjectSubpackageInfo subpackageInfo = PurchaseTenderTemplateParsetImpl.subpackageInfoThreadLocal.get();
        JSONObject jsonObject = this.translateDictText((Object)subpackageInfo);
        if (dataSource.get("subpackageName") == null) {
            PurchaseTenderProjectHead purchaseTenderProjectHead = (PurchaseTenderProjectHead)((Object)this.purchaseTenderProjectHeadService.getById((Serializable)((Object)subpackageInfo.getHeadId())));
            dataSource.put("subpackageName", subpackageInfo.getSubpackageName());
            dataSource.put("subpackageNumber", subpackageInfo.getSubpackageNumber());
            dataSource.put("tenderProjectName", purchaseTenderProjectHead.getTenderProjectName());
        }
        this.setDataByPre(businessId, dataSource, tenderProjectSuppliers, jsonObject);
        this.setDataByOneStep(businessId, dataSource, tenderProjectSuppliers, jsonObject);
        this.setDataByResult(businessId, dataSource, tenderProjectSuppliers, jsonObject);
    }

    private void setDataByOneStep(String businessId, Map<String, Object> dataSource, List<TenderProjectSupplier> tenderProjectSuppliers, JSONObject jsonObject) {
        List<SaleTenderPriceOpeningsVO> purchasePriceOpeningsList;
        this.setFlagInjectionContext(SubpackageInfoCheckTypeEnum.POST_TRIAL.getValue(), SubpackageInfoProcessTypeEnum.TWO_STEP.getValue(), SubpackageInfoCurrentStepEnum.FIRST_STEP.getValue());
        dataSource.put("oneStepOpenBiddingTime", jsonObject.get((Object)"openBiddingTime") == null ? "" : jsonObject.get((Object)"openBiddingTime"));
        long oneStepDecryptTotal = tenderProjectSuppliers.stream().filter(tenderProjectSupplier -> "1".equals(TenderOperationFieldUtils.getFieldStringValue(tenderProjectSupplier, "decrypt"))).count();
        long oneStepSubmitFileTotal = tenderProjectSuppliers.stream().filter(tenderProjectSupplier -> "1".equals(TenderOperationFieldUtils.getFieldStringValue(tenderProjectSupplier, "responseStatus"))).count();
        dataSource.put("oneStepSubmitFileTotal", oneStepSubmitFileTotal);
        dataSource.put("oneStepDecryptTotal", oneStepDecryptTotal);
        try {
            purchasePriceOpeningsList = this.subpackageInfoService.getPurchasePriceOpeningsById(businessId);
        }
        catch (Exception e) {
            purchasePriceOpeningsList = Collections.EMPTY_LIST;
        }
        ArrayList<Object> oneStepPriceOpeningsThList = new ArrayList<Object>();
        TreeMap oneStepPriceOpeningsTrMap = new TreeMap();
        if (CollectionUtil.isNotEmpty(purchasePriceOpeningsList)) {
            oneStepPriceOpeningsThList.add("\u6295\u6807\u5355\u4f4d\u540d\u79f0");
            ArrayList<Object> fieldName = new ArrayList<Object>();
            fieldName.add("supplierName");
            String customizeFieldModel = purchasePriceOpeningsList.get(0).getCustomizeFieldModel();
            JSONArray modelJsonArray = JSONArray.parseArray((String)customizeFieldModel);
            for (int i = 0; i < modelJsonArray.size(); ++i) {
                JSONObject modelJsonObject = modelJsonArray.getJSONObject(i);
                Object title = modelJsonObject.get((Object)"title");
                if ("\u6295\u6807\u5355\u4f4d\u540d\u79f0".equals(title.toString())) continue;
                oneStepPriceOpeningsThList.add(title);
                fieldName.add(modelJsonObject.get((Object)"field"));
            }
            for (SaleTenderPriceOpeningsVO saleTenderPriceOpeningsVO : purchasePriceOpeningsList) {
                ArrayList prePriceOpeningsTrList = (ArrayList)oneStepPriceOpeningsTrMap.get(saleTenderPriceOpeningsVO.getElsAccount());
                if (CollectionUtil.isEmpty((Collection)prePriceOpeningsTrList)) {
                    prePriceOpeningsTrList = new ArrayList();
                    oneStepPriceOpeningsTrMap.put(saleTenderPriceOpeningsVO.getElsAccount(), prePriceOpeningsTrList);
                }
                String customizeDataModel = saleTenderPriceOpeningsVO.getCustomizeFieldData();
                JSONArray dataJsonArray = JSONArray.parseArray((String)customizeDataModel);
                for (int j = 0; j < dataJsonArray.size(); ++j) {
                    ArrayList<Object> dataList = new ArrayList<Object>();
                    dataList.add(saleTenderPriceOpeningsVO.getSupplierName());
                    JSONObject dataJsonArrayObject = dataJsonArray.getJSONObject(j);
                    for (Object e : fieldName) {
                        if ("supplierName".equals(e.toString())) continue;
                        Object fieldVal = dataJsonArrayObject.get(e);
                        dataList.add(fieldVal == null ? "" : fieldVal);
                    }
                    prePriceOpeningsTrList.add(dataList);
                }
            }
        }
        dataSource.put("oneStepPriceOpeningsThList", oneStepPriceOpeningsThList);
        dataSource.put("oneStepPriceOpeningsTrMap", oneStepPriceOpeningsTrMap);
    }

    private void setDataByResult(String businessId, Map<String, Object> dataSource, List<TenderProjectSupplier> tenderProjectSuppliers, JSONObject jsonObject) {
        List purchasePriceOpeningsList;
        this.setFlagInjectionContext(SubpackageInfoCheckTypeEnum.POST_TRIAL.getValue(), null, null);
        dataSource.put("resultOpenBiddingTime", jsonObject.get((Object)"resultOpenBiddingTime") == null ? "" : jsonObject.get((Object)"resultOpenBiddingTime"));
        long decryptTotal = tenderProjectSuppliers.stream().filter(tenderProjectSupplier -> "1".equals(TenderOperationFieldUtils.getFieldStringValue(tenderProjectSupplier, "decrypt"))).count();
        long submitFileTotal = tenderProjectSuppliers.stream().filter(tenderProjectSupplier -> "1".equals(TenderOperationFieldUtils.getFieldStringValue(tenderProjectSupplier, "responseStatus"))).count();
        dataSource.put("submitFileTotal", submitFileTotal);
        dataSource.put("decryptTotal", decryptTotal);
        try {
            purchasePriceOpeningsList = this.subpackageInfoService.getPurchasePriceOpeningsById(businessId);
        }
        catch (Exception e) {
            e.printStackTrace();
            log.error("\u5f00\u6807\u4e00\u89c8\u8868\u5f02\u5e38:{}", (Object)e.getMessage());
            purchasePriceOpeningsList = Collections.EMPTY_LIST;
        }
        ArrayList<Object> priceOpeningsThList = new ArrayList<Object>();
        TreeMap priceOpeningsTrMap = new TreeMap();
        if (CollectionUtil.isNotEmpty((Collection)purchasePriceOpeningsList)) {
            priceOpeningsThList.add("\u6295\u6807\u5355\u4f4d\u540d\u79f0");
            ArrayList<Object> fieldName = new ArrayList<Object>();
            fieldName.add("supplierName");
            String customizeFieldModel = ((SaleTenderPriceOpeningsVO)((Object)purchasePriceOpeningsList.get(0))).getCustomizeFieldModel();
            JSONArray modelJsonArray = JSONArray.parseArray((String)customizeFieldModel);
            for (int i = 0; i < modelJsonArray.size(); ++i) {
                JSONObject modelJsonObject = modelJsonArray.getJSONObject(i);
                Object title = modelJsonObject.get((Object)"title");
                if ("\u6295\u6807\u5355\u4f4d\u540d\u79f0".equals(title.toString())) continue;
                priceOpeningsThList.add(title);
                fieldName.add(modelJsonObject.get((Object)"field"));
            }
            for (SaleTenderPriceOpeningsVO saleTenderPriceOpeningsVO : purchasePriceOpeningsList) {
                ArrayList prePriceOpeningsTrList = (ArrayList)priceOpeningsTrMap.get(saleTenderPriceOpeningsVO.getElsAccount());
                if (CollectionUtil.isEmpty((Collection)prePriceOpeningsTrList)) {
                    prePriceOpeningsTrList = new ArrayList();
                    priceOpeningsTrMap.put(saleTenderPriceOpeningsVO.getElsAccount(), prePriceOpeningsTrList);
                }
                String customizeDataModel = saleTenderPriceOpeningsVO.getCustomizeFieldData();
                JSONArray dataJsonArray = JSONArray.parseArray((String)customizeDataModel);
                for (int j = 0; j < dataJsonArray.size(); ++j) {
                    ArrayList<Object> dataList = new ArrayList<Object>();
                    dataList.add(saleTenderPriceOpeningsVO.getSupplierName());
                    JSONObject dataJsonArrayObject = dataJsonArray.getJSONObject(j);
                    for (Object e : fieldName) {
                        if ("supplierName".equals(e.toString())) continue;
                        Object fieldVal = dataJsonArrayObject.get(e);
                        dataList.add(fieldVal == null ? "" : fieldVal);
                    }
                    prePriceOpeningsTrList.add(dataList);
                }
            }
        }
        dataSource.put("priceOpeningsThList", priceOpeningsThList);
        dataSource.put("priceOpeningsTrMap", priceOpeningsTrMap);
    }

    private void setDataByPre(String businessId, Map<String, Object> dataSource, List<TenderProjectSupplier> tenderProjectSuppliers, JSONObject jsonObject) {
        List purchasePriceOpeningsList;
        this.setFlagInjectionContext(SubpackageInfoCheckTypeEnum.POST_TRIAL.getValue(), SubpackageInfoProcessTypeEnum.ONE_STEP.getValue(), null);
        dataSource.put("preOpenBiddingTime", jsonObject.get((Object)"preOpenBiddingTime") == null ? "" : jsonObject.get((Object)"preOpenBiddingTime"));
        long preDecryptTotal = tenderProjectSuppliers.stream().filter(tenderProjectSupplier -> "1".equals(TenderOperationFieldUtils.getFieldStringValue(tenderProjectSupplier, "decrypt"))).count();
        long preSubmitFileTotal = tenderProjectSuppliers.stream().filter(tenderProjectSupplier -> "1".equals(TenderOperationFieldUtils.getFieldStringValue(tenderProjectSupplier, "responseStatus"))).count();
        dataSource.put("preSubmitFileTotal", preSubmitFileTotal);
        dataSource.put("preDecryptTotal", preDecryptTotal);
        try {
            purchasePriceOpeningsList = this.subpackageInfoService.getPurchasePriceOpeningsById(businessId);
        }
        catch (Exception e) {
            e.printStackTrace();
            log.error(e.getMessage());
            purchasePriceOpeningsList = Collections.EMPTY_LIST;
        }
        ArrayList<Object> prePriceOpeningsThList = new ArrayList<Object>();
        TreeMap prePriceOpeningsTrMap = new TreeMap();
        if (CollectionUtil.isNotEmpty((Collection)purchasePriceOpeningsList)) {
            prePriceOpeningsThList.add("\u6295\u6807\u5355\u4f4d\u540d\u79f0");
            ArrayList<Object> fieldName = new ArrayList<Object>();
            fieldName.add("supplierName");
            String customizeFieldModel = ((SaleTenderPriceOpeningsVO)((Object)purchasePriceOpeningsList.get(0))).getCustomizeFieldModel();
            JSONArray modelJsonArray = JSONArray.parseArray((String)customizeFieldModel);
            for (int i = 0; i < modelJsonArray.size(); ++i) {
                JSONObject modelJsonObject = modelJsonArray.getJSONObject(i);
                Object title = modelJsonObject.get((Object)"title");
                if ("\u6295\u6807\u5355\u4f4d\u540d\u79f0".equals(title.toString())) continue;
                prePriceOpeningsThList.add(title);
                fieldName.add(modelJsonObject.get((Object)"field"));
            }
            for (SaleTenderPriceOpeningsVO saleTenderPriceOpeningsVO : purchasePriceOpeningsList) {
                ArrayList prePriceOpeningsTrList = (ArrayList)prePriceOpeningsTrMap.get(saleTenderPriceOpeningsVO.getElsAccount());
                if (CollectionUtil.isEmpty((Collection)prePriceOpeningsTrList)) {
                    prePriceOpeningsTrList = new ArrayList();
                    prePriceOpeningsTrMap.put(saleTenderPriceOpeningsVO.getElsAccount(), prePriceOpeningsTrList);
                }
                String customizeDataModel = saleTenderPriceOpeningsVO.getCustomizeFieldData();
                JSONArray dataJsonArray = JSONArray.parseArray((String)customizeDataModel);
                for (int j = 0; j < dataJsonArray.size(); ++j) {
                    ArrayList<Object> dataList = new ArrayList<Object>();
                    dataList.add(saleTenderPriceOpeningsVO.getSupplierName());
                    JSONObject dataJsonArrayObject = dataJsonArray.getJSONObject(j);
                    for (Object e : fieldName) {
                        if ("supplierName".equals(e.toString())) continue;
                        Object fieldVal = dataJsonArrayObject.get(e);
                        dataList.add(fieldVal == null ? "" : fieldVal);
                    }
                    prePriceOpeningsTrList.add(dataList);
                }
            }
        }
        dataSource.put("prePriceOpeningsThList", prePriceOpeningsThList);
        dataSource.put("prePriceOpeningsTrMap", prePriceOpeningsTrMap);
    }
}

