/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.tender.common.service.impl;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.StrUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.els.common.exception.ELSBootException;
import com.els.common.system.base.entity.BaseEntity;
import com.els.common.util.I18nUtil;
import com.els.common.util.SpringContextUtils;
import com.els.common.util.TemplateParseUtil;
import com.els.config.mybatis.TenantContext;
import com.els.modules.tender.common.service.PurchaseTenderDataParse;
import com.els.modules.tender.common.service.PurchaseTenderTemplateParse;
import com.els.modules.tender.common.vo.GenerateTemplateVO;
import com.els.modules.tender.common.vo.ParseTemplateParamVO;
import com.els.modules.tender.project.entity.PurchaseTenderProjectSubpackageInfo;
import com.els.modules.tender.project.service.PurchaseTenderProjectSubpackageInfoService;
import com.els.modules.tender.template.entity.PurchaseTenderTemplateLibrary;
import com.els.modules.tender.template.entity.PurchaseTenderVariableLibrary;
import com.els.modules.tender.template.enumerate.TemplateLibraryStatusEnum;
import com.els.modules.tender.template.enumerate.VariableLibraryDataSourceEnum;
import com.els.modules.tender.template.service.PurchaseTenderTemplateLibraryService;
import com.els.modules.tender.template.service.PurchaseTenderVariableLibraryService;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;

@Service
public class PurchaseTenderTemplateParsetImpl
implements PurchaseTenderTemplateParse {
    private static final Logger log = LoggerFactory.getLogger(PurchaseTenderTemplateParsetImpl.class);
    public static Pattern p1 = Pattern.compile("\\$\\{(.*?)}");
    private static Pattern p2 = Pattern.compile("(?<=\\$\\{).*?(?=\\})");
    static ThreadLocal<PurchaseTenderProjectSubpackageInfo> subpackageInfoThreadLocal = new ThreadLocal();
    @Autowired
    private PurchaseTenderVariableLibraryService variableLibraryService;
    @Autowired
    @Lazy
    private PurchaseTenderTemplateLibraryService tenderTemplateLibraryService;
    @Autowired
    @Lazy
    private PurchaseTenderProjectSubpackageInfoService subpackageInfoService;

    @Override
    public String parseTemplate(ParseTemplateParamVO parseTemplateParamVO) {
        PurchaseTenderTemplateLibrary templateLibrary = (PurchaseTenderTemplateLibrary)((Object)this.tenderTemplateLibraryService.getById((Serializable)((Object)parseTemplateParamVO.getTemplateLibraryId())));
        String templateContent = this.replaseBr(templateLibrary.getTemplateContent());
        Matcher matcher = p1.matcher(templateContent);
        TreeSet<String> variableSet = new TreeSet<String>();
        while (matcher.find()) {
            variableSet.add(matcher.group());
        }
        log.info("\u4ece\u6a21\u677f\u4e2d\u5339\u914d\u5230\u7684\u53d8\u91cf{}", variableSet);
        if (CollectionUtil.isEmpty(variableSet)) {
            return templateContent;
        }
        PurchaseTenderProjectSubpackageInfo subpackageInfo = (PurchaseTenderProjectSubpackageInfo)((Object)this.subpackageInfoService.getById((Serializable)((Object)parseTemplateParamVO.getBusinessId())));
        if (subpackageInfo == null) {
            return templateContent;
        }
        subpackageInfoThreadLocal.set(subpackageInfo);
        LambdaQueryWrapper qw = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)((LambdaQueryWrapper)qw.in(PurchaseTenderVariableLibrary::getParamName, variableSet)).eq(PurchaseTenderVariableLibrary::getStatus, (Object)TemplateLibraryStatusEnum.PUBLISH.getValue())).eq(BaseEntity::getElsAccount, (Object)TenantContext.getTenant());
        List variableLibraryList = this.variableLibraryService.list((Wrapper)qw);
        if (CollectionUtil.isEmpty((Collection)variableLibraryList)) {
            qw.clear();
            ((LambdaQueryWrapper)((LambdaQueryWrapper)qw.in(PurchaseTenderVariableLibrary::getParamName, variableSet)).eq(PurchaseTenderVariableLibrary::getStatus, (Object)TemplateLibraryStatusEnum.PUBLISH.getValue())).eq(BaseEntity::getElsAccount, (Object)"100000");
            variableLibraryList = this.variableLibraryService.list((Wrapper)qw);
            if (CollectionUtil.isEmpty((Collection)variableLibraryList)) {
                return templateContent;
            }
        }
        try {
            Map<String, List<PurchaseTenderVariableLibrary>> variableLibraryGroupTypeMap = variableLibraryList.stream().collect(Collectors.groupingBy(PurchaseTenderVariableLibrary::getGroupType));
            HashMap dataSource = new HashMap();
            List<String> variableNames = this.matcherVariableName(variableSet);
            variableNames.forEach(variable -> dataSource.put(variable, ""));
            variableLibraryGroupTypeMap.forEach((groupType, variableLibrarys) -> {
                PurchaseTenderDataParse service = (PurchaseTenderDataParse)SpringContextUtils.getBean((String)VariableLibraryDataSourceEnum.getVariableLibraryDataSourceEnum(groupType).getServicename(), PurchaseTenderDataParse.class);
                List<String> paramValueList = variableLibrarys.stream().map(PurchaseTenderVariableLibrary::getParamValue).collect(Collectors.toList());
                paramValueList = this.matcherVariableName(paramValueList);
                String businessId = parseTemplateParamVO.getBusinessId();
                if (VariableLibraryDataSourceEnum.TENDER_BIDDING.getValue().equals(groupType) && StrUtil.isNotBlank((CharSequence)parseTemplateParamVO.getTenderNoticeId())) {
                    businessId = parseTemplateParamVO.getTenderNoticeId();
                }
                service.parse(businessId, dataSource, paramValueList, (List<PurchaseTenderVariableLibrary>)variableLibrarys, parseTemplateParamVO.getParamMap());
            });
            log.info("dataSource:{}", dataSource);
            templateContent = this.replaceVariableName(templateContent, variableLibraryList);
            log.info("templateContent\u66ff\u6362\u540e:{}", (Object)templateContent);
            templateContent = TemplateParseUtil.getTemplateText((String)"", (String)templateContent, dataSource);
        }
        catch (ELSBootException e) {
            e.printStackTrace();
            throw new RuntimeException(e.getMessage());
        }
        catch (Exception e) {
            log.error(e.getMessage());
            e.printStackTrace();
            throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_IrbLIHWVXVsKW_8ce735b0", (String)("\u6a21\u677f\u751f\u6210\u5f02\u5e38\uff0c\u8bf7\u5237\u65b0\u91cd\u8bd5\uff01" + e.getMessage())));
        }
        finally {
            subpackageInfoThreadLocal.remove();
        }
        return templateContent;
    }

    @Override
    public GenerateTemplateVO templatePreview(PurchaseTenderTemplateLibrary templateLibrary) {
        GenerateTemplateVO generateTemplateVO = new GenerateTemplateVO();
        if (StrUtil.isBlank((CharSequence)templateLibrary.getTemplateContent())) {
            return generateTemplateVO;
        }
        String templateContent = this.replaseBr(templateLibrary.getTemplateContent());
        Matcher matcher = p1.matcher(templateContent);
        TreeSet<String> variableSet = new TreeSet<String>();
        while (matcher.find()) {
            variableSet.add(matcher.group());
        }
        if (CollectionUtil.isEmpty(variableSet)) {
            generateTemplateVO.setContent(templateContent);
            return generateTemplateVO;
        }
        LambdaQueryWrapper qw = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)((LambdaQueryWrapper)qw.in(PurchaseTenderVariableLibrary::getParamName, variableSet)).eq(PurchaseTenderVariableLibrary::getStatus, (Object)TemplateLibraryStatusEnum.PUBLISH.getValue())).eq(BaseEntity::getElsAccount, (Object)TenantContext.getTenant());
        List variableLibraryList = this.variableLibraryService.list((Wrapper)qw);
        if (CollectionUtil.isEmpty((Collection)variableLibraryList)) {
            qw.clear();
            ((LambdaQueryWrapper)qw.eq(PurchaseTenderVariableLibrary::getStatus, (Object)TemplateLibraryStatusEnum.PUBLISH.getValue())).eq(BaseEntity::getElsAccount, (Object)"100000");
            variableLibraryList = this.variableLibraryService.list((Wrapper)qw);
        }
        Map<String, PurchaseTenderVariableLibrary> variableLibraryMap = variableLibraryList.stream().collect(Collectors.toMap(PurchaseTenderVariableLibrary::getParamName, variable -> variable, (o1, o2) -> o1));
        Iterator iterator = variableSet.iterator();
        while (iterator.hasNext()) {
            String paramName;
            PurchaseTenderVariableLibrary variableLibrary = variableLibraryMap.get(paramName = (String)iterator.next());
            templateContent = templateContent.replace(paramName, variableLibrary == null ? "" : variableLibrary.getParamContent());
        }
        generateTemplateVO.setContent(templateContent);
        return generateTemplateVO;
    }

    private String replaceVariableName(String templateContent, List<PurchaseTenderVariableLibrary> variableLibraryList) {
        String replaceTemplateContent = templateContent;
        for (PurchaseTenderVariableLibrary purchaseTenderVariableLibrary : variableLibraryList) {
            if (!templateContent.contains(purchaseTenderVariableLibrary.getParamName().trim())) continue;
            String paramValue = purchaseTenderVariableLibrary.getParamValue();
            replaceTemplateContent = replaceTemplateContent.replace(purchaseTenderVariableLibrary.getParamName().trim(), paramValue);
        }
        return replaceTemplateContent;
    }

    private List<String> matcherVariableName(Collection<String> variableList) {
        ArrayList<String> VariableName = new ArrayList<String>();
        for (String s : variableList) {
            Matcher matcher = p2.matcher(s);
            while (matcher.find()) {
                VariableName.add(matcher.group());
            }
        }
        return VariableName;
    }

    private String matcherSigleVariableName(String variable) {
        Matcher matcher = p2.matcher(variable);
        if (matcher.find()) {
            return matcher.group();
        }
        return "";
    }

    private String replaseBr(String templateContent) {
        String content = templateContent.replaceAll("\\n\\n", "<br/>").replaceAll("\\r\\n", "<br/>").replaceAll("\\r\\n\\t", "<br/>").replaceAll("\\\\r", "<br/>").replaceAll("\\\\n", "<br/>").replaceAll("\\\\t", "&nbsp");
        return content;
    }
}

