/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.tender.notice.adapter;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.els.aspect.param.DictTranslateAspectParam;
import com.els.common.api.vo.Result;
import com.els.common.aspect.annotation.RpcService;
import com.els.common.enumerate.AuditStatusEnum;
import com.els.common.service.DictTranslateService;
import com.els.common.system.vo.MsgParamsVO;
import com.els.common.util.MqUtil;
import com.els.common.util.SpringContextUtils;
import com.els.common.util.SysUtil;
import com.els.config.mybatis.TenantContext;
import com.els.modules.account.api.dto.ElsSubAccountDTO;
import com.els.modules.tender.common.interceptor.TenderFlagInjectionContext;
import com.els.modules.tender.notice.entity.PurchaseTenderNoticeHead;
import com.els.modules.tender.notice.enumerate.PurchaseTenderNoticeTypeEnum;
import com.els.modules.tender.notice.service.PurchaseTenderNoticeHeadService;
import com.els.modules.tender.notice.vo.PurchaseTenderNoticeHeadVO;
import com.els.modules.tender.project.enumerate.SubpackageInfoCheckTypeEnum;
import com.els.modules.workflow.dto.AuditInputParamDTO;
import com.els.modules.workflow.dto.AuditOutputParamDTO;
import com.els.modules.workflow.enums.WorkFlowType;
import com.els.modules.workflow.rpc.service.AuditOptCallBackService;
import com.els.rpc.service.InvokeAccountRpcService;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@RpcService(value="noticeAuditCallBackServiceImpl")
public class PurchaseTenderNoticeAdapter
implements AuditOptCallBackService {
    private static final Logger log = LoggerFactory.getLogger(PurchaseTenderNoticeAdapter.class);
    @Resource
    private PurchaseTenderNoticeHeadService purchaseTenderNoticeHeadService;
    @Resource
    private InvokeAccountRpcService invokeAccountRpcService;

    public void startCallBack(AuditInputParamDTO inputParamDTO, AuditOutputParamDTO outputParamDTO) {
        this.updateAuditStatus(inputParamDTO, outputParamDTO);
        Object operataion = "submitAudit";
        if (WorkFlowType.BPMN.getValue().equals(outputParamDTO.getBpmnType())) {
            operataion = outputParamDTO.getBpmnType() + "_submitAudit";
        }
        this.sendMsg(inputParamDTO, outputParamDTO, (String)operataion);
    }

    private void updateAuditStatus(AuditInputParamDTO inputParamDTO, AuditOutputParamDTO outputParamDTO) {
        this.purchaseTenderNoticeHeadService.updateAuditStatus(inputParamDTO.getBusinessId(), outputParamDTO.getProcessRootId(), outputParamDTO.getAuditStatus(), outputParamDTO.getBpmnType());
    }

    public void completeCallBack(AuditInputParamDTO inputParamDTO, AuditOutputParamDTO outputParamDTO) {
        this.updateAuditStatus(inputParamDTO, outputParamDTO);
        log.info("\u62db\u6807\u516c\u544a\u5ba1\u6279\u53c2\u6570:{}", JSON.toJSON((Object)inputParamDTO));
        if (AuditStatusEnum.AUDIT_FINISH.getValue().equals(outputParamDTO.getAuditStatus())) {
            PurchaseTenderNoticeHeadVO purchaseTenderNoticeHeadVO = this.purchaseTenderNoticeHeadService.queryById(inputParamDTO.getBusinessId());
            if (PurchaseTenderNoticeTypeEnum.hasPreTrial(purchaseTenderNoticeHeadVO.getNoticeType())) {
                TenderFlagInjectionContext.setTenderCheckType(SubpackageInfoCheckTypeEnum.PRE_TRIAL.getValue());
            } else {
                TenderFlagInjectionContext.setTenderCheckType(SubpackageInfoCheckTypeEnum.POST_TRIAL.getValue());
            }
            PurchaseTenderNoticeHead purchaseTenderNoticeHead = (PurchaseTenderNoticeHead)((Object)SysUtil.copyProperties((Object)((Object)purchaseTenderNoticeHeadVO), PurchaseTenderNoticeHead.class));
            this.purchaseTenderNoticeHeadService.publish(purchaseTenderNoticeHead, purchaseTenderNoticeHeadVO.getPurchaseTenderNoticeItemList(), purchaseTenderNoticeHeadVO.getPurchaseTenderSupplierInvitation());
            this.sendMsg(inputParamDTO, outputParamDTO, "auditPass");
        } else {
            this.sendMsg(inputParamDTO, outputParamDTO, "submitAudit");
        }
    }

    public void rejectCallBack(AuditInputParamDTO inputParamDTO, AuditOutputParamDTO outputParamDTO) {
        this.updateAuditStatus(inputParamDTO, outputParamDTO);
        this.sendMsg(inputParamDTO, outputParamDTO, "auditReject");
    }

    public void cancelCallBack(AuditInputParamDTO inputParamDTO, AuditOutputParamDTO outputParamDTO) {
        this.updateAuditStatus(inputParamDTO, outputParamDTO);
    }

    public JSONObject getDataById(String id) {
        PurchaseTenderNoticeHead head = (PurchaseTenderNoticeHead)((Object)this.purchaseTenderNoticeHeadService.getById((Serializable)((Object)id)));
        if (head != null) {
            Result result = Result.ok((Object)((Object)head));
            JSONObject jsonObject = ((DictTranslateService)SpringContextUtils.getBean(DictTranslateService.class)).parseJson((Object)head, new DictTranslateAspectParam());
            return jsonObject;
        }
        return null;
    }

    private void sendMsg(AuditInputParamDTO inputParamDTO, AuditOutputParamDTO outputParamDTO, String optType) {
        String elsAccount = TenantContext.getTenant();
        if (AuditStatusEnum.AUDIT_FINISH.getValue().equals(outputParamDTO.getAuditStatus())) {
            MsgParamsVO msgParamsVO = this.parameterAssemble(inputParamDTO, outputParamDTO, outputParamDTO.getSubmitUser());
            MqUtil.sendBusMsg((String)elsAccount, (String)inputParamDTO.getBusinessType(), (String)optType, (MsgParamsVO)msgParamsVO);
        } else {
            List accountList = outputParamDTO.getNextAuditUserList();
            for (String account : accountList) {
                MsgParamsVO msgParamsVO = this.parameterAssemble(inputParamDTO, outputParamDTO, account);
                MqUtil.sendBusMsg((String)elsAccount, (String)inputParamDTO.getBusinessType(), (String)optType, (MsgParamsVO)msgParamsVO);
            }
        }
    }

    private MsgParamsVO parameterAssemble(AuditInputParamDTO inputParamDTO, AuditOutputParamDTO outputParamDTO, String account) {
        MsgParamsVO msgParamsVO = new MsgParamsVO();
        ArrayList<ElsSubAccountDTO> accountList = new ArrayList<ElsSubAccountDTO>();
        HashMap<String, ArrayList<ElsSubAccountDTO>> receiverMap = new HashMap<String, ArrayList<ElsSubAccountDTO>>();
        ElsSubAccountDTO subAccount = this.invokeAccountRpcService.getAccount(TenantContext.getTenant(), account.split("_")[1]);
        accountList.add(subAccount);
        receiverMap.put(TenantContext.getTenant(), accountList);
        msgParamsVO.setReceiverMap(receiverMap);
        String businessType = inputParamDTO.getBusinessType();
        String flowId = outputParamDTO.getProcessRootId();
        String headId = inputParamDTO.getBusinessId();
        String outAuditPassUrl = SysUtil.getOutAuditPassUrl((ElsSubAccountDTO)subAccount, (String)flowId, (String)businessType, (String)headId);
        String outAuditRejectUrl = SysUtil.getOutAuditRejectUrl((ElsSubAccountDTO)subAccount, (String)flowId, (String)businessType, (String)headId);
        PurchaseTenderNoticeHead purchaseTenderNoticeHead = (PurchaseTenderNoticeHead)((Object)this.purchaseTenderNoticeHeadService.getById((Serializable)((Object)headId)));
        Result result = Result.ok((Object)((Object)purchaseTenderNoticeHead));
        JSONObject jsonObject = ((DictTranslateService)SpringContextUtils.getBean(DictTranslateService.class)).parseJson((Object)purchaseTenderNoticeHead, new DictTranslateAspectParam());
        Map paramMap = (Map)JSON.parse((String)jsonObject.toString());
        paramMap.put("userName", subAccount.getRealname());
        paramMap.put("outAuditPassUrl", outAuditPassUrl);
        paramMap.put("outAuditRejectUrl", outAuditRejectUrl);
        msgParamsVO.setParams((Object)paramMap);
        HashMap<String, JSONObject> receiveParamMap = new HashMap<String, JSONObject>();
        JSONObject paramObj = new JSONObject();
        paramObj.put("businessId", (Object)inputParamDTO.getBusinessId());
        paramObj.put("businessType", (Object)inputParamDTO.getBusinessType());
        if (account.split("_").length > 2) {
            paramObj.put("taskId", (Object)account.split("_")[2]);
        }
        if (account.split("_").length > 3) {
            paramObj.put("processInstanceId", (Object)account.split("_")[3]);
        }
        receiveParamMap.put(TenantContext.getTenant(), paramObj);
        msgParamsVO.setReceiveParamMap(receiveParamMap);
        return msgParamsVO;
    }
}

