/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.tender.openbid.service.impl;

import cn.hutool.core.util.StrUtil;
import com.els.common.aspect.annotation.SrmTransaction;
import com.els.common.constant.CommonConstant;
import com.els.common.system.base.entity.BaseEntity;
import com.els.common.system.base.service.impl.BaseServiceImpl;
import com.els.common.util.I18nUtil;
import com.els.common.util.SysUtil;
import com.els.config.mybatis.TenantContext;
import com.els.modules.tender.common.interceptor.TenderFlagInjectionContext;
import com.els.modules.tender.common.utils.TenderOperationFieldUtils;
import com.els.modules.tender.openbid.entity.PurchaseTenderProjectOpenSettingAttendees;
import com.els.modules.tender.openbid.entity.PurchaseTenderProjectOpenSettingHead;
import com.els.modules.tender.openbid.enumerate.PurchaseOpenBidStatusEnum;
import com.els.modules.tender.openbid.job.TenderJobUtil;
import com.els.modules.tender.openbid.mapper.PurchaseTenderProjectOpenSettingHeadMapper;
import com.els.modules.tender.openbid.service.PurchaseTenderProjectOpenSettingAttendeesService;
import com.els.modules.tender.openbid.service.PurchaseTenderProjectOpenSettingHeadService;
import com.els.modules.tender.openbid.vo.PurchaseOpenSettingHeadVO;
import com.els.modules.tender.project.entity.PurchaseTenderProjectHead;
import com.els.modules.tender.project.entity.PurchaseTenderProjectSubpackageInfo;
import com.els.modules.tender.project.enumerate.SubpackageBidOpenTypeEnum;
import com.els.modules.tender.project.enumerate.SubpackageInfoCheckTypeEnum;
import com.els.modules.tender.project.enumerate.SubpackageInfoCurrentStepEnum;
import com.els.modules.tender.project.enumerate.SubpackageInfoProcessTypeEnum;
import com.els.modules.tender.project.service.PurchaseTenderProjectHeadService;
import com.els.modules.tender.project.service.PurchaseTenderProjectSubpackageInfoService;
import com.els.modules.tender.project.vo.PurchaseTenderProjectHeadVO;
import java.io.Serializable;
import java.util.Date;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;

@Service
public class PurchaseTenderProjectOpenSettingHeadServiceImpl
extends BaseServiceImpl<PurchaseTenderProjectOpenSettingHeadMapper, PurchaseTenderProjectOpenSettingHead>
implements PurchaseTenderProjectOpenSettingHeadService {
    @Autowired
    private PurchaseTenderProjectOpenSettingAttendeesService openSettingAttendeesService;
    @Autowired
    private PurchaseTenderProjectSubpackageInfoService subpackageInfoService;
    @Autowired
    private PurchaseTenderProjectHeadService purchaseTenderProjectHeadService;

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void saveMain(PurchaseTenderProjectOpenSettingHead purchaseTenderProjectOpenSettingHead, List<PurchaseTenderProjectOpenSettingAttendees> purchaseTenderProjectOpenSettingAttendeesList) {
        purchaseTenderProjectOpenSettingHead.setStatus("0");
        purchaseTenderProjectOpenSettingHead.setDeleted(CommonConstant.DEL_FLAG_0);
        purchaseTenderProjectOpenSettingHead.setElsAccount(TenantContext.getTenant());
        ((PurchaseTenderProjectOpenSettingHeadMapper)this.baseMapper).insert((Object)purchaseTenderProjectOpenSettingHead);
        super.setHeadDefaultValue((BaseEntity)purchaseTenderProjectOpenSettingHead);
        this.insertData(purchaseTenderProjectOpenSettingHead, purchaseTenderProjectOpenSettingAttendeesList);
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void updateMain(PurchaseTenderProjectOpenSettingHead purchaseTenderProjectOpenSettingHead, List<PurchaseTenderProjectOpenSettingAttendees> purchaseTenderProjectOpenSettingAttendeesList) {
        PurchaseTenderProjectOpenSettingHead openSettingHead = (PurchaseTenderProjectOpenSettingHead)((Object)this.getById((Serializable)((Object)purchaseTenderProjectOpenSettingHead.getId())));
        Assert.isTrue((boolean)"0".equals(openSettingHead.getStatus()), (String)I18nUtil.translate((String)"i18n_field_APzExiTcr_3e637faa", (String)"\u5f53\u524d\u72b6\u6001\u4e0d\u5141\u8bb8\u4fee\u6539"));
        purchaseTenderProjectOpenSettingHead.setDataVersion(openSettingHead.getDataVersion());
        int count = ((PurchaseTenderProjectOpenSettingHeadMapper)this.baseMapper).updateById((Object)purchaseTenderProjectOpenSettingHead);
        Assert.isTrue((count != 0 ? 1 : 0) != 0, (String)I18nUtil.translate((String)"i18n_alert_APWFIKXWVVVXVSDJHrW_2fe92d52", (String)"\u5f53\u524d\u6570\u636e\u5df2\u5931\u6548\uff0c\u8bf7\u91cd\u65b0\u5237\u65b0\u540e\u63d0\u4ea4\u66f4\u6539\uff01"));
        this.openSettingAttendeesService.deleteByMainId(purchaseTenderProjectOpenSettingHead.getId());
        this.insertData(purchaseTenderProjectOpenSettingHead, purchaseTenderProjectOpenSettingAttendeesList);
    }

    private void insertData(PurchaseTenderProjectOpenSettingHead purchaseTenderProjectOpenSettingHead, List<PurchaseTenderProjectOpenSettingAttendees> purchaseTenderProjectOpenSettingAttendeesList) {
        if (!CollectionUtils.isEmpty(purchaseTenderProjectOpenSettingAttendeesList)) {
            for (PurchaseTenderProjectOpenSettingAttendees entity : purchaseTenderProjectOpenSettingAttendeesList) {
                entity.setHeadId(purchaseTenderProjectOpenSettingHead.getId());
                SysUtil.setSysParam((BaseEntity)entity, (BaseEntity)purchaseTenderProjectOpenSettingHead);
            }
            this.openSettingAttendeesService.saveBatch(purchaseTenderProjectOpenSettingAttendeesList, 2000);
        }
    }

    @Override
    public PurchaseOpenSettingHeadVO queryBySubpackageId(String subpackageId) {
        List<PurchaseTenderProjectOpenSettingHead> purchaseTenderProjectOpenSettingHeadList = this.selectByMainId(subpackageId);
        PurchaseOpenSettingHeadVO purchaseOpenSettingHeadVO = null;
        if (purchaseTenderProjectOpenSettingHeadList.isEmpty()) {
            purchaseOpenSettingHeadVO = new PurchaseOpenSettingHeadVO();
        } else {
            PurchaseTenderProjectOpenSettingHead purchaseTenderProjectOpenSettingHead = purchaseTenderProjectOpenSettingHeadList.get(0);
            List<PurchaseTenderProjectOpenSettingAttendees> purchaseTenderProjectOpenSettingAttendees = this.openSettingAttendeesService.selectByMainId(purchaseTenderProjectOpenSettingHead.getId());
            purchaseOpenSettingHeadVO = (PurchaseOpenSettingHeadVO)((Object)SysUtil.copyProperties((Object)((Object)purchaseTenderProjectOpenSettingHead), PurchaseOpenSettingHeadVO.class));
            purchaseOpenSettingHeadVO.setAttendeesList(purchaseTenderProjectOpenSettingAttendees);
        }
        PurchaseTenderProjectHeadVO purchaseTenderProjectHead = this.purchaseTenderProjectHeadService.queryProjectHeadBySubpackageId(subpackageId);
        purchaseOpenSettingHeadVO.setBidOpener(purchaseTenderProjectHead.getPurchaseExecutorName());
        purchaseOpenSettingHeadVO.setBidOpenerElsAccount(purchaseTenderProjectHead.getPurchaseExecutorAccount());
        purchaseOpenSettingHeadVO.setBidOpenerElsSubAccount(purchaseTenderProjectHead.getPurchaseExecutorSubAccount());
        purchaseOpenSettingHeadVO.setAgencyElsAccount(purchaseTenderProjectHead.getAgencyElsAccount());
        purchaseOpenSettingHeadVO.setBiddingUnitElsAccount(purchaseTenderProjectHead.getElsAccount());
        return purchaseOpenSettingHeadVO;
    }

    @Override
    public List<PurchaseTenderProjectOpenSettingHead> selectByMainId(String subpackageId) {
        return ((PurchaseTenderProjectOpenSettingHeadMapper)this.baseMapper).selectByMainId(subpackageId, TenderFlagInjectionContext.getTenderCheckType(), TenderFlagInjectionContext.getTenderProcessType(), TenderFlagInjectionContext.getTenderCurrentStep());
    }

    @Override
    public PurchaseTenderProjectOpenSettingHead selectBySubpackageId(String subpackageId) {
        return ((PurchaseTenderProjectOpenSettingHeadMapper)this.baseMapper).selectBySubpackageId(subpackageId);
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void saveOrUpatePublish(PurchaseTenderProjectOpenSettingHead purchaseTenderProjectOpenSettingHead, List<PurchaseTenderProjectOpenSettingAttendees> attendeesList) {
        if (StrUtil.isBlank((CharSequence)purchaseTenderProjectOpenSettingHead.getId())) {
            this.saveMain(purchaseTenderProjectOpenSettingHead, attendeesList);
        } else {
            this.updateMain(purchaseTenderProjectOpenSettingHead, attendeesList);
        }
        this.publish(purchaseTenderProjectOpenSettingHead, attendeesList);
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void publish(PurchaseTenderProjectOpenSettingHead purchaseTenderProjectOpenSettingHead, List<PurchaseTenderProjectOpenSettingAttendees> purchaseTenderProjectOpenSettingAttendeesList) {
        purchaseTenderProjectOpenSettingHead.setStatus("1");
        this.updateMain(purchaseTenderProjectOpenSettingHead, purchaseTenderProjectOpenSettingAttendeesList);
        PurchaseTenderProjectSubpackageInfo subpackageInfo = this.subpackageInfoService.selectById(purchaseTenderProjectOpenSettingHead.getSubpackageId());
        PurchaseTenderProjectHead projectHead = (PurchaseTenderProjectHead)((Object)this.purchaseTenderProjectHeadService.getById((Serializable)((Object)subpackageInfo.getHeadId())));
        if (StrUtil.isNotBlank((CharSequence)projectHead.getOpenBidPassword())) {
            Assert.isTrue((boolean)"0".equals(purchaseTenderProjectOpenSettingHead.getAutoOpenBid()), (String)I18nUtil.translate((String)"i18n_alert_dIGRjvBwoWxiTJOvB_669dc17e", (String)"\u9879\u76ee\u8bbe\u7f6e\u7684\u5f00\u6807\u5bc6\u7801\uff0c\u4e0d\u5141\u8bb8\u81ea\u52a8\u5f00\u6807"));
        }
        String tenderCheckType = TenderFlagInjectionContext.getTenderCheckType();
        String tenderProcessType = TenderFlagInjectionContext.getTenderProcessType();
        String currentStep = TenderFlagInjectionContext.getTenderCurrentStep();
        if (SubpackageBidOpenTypeEnum.ON_LINE.getValue().equals(subpackageInfo.getBidOpenType())) {
            Date openBiddingTime = null;
            openBiddingTime = SubpackageInfoCheckTypeEnum.POST_TRIAL.getValue().equals(tenderCheckType) && SubpackageInfoProcessTypeEnum.TWO_STEP.getValue().equals(tenderProcessType) && SubpackageInfoCurrentStepEnum.SECOND_STEP.getValue().equals(currentStep) ? purchaseTenderProjectOpenSettingHead.getOpenBiddingTime() : subpackageInfo.getOpenBiddingTime();
            Assert.isTrue((openBiddingTime != null ? 1 : 0) != 0, (String)I18nUtil.translate((String)"i18n_field_vBKIxOLVW_cb5d460c", (String)"\u5f00\u6807\u65f6\u95f4\u4e0d\u80fd\u4e3a\u7a7a\uff01"));
            TenderJobUtil.createOrUpdateOpenBidForewarningAlertJob(subpackageInfo, openBiddingTime);
            if ("1".equals(purchaseTenderProjectOpenSettingHead.getAutoOpenBid())) {
                TenderJobUtil.createOrUpdateOpenBidAlertJob(subpackageInfo, openBiddingTime);
            }
        }
        TenderOperationFieldUtils.setOpenBidStatus((Object)subpackageInfo, PurchaseOpenBidStatusEnum.NOT_OPEN_BID.getValue());
        TenderOperationFieldUtils.setFieldValue((Object)subpackageInfo, purchaseTenderProjectOpenSettingHead.getAnnoQuote(), "annoQuote");
        if (SubpackageInfoCheckTypeEnum.POST_TRIAL.getValue().equals(tenderCheckType) && SubpackageInfoProcessTypeEnum.TWO_STEP.getValue().equals(tenderProcessType) && SubpackageInfoCurrentStepEnum.SECOND_STEP.getValue().equals(currentStep)) {
            subpackageInfo.setResultOpenBiddingTime(purchaseTenderProjectOpenSettingHead.getOpenBiddingTime());
        }
        this.subpackageInfoService.updateById((Object)subpackageInfo);
    }
}

