/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.tender.process.service.impl;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.els.common.aspect.annotation.SrmTransaction;
import com.els.common.constant.CommonConstant;
import com.els.common.system.base.entity.BaseEntity;
import com.els.common.system.base.service.impl.BaseServiceImpl;
import com.els.common.util.ExpressUtils;
import com.els.common.util.I18nUtil;
import com.els.common.util.SpringContextUtils;
import com.els.common.util.SysUtil;
import com.els.common.vo.CountVO;
import com.els.config.mybatis.TenantContext;
import com.els.modules.base.api.dto.DictDTO;
import com.els.modules.base.api.service.BaseRpcService;
import com.els.modules.tender.common.utils.FastJsonUtils;
import com.els.modules.tender.evaluation.entity.TenderEvaluationTemplateHead;
import com.els.modules.tender.process.entity.TenderProcessModelHead;
import com.els.modules.tender.process.entity.TenderProcessModelNode;
import com.els.modules.tender.process.entity.TenderProcessModelNodeInfo;
import com.els.modules.tender.process.entity.TenderProcessNode;
import com.els.modules.tender.process.enumerate.TenderMustNodeEnum;
import com.els.modules.tender.process.enumerate.TenderNodeStateEnum;
import com.els.modules.tender.process.enumerate.TenderProcessModelHeadStateEnum;
import com.els.modules.tender.process.enumerate.TenderProcessNodeCheckStateEnum;
import com.els.modules.tender.process.enumerate.TenderProcessNodePeriodTypeNum;
import com.els.modules.tender.process.mapper.TenderProcessModelHeadMapper;
import com.els.modules.tender.process.service.TenderProcessModelHeadService;
import com.els.modules.tender.process.service.TenderProcessModelNodeService;
import com.els.modules.tender.process.service.TenderProcessNodeService;
import com.els.modules.tender.process.vo.TenderProcessModelHeadVO;
import com.els.modules.tender.process.vo.TenderProcessNodeAuditVO;
import com.els.modules.tender.process.vo.TenderProcessNodeGroupVO;
import com.els.modules.tender.process.vo.TenderProcessNodeInfoVO;
import com.els.modules.tender.process.vo.TenderProcessNodeVO;
import com.els.modules.tender.project.entity.PurchaseTenderProjectSubpackageInfo;
import com.els.modules.tender.project.enumerate.SubpackageInfoCheckTypeEnum;
import com.els.modules.tender.project.enumerate.TenderProjectSubpackageStatusEnum;
import com.els.modules.tender.project.enumerate.TenderRoleEnum;
import com.els.modules.tender.project.service.PurchaseTenderProjectSubpackageInfoService;
import com.els.modules.tender.supplier.entity.TenderProjectSupplier;
import com.els.modules.tender.supplier.service.TenderProjectSupplierService;
import com.els.rpc.service.InvokeBaseRpcService;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;

@Service
public class TenderProcessModelHeadServiceImpl
extends BaseServiceImpl<TenderProcessModelHeadMapper, TenderProcessModelHead>
implements TenderProcessModelHeadService {
    private static final Logger log = LoggerFactory.getLogger(TenderProcessModelHeadServiceImpl.class);
    @Autowired
    private TenderProcessModelNodeService tenderProcessModelNodeService;
    @Autowired
    private TenderProcessNodeService tenderProcessNodeService;
    @Resource
    private InvokeBaseRpcService invokeBaseRpcService;
    @Autowired
    private PurchaseTenderProjectSubpackageInfoService subpackageInfoService;
    @Autowired
    @Lazy
    private TenderProjectSupplierService supplierService;

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void saveMain(TenderProcessModelHead tenderProcessModelHead, List<String> nodeIds) {
        tenderProcessModelHead.setTenderProcessNumber(this.invokeBaseRpcService.getNextCode("tenderProcessModelNumber", (Object)tenderProcessModelHead));
        tenderProcessModelHead.setStatus(TenderProcessModelHeadStateEnum.STATE_OFF.getValue());
        ((TenderProcessModelHeadMapper)this.baseMapper).insert((Object)tenderProcessModelHead);
        super.setHeadDefaultValue((BaseEntity)tenderProcessModelHead);
        this.insertData(tenderProcessModelHead, nodeIds);
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void updateMain(TenderProcessModelHead tenderProcessModelHead, List<String> nodeIds) {
        TenderProcessModelHead modelHead = (TenderProcessModelHead)((Object)((TenderProcessModelHeadMapper)this.baseMapper).selectById((Serializable)((Object)tenderProcessModelHead.getId())));
        Assert.isTrue((boolean)ObjectUtil.isNotEmpty((Object)((Object)modelHead)), (String)I18nUtil.translate((String)"i18n_field_WFxMKW_b697ca02", (String)"\u6570\u636e\u4e0d\u5b58\u5728\uff01"));
        int count = ((TenderProcessModelHeadMapper)this.baseMapper).updateById((Object)tenderProcessModelHead);
        Assert.isTrue((count != 0 ? 1 : 0) != 0, (String)I18nUtil.translate((String)"i18n_alert_APWFIKXWVVVXVSDJHrW_2fe92d52", (String)"\u5f53\u524d\u6570\u636e\u5df2\u5931\u6548\uff0c\u8bf7\u91cd\u65b0\u5237\u65b0\u540e\u63d0\u4ea4\u66f4\u6539\uff01"));
        this.tenderProcessModelNodeService.deleteByMainId(tenderProcessModelHead.getId());
        this.insertData(tenderProcessModelHead, nodeIds);
    }

    private void insertData(TenderProcessModelHead tenderProcessModelHead, List<String> nodeIds) {
        ArrayList<TenderProcessModelNode> tenderProcessModelNodeList = new ArrayList<TenderProcessModelNode>();
        List<Object> tenderProcessNodes = new ArrayList();
        if (!nodeIds.isEmpty()) {
            tenderProcessNodes = this.tenderProcessNodeService.selectBatchIds(nodeIds);
        }
        TenderProcessNodeGroupVO tenderProcessNodeGroupVO = this.queryByGruop(tenderProcessModelHead);
        Map<String, List<TenderProcessNodeVO>> mustNode = tenderProcessNodeGroupVO.getMustNode();
        Assert.isTrue((boolean)ObjectUtil.isNotEmpty(mustNode), (String)I18nUtil.translate((String)"i18n_field_WFxMKW_b697c", (String)"\u6d41\u7a0b\u8282\u70b9\u5fc5\u987b\u8282\u70b9\u4e0d\u80fd\u4e3a\u7a7a\uff01"));
        for (List<TenderProcessNodeVO> list : mustNode.values()) {
            tenderProcessNodes.addAll(SysUtil.copyProperties(list, TenderProcessNode.class));
        }
        for (TenderProcessNode tenderProcessNode : tenderProcessNodes) {
            TenderProcessModelNode tenderProcessModelNode = new TenderProcessModelNode();
            tenderProcessModelNode.setNodeId(tenderProcessNode.getId());
            tenderProcessModelNode.setHeadId(tenderProcessModelHead.getId());
            tenderProcessModelNode.setDeleted(CommonConstant.DEL_FLAG_0);
            tenderProcessModelNode.setNodeName(tenderProcessNode.getNodeName());
            tenderProcessModelNode.setPeriodType(tenderProcessNode.getPeriodType());
            tenderProcessModelNode.setStatus(tenderProcessModelHead.getStatus());
            tenderProcessModelNodeList.add(tenderProcessModelNode);
            SysUtil.setSysParam((BaseEntity)tenderProcessModelNode, (BaseEntity)tenderProcessModelHead);
        }
        this.tenderProcessModelNodeService.saveBatch(tenderProcessModelNodeList, 2000);
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void deleteMain(String id) {
        this.tenderProcessModelNodeService.deleteByMainId(id);
        ((TenderProcessModelHeadMapper)this.baseMapper).deleteById((Serializable)((Object)id));
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void deleteBatchMain(List<String> idList) {
        for (Serializable serializable : idList) {
            this.tenderProcessModelNodeService.deleteByMainId(serializable.toString());
            ((TenderProcessModelHeadMapper)this.baseMapper).deleteById(serializable);
        }
    }

    private void checkAndSetParam(TenderProcessModelHead tenderProcessModelHead) {
        Assert.isTrue((boolean)StrUtil.isNotBlank((CharSequence)tenderProcessModelHead.getBidOpenType()), (String)I18nUtil.translate((String)"i18n_field_vBCKxOLVW_8409d754", (String)"\u5f00\u6807\u65b9\u5f0f\u4e0d\u80fd\u4e3a\u7a7a\uff01"));
        Assert.isTrue((boolean)StrUtil.isNotBlank((CharSequence)tenderProcessModelHead.getEvaluationType()), (String)I18nUtil.translate((String)"i18n_field_UBCKxOLVW_cb830018", (String)"\u8bc4\u6807\u65b9\u5f0f\u4e0d\u80fd\u4e3a\u7a7a\uff01"));
        tenderProcessModelHead.setDeleted(CommonConstant.DEL_FLAG_0);
        tenderProcessModelHead.setStatus(TenderProcessModelHeadStateEnum.STATE_OFF.getValue());
    }

    @Override
    public List<TenderProcessModelHead> selectBatchIds(List<String> tenderProcessModelIdList) {
        return ((TenderProcessModelHeadMapper)this.baseMapper).selectBatchIds(tenderProcessModelIdList);
    }

    @Override
    public List<TenderProcessModelHeadVO> querryListDetail() {
        LambdaQueryWrapper qw = new LambdaQueryWrapper();
        qw.eq(BaseEntity::getElsAccount, (Object)TenantContext.getTenant());
        List tenderProcessModelHeads = ((TenderProcessModelHeadMapper)this.baseMapper).selectList((Wrapper)qw);
        if (CollectionUtil.isEmpty((Collection)tenderProcessModelHeads)) {
            qw.clear();
            qw.eq(BaseEntity::getElsAccount, (Object)"100000");
            tenderProcessModelHeads = ((TenderProcessModelHeadMapper)this.baseMapper).selectList((Wrapper)qw);
        }
        if (CollectionUtil.isEmpty((Collection)tenderProcessModelHeads)) {
            return null;
        }
        List headIds = tenderProcessModelHeads.stream().map(BaseEntity::getId).collect(Collectors.toList());
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.in(TenderProcessModelNode::getHeadId, headIds);
        List tenderProcessModelNodes = this.tenderProcessModelNodeService.list((Wrapper)queryWrapper);
        Map<String, List<TenderProcessModelNode>> tenderProcessModelItemMap = tenderProcessModelNodes.stream().collect(Collectors.groupingBy(TenderProcessModelNode::getHeadId));
        List tenderProcessModelHeadVOS = BeanUtil.copyToList((Collection)tenderProcessModelHeads, TenderProcessModelHeadVO.class);
        tenderProcessModelHeadVOS.forEach(headVO -> headVO.setTenderProcessModelNodeList((List)tenderProcessModelItemMap.get(headVO.getId())));
        return tenderProcessModelHeadVOS;
    }

    @Override
    public TenderProcessNodeGroupVO queryByGruop(TenderProcessModelHead tenderProcessModelHead) {
        BaseRpcService baseRpcService;
        List dictDTOS;
        LambdaQueryWrapper qw = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)((LambdaQueryWrapper)qw.eq(BaseEntity::getElsAccount, (Object)TenantContext.getTenant())).orderByAsc(TenderProcessNode::getSortOrder)).orderByDesc(BaseEntity::getCreateTime);
        List tenderProcessNodes = this.tenderProcessNodeService.list((Wrapper)qw);
        TenderProcessNodeGroupVO tenderProcessNodeGroupVO = new TenderProcessNodeGroupVO();
        if (CollectionUtil.isEmpty((Collection)tenderProcessNodes)) {
            qw.clear();
            ((LambdaQueryWrapper)((LambdaQueryWrapper)qw.eq(BaseEntity::getElsAccount, (Object)"100000")).orderByAsc(TenderProcessNode::getSortOrder)).orderByDesc(BaseEntity::getCreateTime);
            tenderProcessNodes = this.tenderProcessNodeService.list((Wrapper)qw);
        }
        if (CollectionUtil.isEmpty((Collection)tenderProcessNodes)) {
            return tenderProcessNodeGroupVO;
        }
        boolean hasPreExamine = SubpackageInfoCheckTypeEnum.PRE_TRIAL.getValue().equals(tenderProcessModelHead.getCheckType());
        if (!hasPreExamine) {
            tenderProcessNodes = tenderProcessNodes.stream().filter(tenderProcessNode -> !TenderProcessNodePeriodTypeNum.PRELIMINARY_HEARING.getValue().equals(tenderProcessNode.getPeriodType())).collect(Collectors.toList());
        }
        ArrayList<TenderProcessNode> tenderProcessNodeTemp = new ArrayList<TenderProcessNode>();
        for (TenderProcessNode tenderProcessNode2 : tenderProcessNodes) {
            if (!StrUtil.isNotBlank((CharSequence)tenderProcessNode2.getShowCondition())) {
                tenderProcessNodeTemp.add(tenderProcessNode2);
                continue;
            }
            boolean expressRessult = ExpressUtils.getExpressRessult((String)tenderProcessNode2.getShowCondition(), (Map)FastJsonUtils.toMap((Object)tenderProcessModelHead));
            if (!expressRessult) continue;
            tenderProcessNodeTemp.add(tenderProcessNode2);
        }
        if (CollectionUtil.isEmpty(tenderProcessNodeTemp)) {
            return tenderProcessNodeGroupVO;
        }
        List tenderProcessNodeVOS = BeanUtil.copyToList(tenderProcessNodeTemp, TenderProcessNodeVO.class);
        if (StrUtil.isNotBlank((CharSequence)tenderProcessModelHead.getId())) {
            List nodeIds = tenderProcessNodeVOS.stream().map(BaseEntity::getId).collect(Collectors.toList());
            QueryWrapper queryWrapper = new QueryWrapper();
            queryWrapper.in((Object)"node_id", nodeIds);
            queryWrapper.eq((Object)"head_id", (Object)tenderProcessModelHead.getId());
            List tenderProcessModelNodes = this.tenderProcessModelNodeService.list((Wrapper)queryWrapper);
            if (CollectionUtil.isNotEmpty((Collection)tenderProcessModelNodes)) {
                Map<String, TenderProcessModelNode> tenderProcessNodeMap = tenderProcessModelNodes.stream().collect(Collectors.toMap(TenderProcessModelNode::getNodeId, item -> item, (o1, o2) -> o1));
                tenderProcessNodeVOS.forEach(node -> {
                    node.setNodeName(I18nUtil.translate((String)node.getI18nKey(), (String)node.getNodeName()));
                    TenderProcessModelNode tenderProcessModelNode = (TenderProcessModelNode)((Object)((Object)tenderProcessNodeMap.get(node.getId())));
                    if (tenderProcessModelNode != null) {
                        node.setCheckState(TenderProcessNodeCheckStateEnum.CHECK.getValue());
                    }
                });
            }
        }
        Map<String, List<TenderProcessNodeVO>> tenderProcessNodeGroupVoMap = tenderProcessNodeVOS.stream().collect(Collectors.groupingBy(TenderProcessNode::getMustNode));
        List<TenderProcessNodeVO> notMustNodes = tenderProcessNodeGroupVoMap.get(TenderMustNodeEnum.NO.getValue());
        List<TenderProcessNodeVO> mustNodes = tenderProcessNodeGroupVoMap.get(TenderMustNodeEnum.YES.getValue());
        if (CollectionUtil.isNotEmpty(notMustNodes)) {
            Map<String, List<TenderProcessNodeVO>> notMustNodeMap = notMustNodes.stream().collect(Collectors.groupingBy(TenderProcessNode::getPeriodType));
            tenderProcessNodeGroupVO.setNotMustNode(notMustNodeMap);
        }
        if (CollectionUtil.isNotEmpty(mustNodes)) {
            Map<String, List<TenderProcessNodeVO>> mustNodeMap = mustNodes.stream().collect(Collectors.groupingBy(TenderProcessNode::getPeriodType));
            tenderProcessNodeGroupVO.setMustNode(mustNodeMap);
        }
        if (CollectionUtil.isNotEmpty((Collection)(dictDTOS = (baseRpcService = (BaseRpcService)SpringContextUtils.getBean(BaseRpcService.class)).queryDictItemsByCode("tenderPeriodType", tenderProcessModelHead.getId())))) {
            HashMap<String, Object> periodTypeInfo = new HashMap<String, Object>();
            dictDTOS.forEach(dictDTO -> periodTypeInfo.put(dictDTO.getValue(), I18nUtil.translate((String)dictDTO.getTextI18nKey(), (String)dictDTO.getText())));
            if (!hasPreExamine) {
                periodTypeInfo.remove("100");
            }
            tenderProcessNodeGroupVO.setPeriodTypeInfo(periodTypeInfo);
        }
        return tenderProcessNodeGroupVO;
    }

    @Override
    public List<TenderProcessNodeInfoVO> queryProcessNodeBySubpackageId(String subpackageId, String applyRole) {
        PurchaseTenderProjectSubpackageInfo subpackageInfo = (PurchaseTenderProjectSubpackageInfo)((Object)this.subpackageInfoService.getById((Serializable)((Object)subpackageId)));
        List<TenderProcessModelNodeInfo> modelNodeInfoList = this.tenderProcessModelNodeService.selectByMainIds(Arrays.asList(subpackageInfo.getTenderProcessModelId()));
        Iterator<TenderProcessModelNodeInfo> iterator = modelNodeInfoList.iterator();
        while (iterator.hasNext()) {
            TenderProcessModelNodeInfo next = iterator.next();
            if (StrUtil.isNotBlank((CharSequence)next.getApplyRole())) {
                ArrayList<String> applyRoleList = new ArrayList<String>();
                applyRoleList.addAll(Arrays.asList(next.getApplyRole().split(",")));
                if (!applyRoleList.contains(applyRole)) {
                    iterator.remove();
                    continue;
                }
            }
            next.setNodeName(I18nUtil.translate((String)next.getI18nKey(), (String)next.getNodeName()));
        }
        Map<String, List<TenderProcessModelNodeInfo>> proidNodeMap = modelNodeInfoList.parallelStream().collect(Collectors.groupingBy(TenderProcessModelNode::getPeriodType));
        BaseRpcService baseRpcService = (BaseRpcService)SpringContextUtils.getBean(BaseRpcService.class);
        List tenderPeriodTypeList = baseRpcService.queryDictItemsByCode("tenderPeriodType", TenantContext.getTenant());
        ArrayList<TenderProcessNodeInfoVO> result = new ArrayList<TenderProcessNodeInfoVO>();
        for (DictDTO dictDTO : tenderPeriodTypeList) {
            List<TenderProcessModelNodeInfo> nodeInfoList = proidNodeMap.get(dictDTO.getValue());
            if (nodeInfoList == null) continue;
            nodeInfoList.stream().forEach(nodeInfo -> {
                if (nodeInfo.getSortOrder() == null) {
                    nodeInfo.setSortOrder(Integer.MAX_VALUE);
                }
            });
            nodeInfoList.sort(Comparator.comparing(TenderProcessModelNodeInfo::getSortOrder));
            TenderProcessNodeInfoVO nodeVO = TenderProcessNodeInfoVO.builder().nodeList(nodeInfoList).name(I18nUtil.translate((String)dictDTO.getTextI18nKey(), (String)dictDTO.getText())).value(dictDTO.getValue()).build();
            result.add(nodeVO);
        }
        return result;
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void publish(String id) {
        TenderProcessModelHead tenderProcessModelHead = (TenderProcessModelHead)((Object)((TenderProcessModelHeadMapper)this.baseMapper).selectById((Serializable)((Object)id)));
        this.checkAndSetParam(tenderProcessModelHead);
        Assert.isTrue((boolean)ObjectUtil.isNotEmpty((Object)((Object)tenderProcessModelHead)), (String)I18nUtil.translate((String)"i18n_field_WFxMKW_b697ca02", (String)"\u6570\u636e\u4e0d\u5b58\u5728\uff01"));
        Assert.isTrue((boolean)TenderProcessModelHeadStateEnum.STATE_OFF.getValue().equals(tenderProcessModelHead.getStatus()), (String)I18nUtil.translate((String)"i18n_field_IbXxqhxW_e8c1ed92", (String)"\u5df2\u751f\u6548\u4e0d\u53ef\u53d1\u5e03"));
        tenderProcessModelHead.setStatus(TenderProcessModelHeadStateEnum.STATE_ON.getValue());
        ((TenderProcessModelHeadMapper)this.baseMapper).updateById((Object)tenderProcessModelHead);
    }

    @Override
    public List<CountVO> queryTabsCount(String elsAccount, QueryWrapper<TenderEvaluationTemplateHead> queryWrapper) {
        return ((TenderProcessModelHeadMapper)this.baseMapper).queryTabsCount(elsAccount, queryWrapper);
    }

    @Override
    public TenderProcessNodeAuditVO queryProcessNodeAuditBySubpackageId(String subpackageId, String nodeId, String applyRole) {
        TenderProcessNodeAuditVO nodeAuditVO = new TenderProcessNodeAuditVO();
        TenderProcessNode processNode = (TenderProcessNode)((Object)this.tenderProcessNodeService.getById((Serializable)((Object)nodeId)));
        if (!processNode.getApplyRole().contains(applyRole)) {
            nodeAuditVO.setNodeAuditStatus("0");
            return nodeAuditVO;
        }
        PurchaseTenderProjectSubpackageInfo purchaseTenderProjectSubpackageInfo = this.subpackageInfoService.selectById(subpackageId);
        if (TenderRoleEnum.BIDING_ORG.getValue().equals(applyRole) && SubpackageInfoCheckTypeEnum.PRE_TRIAL.getValue().equals(purchaseTenderProjectSubpackageInfo.getCheckType()) && !TenderProcessNodePeriodTypeNum.PRELIMINARY_HEARING.getValue().equals(processNode.getPeriodType()) && !TenderProcessNodePeriodTypeNum.OTHER.getValue().equals(processNode.getPeriodType())) {
            TenderProjectSupplier supplierVO = new TenderProjectSupplier();
            supplierVO.setSubpackageId(subpackageId);
            supplierVO.setPreShortlisted("1");
            List<TenderProjectSupplier> tenderProjectSuppliers = this.supplierService.selectBySubpackageId(supplierVO);
            List preShortlistedSupplierAccount = tenderProjectSuppliers.stream().map(TenderProjectSupplier::getSupplierAccount).collect(Collectors.toList());
            if (!preShortlistedSupplierAccount.contains(TenantContext.getTenant())) {
                nodeAuditVO.setNodeAuditStatus("2");
                nodeAuditVO.setSubpackageStatusDesc(I18nUtil.translate((String)"i18n_alert_LLeRJmUUWShsUSTYBSyW_57cc96fa", (String)"\u60a8\u672a\u901a\u8fc7\u8d44\u683c\u9884\u5ba1\uff0c\u65e0\u6cd5\u53c2\u4e0e\u540e\u7eed\u62db\u6807\u73af\u8282\uff01"));
                return nodeAuditVO;
            }
        }
        HashMap<String, Map> params = new HashMap<String, Map>();
        params.put("item", FastJsonUtils.toMap((Object)purchaseTenderProjectSubpackageInfo));
        params.putAll(FastJsonUtils.toMap((Object)purchaseTenderProjectSubpackageInfo));
        boolean expressRessult = ExpressUtils.getExpressRessult((String)processNode.getOperationCondition(), params);
        nodeAuditVO.setNodeAuditStatus(expressRessult ? "1" : "0");
        TenderProjectSubpackageStatusEnum statusEnum = TenderProjectSubpackageStatusEnum.getSubpackageStatus(purchaseTenderProjectSubpackageInfo.getStatus());
        if (StrUtil.isNotBlank((CharSequence)statusEnum.getTip())) {
            nodeAuditVO.setSubpackageStatusDesc(statusEnum.getDesc() + "\uff0c" + statusEnum.getTip());
        } else {
            nodeAuditVO.setSubpackageStatusDesc(statusEnum.getDesc());
        }
        nodeAuditVO.setSubpackageStatus("" + purchaseTenderProjectSubpackageInfo.getStatus());
        nodeAuditVO.setNodeAuditStatus(expressRessult ? TenderNodeStateEnum.ENABLE.getValue() : TenderNodeStateEnum.DISABLED.getValue());
        return nodeAuditVO;
    }
}

