/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.tender.project.adapter;

import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.els.aspect.param.DictTranslateAspectParam;
import com.els.common.api.vo.Result;
import com.els.common.aspect.annotation.RpcService;
import com.els.common.enumerate.AuditStatusEnum;
import com.els.common.service.DictTranslateService;
import com.els.common.system.vo.MsgParamsVO;
import com.els.common.util.MqUtil;
import com.els.common.util.SpringContextUtils;
import com.els.common.util.SysUtil;
import com.els.config.mybatis.TenantContext;
import com.els.modules.account.api.dto.ElsSubAccountDTO;
import com.els.modules.tender.project.entity.PurchaseTenderSubpackagePriceChange;
import com.els.modules.tender.project.service.PurchaseTenderProjectHeadService;
import com.els.modules.tender.project.service.PurchaseTenderSubpackagePriceChangeService;
import com.els.modules.tender.project.vo.PurchaseTenderProjectHeadVO;
import com.els.modules.tender.project.vo.PurchaseTenderSubpackagePriceChangeSubmitVo;
import com.els.modules.workflow.dto.AuditInputParamDTO;
import com.els.modules.workflow.dto.AuditOutputParamDTO;
import com.els.modules.workflow.enums.WorkFlowType;
import com.els.modules.workflow.rpc.service.AuditOptCallBackService;
import com.els.rpc.service.InvokeAccountRpcService;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;

@RpcService(value="subpackagePriceChangeAuditCallBackServiceImpl")
public class PurchaseSubpackagePriceChangeAdapter
implements AuditOptCallBackService {
    @Resource
    private PurchaseTenderSubpackagePriceChangeService priceChangeService;
    @Resource
    private PurchaseTenderProjectHeadService headService;
    @Resource
    private InvokeAccountRpcService invokeAccountRpcService;

    public void startCallBack(AuditInputParamDTO inputParamDTO, AuditOutputParamDTO outputParamDTO) {
        this.updateAuditStatus(inputParamDTO, outputParamDTO);
        Object operataion = "submitAudit";
        if (WorkFlowType.BPMN.getValue().equals(outputParamDTO.getBpmnType())) {
            operataion = outputParamDTO.getBpmnType() + "_submitAudit";
        }
        this.sendMsg(inputParamDTO, outputParamDTO, (String)operataion);
    }

    public void completeCallBack(AuditInputParamDTO inputParamDTO, AuditOutputParamDTO outputParamDTO) {
        this.updateAuditStatus(inputParamDTO, outputParamDTO);
        if (AuditStatusEnum.AUDIT_FINISH.getValue().equals(outputParamDTO.getAuditStatus())) {
            String param = StrUtil.isBlank((CharSequence)inputParamDTO.getParams()) ? "{}" : inputParamDTO.getParams();
            PurchaseTenderSubpackagePriceChangeSubmitVo priceChangeSubmitVo = (PurchaseTenderSubpackagePriceChangeSubmitVo)((Object)JSONObject.parseObject((String)param, PurchaseTenderSubpackagePriceChangeSubmitVo.class));
            List<PurchaseTenderSubpackagePriceChange> subpackagePriceChanges = priceChangeSubmitVo.getSubpackagePriceChanges();
            this.priceChangeService.updateSubpackageInfoAndChangeInfo(subpackagePriceChanges);
            this.sendMsg(inputParamDTO, outputParamDTO, "auditPass");
        } else {
            this.sendMsg(inputParamDTO, outputParamDTO, "submitAudit");
        }
    }

    public void rejectCallBack(AuditInputParamDTO inputParamDTO, AuditOutputParamDTO outputParamDTO) {
        this.updateAuditStatus(inputParamDTO, outputParamDTO);
        this.sendMsg(inputParamDTO, outputParamDTO, "auditReject");
    }

    public void cancelCallBack(AuditInputParamDTO inputParamDTO, AuditOutputParamDTO outputParamDTO) {
        this.updateAuditStatus(inputParamDTO, outputParamDTO);
    }

    public JSONObject getDataById(String id) {
        PurchaseTenderProjectHeadVO head = this.headService.queryById(id);
        if (head != null) {
            Result result = Result.ok((Object)((Object)head));
            JSONObject jsonObject = ((DictTranslateService)SpringContextUtils.getBean(DictTranslateService.class)).parseJson((Object)head, new DictTranslateAspectParam());
            return jsonObject;
        }
        return null;
    }

    private void updateAuditStatus(AuditInputParamDTO inputParamDTO, AuditOutputParamDTO outputParamDTO) {
        String param = StrUtil.isBlank((CharSequence)inputParamDTO.getParams()) ? "{}" : inputParamDTO.getParams();
        PurchaseTenderSubpackagePriceChangeSubmitVo priceChangeSubmitVo = (PurchaseTenderSubpackagePriceChangeSubmitVo)((Object)JSONObject.parseObject((String)param, PurchaseTenderSubpackagePriceChangeSubmitVo.class));
        List<PurchaseTenderSubpackagePriceChange> subpackagePriceChanges = priceChangeSubmitVo.getSubpackagePriceChanges();
        subpackagePriceChanges.forEach(x -> {
            x.setFlowId(outputParamDTO.getProcessRootId());
            x.setAuditStatus(outputParamDTO.getAuditStatus());
            x.setWorkFlowType(outputParamDTO.getBpmnType());
        });
        this.priceChangeService.saveOrUpdateBatch(subpackagePriceChanges);
    }

    private void sendMsg(AuditInputParamDTO inputParamDTO, AuditOutputParamDTO outputParamDTO, String optType) {
        String elsAccount = TenantContext.getTenant();
        if (AuditStatusEnum.AUDIT_FINISH.getValue().equals(outputParamDTO.getAuditStatus())) {
            MsgParamsVO msgParamsVO = this.parameterAssemble(inputParamDTO, outputParamDTO, outputParamDTO.getSubmitUser());
            MqUtil.sendBusMsg((String)elsAccount, (String)inputParamDTO.getBusinessType(), (String)optType, (MsgParamsVO)msgParamsVO);
        } else {
            List accountList = outputParamDTO.getNextAuditUserList();
            for (String account : accountList) {
                MsgParamsVO msgParamsVO = this.parameterAssemble(inputParamDTO, outputParamDTO, account);
                MqUtil.sendBusMsg((String)elsAccount, (String)inputParamDTO.getBusinessType(), (String)optType, (MsgParamsVO)msgParamsVO);
            }
        }
    }

    private MsgParamsVO parameterAssemble(AuditInputParamDTO inputParamDTO, AuditOutputParamDTO outputParamDTO, String account) {
        MsgParamsVO msgParamsVO = new MsgParamsVO();
        ArrayList<ElsSubAccountDTO> accountList = new ArrayList<ElsSubAccountDTO>();
        HashMap<String, ArrayList<ElsSubAccountDTO>> receiverMap = new HashMap<String, ArrayList<ElsSubAccountDTO>>();
        ElsSubAccountDTO subAccount = this.invokeAccountRpcService.getAccount(TenantContext.getTenant(), account.split("_")[1]);
        accountList.add(subAccount);
        receiverMap.put(TenantContext.getTenant(), accountList);
        msgParamsVO.setReceiverMap(receiverMap);
        String businessType = inputParamDTO.getBusinessType();
        String flowId = outputParamDTO.getProcessRootId();
        String headId = inputParamDTO.getBusinessId();
        String outAuditPassUrl = SysUtil.getOutAuditPassUrl((ElsSubAccountDTO)subAccount, (String)flowId, (String)businessType, (String)headId);
        String outAuditRejectUrl = SysUtil.getOutAuditRejectUrl((ElsSubAccountDTO)subAccount, (String)flowId, (String)businessType, (String)headId);
        PurchaseTenderProjectHeadVO headVO = this.headService.queryById(headId);
        JSONObject jsonObject = ((DictTranslateService)SpringContextUtils.getBean(DictTranslateService.class)).parseJson((Object)headVO, new DictTranslateAspectParam());
        Map paramMap = (Map)JSON.parse((String)jsonObject.toString());
        paramMap.put("userName", subAccount.getRealname());
        paramMap.put("outAuditPassUrl", outAuditPassUrl);
        paramMap.put("outAuditRejectUrl", outAuditRejectUrl);
        msgParamsVO.setParams((Object)paramMap);
        HashMap<String, JSONObject> receiveParamMap = new HashMap<String, JSONObject>();
        JSONObject paramObj = new JSONObject();
        paramObj.put("businessId", (Object)inputParamDTO.getBusinessId());
        paramObj.put("businessType", (Object)inputParamDTO.getBusinessType());
        if (account.split("_").length > 2) {
            paramObj.put("taskId", (Object)account.split("_")[2]);
        }
        if (account.split("_").length > 3) {
            paramObj.put("processInstanceId", (Object)account.split("_")[3]);
        }
        receiveParamMap.put(TenantContext.getTenant(), paramObj);
        msgParamsVO.setReceiveParamMap(receiveParamMap);
        return msgParamsVO;
    }
}

