/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.tender.sale.controller;

import cn.hutool.core.collection.CollectionUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.els.common.api.vo.Result;
import com.els.common.aspect.annotation.AutoLog;
import com.els.common.aspect.annotation.SrmValidated;
import com.els.common.system.base.controller.BaseController;
import com.els.common.system.query.QueryGenerator;
import com.els.common.util.SysUtil;
import com.els.modules.account.api.dto.LoginUserDTO;
import com.els.modules.tender.common.aspect.TenderPermissions;
import com.els.modules.tender.project.enumerate.TenderRoleEnum;
import com.els.modules.tender.project.service.PurchaseTenderProjectHeadService;
import com.els.modules.tender.project.vo.PurchaseTenderProjectHeadVO;
import com.els.modules.tender.project.vo.PurchaseTenderProjectInfoVO;
import com.els.modules.tender.sale.entity.SaleTenderProjectMarginHead;
import com.els.modules.tender.sale.entity.SaleTenderProjectMarginItem;
import com.els.modules.tender.sale.entity.SaleTenderProjectRefund;
import com.els.modules.tender.sale.enumerate.TenderProjectMarginItemStatusEnum;
import com.els.modules.tender.sale.service.SaleTenderProjectMarginHeadService;
import com.els.modules.tender.sale.service.SaleTenderProjectMarginItemService;
import com.els.modules.tender.sale.service.SaleTenderProjectRefundService;
import com.els.modules.tender.sale.vo.SaleTenderProjectMarginHeadVO;
import com.els.modules.tender.sale.vo.SaleTenderProjectMarginItemVO;
import com.els.rpc.service.InvokeBaseRpcService;
import com.google.common.collect.Lists;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/tender/sale/saleTenderProjectMarginHead"})
@Api(tags={"\u4fdd\u8bc1\u91d1\u7f34\u7eb3\u4fe1\u606f\u884c\u5934-\u4f9b\u5e94\u5546"})
public class SaleTenderProjectMarginHeadController
extends BaseController<SaleTenderProjectMarginHead, SaleTenderProjectMarginHeadService> {
    private static final Logger log = LoggerFactory.getLogger(SaleTenderProjectMarginHeadController.class);
    @Autowired
    private SaleTenderProjectMarginHeadService saleTenderProjectMarginHeadService;
    @Autowired
    private SaleTenderProjectMarginItemService saleTenderProjectMarginItemService;
    @Autowired
    private SaleTenderProjectRefundService saleTenderProjectRefundService;
    @Autowired
    private PurchaseTenderProjectHeadService purchaseTenderProjectHeadService;
    @Resource
    private InvokeBaseRpcService invokeBaseRpcService;

    @ApiOperation(value="\u5206\u9875\u5217\u8868\u67e5\u8be2", notes="\u5206\u9875\u5217\u8868\u67e5\u8be2")
    @GetMapping(value={"/list"})
    @RequiresPermissions(value={"tender#tenderProject:list"})
    @TenderPermissions(value={TenderRoleEnum.BIDING_ORG})
    public Result<?> queryPageList(SaleTenderProjectMarginHead saleTenderProjectMarginHead, @RequestParam(name="pageNo", defaultValue="1") Integer pageNo, @RequestParam(name="pageSize", defaultValue="10") Integer pageSize, HttpServletRequest req) {
        QueryWrapper queryWrapper = QueryGenerator.initQueryWrapper((Object)((Object)saleTenderProjectMarginHead), (Map)req.getParameterMap());
        Page page = new Page((long)pageNo.intValue(), (long)pageSize.intValue());
        IPage pageList = this.saleTenderProjectMarginHeadService.page((IPage)page, (Wrapper)queryWrapper);
        return Result.ok((Object)pageList);
    }

    @ApiOperation(value="\u901a\u8fc7\u5206\u5305id\u67e5\u8be2", notes="\u901a\u8fc7\u5206\u5305id\u67e5\u8be2")
    @GetMapping(value={"/queryBySubpackageId"})
    @RequiresPermissions(value={"tender#tenderProject:queryById"})
    @TenderPermissions(value={TenderRoleEnum.BIDING_ORG})
    public Result<?> queryBySubpackageId(@RequestParam(name="subpackageId") String subpackageId, @RequestParam(name="supplierAccount") String supplierAccount) {
        LambdaQueryWrapper qw = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)qw.eq(SaleTenderProjectMarginHead::getSubpackageId, (Object)subpackageId)).eq(SaleTenderProjectMarginHead::getSupplierAccount, (Object)supplierAccount);
        List list = this.saleTenderProjectMarginHeadService.list((Wrapper)qw);
        if (CollectionUtil.isEmpty((Collection)list)) {
            return null;
        }
        SaleTenderProjectMarginHead saleTenderProjectMarginHead = (SaleTenderProjectMarginHead)((Object)list.get(0));
        SaleTenderProjectMarginHeadVO saleTenderProjectMarginHeadVO = (SaleTenderProjectMarginHeadVO)((Object)SysUtil.copyProperties((Object)((Object)saleTenderProjectMarginHead), SaleTenderProjectMarginHeadVO.class));
        PurchaseTenderProjectInfoVO purchaseTenderProjectInfoVO = this.purchaseTenderProjectHeadService.queryProjectInfoBySubpackageId(saleTenderProjectMarginHeadVO.getSubpackageId());
        saleTenderProjectMarginHeadVO.setSubpackageName(purchaseTenderProjectInfoVO.getSubpackageName());
        saleTenderProjectMarginHeadVO.setTenderProjectName(purchaseTenderProjectInfoVO.getTenderProjectName());
        saleTenderProjectMarginHeadVO.setTenderProjectNumber(purchaseTenderProjectInfoVO.getTenderProjectNumber());
        return Result.ok((Object)((Object)saleTenderProjectMarginHeadVO));
    }

    @AutoLog(busModule="\u4fdd\u8bc1\u91d1\u8bb0\u5f55\u6dfb\u52a0", value="\u4fdd\u8bc1\u91d1\u8bb0\u5f55\u6dfb\u52a0")
    @ApiOperation(value="\u4fdd\u8bc1\u91d1\u8bb0\u5f55\u6dfb\u52a0", notes="\u4fdd\u8bc1\u91d1\u8bb0\u5f55\u6dfb\u52a0")
    @PostMapping(value={"/addMargin"})
    @RequiresPermissions(value={"tender#tenderProject:add"})
    @SrmValidated
    public Result<?> addMargin(@RequestBody SaleTenderProjectMarginItemVO tenderProjectMarginItemVO) {
        tenderProjectMarginItemVO.setStatus(TenderProjectMarginItemStatusEnum.UNCONFIRMED.getValue());
        LoginUserDTO loginUser = SysUtil.getLoginUser();
        tenderProjectMarginItemVO.setSupplierAccount(loginUser.getElsAccount());
        tenderProjectMarginItemVO.setSupplierName(loginUser.getCompanyName());
        SaleTenderProjectMarginItem tenderProjectMarginItem = this.saleTenderProjectMarginHeadService.addMargin(tenderProjectMarginItemVO);
        return Result.ok((Object)((Object)tenderProjectMarginItem));
    }

    @AutoLog(busModule="\u4fdd\u8bc1\u91d1\u8bb0\u5f55\u4fee\u6539", value="\u4fdd\u8bc1\u91d1\u8bb0\u5f55\u4fee\u6539")
    @ApiOperation(value="\u4fdd\u8bc1\u91d1\u8bb0\u5f55\u4fee\u6539", notes="\u4fdd\u8bc1\u91d1\u8bb0\u5f55\u4fee\u6539")
    @PostMapping(value={"/editMargin"})
    @RequiresPermissions(value={"tender#tenderProject:edit"})
    @SrmValidated
    public Result<?> editMargin(@RequestBody SaleTenderProjectMarginItemVO tenderProjectMarginItemVO) {
        SaleTenderProjectMarginItem tenderProjectMarginItem = this.saleTenderProjectMarginHeadService.editMargin(tenderProjectMarginItemVO);
        return Result.ok((Object)((Object)tenderProjectMarginItem));
    }

    @AutoLog(busModule="\u4fdd\u8bc1\u91d1\u8bb0\u5f55\u63d0\u4ea4", value="\u4fdd\u8bc1\u91d1\u8bb0\u5f55\u63d0\u4ea4")
    @ApiOperation(value="\u4fdd\u8bc1\u91d1\u8bb0\u5f55\u63d0\u4ea4", notes="\u4fdd\u8bc1\u91d1\u8bb0\u5f55\u63d0\u4ea4")
    @PostMapping(value={"/submitMargin"})
    @RequiresPermissions(value={"tender#tenderProject:publish"})
    @SrmValidated
    public Result<?> submitMargin(@RequestBody SaleTenderProjectMarginItemVO tenderProjectMarginItemVO) {
        SaleTenderProjectMarginItem tenderProjectMarginItem = this.saleTenderProjectMarginHeadService.submitMargin(tenderProjectMarginItemVO);
        return Result.ok((Object)((Object)tenderProjectMarginItem));
    }

    @ApiOperation(value="\u67e5\u8be2\u4fdd\u8bc1\u91d1\u7f34\u7eb3\u4fe1\u606f\u5217\u8868", notes="\u67e5\u8be2\u4fdd\u8bc1\u91d1\u7f34\u7eb3\u4fe1\u606f\u5217\u8868")
    @GetMapping(value={"/queryItem"})
    @RequiresPermissions(value={"tender#tenderProject:queryById"})
    @TenderPermissions(value={TenderRoleEnum.BIDING_ORG})
    public Result<?> queryItem(SaleTenderProjectMarginItem tenderProjectMarginItem, HttpServletRequest req) {
        QueryWrapper queryWrapper = QueryGenerator.initQueryWrapper((Object)((Object)tenderProjectMarginItem), (Map)req.getParameterMap());
        List list = this.saleTenderProjectMarginItemService.list((Wrapper)queryWrapper);
        if (CollectionUtil.isEmpty((Collection)list)) {
            return Result.ok((Object)Lists.newArrayList());
        }
        PurchaseTenderProjectHeadVO projectHeadVO = this.purchaseTenderProjectHeadService.queryProjectHeadBySubpackageId(tenderProjectMarginItem.getSubpackageId());
        ArrayList marginItemVOList = SysUtil.copyProperties((List)list, SaleTenderProjectMarginItemVO.class);
        marginItemVOList.forEach(marginItemVO -> {
            List saleAttachmentDTOS = this.invokeBaseRpcService.selectSaleAttachmentByMainId(marginItemVO.getId());
            marginItemVO.setAttachmentDTOList(saleAttachmentDTOS);
            marginItemVO.setBusAccount(projectHeadVO.getElsAccount());
        });
        return Result.ok((Object)marginItemVOList);
    }

    @ApiOperation(value="\u67e5\u8be2\u4fdd\u8bc1\u91d1\u7f34\u7eb3\u4fe1\u606f\u660e\u7ec6", notes="\u67e5\u8be2\u4fdd\u8bc1\u91d1\u7f34\u7eb3\u4fe1\u606f\u660e\u7ec6")
    @GetMapping(value={"/queryItemById"})
    @RequiresPermissions(value={"tender#tenderProject:queryById"})
    public Result<?> queryItemById(@RequestParam(name="id") String id) {
        SaleTenderProjectMarginItem tenderProjectMarginItem = this.saleTenderProjectMarginItemService.selectById(id);
        if (tenderProjectMarginItem == null) {
            return Result.ok();
        }
        SaleTenderProjectMarginItemVO tenderProjectMarginItemVO = (SaleTenderProjectMarginItemVO)((Object)SysUtil.copyProperties((Object)((Object)tenderProjectMarginItem), SaleTenderProjectMarginItemVO.class));
        PurchaseTenderProjectInfoVO purchaseTenderProjectInfoVO = this.purchaseTenderProjectHeadService.queryProjectInfoBySubpackageId(tenderProjectMarginItem.getSubpackageId());
        tenderProjectMarginItemVO.setSubpackageName(purchaseTenderProjectInfoVO.getSubpackageName());
        tenderProjectMarginItemVO.setTenderProjectName(purchaseTenderProjectInfoVO.getTenderProjectName());
        tenderProjectMarginItemVO.setTenderProjectNumber(purchaseTenderProjectInfoVO.getTenderProjectNumber());
        List saleAttachmentDTOS = this.invokeBaseRpcService.selectSaleAttachmentByMainId(tenderProjectMarginItemVO.getId());
        tenderProjectMarginItemVO.setAttachmentDTOList(saleAttachmentDTOS);
        return Result.ok((Object)((Object)tenderProjectMarginItemVO));
    }

    @ApiOperation(value="\u67e5\u8be2\u4fdd\u8bc1\u91d1\u9000\u6b3e\u4fe1\u606f\u5217\u8868", notes="\u67e5\u8be2\u4fdd\u8bc1\u91d1\u9000\u6b3e\u4fe1\u606f\u5217\u8868")
    @GetMapping(value={"/queryRefund"})
    @RequiresPermissions(value={"tender#tenderProject:list"})
    @TenderPermissions(value={TenderRoleEnum.BIDING_ORG})
    public Result<?> queryRefund(SaleTenderProjectRefund tenderProjectRefund, HttpServletRequest req) {
        QueryWrapper queryWrapper = QueryGenerator.initQueryWrapper((Object)((Object)tenderProjectRefund), (Map)req.getParameterMap());
        List list = this.saleTenderProjectRefundService.list((Wrapper)queryWrapper);
        return Result.ok((Object)list);
    }
}

