/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.tender.sale.service.impl;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.els.api.dto.ParentEntityDTO;
import com.els.common.aspect.annotation.SrmTransaction;
import com.els.common.constant.CommonConstant;
import com.els.common.system.base.entity.BaseEntity;
import com.els.common.system.base.service.impl.BaseServiceImpl;
import com.els.common.util.I18nUtil;
import com.els.common.util.IPUtils;
import com.els.common.util.RedisUtil;
import com.els.common.util.SpringContextUtils;
import com.els.common.util.SysUtil;
import com.els.common.util.encryption.AesEncryptUtil;
import com.els.config.mybatis.TenantContext;
import com.els.modules.account.api.dto.ElsSubAccountDTO;
import com.els.modules.account.api.dto.ElsTenantDTO;
import com.els.modules.account.api.dto.LoginUserDTO;
import com.els.modules.base.api.dto.SaleAttachmentDTO;
import com.els.modules.tender.archive.enumerate.TenderProjectArchiveAttachmentEnum;
import com.els.modules.tender.archive.utils.ArchiveUtil;
import com.els.modules.tender.attachment.entity.CustomColumnModel;
import com.els.modules.tender.attachment.entity.PriceModel;
import com.els.modules.tender.attachment.entity.PurchaseTenderBidLetter;
import com.els.modules.tender.attachment.entity.PurchaseTenderPriceOpeningsTemplate;
import com.els.modules.tender.attachment.entity.PurchaseTenderQuoteMaterial;
import com.els.modules.tender.attachment.entity.SaleTenderQuoteMaterial;
import com.els.modules.tender.attachment.enumerate.BidLetterFormatQuoteTypeEnum;
import com.els.modules.tender.attachment.enumerate.BidLetterFormatTypeEnum;
import com.els.modules.tender.attachment.service.PurchaseTenderBidLetterService;
import com.els.modules.tender.attachment.service.PurchaseTenderPriceOpeningsTemplateService;
import com.els.modules.tender.attachment.service.PurchaseTenderProjectAttachmentHeadService;
import com.els.modules.tender.attachment.service.PurchaseTenderQuoteMaterialService;
import com.els.modules.tender.attachment.service.SaleTenderQuoteMaterialService;
import com.els.modules.tender.attachment.vo.PurchaseTenderBidLetterFormatGroupVO;
import com.els.modules.tender.attachment.vo.SaleQuoteMaterialDataVO;
import com.els.modules.tender.clarification.entity.SaleTenderClarificationInfo;
import com.els.modules.tender.clarification.service.SaleTenderClarificationInfoService;
import com.els.modules.tender.column.enumerate.CustomerFieldCategoryEnum;
import com.els.modules.tender.common.interceptor.TenderFlagInjectionContext;
import com.els.modules.tender.common.utils.FastJsonUtils;
import com.els.modules.tender.common.utils.TenderOperationFieldUtils;
import com.els.modules.tender.evaluation.entity.TenderEvaQuotedPriceItem;
import com.els.modules.tender.project.entity.PurchaseTenderProjectSubpackageInfo;
import com.els.modules.tender.project.enumerate.SubpackageInfoCheckTypeEnum;
import com.els.modules.tender.project.enumerate.SubpackageInfoProcessTypeEnum;
import com.els.modules.tender.project.service.PurchaseTenderProjectSubpackageInfoService;
import com.els.modules.tender.project.utils.TenderProjectMemberUtils;
import com.els.modules.tender.sale.entity.SaleTenderPriceOpenings;
import com.els.modules.tender.sale.enumerate.SaleTenderDocumentSubmitEnum;
import com.els.modules.tender.sale.enumerate.TenderProjectSignUpStatusEnum;
import com.els.modules.tender.sale.enumerate.TenderProjectSupplieResponseStatusEnum;
import com.els.modules.tender.sale.mapper.SaleTenderPriceOpeningsMapper;
import com.els.modules.tender.sale.service.SaleTenderEvaluationAttachmentService;
import com.els.modules.tender.sale.service.SaleTenderPriceOpeningsService;
import com.els.modules.tender.sale.vo.SaleTenderBidLetterVo;
import com.els.modules.tender.sale.vo.SaleTenderProjectDocumentSubmitInfoVO;
import com.els.modules.tender.sale.vo.SaleTenderProjectDocumentSubmitInfoViewVO;
import com.els.modules.tender.supplier.entity.TenderProjectSignUp;
import com.els.modules.tender.supplier.entity.TenderProjectSupplier;
import com.els.modules.tender.supplier.service.TenderInvitationSupplierReceiptService;
import com.els.modules.tender.supplier.service.TenderProjectSignUpService;
import com.els.modules.tender.supplier.service.TenderProjectSupplierService;
import com.els.rpc.service.InvokeAccountRpcService;
import com.els.rpc.service.InvokeBaseRpcService;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.shiro.util.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;

@Service
public class SaleTenderPriceOpeningsServiceImpl
extends BaseServiceImpl<SaleTenderPriceOpeningsMapper, SaleTenderPriceOpenings>
implements SaleTenderPriceOpeningsService {
    private static final Logger log = LoggerFactory.getLogger(SaleTenderPriceOpeningsServiceImpl.class);
    @Autowired
    private TenderProjectSupplierService saleTenderProjectSupplierService;
    @Autowired
    private SaleTenderEvaluationAttachmentService saleTenderEvaluationAttachmentService;
    @Autowired
    private SaleTenderQuoteMaterialService saleTenderQuoteMaterialService;
    @Autowired
    private PurchaseTenderQuoteMaterialService purchaseTenderQuoteMaterialService;
    @Autowired
    private TenderProjectSignUpService tenderProjectSignUpService;
    @Resource
    private InvokeBaseRpcService invokeBaseRpcService;
    @Resource
    private InvokeAccountRpcService accountRpcService;
    @Autowired
    private PurchaseTenderBidLetterService purchaseTenderBidLetterService;
    @Autowired
    private PurchaseTenderPriceOpeningsTemplateService purchasePriceOpeningsTemplateService;
    @Lazy
    @Autowired
    private PurchaseTenderProjectSubpackageInfoService purchaseTenderProjectSubpackageInfoService;
    @Autowired
    private TenderInvitationSupplierReceiptService tenderInvitationSupplierReceiptService;
    @Autowired
    @Lazy
    private PurchaseTenderProjectAttachmentHeadService attachmentHeadService;
    @Resource
    private RedisUtil redisUtil;

    @Override
    public List<SaleTenderPriceOpenings> selectByMainId(String mainId) {
        return ((SaleTenderPriceOpeningsMapper)this.baseMapper).selectByMainId(mainId);
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void addAll(SaleTenderProjectDocumentSubmitInfoVO documentSubmitInfoVO) {
        TenderProjectSupplier masterInfo = this.save(documentSubmitInfoVO, false);
        this.saleTenderProjectSupplierService.updateById((Object)masterInfo);
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void publish(SaleTenderProjectDocumentSubmitInfoVO documentSubmitInfoVO) {
        TenderProjectSupplier masterInfo = this.save(documentSubmitInfoVO, true);
        boolean hasPreTrial = SubpackageInfoCheckTypeEnum.hasPreTrial(TenderFlagInjectionContext.getTenderCheckType());
        String operation = "documentSubmitFile";
        if (hasPreTrial) {
            operation = "preDocumentSubmitFile";
        }
        String filePassword = "";
        PurchaseTenderProjectSubpackageInfo subpackageInfo = this.purchaseTenderProjectSubpackageInfoService.selectById(masterInfo.getSubpackageId());
        if ("1".equals(subpackageInfo.getOpenBidEncrypt())) {
            filePassword = AesEncryptUtil.encrypt((String)documentSubmitInfoVO.getFilePassword());
        }
        if (hasPreTrial) {
            masterInfo.setPreFilePassword(filePassword);
            masterInfo.setPreResponseStatus("1");
            masterInfo.setPreResponseTime(new Date());
        } else {
            masterInfo.setFilePassword(filePassword);
            masterInfo.setResultResponseStatus("1");
            masterInfo.setResultResponseTime(new Date());
            masterInfo.setResponseStatus("1");
            masterInfo.setResponseTime(new Date());
        }
        this.saleTenderProjectSupplierService.updateById((Object)masterInfo);
        this.sendMsg(masterInfo, operation);
    }

    private TenderProjectSupplier save(SaleTenderProjectDocumentSubmitInfoVO documentSubmitInfoVO, boolean isPublish) {
        TenderProjectSupplier masterInfo = (TenderProjectSupplier)((Object)this.saleTenderProjectSupplierService.getById((Serializable)((Object)documentSubmitInfoVO.getId())));
        this.checkParam(documentSubmitInfoVO, masterInfo, isPublish);
        masterInfo.setDeleted(CommonConstant.DEL_FLAG_0);
        masterInfo.setContacts(documentSubmitInfoVO.getContacts());
        masterInfo.setContactsPhone(documentSubmitInfoVO.getContactsPhone());
        masterInfo.setCombination(documentSubmitInfoVO.getCombination());
        masterInfo.setCombinationName(documentSubmitInfoVO.getCombinationName());
        masterInfo.setSubmitFileIp(IPUtils.getIpAddr());
        boolean hasReject = this.tenderInvitationSupplierReceiptService.hasReject(masterInfo.getSupplierAccount(), masterInfo.getSubpackageId());
        Assert.isTrue((!hasReject ? 1 : 0) != 0, (String)I18nUtil.translate((String)"i18n_field_PVIFKWxqnJQIW_284e41b8", (String)"\u9080\u8bf7\u5df2\u62d2\u7edd\uff0c\u4e0d\u53ef\u9012\u4ea4\u6587\u4ef6!"));
        this.add(documentSubmitInfoVO);
        return masterInfo;
    }

    private void sendMsg(TenderProjectSupplier masterInfo, String operation) {
        List<ElsSubAccountDTO> accountDTOList = TenderProjectMemberUtils.getTenderProjectMember(masterInfo.getTenderProjectId());
        StringBuilder urlParams = new StringBuilder("tenderProjectId=").append(masterInfo.getTenderProjectId()).append("&subpackageId=").append(masterInfo.getSubpackageId());
        this.sendMsgToSubAccount(TenantContext.getTenant(), accountDTOList, (Object)masterInfo, urlParams.toString(), "tender", operation);
    }

    private void checkParam(SaleTenderProjectDocumentSubmitInfoVO supplierTenderProjectMasterInfoPage, TenderProjectSupplier newSupplier, boolean isPublish) {
        Assert.hasText((String)supplierTenderProjectMasterInfoPage.getTenderProjectNumber(), (String)I18nUtil.translate((String)"i18n_alert_dIAyxOLVW_a6e5f3db", (String)"\u9879\u76ee\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a!"));
        Assert.hasText((String)supplierTenderProjectMasterInfoPage.getTenderProjectName(), (String)I18nUtil.translate((String)"i18n_alert_dIRLxOLVW_eb0fa139", (String)"\u9879\u76ee\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a!"));
        Assert.hasText((String)supplierTenderProjectMasterInfoPage.getSubpackageId(), (String)I18nUtil.translate((String)"i18n_alert_zsxOLVW_2edb7bb2", (String)"\u5206\u5305\u4e0d\u80fd\u4e3a\u7a7a!"));
        Assert.hasText((String)supplierTenderProjectMasterInfoPage.getSupplierName(), (String)I18nUtil.translate((String)"i18n_alert_eBtLRLWAERLWxOLVW_351757df", (String)"\u6295\u6807\u5355\u4f4d\u540d\u79f0(\u4f01\u4e1a\u540d\u79f0)\u4e0d\u80fd\u4e3a\u7a7a!"));
        Assert.hasText((String)supplierTenderProjectMasterInfoPage.getPurchaseEnterpriseAccount(), (String)I18nUtil.translate((String)"i18n_alert_YBtLeyxOLVW_e92a07c", (String)"\u62db\u6807\u5355\u4f4d\u8d26\u53f7\u4e0d\u80fd\u4e3a\u7a7a!"));
        List<SaleAttachmentDTO> saleAttachmentDTOList = supplierTenderProjectMasterInfoPage.getSaleAttachmentDTOList();
        if (isPublish) {
            Assert.isTrue((boolean)CollectionUtils.isNotEmpty(saleAttachmentDTOList), (String)I18nUtil.translate((String)"i18n_alert_QIVHxOLVW_3eef2cf4", (String)"\u6587\u4ef6\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a!"));
            Map<String, Long> fileTypeCount = saleAttachmentDTOList.stream().collect(Collectors.groupingBy(SaleAttachmentDTO::getFileType, Collectors.counting()));
            if ("1".equals(TenderFlagInjectionContext.getTenderCheckType())) {
                if ("1".equals(TenderFlagInjectionContext.getTenderProcessType())) {
                    Assert.isTrue((Long.valueOf("1").equals(fileTypeCount.get(SaleTenderDocumentSubmitEnum.ONE_STEP_PROCESS.getValue())) && Long.valueOf("1").equals(fileTypeCount.get(SaleTenderDocumentSubmitEnum.TWO_STEP_PROCESS.getValue())) ? 1 : 0) != 0, (String)I18nUtil.translate((String)"i18n_field_nIxeBQInnxxeBQImTPImW_15673d5e", (String)"\u7b2c\u4e00\u6b65\u6295\u6807\u6587\u4ef6\u548c\u7b2c\u4e8c\u6b65\u6295\u6807\u6587\u4ef6\u5404\u9700\u8981\u4e00\u4e2a!"));
                } else {
                    Assert.isTrue((boolean)Long.valueOf("1").equals(fileTypeCount.get(SaleTenderDocumentSubmitEnum.PROCESS.getValue())), (String)I18nUtil.translate((String)"i18n_field_eBQIjFROjImW_99c25f2d", (String)"\u6295\u6807\u6587\u4ef6\u6709\u4e14\u53ea\u80fd\u6709\u4e00\u4e2a!"));
                }
            } else {
                Assert.isTrue((boolean)Long.valueOf("1").equals(fileTypeCount.get(SaleTenderDocumentSubmitEnum.PRE_PROCESS.getValue())), (String)I18nUtil.translate((String)"i18n_field_UUQIjFROjImW_845828f8", (String)"\u9884\u5ba1\u6587\u4ef6\u6709\u4e14\u53ea\u80fd\u6709\u4e00\u4e2a!"));
            }
        }
        PurchaseTenderProjectSubpackageInfo subpackageInfo = this.purchaseTenderProjectSubpackageInfoService.selectById(supplierTenderProjectMasterInfoPage.getSubpackageId());
        LambdaQueryWrapper qw = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)qw.eq(TenderProjectSignUp::getSubpackageId, (Object)supplierTenderProjectMasterInfoPage.getSubpackageId())).eq(BaseEntity::getElsAccount, (Object)TenantContext.getTenant());
        List tenderProjectSignUps = this.tenderProjectSignUpService.list((Wrapper)qw);
        if (CollectionUtils.isNotEmpty((Collection)tenderProjectSignUps)) {
            TenderProjectSignUp tenderProjectSignUp = (TenderProjectSignUp)((Object)tenderProjectSignUps.get(0));
            Assert.isTrue((boolean)TenderProjectSignUpStatusEnum.AUDIT_PASS.getValue().equals(tenderProjectSignUp.getStatus()), (String)I18nUtil.translate((String)"i18n_alert_sRUJeRSnOtkQInJ_bd180235", (String)"\u62a5\u540d\u5ba1\u67e5\u901a\u8fc7\u540e\u624d\u80fd\u64cd\u4f5c\u6587\u4ef6\u9012\u4ea4!"));
        }
        String tenderCheckType = TenderFlagInjectionContext.getTenderCheckType();
        Assert.hasText((String)tenderCheckType, (String)I18nUtil.translate((String)"i18n_field_UJCKxOLVW_e56eae77", (String)"\u5ba1\u67e5\u65b9\u5f0f\u4e0d\u80fd\u4e3a\u7a7a!"));
        boolean hasPreTrial = SubpackageInfoCheckTypeEnum.PRE_TRIAL.getValue().equals(tenderCheckType);
        Date fileSubmitEndTime = hasPreTrial ? subpackageInfo.getPreFileSubmitEndTime() : subpackageInfo.getFileSubmitEndTime();
        Assert.isTrue((boolean)new Date().before(fileSubmitEndTime), (String)I18nUtil.translate((String)"i18n_alert_QInJKIIRW_ebbbb46d", (String)"\u6587\u4ef6\u9012\u4ea4\u65f6\u95f4\u5df2\u8fc7!"));
        if (hasPreTrial) {
            if ("1".equals(subpackageInfo.getBidding())) {
                purchaseBid = newSupplier.getPrePurchaseBid();
                Assert.isTrue((boolean)"1".equals(purchaseBid), (String)I18nUtil.translate((String)"i18n_alert_SUURBVHVImW_c7c1e16a", (String)"\u65e0\u9884\u5ba1\u8d2d\u6807\u4fe1\u606f\u8bf7\u68c0\u67e5!"));
            }
        } else if ("1".equals(subpackageInfo.getBidding())) {
            purchaseBid = newSupplier.getPurchaseBid();
            Assert.isTrue((boolean)"1".equals(purchaseBid), (String)I18nUtil.translate((String)"i18n_alert_SRBVHVImW_dd43f2cd", (String)"\u65e0\u8d2d\u6807\u4fe1\u606f\u8bf7\u68c0\u67e5!"));
        }
        SaleTenderClarificationInfoService saleTenderClarificationInfoService = (SaleTenderClarificationInfoService)SpringContextUtils.getBean(SaleTenderClarificationInfoService.class);
        SaleTenderClarificationInfo query = new SaleTenderClarificationInfo();
        query.setSubpackageId(subpackageInfo.getId());
        query.setCheckType(TenderFlagInjectionContext.getTenderCheckType());
        query.setElsAccount(TenantContext.getTenant());
        query.setStatus("0");
        List<SaleTenderClarificationInfo> saleTenderClarificationInfos = saleTenderClarificationInfoService.selectByMainId(query);
        Assert.isTrue((boolean)CollectionUtils.isEmpty(saleTenderClarificationInfos), (String)I18nUtil.translate((String)"i18n_field_LVfIsjLRLjLVWVImW_903731f2", (String)"\u6f84\u6e05\u7b54\u7591\u4e2d\u6709\u672a\u786e\u8ba4\u7684\u6f84\u6e05,\u8bf7\u68c0\u67e5!"));
        if ("1".equals(subpackageInfo.getUseCa())) {
            return;
        }
        List<SaleTenderPriceOpenings> saleTenderPriceOpeningsList = supplierTenderProjectMasterInfoPage.getSaleTenderPriceOpeningsList();
        Assert.isTrue((boolean)CollectionUtils.isNotEmpty(saleTenderPriceOpeningsList), (String)I18nUtil.translate((String)"i18n_alert_eBxIumIBBxOLVW_13a6c6d6", (String)"\u6295\u6807\u51fd\u4e0b\u4ef7\u683c\u4e00\u89c8\u8868\u4e0d\u80fd\u4e3a\u7a7a!"));
        if (isPublish) {
            List<String> bidLetterIds = saleTenderPriceOpeningsList.stream().map(SaleTenderPriceOpenings::getBidLetterId).collect(Collectors.toList());
            List<PurchaseTenderBidLetter> purchaseTenderBidLetters = this.purchaseTenderBidLetterService.selectBatchIds(bidLetterIds);
            Map<String, List<PurchaseTenderBidLetter>> bidLetterMaps = purchaseTenderBidLetters.stream().collect(Collectors.groupingBy(BaseEntity::getId));
            saleTenderPriceOpeningsList.stream().forEach(priceOpenings -> {
                String customizeFieldModel = priceOpenings.getCustomizeFieldModel();
                Assert.hasText((String)customizeFieldModel, (String)I18nUtil.translate((String)"i18n_alert_umIBBAxOLV_3476f42c", (String)"\u4ef7\u683c\u4e00\u89c8\u8868\u5217\u4e0d\u80fd\u4e3a\u7a7a!"));
                Assert.isTrue((!"[]".equals(customizeFieldModel) ? 1 : 0) != 0, (String)I18nUtil.translate((String)"i18n_alert_umIBBAxOLV_3476f42c", (String)"\u4ef7\u683c\u4e00\u89c8\u8868\u5217\u4e0d\u80fd\u4e3a\u7a7a!"));
                String customizeFieldData = priceOpenings.getCustomizeFieldData();
                Assert.hasText((String)customizeFieldData, (String)I18nUtil.translate((String)"i18n_alert_umIBBWFxOLV_75313029", (String)"\u4ef7\u683c\u4e00\u89c8\u8868\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a!"));
                Assert.isTrue((!"[]".equals(customizeFieldData) ? 1 : 0) != 0, (String)I18nUtil.translate((String)"i18n_alert_umIBBWFxOLV_75313029", (String)"\u4ef7\u683c\u4e00\u89c8\u8868\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a!"));
                List columnList = JSONArray.parseArray((String)customizeFieldModel, CustomColumnModel.class);
                JSONArray dataJsonArray = JSONArray.parseArray((String)customizeFieldData);
                for (CustomColumnModel customColumnModel : columnList) {
                    if (!"1".equals(customColumnModel.getMust()) || !"0".equals(customColumnModel.getInputOrg())) continue;
                    for (int i = 0; i < dataJsonArray.size(); ++i) {
                        JSONObject jsonObject = dataJsonArray.getJSONObject(i);
                        List bidLetterList = (List)bidLetterMaps.get(priceOpenings.getBidLetterId());
                        PurchaseTenderBidLetter purchaseTenderBidLetter = (PurchaseTenderBidLetter)((Object)((Object)bidLetterList.get(0)));
                        Assert.isTrue((boolean)jsonObject.containsKey((Object)customColumnModel.getField()), (String)I18nUtil.translate((String)"i18n_alert_eBx[0]sMKeBtLlSALSMVSMMLSDJ_3866db00", (String)"\u6295\u6807\u51fd[${0}]\u4e2d\u5b58\u5728\u6295\u6807\u5355\u4f4d\u5fc5\u586b\u5217\u672a\u586b\u5199\uff0c\u8bf7\u586b\u5199\u5b8c\u6210\u540e\u63d0\u4ea4", (String[])new String[]{purchaseTenderBidLetter.getName()}));
                        Assert.isTrue((null != jsonObject.get((Object)customColumnModel.getField()) ? 1 : 0) != 0, (String)I18nUtil.translate((String)"i18n_alert_eBx[0]sMKeBtLlSALSMVSMMLSDJ_3866db00", (String)"\u6295\u6807\u51fd[${0}]\u4e2d\u5b58\u5728\u6295\u6807\u5355\u4f4d\u5fc5\u586b\u5217\u672a\u586b\u5199\uff0c\u8bf7\u586b\u5199\u5b8c\u6210\u540e\u63d0\u4ea4", (String[])new String[]{purchaseTenderBidLetter.getName()}));
                        Assert.isTrue((!"".equals(jsonObject.get((Object)customColumnModel.getField())) ? 1 : 0) != 0, (String)I18nUtil.translate((String)"i18n_alert_eBx[0]sMKeBtLlSALSMVSMMLSDJ_3866db00", (String)"\u6295\u6807\u51fd[${0}]\u4e2d\u5b58\u5728\u6295\u6807\u5355\u4f4d\u5fc5\u586b\u5217\u672a\u586b\u5199\uff0c\u8bf7\u586b\u5199\u5b8c\u6210\u540e\u63d0\u4ea4", (String[])new String[]{purchaseTenderBidLetter.getName()}));
                    }
                }
            });
        }
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void editAll(SaleTenderProjectDocumentSubmitInfoVO documentSubmitInfoVO) {
        TenderProjectSupplier masterInfo = new TenderProjectSupplier();
        String filePassword = AesEncryptUtil.encrypt((String)masterInfo.getFilePassword());
        TenderOperationFieldUtils.setFieldValue((Object)masterInfo, TenderProjectSupplieResponseStatusEnum.RESPONSE_BID.getValue(), "responseStatus");
        TenderOperationFieldUtils.setFieldValue((Object)masterInfo, new Date(), "responseTime");
        BeanUtils.copyProperties((Object)((Object)documentSubmitInfoVO), (Object)((Object)masterInfo));
        boolean hasReject = this.tenderInvitationSupplierReceiptService.hasReject(masterInfo.getSupplierAccount(), masterInfo.getSubpackageId());
        Assert.isTrue((!hasReject ? 1 : 0) != 0, (String)I18nUtil.translate((String)"i18n_field_PVIFKWxqnJQIW_284e41b8", (String)"\u9080\u8bf7\u5df2\u62d2\u7edd\uff0c\u4e0d\u53ef\u9012\u4ea4\u6587\u4ef6!"));
        boolean hasPreTrial = SubpackageInfoCheckTypeEnum.hasPreTrial(TenderFlagInjectionContext.getTenderCheckType());
        PurchaseTenderProjectSubpackageInfo subpackageInfo = this.purchaseTenderProjectSubpackageInfoService.selectById(masterInfo.getSubpackageId());
        if ("1".equals(subpackageInfo.getOpenBidEncrypt())) {
            filePassword = AesEncryptUtil.encrypt((String)masterInfo.getFilePassword());
        }
        if (hasPreTrial) {
            masterInfo.setPreFilePassword(filePassword);
            masterInfo.setFilePassword(null);
        } else {
            masterInfo.setFilePassword(filePassword);
        }
        masterInfo.setSubmitFileIp(IPUtils.getIpAddr());
        this.saleTenderProjectSupplierService.updateById((Object)masterInfo);
        this.add(documentSubmitInfoVO);
        String operation = "documentSubmitFile";
        if (hasPreTrial) {
            operation = "preDocumentSubmitFile";
        }
        this.sendMsg(masterInfo, operation);
    }

    @Override
    public SaleTenderProjectDocumentSubmitInfoViewVO queryDocumentSubmitInfo(TenderProjectSupplier tenderProjectSupplier) {
        TenderFlagInjectionContext.setTenderCurrentStep(null);
        SaleTenderProjectDocumentSubmitInfoViewVO documentSubmitInfoVO = new SaleTenderProjectDocumentSubmitInfoViewVO();
        TenderProjectSupplier projectSupplier = new TenderProjectSupplier();
        projectSupplier.setSubpackageId(tenderProjectSupplier.getSubpackageId());
        projectSupplier.setSupplierAccount(TenantContext.getTenant());
        List<TenderProjectSupplier> tenderProjectSuppliers = this.saleTenderProjectSupplierService.selectBySubpackageId(projectSupplier);
        Assert.isTrue((boolean)ObjectUtil.isNotEmpty(tenderProjectSuppliers), (String)I18nUtil.translate((String)"i18n_field_SsRVHWVImW_290fb9b", (String)"\u65e0\u62a5\u540d\u4fe1\u606f,\u8bf7\u68c0\u67e5!"));
        TenderProjectSupplier masterInfo = tenderProjectSuppliers.get(0);
        BeanUtils.copyProperties((Object)((Object)masterInfo), (Object)((Object)documentSubmitInfoVO));
        documentSubmitInfoVO.setBusAccount(masterInfo.getPurchaseEnterpriseAccount());
        List saleAttachmentDTOList = this.invokeBaseRpcService.selectSaleAttachmentByMainId(masterInfo.getId() + "_" + TenderFlagInjectionContext.getTenderCheckType());
        documentSubmitInfoVO.setSaleAttachmentDTOList(saleAttachmentDTOList);
        List<SaleTenderBidLetterVo> tenderBidLetterVo = this.selectTenderBidLetter(masterInfo.getSubpackageId(), null, TenantContext.getTenant(), false, "0");
        documentSubmitInfoVO.setTenderBidLetterVoList(tenderBidLetterVo);
        return documentSubmitInfoVO;
    }

    @Override
    public List<SaleTenderBidLetterVo> queryQuotedPriceInfo(String subpackageId, String finalQuote) {
        List<SaleTenderBidLetterVo> saleTenderBidLetterVos = this.selectTenderBidLetter(subpackageId, null, TenantContext.getTenant(), true, finalQuote);
        return saleTenderBidLetterVos;
    }

    @Override
    public List<SaleTenderBidLetterVo> selectByQuotedPriceItemId(TenderEvaQuotedPriceItem tenderEvaQuotedPriceItem, String finalQuote) {
        return this.selectTenderBidLetter(tenderEvaQuotedPriceItem.getSubpackageId(), tenderEvaQuotedPriceItem.getId(), tenderEvaQuotedPriceItem.getSupplierAccount(), true, finalQuote);
    }

    private List<SaleTenderBidLetterVo> selectTenderBidLetter(String subpackageId, String quotedPriceItemId, String supplierAccount, boolean hasStagePrice, String finalQuote) {
        PurchaseTenderBidLetterFormatGroupVO formatGroupVO = this.attachmentHeadService.queryBidLetterFormatGroup(subpackageId);
        String quoteType = formatGroupVO.getQuoteType();
        List purchaseTenderBidLetters = this.purchaseTenderBidLetterService.queryPurchaseTenderBidLetter(subpackageId, hasStagePrice).stream().filter(item -> {
            if ("1".equals(finalQuote) && BidLetterFormatQuoteTypeEnum.ITEMIZED_QUOTATION.getValue().equals(quoteType) && SubpackageInfoProcessTypeEnum.TWO_STEP.getValue().equals(item.getProcessType())) {
                return "1".equals(item.getQuoteBidLetter());
            }
            return true;
        }).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(purchaseTenderBidLetters)) {
            return null;
        }
        List<String> bidIds = purchaseTenderBidLetters.stream().map(BaseEntity::getId).collect(Collectors.toList());
        List<SaleTenderPriceOpenings> saleTenderPriceOpeningList = this.getLatestQuoteSaleTenderPriceOpeningList(quotedPriceItemId, Arrays.asList(supplierAccount), hasStagePrice, bidIds, finalQuote);
        Map<String, List<SaleTenderPriceOpenings>> saleTenderPriceOpeningListMap = saleTenderPriceOpeningList.stream().collect(Collectors.groupingBy(SaleTenderPriceOpenings::getBidLetterId));
        List<PurchaseTenderPriceOpeningsTemplate> purchaseTenderPriceOpeningTemplates = this.purchasePriceOpeningsTemplateService.selectByMainIds(bidIds);
        ArrayList purchaseTenderPriceOpeningList = SysUtil.copyProperties(purchaseTenderPriceOpeningTemplates, SaleTenderPriceOpenings.class);
        purchaseTenderPriceOpeningList.stream().forEach(item -> item.setId(IdWorker.getIdStr()));
        Map<String, List<SaleTenderPriceOpenings>> purchaseTenderPriceOpeningListMap = purchaseTenderPriceOpeningList.stream().collect(Collectors.groupingBy(SaleTenderPriceOpenings::getBidLetterId));
        Map<Object, Object> quoteMaterialListByBidLetterId = new LinkedHashMap();
        Map<Object, Object> purchashQuoteMaterialListByBidLetterId = new LinkedHashMap();
        List<String> priceOpeningIdList = saleTenderPriceOpeningList.stream().map(BaseEntity::getId).collect(Collectors.toList());
        List<SaleTenderQuoteMaterial> quoteMaterialList = this.saleTenderQuoteMaterialService.selectByMainIds(priceOpeningIdList, supplierAccount);
        List<PurchaseTenderQuoteMaterial> templateMaterialList = this.purchaseTenderQuoteMaterialService.selectByMainIds(bidIds);
        ArrayList purchashQuoteMaterialList = SysUtil.copyProperties(templateMaterialList, SaleTenderQuoteMaterial.class);
        purchashQuoteMaterialList.parallelStream().forEach(item -> item.setId(null));
        quoteMaterialListByBidLetterId = quoteMaterialList.stream().collect(Collectors.groupingBy(SaleTenderQuoteMaterial::getBidLetterId));
        purchashQuoteMaterialListByBidLetterId = purchashQuoteMaterialList.stream().collect(Collectors.groupingBy(SaleTenderQuoteMaterial::getBidLetterId));
        ArrayList<SaleTenderBidLetterVo> tenderBidLetterList = new ArrayList<SaleTenderBidLetterVo>();
        for (PurchaseTenderBidLetter purchaseTenderBidLetter : purchaseTenderBidLetters) {
            SaleTenderBidLetterVo saleTenderBidLetterVo = new SaleTenderBidLetterVo();
            BeanUtils.copyProperties((Object)((Object)purchaseTenderBidLetter), (Object)((Object)saleTenderBidLetterVo));
            List<SaleTenderPriceOpenings> openingsList = saleTenderPriceOpeningListMap.getOrDefault(purchaseTenderBidLetter.getId(), purchaseTenderPriceOpeningListMap.get(purchaseTenderBidLetter.getId()));
            openingsList.stream().forEach(saleTenderPriceOpenings -> {
                try {
                    if (saleTenderPriceOpenings.getQuoteColumnEncryptionByte() != null && saleTenderPriceOpenings.getQuoteColumnEncryptionByte().length > 0) {
                        saleTenderPriceOpenings.setQuoteColumnEncryption(new String(saleTenderPriceOpenings.getQuoteColumnEncryptionByte(), "utf-8"));
                        saleTenderPriceOpenings.setQuoteColumnEncryptionByte(null);
                    }
                }
                catch (UnsupportedEncodingException e) {
                    log.error("\u52a0\u5bc6\u62a5\u4ef7\u5217\u8f6c\u6362\u5f02\u5e38" + e.getMessage());
                }
            });
            saleTenderBidLetterVo.setPriceOpeningsList(openingsList);
            List materialAllList = quoteMaterialListByBidLetterId.getOrDefault(purchaseTenderBidLetter.getId(), (List)purchashQuoteMaterialListByBidLetterId.get(purchaseTenderBidLetter.getId()));
            if (CollectionUtils.isNotEmpty((Collection)materialAllList)) {
                ArrayList<SaleQuoteMaterialDataVO> quoteColumnList = new ArrayList<SaleQuoteMaterialDataVO>();
                Map<String, List<SaleTenderQuoteMaterial>> materialDataAllGroupByQuoteField = materialAllList.stream().collect(Collectors.groupingBy(SaleTenderQuoteMaterial::getQuoteField));
                for (String quoteField : materialDataAllGroupByQuoteField.keySet()) {
                    SaleQuoteMaterialDataVO saleQuoteMaterialDataVO = new SaleQuoteMaterialDataVO();
                    saleQuoteMaterialDataVO.setField(quoteField);
                    SaleTenderPriceOpenings saleTenderPriceOpenings2 = openingsList.get(0);
                    List<CustomColumnModel> columnModelList = FastJsonUtils.toList(saleTenderPriceOpenings2.getCustomizeFieldModel(), CustomColumnModel.class);
                    for (CustomColumnModel customColumnModel : columnModelList) {
                        if (!quoteField.equals(customColumnModel.getField())) continue;
                        saleQuoteMaterialDataVO.setTitle(customColumnModel.getTitle());
                        break;
                    }
                    List<SaleTenderQuoteMaterial> materialList = materialDataAllGroupByQuoteField.get(quoteField);
                    materialList.stream().forEach(saleTenderQuoteMaterial -> saleTenderQuoteMaterial.setPriceOpeningsId(saleTenderPriceOpenings2.getId()));
                    saleQuoteMaterialDataVO.setMaterialDataList(materialList);
                    saleQuoteMaterialDataVO.setPriceOpeningsId(saleTenderPriceOpenings2.getId());
                    quoteColumnList.add(saleQuoteMaterialDataVO);
                }
                saleTenderBidLetterVo.setSaleQuoteMaterialDataList(quoteColumnList);
            }
            tenderBidLetterList.add(saleTenderBidLetterVo);
        }
        return tenderBidLetterList;
    }

    @Override
    public List<SaleTenderPriceOpenings> getLatestQuoteSaleTenderPriceOpeningList(String quotedPriceItemId, List<String> supplierAccountList, boolean stagePrice, List<String> bidIds, String finalQuote) {
        ArrayList<String> quotedPriceItemIds = new ArrayList<String>();
        if (StrUtil.isNotBlank((CharSequence)quotedPriceItemId)) {
            quotedPriceItemIds.add(quotedPriceItemId);
        }
        return this.getLatestQuoteSaleTenderPriceOpeningList(quotedPriceItemIds, supplierAccountList, stagePrice, bidIds, finalQuote);
    }

    @Override
    public List<SaleTenderPriceOpenings> getLatestQuoteSaleTenderPriceOpeningList(List<String> quotedPriceItemIds, List<String> supplierAccountList, boolean stagePrice, List<String> bidIds, String finalQuote) {
        if (CollectionUtil.isEmpty(quotedPriceItemIds)) {
            if (CollectionUtil.isEmpty(bidIds)) {
                log.warn("\u6295\u6807\u51fdId\u96c6\u5408\u4e0d\u5b58\u5728\uff01");
                return Collections.emptyList();
            }
            bidIds = bidIds.stream().distinct().collect(Collectors.toList());
        }
        if (CollectionUtil.isNotEmpty(supplierAccountList)) {
            supplierAccountList = supplierAccountList.stream().distinct().collect(Collectors.toList());
        }
        if (stagePrice) {
            if (CollectionUtil.isNotEmpty(quotedPriceItemIds)) {
                return ((SaleTenderPriceOpeningsMapper)this.baseMapper).selectByQuotedPriceItemId(bidIds, supplierAccountList, quotedPriceItemIds, finalQuote);
            }
            List<SaleTenderPriceOpenings> priceOpeningList = ((SaleTenderPriceOpeningsMapper)this.baseMapper).getLatestQuoteSaleTenderPriceOpeningList(supplierAccountList, bidIds, finalQuote);
            if ("1".equals(finalQuote) && CollectionUtil.isEmpty(priceOpeningList)) {
                priceOpeningList = ((SaleTenderPriceOpeningsMapper)this.baseMapper).getLatestQuoteSaleTenderPriceOpeningList(supplierAccountList, bidIds, null);
            }
            return priceOpeningList;
        }
        return ((SaleTenderPriceOpeningsMapper)this.baseMapper).selectByOriginStageQuote(bidIds, supplierAccountList);
    }

    public void add(SaleTenderProjectDocumentSubmitInfoVO documentSubmitInfoVO) {
        String checkType = TenderFlagInjectionContext.getTenderCheckType();
        String headId = documentSubmitInfoVO.getId() + "_" + checkType;
        this.invokeBaseRpcService.deleteSaleAttachmentByMainId(headId);
        this.saleTenderEvaluationAttachmentService.deleteByMainId(headId);
        List<SaleAttachmentDTO> saleAttachmentDTOList = documentSubmitInfoVO.getSaleAttachmentDTOList();
        this.invokeBaseRpcService.deleteSaleAttachmentByMainId(headId);
        if (CollectionUtils.isNotEmpty(saleAttachmentDTOList)) {
            saleAttachmentDTOList.stream().forEach(attachment -> attachment.setHeadId(headId));
            this.invokeBaseRpcService.insertSaleAttachmentBatchSomeColumn(saleAttachmentDTOList);
            ArchiveUtil.saveArchiveBySaleAttachmentDTO(saleAttachmentDTOList, headId, documentSubmitInfoVO.getSubpackageId(), documentSubmitInfoVO.getTenderProjectId(), TenderProjectArchiveAttachmentEnum.DOCUMENT_SUBMIT_PREFIX.getValue());
        }
        LoginUserDTO user = SysUtil.getLoginUser();
        List tenantList = this.accountRpcService.getTenantList(Arrays.asList(user.getElsAccount()));
        Assert.isTrue((boolean)CollectionUtil.isNotEmpty((Collection)tenantList), (String)I18nUtil.translate((String)"", (String)"\u8d26\u53f7${0}\u627e\u4e0d\u5230\u79df\u6237\u4fe1\u606f\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\uff01", (String[])new String[]{user.getElsAccount()}));
        Map tenantListMap = tenantList.stream().collect(Collectors.toMap(ParentEntityDTO::getElsAccount, Function.identity()));
        ElsTenantDTO elsTenantDTO = (ElsTenantDTO)tenantListMap.get(user.getElsAccount());
        List<SaleTenderPriceOpenings> priceOpeningsList = documentSubmitInfoVO.getSaleTenderPriceOpeningsList();
        List<String> bidLetterIdList = priceOpeningsList.stream().map(SaleTenderPriceOpenings::getBidLetterId).collect(Collectors.toList());
        List<PurchaseTenderBidLetter> tenderBidLetterList = this.purchaseTenderBidLetterService.selectBatchIds(bidLetterIdList);
        Map bidLetterMap = tenderBidLetterList.stream().collect(Collectors.toMap(BaseEntity::getId, Function.identity()));
        List<SaleQuoteMaterialDataVO> saleQuoteMaterialDataVOList = documentSubmitInfoVO.getSaleQuoteMaterialDataList();
        Map<String, List<SaleQuoteMaterialDataVO>> saleQuoteMaterialDataListMap = saleQuoteMaterialDataVOList.stream().collect(Collectors.groupingBy(SaleQuoteMaterialDataVO::getPriceOpeningsId));
        ArrayList<SaleTenderQuoteMaterial> saleQuoteMaterialAllList = new ArrayList<SaleTenderQuoteMaterial>();
        ArrayList<String> priceOpeningsIdList = new ArrayList<String>();
        for (SaleTenderPriceOpenings saleTenderPriceOpenings : priceOpeningsList) {
            saleTenderPriceOpenings.setSupplierName(elsTenantDTO.getCompanyName());
            saleTenderPriceOpenings.setElsAccount(user.getElsAccount());
            saleTenderPriceOpenings.setHeadId(headId);
            PurchaseTenderBidLetter purchaseTenderBidLetter = (PurchaseTenderBidLetter)((Object)bidLetterMap.get(saleTenderPriceOpenings.getBidLetterId()));
            saleTenderPriceOpenings.setCheckType(purchaseTenderBidLetter.getCheckType());
            saleTenderPriceOpenings.setProcessType(purchaseTenderBidLetter.getProcessType());
            saleTenderPriceOpenings.setCurrentStep(purchaseTenderBidLetter.getCurrentStep());
            saleTenderPriceOpenings.setStageQuote("0");
            saleTenderPriceOpenings.setStage(CommonConstant.STATUS_NO);
            try {
                if (StringUtils.hasText((String)saleTenderPriceOpenings.getQuoteColumnEncryption())) {
                    saleTenderPriceOpenings.setQuoteColumnEncryptionByte(saleTenderPriceOpenings.getQuoteColumnEncryption().getBytes("utf-8"));
                    saleTenderPriceOpenings.setQuoteColumnEncryptionByte(null);
                }
            }
            catch (UnsupportedEncodingException e) {
                log.error("\u52a0\u5bc6\u62a5\u4ef7\u5217\u8f6c\u6362\u5f02\u5e38" + e.getMessage());
            }
            List<SaleQuoteMaterialDataVO> saleQuoteMaterialDataList = saleQuoteMaterialDataListMap.get(saleTenderPriceOpenings.getId());
            if (CollectionUtil.isNotEmpty(saleQuoteMaterialDataList)) {
                for (SaleQuoteMaterialDataVO saleQuoteMaterialDataVO : saleQuoteMaterialDataList) {
                    List<SaleTenderQuoteMaterial> materialDataList = saleQuoteMaterialDataVO.getMaterialDataList();
                    for (SaleTenderQuoteMaterial quoteMaterial : materialDataList) {
                        quoteMaterial.setId(IdWorker.getIdStr());
                        quoteMaterial.setHeadId(headId);
                        quoteMaterial.setElsAccount(user.getElsAccount());
                        quoteMaterial.setPriceOpeningsId(saleTenderPriceOpenings.getId());
                        quoteMaterial.setCurrentRound(0);
                        quoteMaterial.setSupplierAccount(user.getElsAccount());
                        quoteMaterial.setSupplierName(elsTenantDTO.getCompanyName());
                        quoteMaterial.setQuoteIp(IPUtils.getIpAddr());
                    }
                    saleQuoteMaterialAllList.addAll(materialDataList);
                }
            }
            priceOpeningsIdList.add(saleTenderPriceOpenings.getId());
        }
        if (CollectionUtil.isNotEmpty(priceOpeningsList)) {
            this.deleteByBidLetter(bidLetterIdList, user.getElsAccount(), CommonConstant.DEL_FLAG_0);
            this.saveBatch(priceOpeningsList, 2000);
        }
        if (CollectionUtil.isNotEmpty(saleQuoteMaterialAllList)) {
            this.saleTenderQuoteMaterialService.deleteByPriceOpeningsIdList(priceOpeningsIdList, user.getElsAccount());
            this.saleTenderQuoteMaterialService.saveBatch(saleQuoteMaterialAllList, 2000);
        }
    }

    private void deleteByBidLetter(List<String> bidLetterIdList, String elsAccount, Integer stage) {
        ((SaleTenderPriceOpeningsMapper)this.baseMapper).deleteByBidLetter(bidLetterIdList, elsAccount, stage);
    }

    @Override
    public void deleteByMainId(String mainId) {
        ((SaleTenderPriceOpeningsMapper)this.baseMapper).deleteByMainId(mainId, TenderFlagInjectionContext.getTenderCheckType());
    }

    @Override
    public void removeByQuotedPriceItemIdList(List<String> quotedPriceItemIdList) {
        if (CollectionUtil.isEmpty(quotedPriceItemIdList)) {
            return;
        }
        LambdaQueryWrapper lambdaQueryWrapper = new LambdaQueryWrapper();
        lambdaQueryWrapper.in(SaleTenderPriceOpenings::getQuotedPriceItemId, quotedPriceItemIdList);
        this.remove((Wrapper)lambdaQueryWrapper);
    }

    @Override
    public List<SaleTenderPriceOpenings> getSalePriceOpeningsBySubpackageId(String subpackageId, List<String> supplierAccountList, String stageQuote, String finalQuote) {
        List<PurchaseTenderBidLetter> purchaseTenderBidLetters = this.purchaseTenderBidLetterService.queryPurchaseTenderBidLetter(subpackageId);
        List<String> bidLetterIdList = purchaseTenderBidLetters.stream().filter(bidLetter -> !BidLetterFormatTypeEnum.OTHER.getValue().equals(bidLetter.getFormatType())).map(BaseEntity::getId).collect(Collectors.toList());
        List<SaleTenderPriceOpenings> priceOpeningsList = this.getLatestQuoteSaleTenderPriceOpeningList(Collections.emptyList(), supplierAccountList, "1".equals(stageQuote), bidLetterIdList, finalQuote);
        if (CollectionUtil.isEmpty(priceOpeningsList)) {
            return Collections.emptyList();
        }
        for (SaleTenderPriceOpenings saleTenderPriceOpenings : priceOpeningsList) {
            try {
                if (saleTenderPriceOpenings.getQuoteColumnEncryptionByte() == null || saleTenderPriceOpenings.getQuoteColumnEncryptionByte().length <= 0) continue;
                saleTenderPriceOpenings.setQuoteColumnEncryption(new String(saleTenderPriceOpenings.getQuoteColumnEncryptionByte(), "utf-8"));
                saleTenderPriceOpenings.setQuoteColumnEncryptionByte(null);
            }
            catch (UnsupportedEncodingException e) {
                log.error("\u52a0\u5bc6\u62a5\u4ef7\u5217\u8f6c\u6362\u5f02\u5e38" + e.getMessage());
            }
        }
        return priceOpeningsList;
    }

    @Override
    public List<SaleTenderPriceOpenings> getSalePriceOpeningsBySubpackageId(String subpackageId, boolean itemizedQuote) {
        List<PurchaseTenderBidLetter> purchaseTenderBidLetters = this.purchaseTenderBidLetterService.queryPurchaseTenderBidLetter(subpackageId, true);
        List<String> bidLetterIdList = purchaseTenderBidLetters.stream().filter(bidLetter -> {
            boolean result;
            boolean bl = result = !BidLetterFormatTypeEnum.OTHER.getValue().equals(bidLetter.getFormatType());
            if (!itemizedQuote) {
                return result;
            }
            return result && "1".equals(bidLetter.getQuoteBidLetter());
        }).map(BaseEntity::getId).collect(Collectors.toList());
        List<SaleTenderPriceOpenings> priceOpeningsList = this.getLatestQuoteSaleTenderPriceOpeningList(Collections.emptyList(), null, true, bidLetterIdList, "0");
        List<SaleTenderPriceOpenings> finalPriceOpeningsList = this.getLatestQuoteSaleTenderPriceOpeningList(Collections.emptyList(), null, true, bidLetterIdList, "1");
        if (CollectionUtil.isNotEmpty(finalPriceOpeningsList)) {
            ArrayList<SaleTenderPriceOpenings> saleTenderPriceOpeningsList = new ArrayList<SaleTenderPriceOpenings>();
            Map finalPriceOpeningsMap = finalPriceOpeningsList.stream().collect(Collectors.toMap(p -> p.getElsAccount() + "_" + p.getBidLetterId(), Function.identity(), (o1, o2) -> o1));
            for (SaleTenderPriceOpenings tenderPriceOpenings : priceOpeningsList) {
                String key = tenderPriceOpenings.getElsAccount() + "_" + tenderPriceOpenings.getBidLetterId();
                SaleTenderPriceOpenings saleTenderPriceOpenings = (SaleTenderPriceOpenings)((Object)finalPriceOpeningsMap.get(key));
                saleTenderPriceOpeningsList.add(saleTenderPriceOpenings == null ? tenderPriceOpenings : saleTenderPriceOpenings);
            }
            priceOpeningsList = saleTenderPriceOpeningsList;
        }
        if (CollectionUtil.isEmpty(priceOpeningsList)) {
            return Collections.emptyList();
        }
        for (SaleTenderPriceOpenings saleTenderPriceOpenings : priceOpeningsList) {
            try {
                if (saleTenderPriceOpenings.getQuoteColumnEncryptionByte() == null || saleTenderPriceOpenings.getQuoteColumnEncryptionByte().length <= 0) continue;
                saleTenderPriceOpenings.setQuoteColumnEncryption(new String(saleTenderPriceOpenings.getQuoteColumnEncryptionByte(), "utf-8"));
                saleTenderPriceOpenings.setQuoteColumnEncryptionByte(null);
            }
            catch (UnsupportedEncodingException e) {
                log.error("\u52a0\u5bc6\u62a5\u4ef7\u5217\u8f6c\u6362\u5f02\u5e38" + e.getMessage());
            }
        }
        return priceOpeningsList;
    }

    @Override
    public List<SaleTenderPriceOpenings> queryByBidLetterIdIn(List<String> bidLetterIds, String supplierAccount) {
        return ((SaleTenderPriceOpeningsMapper)this.baseMapper).queryByBidLetterIdIn(bidLetterIds, supplierAccount);
    }

    @Override
    public void revokeSave(SaleTenderProjectDocumentSubmitInfoVO supplierTenderProjectMasterInfoPage) {
        PurchaseTenderProjectSubpackageInfo subpackageInfo = this.purchaseTenderProjectSubpackageInfoService.selectById(supplierTenderProjectMasterInfoPage.getSubpackageId());
        if (null != subpackageInfo) {
            Date fileSubmitEndTime = null;
            fileSubmitEndTime = "0".equals(TenderFlagInjectionContext.getTenderCheckType()) ? subpackageInfo.getPreFileSubmitEndTime() : subpackageInfo.getFileSubmitEndTime();
            Assert.isTrue((boolean)new Date().before(fileSubmitEndTime), (String)I18nUtil.translate((String)"i18n_alert_QInJKIIRW_ebbbb46d", (String)"\u6587\u4ef6\u9012\u4ea4\u65f6\u95f4\u5df2\u8fc7!"));
        }
        TenderProjectSupplier tenderProjectSupplier = (TenderProjectSupplier)((Object)SysUtil.copyProperties((Object)((Object)supplierTenderProjectMasterInfoPage), TenderProjectSupplier.class));
        this.saleTenderProjectSupplierService.updateResponseById(tenderProjectSupplier);
        boolean hasPreTrial = SubpackageInfoCheckTypeEnum.hasPreTrial(TenderFlagInjectionContext.getTenderCheckType());
        String operation = "documentRevokeSubmitFile";
        if (hasPreTrial) {
            operation = "preDocumentRevokeSubmitFile";
        }
        this.sendMsg(tenderProjectSupplier, operation);
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void batchRevokeSave(String subpackageId) {
        LambdaQueryWrapper lambdaQueryWrapper = new LambdaQueryWrapper();
        lambdaQueryWrapper.eq(TenderProjectSupplier::getSubpackageId, (Object)subpackageId);
        if (SubpackageInfoCheckTypeEnum.PRE_TRIAL.getValue().equals(TenderFlagInjectionContext.getTenderCheckType())) {
            lambdaQueryWrapper.eq(TenderProjectSupplier::getPreResponseStatus, (Object)"1");
        } else {
            lambdaQueryWrapper.eq(TenderProjectSupplier::getResultResponseStatus, (Object)"1");
        }
        List supplierList = this.saleTenderProjectSupplierService.list((Wrapper)lambdaQueryWrapper);
        if (CollectionUtil.isEmpty((Collection)supplierList)) {
            return;
        }
        List<String> idList = supplierList.stream().map(BaseEntity::getId).collect(Collectors.toList());
        this.saleTenderProjectSupplierService.updateResponseByIdList(idList);
        String operation = "documentRevokeSubmitFileByClarification";
        boolean hasPreTrial = SubpackageInfoCheckTypeEnum.hasPreTrial(TenderFlagInjectionContext.getTenderCheckType());
        if (hasPreTrial) {
            operation = "preDocumentRevokeSubmitFileByClarification";
        }
        List accountList = supplierList.stream().map(TenderProjectSupplier::getSupplierAccount).collect(Collectors.toList());
        TenderProjectSupplier supplier = (TenderProjectSupplier)((Object)supplierList.get(0));
        StringBuilder urlParams = new StringBuilder("tenderProjectId=").append(supplier.getTenderProjectId()).append("&subpackageId=").append(supplier.getSubpackageId());
        String idStr = IdWorker.getIdStr();
        JSONObject jsonObject = JSONObject.parseObject((String)JSONObject.toJSONString((Object)((Object)supplier)));
        jsonObject.put("urlParams", (Object)urlParams);
        this.redisUtil.set("sys:message:" + idStr, (Object)jsonObject, 172800L);
        super.sendMessage(TenantContext.getTenant(), "tender", operation, idStr, "tenderBusDataServiceImpl", accountList);
    }

    @Override
    public List<SaleAttachmentDTO> queryAttachmentBySubpackageId(String subpackageId, String supplierAccount) {
        TenderProjectSupplier projectSupplier = new TenderProjectSupplier();
        projectSupplier.setSubpackageId(subpackageId);
        projectSupplier.setSupplierAccount(supplierAccount);
        List<TenderProjectSupplier> tenderProjectSuppliers = this.saleTenderProjectSupplierService.selectBySubpackageId(projectSupplier);
        Assert.isTrue((boolean)ObjectUtil.isNotEmpty(tenderProjectSuppliers), (String)I18nUtil.translate((String)"i18n_field_SsRVHWVImW_290fb9b", (String)"\u65e0\u62a5\u540d\u4fe1\u606f,\u8bf7\u68c0\u67e5!"));
        TenderProjectSupplier masterInfo = tenderProjectSuppliers.get(0);
        List<SaleAttachmentDTO> saleAttachmentDTOList = this.invokeBaseRpcService.selectSaleAttachmentByMainId(masterInfo.getId() + "_" + TenderFlagInjectionContext.getTenderCheckType());
        saleAttachmentDTOList = this.getStepSaleAttachmentDTO(saleAttachmentDTOList);
        return saleAttachmentDTOList;
    }

    @Override
    public void addQuotedPriceInfo(Map<String, PurchaseTenderBidLetter> bidLetterMap, List<SaleTenderPriceOpenings> priceOpeningsList, List<SaleQuoteMaterialDataVO> materialDataVOList, Integer stage, String quotedPriceItemId, String finalQuote) {
        LoginUserDTO user = SysUtil.getLoginUser();
        List tenantList = this.accountRpcService.getTenantList(Arrays.asList(user.getElsAccount()));
        Map tenantListMap = tenantList.stream().collect(Collectors.toMap(ParentEntityDTO::getElsAccount, Function.identity()));
        ElsTenantDTO elsTenantDTO = (ElsTenantDTO)tenantListMap.get(user.getElsAccount());
        Map<String, List<SaleQuoteMaterialDataVO>> saleQuoteMaterialDataListMap = materialDataVOList.stream().collect(Collectors.groupingBy(SaleQuoteMaterialDataVO::getPriceOpeningsId));
        ArrayList<SaleTenderQuoteMaterial> saleQuoteMaterialAllList = new ArrayList<SaleTenderQuoteMaterial>();
        for (SaleTenderPriceOpenings saleTenderPriceOpenings : priceOpeningsList) {
            String originPriceOpeningsId = saleTenderPriceOpenings.getId();
            saleTenderPriceOpenings.setId(IdWorker.getIdStr());
            saleTenderPriceOpenings.setSupplierName(elsTenantDTO.getCompanyName());
            saleTenderPriceOpenings.setElsAccount(user.getElsAccount());
            PurchaseTenderBidLetter purchaseTenderBidLetter = bidLetterMap.get(saleTenderPriceOpenings.getBidLetterId());
            saleTenderPriceOpenings.setCheckType(purchaseTenderBidLetter.getCheckType());
            saleTenderPriceOpenings.setProcessType(purchaseTenderBidLetter.getProcessType());
            saleTenderPriceOpenings.setCurrentStep(purchaseTenderBidLetter.getCurrentStep());
            saleTenderPriceOpenings.setStageQuote("1");
            saleTenderPriceOpenings.setStage(stage);
            saleTenderPriceOpenings.setFinalQuote(finalQuote);
            saleTenderPriceOpenings.setQuotedPriceItemId(quotedPriceItemId);
            List<SaleQuoteMaterialDataVO> saleQuoteMaterialDataList = saleQuoteMaterialDataListMap.get(originPriceOpeningsId);
            if (!CollectionUtil.isNotEmpty(saleQuoteMaterialDataList)) continue;
            JSONArray customizeFieldDataList = JSON.parseArray((String)saleTenderPriceOpenings.getCustomizeFieldData());
            for (SaleQuoteMaterialDataVO saleQuoteMaterialDataVO : saleQuoteMaterialDataList) {
                List<SaleTenderQuoteMaterial> materialDataList = saleQuoteMaterialDataVO.getMaterialDataList();
                for (SaleTenderQuoteMaterial quoteMaterial : materialDataList) {
                    quoteMaterial.setId(IdWorker.getIdStr());
                    quoteMaterial.setHeadId(saleTenderPriceOpenings.getHeadId());
                    quoteMaterial.setElsAccount(user.getElsAccount());
                    quoteMaterial.setPriceOpeningsId(saleTenderPriceOpenings.getId());
                    quoteMaterial.setCurrentRound(stage);
                    quoteMaterial.setSupplierAccount(user.getElsAccount());
                    quoteMaterial.setSupplierName(elsTenantDTO.getCompanyName());
                    quoteMaterial.setQuoteIp(IPUtils.getIpAddr());
                    for (Object o : customizeFieldDataList) {
                        String quotedPrice;
                        JSONObject jsonObject = (JSONObject)o;
                        String materialId = jsonObject.getString("materialId");
                        if (!quoteMaterial.getMaterialId().equals(materialId) || !StrUtil.isNotBlank((CharSequence)(quotedPrice = jsonObject.getString("quotedPrice")))) continue;
                        quoteMaterial.setEvaPrice(new BigDecimal(quotedPrice));
                    }
                }
                saleQuoteMaterialAllList.addAll(materialDataList);
            }
        }
        this.saveBatch(priceOpeningsList, 2000);
        this.saleTenderQuoteMaterialService.saveBatch(saleQuoteMaterialAllList, 2000);
    }

    @Override
    public void revokeQuotedPriceInfo(String quotedPriceItemId) {
        LoginUserDTO user = SysUtil.getLoginUser();
        this.saleTenderQuoteMaterialService.deleteByBidLetterQuotedPriceItemId(quotedPriceItemId, user.getElsAccount());
        ((SaleTenderPriceOpeningsMapper)this.baseMapper).deleteByBidLetterQuotedPriceItemId(quotedPriceItemId, user.getElsAccount());
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void encryptionOrDecryptionLetterStatus(SaleTenderPriceOpenings saleTenderPriceOpenings, String status) {
        SaleTenderPriceOpenings priceOpenings = new SaleTenderPriceOpenings();
        priceOpenings.setId(saleTenderPriceOpenings.getId());
        priceOpenings.setEncryption(status);
        ((SaleTenderPriceOpeningsMapper)this.baseMapper).updateById((Object)priceOpenings);
    }

    @Override
    public void rankQuotedPrice(String subpackageId) {
        List<SaleTenderPriceOpenings> saleTenderPriceOpeningsList = ((SaleTenderPriceOpeningsMapper)this.baseMapper).selectByMainSubpackageId(subpackageId);
        Map<String, List<SaleTenderPriceOpenings>> bidLetterPriceMap = saleTenderPriceOpeningsList.stream().collect(Collectors.groupingBy(SaleTenderPriceOpenings::getBidLetterId));
        List<String> bidLetterIds = saleTenderPriceOpeningsList.stream().map(SaleTenderPriceOpenings::getBidLetterId).distinct().collect(Collectors.toList());
        List<PurchaseTenderPriceOpeningsTemplate> purchaseTenderPriceOpeningsTemplates = this.purchasePriceOpeningsTemplateService.selectByMainIds(bidLetterIds);
        Map<String, PurchaseTenderPriceOpeningsTemplate> priceOpeningsTemplateMap = purchaseTenderPriceOpeningsTemplates.stream().collect(Collectors.toMap(PurchaseTenderPriceOpeningsTemplate::getBidLetterId, priceOpeningsTemplate -> priceOpeningsTemplate, (o1, o2) -> o1));
        ArrayList priceModelAllList = new ArrayList();
        for (String bidLetterId : bidLetterPriceMap.keySet()) {
            List<SaleTenderPriceOpenings> saleTenderPriceOpeningList = bidLetterPriceMap.get(bidLetterId);
            Map<String, List<SaleTenderPriceOpenings>> supplierPriceMap = saleTenderPriceOpeningList.stream().collect(Collectors.groupingBy(BaseEntity::getElsAccount));
            ArrayList supplierMaxStagePriceList = new ArrayList();
            supplierPriceMap.forEach((supplierAccount, supplierPriceList) -> {
                SaleTenderPriceOpenings saleTenderPriceOpenings = supplierPriceList.stream().max(Comparator.comparing(SaleTenderPriceOpenings::getStage)).get();
                supplierMaxStagePriceList.add(saleTenderPriceOpenings);
            });
            PurchaseTenderPriceOpeningsTemplate priceOpeningsTemplate2 = priceOpeningsTemplateMap.get(bidLetterId);
            if (priceOpeningsTemplate2 == null) continue;
            String customizeFieldModel = priceOpeningsTemplate2.getCustomizeFieldModel();
            List columnList = JSONArray.parseArray((String)customizeFieldModel, CustomColumnModel.class);
            List filterColumnList = columnList.stream().filter(column -> CustomerFieldCategoryEnum.TENDER_OFFERS_COLUMN.getValue().equals(column.getFieldCategory())).collect(Collectors.toList());
            for (CustomColumnModel customColumnModel : filterColumnList) {
                ArrayList priceModels = new ArrayList();
                String field = customColumnModel.getField();
                supplierMaxStagePriceList.forEach(supplierMaxStagePrice -> {
                    if (supplierMaxStagePrice.getCustomizeFieldData().indexOf(field) != -1) {
                        PriceModel priceModel = new PriceModel();
                        priceModel.setField(customColumnModel.getField());
                        priceModel.setPriceOpeningsId(supplierMaxStagePrice.getId());
                        priceModel.setTitle(customColumnModel.getTitle());
                        JSONArray dataJsonArray = JSONArray.parseArray((String)supplierMaxStagePrice.getCustomizeFieldData());
                        for (int j = 0; j < dataJsonArray.size(); ++j) {
                            JSONObject jsonObject = dataJsonArray.getJSONObject(j);
                            Object value = jsonObject.get((Object)customColumnModel.getField());
                            if (value == null) continue;
                            priceModel.setPrice(new BigDecimal(value.toString()));
                            break;
                        }
                        priceModels.add(priceModel);
                    }
                });
                Collections.sort(priceModels, Comparator.comparing(PriceModel::getPrice));
                for (int i = 0; i < priceModels.size(); ++i) {
                    PriceModel priceModel = (PriceModel)priceModels.get(i);
                    priceModel.setSort(i + 1);
                }
                priceModelAllList.addAll(priceModels);
            }
        }
        ArrayList<SaleTenderPriceOpenings> updSaleTenderPriceOpeningsList = new ArrayList<SaleTenderPriceOpenings>();
        Map<String, List<PriceModel>> priceModelAllMap = priceModelAllList.stream().collect(Collectors.groupingBy(PriceModel::getPriceOpeningsId));
        for (SaleTenderPriceOpenings saleTenderPriceOpenings : saleTenderPriceOpeningsList) {
            List<PriceModel> priceModels = priceModelAllMap.get(saleTenderPriceOpenings.getId());
            if (!CollectionUtil.isNotEmpty(priceModels)) continue;
            saleTenderPriceOpenings.setPriceData(JSONObject.toJSONString(priceModels));
            updSaleTenderPriceOpeningsList.add(saleTenderPriceOpenings);
        }
        log.info("\u591a\u8f6e\u62a5\u4ef7\u7ed3\u675f\u66f4\u65b0\u7684\u62a5\u4ef7\u4fe1\u606f:{}", (Object)JSONObject.toJSONString(updSaleTenderPriceOpeningsList));
        if (CollectionUtil.isNotEmpty(updSaleTenderPriceOpeningsList)) {
            this.updateBatchById(updSaleTenderPriceOpeningsList);
        }
    }

    @Override
    public SaleTenderProjectDocumentSubmitInfoViewVO querySaleSubmitInfoBySubpackageId(String subpackageId, String supplierId) {
        TenderProjectSupplier tenderProjectSupplier = (TenderProjectSupplier)((Object)this.saleTenderProjectSupplierService.getById((Serializable)((Object)supplierId)));
        Assert.isTrue((tenderProjectSupplier != null ? 1 : 0) != 0, (String)I18nUtil.translate((String)"i18n_alert_mSWFW_e7e80f68", (String)"\u67e5\u65e0\u6570\u636e!"));
        if (!TenderProjectSupplieResponseStatusEnum.RESPONSE_BID.getValue().equals(TenderOperationFieldUtils.getFieldStringValue((Object)tenderProjectSupplier, "responseStatus"))) {
            return null;
        }
        SaleTenderProjectDocumentSubmitInfoViewVO submitInfoViewVO = (SaleTenderProjectDocumentSubmitInfoViewVO)((Object)SysUtil.copyProperties((Object)((Object)tenderProjectSupplier), SaleTenderProjectDocumentSubmitInfoViewVO.class));
        submitInfoViewVO.setBusAccount(tenderProjectSupplier.getPurchaseEnterpriseAccount());
        List<SaleAttachmentDTO> saleAttachmentDTOList = this.invokeBaseRpcService.selectSaleAttachmentByMainId(tenderProjectSupplier.getId() + "_" + TenderFlagInjectionContext.getTenderCheckType());
        saleAttachmentDTOList = this.getStepSaleAttachmentDTO(saleAttachmentDTOList);
        submitInfoViewVO.setSaleAttachmentDTOList(saleAttachmentDTOList);
        List<SaleTenderBidLetterVo> tenderBidLetterVo = this.selectFinalOfferBidLetterVo(tenderProjectSupplier.getSubpackageId(), null, tenderProjectSupplier.getSupplierAccount(), false);
        submitInfoViewVO.setTenderBidLetterVoList(tenderBidLetterVo);
        return submitInfoViewVO;
    }

    private List<SaleAttachmentDTO> getStepSaleAttachmentDTO(List<SaleAttachmentDTO> saleAttachmentDTOList) {
        String checkType = TenderFlagInjectionContext.getTenderCheckType();
        String processType = TenderFlagInjectionContext.getTenderProcessType();
        String currentStep = TenderFlagInjectionContext.getTenderCurrentStep();
        String fileType = "";
        if ("0".equals(checkType)) {
            fileType = SaleTenderDocumentSubmitEnum.PRE_PROCESS.getValue();
        } else if ("0".equals(processType)) {
            fileType = SaleTenderDocumentSubmitEnum.PROCESS.getValue();
        } else if ("0".equals(currentStep)) {
            fileType = SaleTenderDocumentSubmitEnum.ONE_STEP_PROCESS.getValue();
        }
        if (CollectionUtil.isNotEmpty(saleAttachmentDTOList)) {
            String finalFileType = fileType;
            saleAttachmentDTOList = StrUtil.isBlank((CharSequence)finalFileType) ? saleAttachmentDTOList.stream().filter(item -> SaleTenderDocumentSubmitEnum.ONE_STEP_PROCESS.getValue().equals(item.getFileType()) || SaleTenderDocumentSubmitEnum.TWO_STEP_PROCESS.getValue().equals(item.getFileType())).collect(Collectors.toList()) : saleAttachmentDTOList.stream().filter(item -> finalFileType.equals(item.getFileType())).collect(Collectors.toList());
        }
        return saleAttachmentDTOList;
    }

    private List<SaleTenderBidLetterVo> selectFinalOfferBidLetterVo(String subpackageId, String quotedPriceItemId, String supplierAccount, boolean hasStagePrice) {
        List<PurchaseTenderBidLetter> purchaseTenderBidLetters = this.purchaseTenderBidLetterService.queryPurchaseTenderBidLetter(subpackageId);
        if (CollectionUtils.isEmpty(purchaseTenderBidLetters)) {
            return null;
        }
        List<String> bidIds = purchaseTenderBidLetters.stream().map(BaseEntity::getId).collect(Collectors.toList());
        ArrayList saleTenderPriceOpeningList = this.getLatestQuoteSaleTenderPriceOpeningList(quotedPriceItemId, Arrays.asList(supplierAccount), hasStagePrice, bidIds, "0");
        if (CollectionUtils.isEmpty(saleTenderPriceOpeningList)) {
            List<PurchaseTenderPriceOpeningsTemplate> purchaseTenderPriceOpeningTemplates = this.purchasePriceOpeningsTemplateService.selectByMainIds(bidIds);
            saleTenderPriceOpeningList = SysUtil.copyProperties(purchaseTenderPriceOpeningTemplates, SaleTenderPriceOpenings.class);
            saleTenderPriceOpeningList.stream().forEach(item -> item.setId(IdWorker.getIdStr()));
        }
        Map<String, List<SaleTenderPriceOpenings>> saleTenderPriceOpeningListMap = saleTenderPriceOpeningList.stream().collect(Collectors.groupingBy(SaleTenderPriceOpenings::getBidLetterId));
        List<String> priceOpeningIdList = saleTenderPriceOpeningList.stream().map(BaseEntity::getId).collect(Collectors.toList());
        ArrayList quoteMaterialList = this.saleTenderQuoteMaterialService.selectByMainIds(priceOpeningIdList, supplierAccount);
        if (CollectionUtils.isEmpty(quoteMaterialList)) {
            List<PurchaseTenderQuoteMaterial> materialList = this.purchaseTenderQuoteMaterialService.selectByMainIds(bidIds);
            quoteMaterialList = SysUtil.copyProperties(materialList, SaleTenderQuoteMaterial.class);
            quoteMaterialList.parallelStream().forEach(item -> item.setId(null));
        }
        Map<String, List<SaleTenderQuoteMaterial>> quoteMaterialListByBidLetterId = quoteMaterialList.stream().collect(Collectors.groupingBy(SaleTenderQuoteMaterial::getBidLetterId));
        ArrayList<SaleTenderBidLetterVo> tenderBidLetterList = new ArrayList<SaleTenderBidLetterVo>();
        for (PurchaseTenderBidLetter purchaseTenderBidLetter : purchaseTenderBidLetters) {
            SaleTenderBidLetterVo saleTenderBidLetterVo = new SaleTenderBidLetterVo();
            BeanUtils.copyProperties((Object)((Object)purchaseTenderBidLetter), (Object)((Object)saleTenderBidLetterVo));
            List<SaleTenderPriceOpenings> openingsList = saleTenderPriceOpeningListMap.get(purchaseTenderBidLetter.getId());
            openingsList.stream().forEach(saleTenderPriceOpenings -> {
                try {
                    if (saleTenderPriceOpenings.getQuoteColumnEncryptionByte() != null && saleTenderPriceOpenings.getQuoteColumnEncryptionByte().length > 0) {
                        saleTenderPriceOpenings.setQuoteColumnEncryption(new String(saleTenderPriceOpenings.getQuoteColumnEncryptionByte(), "utf-8"));
                        saleTenderPriceOpenings.setQuoteColumnEncryptionByte(null);
                    }
                }
                catch (UnsupportedEncodingException e) {
                    log.error("\u52a0\u5bc6\u62a5\u4ef7\u5217\u8f6c\u6362\u5f02\u5e38" + e.getMessage());
                }
            });
            saleTenderBidLetterVo.setPriceOpeningsList(openingsList);
            List<SaleTenderQuoteMaterial> materialAllList = quoteMaterialListByBidLetterId.get(purchaseTenderBidLetter.getId());
            if (CollectionUtils.isNotEmpty(materialAllList)) {
                ArrayList<SaleQuoteMaterialDataVO> quoteColumnList = new ArrayList<SaleQuoteMaterialDataVO>();
                Map<String, List<SaleTenderQuoteMaterial>> materialDataAllGroupByQuoteField = materialAllList.stream().collect(Collectors.groupingBy(SaleTenderQuoteMaterial::getQuoteField));
                for (String quoteField : materialDataAllGroupByQuoteField.keySet()) {
                    SaleQuoteMaterialDataVO saleQuoteMaterialDataVO = new SaleQuoteMaterialDataVO();
                    saleQuoteMaterialDataVO.setField(quoteField);
                    SaleTenderPriceOpenings saleTenderPriceOpenings2 = openingsList.get(0);
                    List<CustomColumnModel> columnModelList = FastJsonUtils.toList(saleTenderPriceOpenings2.getCustomizeFieldModel(), CustomColumnModel.class);
                    for (CustomColumnModel customColumnModel : columnModelList) {
                        if (!quoteField.equals(customColumnModel.getField())) continue;
                        saleQuoteMaterialDataVO.setTitle(customColumnModel.getTitle());
                        break;
                    }
                    List<SaleTenderQuoteMaterial> materialList = materialDataAllGroupByQuoteField.get(quoteField);
                    materialList.stream().forEach(saleTenderQuoteMaterial -> saleTenderQuoteMaterial.setPriceOpeningsId(saleTenderPriceOpenings2.getId()));
                    saleQuoteMaterialDataVO.setMaterialDataList(materialList);
                    saleQuoteMaterialDataVO.setPriceOpeningsId(saleTenderPriceOpenings2.getId());
                    quoteColumnList.add(saleQuoteMaterialDataVO);
                }
                saleTenderBidLetterVo.setSaleQuoteMaterialDataList(quoteColumnList);
            }
            tenderBidLetterList.add(saleTenderBidLetterVo);
        }
        return tenderBidLetterList;
    }
}

