/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.tender.supplier.controller;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.StrUtil;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.els.common.api.vo.Result;
import com.els.common.aspect.annotation.AutoLog;
import com.els.common.aspect.annotation.SrmValidated;
import com.els.common.system.base.controller.BaseController;
import com.els.common.system.query.QueryGenerator;
import com.els.common.util.I18nUtil;
import com.els.common.util.SysUtil;
import com.els.config.mybatis.TenantContext;
import com.els.modules.tender.common.aspect.TenderPermissions;
import com.els.modules.tender.project.enumerate.TenderRoleEnum;
import com.els.modules.tender.project.service.PurchaseTenderProjectHeadService;
import com.els.modules.tender.project.vo.PurchaseTenderProjectInfoVO;
import com.els.modules.tender.sale.enumerate.TenderProjectMarginItemStatusEnum;
import com.els.modules.tender.supplier.entity.PurchaseTenderProjectMarginDeductRecord;
import com.els.modules.tender.supplier.entity.PurchaseTenderProjectMarginHead;
import com.els.modules.tender.supplier.entity.PurchaseTenderProjectMarginItem;
import com.els.modules.tender.supplier.entity.PurchaseTenderProjectRefund;
import com.els.modules.tender.supplier.excel.PurchaseTenderProjectRefundExcelExportServiceImpl;
import com.els.modules.tender.supplier.service.PurchaseTenderProjectMarginDeductRecordService;
import com.els.modules.tender.supplier.service.PurchaseTenderProjectMarginHeadService;
import com.els.modules.tender.supplier.service.PurchaseTenderProjectMarginItemService;
import com.els.modules.tender.supplier.service.PurchaseTenderProjectRefundService;
import com.els.modules.tender.supplier.vo.PurchaseTenderProjectMarginHeadVO;
import com.els.modules.tender.supplier.vo.PurchaseTenderProjectMarginItemVO;
import com.els.modules.tender.supplier.vo.PurchaseTenderProjectMarginStatVO;
import com.els.modules.tender.supplier.vo.PurchaseTenderProjectMarginTypeInfoVO;
import com.els.rpc.service.InvokeBaseRpcService;
import com.google.common.collect.Lists;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.Assert;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.servlet.ModelAndView;

@RestController
@RequestMapping(value={"/tender/supplier/purchaseTenderProjectMarginHead"})
@Api(tags={"\u4fdd\u8bc1\u91d1\u7f34\u7eb3\u4fe1\u606f\u884c\u5934-\u91c7\u8d2d\u5546"})
public class PurchaseTenderProjectMarginHeadController
extends BaseController<PurchaseTenderProjectMarginHead, PurchaseTenderProjectMarginHeadService> {
    private static final Logger log = LoggerFactory.getLogger(PurchaseTenderProjectMarginHeadController.class);
    @Autowired
    private PurchaseTenderProjectMarginHeadService marginHeadService;
    @Autowired
    private PurchaseTenderProjectMarginItemService purchaseTenderProjectMarginItemService;
    @Autowired
    private PurchaseTenderProjectRefundService purchaseTenderProjectRefundService;
    @Resource
    private InvokeBaseRpcService invokeBaseRpcService;
    @Autowired
    private PurchaseTenderProjectHeadService purchaseTenderProjectHeadService;
    @Autowired
    private PurchaseTenderProjectMarginDeductRecordService purchaseTenderProjectMarginDeductRecordService;

    @ApiOperation(value="\u5217\u8868\u67e5\u8be2", notes="\u5217\u8868\u67e5\u8be2")
    @GetMapping(value={"/queryList"})
    @RequiresPermissions(value={"tender#tenderProject:list"})
    @TenderPermissions(value={TenderRoleEnum.PURCHASE_EXECUTOR, TenderRoleEnum.BIDING_USER})
    public Result<?> queryList(@RequestParam(name="subpackageId") String subpackageId) {
        List<PurchaseTenderProjectMarginHeadVO> purchaseTenderProjectMarginHeads = this.marginHeadService.queryList(subpackageId);
        return Result.ok(purchaseTenderProjectMarginHeads);
    }

    @ApiOperation(value="\u67e5\u8be2\u4fdd\u8bc1\u91d1\u7f34\u7eb3\u60c5\u51b5(\u9000\u6b3e\u67e5\u8be2\u4f7f\u7528)", notes="\u67e5\u8be2\u4fdd\u8bc1\u91d1\u7f34\u7eb3\u60c5\u51b5(\u9000\u6b3e\u67e5\u8be2\u4f7f\u7528)")
    @GetMapping(value={"/queryMarginInfo"})
    @RequiresPermissions(value={"tender#tenderProject:list"})
    @TenderPermissions(value={TenderRoleEnum.PURCHASE_EXECUTOR, TenderRoleEnum.BIDING_USER})
    public Result<?> queryRefundList(@RequestParam(name="subpackageId") String subpackageId, @RequestParam(name="refundType") String refundType) {
        List<PurchaseTenderProjectMarginTypeInfoVO> marginTypeInfoVOS = this.marginHeadService.queryMarginInfo(subpackageId, refundType);
        return Result.ok(marginTypeInfoVOS);
    }

    @ApiOperation(value="\u7edf\u8ba1\u6c47\u603b\u67e5\u8be2", notes="\u7edf\u8ba1\u6c47\u603b\u67e5\u8be2")
    @GetMapping(value={"/queryStat"})
    @RequiresPermissions(value={"tender#tenderProject:queryById"})
    @TenderPermissions(value={TenderRoleEnum.PURCHASE_EXECUTOR, TenderRoleEnum.BIDING_USER})
    public Result<?> queryStat(@RequestParam(name="subpackageId") String subpackageId) {
        PurchaseTenderProjectMarginStatVO purchaseTenderProjectMarginHeads = this.marginHeadService.queryStat(subpackageId);
        return Result.ok((Object)purchaseTenderProjectMarginHeads);
    }

    @AutoLog(busModule="\u4fdd\u8bc1\u91d1\u8bb0\u5f55\u6dfb\u52a0", value="\u4fdd\u8bc1\u91d1\u8bb0\u5f55\u6dfb\u52a0")
    @ApiOperation(value="\u4fdd\u8bc1\u91d1\u8bb0\u5f55\u6dfb\u52a0", notes="\u4fdd\u8bc1\u91d1\u8bb0\u5f55\u6dfb\u52a0")
    @PostMapping(value={"/addMargin"})
    @RequiresPermissions(value={"tender#tenderProject:add"})
    @SrmValidated
    public Result<?> addMargin(@RequestBody PurchaseTenderProjectMarginItemVO tenderProjectMarginItemVO) {
        tenderProjectMarginItemVO.setStatus(TenderProjectMarginItemStatusEnum.UNCONFIRMED.getValue());
        PurchaseTenderProjectMarginItem purchaseTenderProjectMarginItem = this.marginHeadService.addMargin(tenderProjectMarginItemVO);
        return Result.ok((Object)((Object)purchaseTenderProjectMarginItem));
    }

    @AutoLog(busModule="\u4fdd\u8bc1\u91d1\u8bb0\u5f55\u4fee\u6539", value="\u4fdd\u8bc1\u91d1\u8bb0\u5f55\u4fee\u6539")
    @ApiOperation(value="\u4fdd\u8bc1\u91d1\u8bb0\u5f55\u4fee\u6539", notes="\u4fdd\u8bc1\u91d1\u8bb0\u5f55\u4fee\u6539")
    @PostMapping(value={"/editMargin"})
    @RequiresPermissions(value={"tender#tenderProject:edit"})
    @SrmValidated
    public Result<?> editMargin(@RequestBody PurchaseTenderProjectMarginItemVO tenderProjectMarginItemVO) {
        PurchaseTenderProjectMarginItem purchaseTenderProjectMarginItem = this.marginHeadService.editMargin(tenderProjectMarginItemVO);
        return Result.ok((Object)((Object)purchaseTenderProjectMarginItem));
    }

    @AutoLog(busModule="\u4fdd\u8bc1\u91d1\u8bb0\u5f55\u63d0\u4ea4", value="\u4fdd\u8bc1\u91d1\u8bb0\u5f55\u63d0\u4ea4")
    @ApiOperation(value="\u4fdd\u8bc1\u91d1\u8bb0\u5f55\u63d0\u4ea4", notes="\u4fdd\u8bc1\u91d1\u8bb0\u5f55\u63d0\u4ea4")
    @PostMapping(value={"/submitMargin"})
    @SrmValidated
    @RequiresPermissions(value={"tender#tenderProject:publish"})
    public Result<?> submitMargin(@RequestBody PurchaseTenderProjectMarginItemVO tenderProjectMarginItemVO) {
        tenderProjectMarginItemVO.setStatus(TenderProjectMarginItemStatusEnum.CONFIRMED.getValue());
        this.marginHeadService.submitMargin(tenderProjectMarginItemVO);
        return Result.ok((Object)((Object)tenderProjectMarginItemVO));
    }

    @ApiOperation(value="\u4fdd\u8bc1\u91d1\u786e\u8ba4", notes="\u4fdd\u8bc1\u91d1\u786e\u8ba4")
    @PostMapping(value={"/confirmMargin"})
    @SrmValidated
    @RequiresPermissions(value={"tender#biddingHall:operational"})
    public Result<?> confirmMargin(@RequestBody List<String> ids) {
        this.marginHeadService.confirmMargin(ids);
        return Result.ok();
    }

    @ApiOperation(value="\u4fdd\u8bc1\u91d1\u9000\u56de", notes="\u4fdd\u8bc1\u91d1\u9000\u56de")
    @GetMapping(value={"/reject"})
    @RequiresPermissions(value={"tender#biddingHall:operational"})
    public Result<?> reject(@RequestParam(name="id") String id) {
        this.marginHeadService.reject(id);
        return Result.ok();
    }

    @ApiOperation(value="\u67e5\u8be2\u4fdd\u8bc1\u91d1\u7f34\u7eb3\u4fe1\u606f\u660e\u7ec6", notes="\u67e5\u8be2\u4fdd\u8bc1\u91d1\u7f34\u7eb3\u4fe1\u606f\u660e\u7ec6")
    @GetMapping(value={"/queryItemById"})
    @RequiresPermissions(value={"tender#tenderProject:queryById"})
    @TenderPermissions(value={TenderRoleEnum.PURCHASE_EXECUTOR, TenderRoleEnum.BIDING_USER})
    public Result<?> queryItemById(@RequestParam(name="id") String id) {
        PurchaseTenderProjectMarginItem tenderProjectMarginItem = (PurchaseTenderProjectMarginItem)((Object)this.purchaseTenderProjectMarginItemService.getById((Serializable)((Object)id)));
        Assert.isTrue((tenderProjectMarginItem != null ? 1 : 0) != 0, (String)I18nUtil.translate((String)"i18n_alert_tHxMK_c2373c29", (String)"\u8bb0\u5f55\u4e0d\u5b58\u5728\uff01"));
        PurchaseTenderProjectInfoVO purchaseTenderProjectInfoVO = this.purchaseTenderProjectHeadService.queryProjectInfoBySubpackageId(tenderProjectMarginItem.getSubpackageId());
        String elsAccount = TenantContext.getTenant();
        Assert.isTrue((elsAccount.equals(purchaseTenderProjectInfoVO.getPurchaseExecutorAccount()) || elsAccount.equals(purchaseTenderProjectInfoVO.getPurchaseEnterpriseAccount()) ? 1 : 0) != 0, (String)I18nUtil.translate((String)"i18n_alert_tHxMK_c2373c29", (String)"\u8bb0\u5f55\u4e0d\u5b58\u5728\uff01"));
        PurchaseTenderProjectMarginItemVO tenderProjectMarginItemVO = (PurchaseTenderProjectMarginItemVO)((Object)SysUtil.copyProperties((Object)((Object)tenderProjectMarginItem), PurchaseTenderProjectMarginItemVO.class));
        tenderProjectMarginItemVO.setSubpackageName(purchaseTenderProjectInfoVO.getSubpackageName());
        tenderProjectMarginItemVO.setTenderProjectName(purchaseTenderProjectInfoVO.getTenderProjectName());
        tenderProjectMarginItemVO.setTenderProjectNumber(purchaseTenderProjectInfoVO.getTenderProjectNumber());
        List attachmentDTOS = this.invokeBaseRpcService.selectPurchaseAttachmentByMainId(tenderProjectMarginItemVO.getId());
        tenderProjectMarginItemVO.setAttachmentDTOList(attachmentDTOS);
        return Result.ok((Object)((Object)tenderProjectMarginItemVO));
    }

    @AutoLog(busModule="\u4fdd\u8bc1\u91d1\u9000\u6b3e", value="\u4fdd\u8bc1\u91d1\u9000\u6b3e")
    @ApiOperation(value="\u4fdd\u8bc1\u91d1\u9000\u6b3e", notes="\u4fdd\u8bc1\u91d1\u9000\u6b3e")
    @PostMapping(value={"/refund"})
    @RequiresPermissions(value={"tender#biddingHall:operational"})
    @SrmValidated
    public Result<?> refund(@RequestBody List<PurchaseTenderProjectRefund> tenderProjectRefunds) {
        this.marginHeadService.refund(tenderProjectRefunds);
        return Result.ok();
    }

    @ApiOperation(value="\u67e5\u8be2\u4fdd\u8bc1\u91d1\u7f34\u7eb3\u4fe1\u606f\u5217\u8868", notes="\u67e5\u8be2\u4fdd\u8bc1\u91d1\u7f34\u7eb3\u4fe1\u606f\u5217\u8868")
    @GetMapping(value={"/queryItem"})
    @RequiresPermissions(value={"tender#tenderProject:queryById"})
    @TenderPermissions(value={TenderRoleEnum.PURCHASE_EXECUTOR, TenderRoleEnum.BIDING_USER})
    public Result<?> queryItem(PurchaseTenderProjectMarginItem tenderProjectMarginItem, HttpServletRequest req) {
        List<PurchaseTenderProjectMarginItem> list;
        ArrayList<String> statusList = new ArrayList<String>();
        if (StrUtil.isNotBlank((CharSequence)tenderProjectMarginItem.getStatus())) {
            statusList.add(tenderProjectMarginItem.getStatus());
        }
        if (CollectionUtil.isEmpty(list = this.purchaseTenderProjectMarginItemService.selectBySubpackageId(tenderProjectMarginItem, statusList))) {
            return Result.ok((Object)Lists.newArrayList());
        }
        ArrayList marginItemVOList = SysUtil.copyProperties(list, PurchaseTenderProjectMarginItemVO.class);
        marginItemVOList.forEach(marginItemVO -> {
            List purchaseAttachmentDTOS = this.invokeBaseRpcService.selectPurchaseAttachmentByMainId(marginItemVO.getId());
            marginItemVO.setAttachmentDTOList(purchaseAttachmentDTOS);
        });
        return Result.ok((Object)marginItemVOList);
    }

    @ApiOperation(value="\u67e5\u8be2\u4fdd\u8bc1\u91d1\u9000\u6b3e\u4fe1\u606f\u5217\u8868", notes="\u67e5\u8be2\u4fdd\u8bc1\u91d1\u9000\u6b3e\u4fe1\u606f\u5217\u8868")
    @GetMapping(value={"/queryRefund"})
    @RequiresPermissions(value={"tender#tenderProject:queryById"})
    @TenderPermissions(value={TenderRoleEnum.PURCHASE_EXECUTOR, TenderRoleEnum.BIDING_USER})
    public Result<?> queryRefund(PurchaseTenderProjectRefund tenderProjectRefund, HttpServletRequest req) {
        QueryWrapper queryWrapper = QueryGenerator.initQueryWrapper((Object)((Object)tenderProjectRefund), (Map)req.getParameterMap());
        List<PurchaseTenderProjectRefund> list = this.purchaseTenderProjectRefundService.queryTenderPage((QueryWrapper<PurchaseTenderProjectRefund>)queryWrapper);
        return Result.ok(list);
    }

    @ApiOperation(value="\u5bfc\u51fa", notes="\u5bfc\u51fa")
    @PostMapping(value={"/exportRefundXls"})
    @RequiresPermissions(value={"tender#tenderProject:queryById"})
    @TenderPermissions(value={TenderRoleEnum.PURCHASE_EXECUTOR, TenderRoleEnum.BIDING_USER})
    public ModelAndView exportRefundXls(HttpServletRequest request, @RequestBody Map<String, Object> object) {
        return super.exportXls(request, object, PurchaseTenderProjectRefundExcelExportServiceImpl.class);
    }

    @ApiOperation(value="\u67e5\u8be2\u4fdd\u8bc1\u91d1\u62b5\u6263\u4fe1\u606f\u5217\u8868", notes="\u67e5\u8be2\u4fdd\u8bc1\u91d1\u62b5\u6263\u4fe1\u606f\u5217\u8868")
    @GetMapping(value={"/queryDeductBysubpackageId"})
    @RequiresPermissions(value={"tender#tenderProject:queryById"})
    @TenderPermissions(value={TenderRoleEnum.PURCHASE_EXECUTOR, TenderRoleEnum.BIDING_USER})
    public Result<?> queryDeductBysubpackageId(PurchaseTenderProjectMarginDeductRecord marginDeductRecord, HttpServletRequest req) {
        Map stringMap = req.getParameterMap();
        QueryWrapper queryWrapper = QueryGenerator.initQueryWrapper((Object)((Object)marginDeductRecord), (Map)stringMap);
        List<PurchaseTenderProjectMarginDeductRecord> list = this.purchaseTenderProjectMarginDeductRecordService.queryTenderPage((QueryWrapper<PurchaseTenderProjectMarginDeductRecord>)queryWrapper);
        return Result.ok(list);
    }
}

