/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.tender.supplier.controller;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.StrUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.els.common.api.vo.Result;
import com.els.common.aspect.annotation.AutoLog;
import com.els.common.aspect.annotation.SrmValidated;
import com.els.common.system.base.controller.BaseController;
import com.els.common.system.base.entity.BaseEntity;
import com.els.common.util.I18nUtil;
import com.els.common.util.SysUtil;
import com.els.config.mybatis.TenantContext;
import com.els.modules.account.api.dto.LoginUserDTO;
import com.els.modules.base.api.dto.SaleAttachmentDTO;
import com.els.modules.tender.project.entity.PurchaseTenderProjectHead;
import com.els.modules.tender.project.service.PurchaseTenderProjectHeadService;
import com.els.modules.tender.sale.enumerate.TenderProjectSignUpStatusEnum;
import com.els.modules.tender.sale.enumerate.TenderProjectSourceTypeEnum;
import com.els.modules.tender.sale.vo.TenderProjectSignUpVO;
import com.els.modules.tender.supplier.entity.TenderProjectSignUp;
import com.els.modules.tender.supplier.entity.TenderProjectSignUpExamine;
import com.els.modules.tender.supplier.service.TenderProjectSignUpRejectService;
import com.els.modules.tender.supplier.service.TenderProjectSignUpService;
import com.els.rpc.service.InvokeBaseRpcService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;
import javax.annotation.Resource;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.Assert;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"\u4f9b\u5e94\u5546\u6295\u6807\u9879\u76ee\u62a5\u540d\u8868"})
@RestController
@RequestMapping(value={"/tender/purchase/supplierTenderProjectSignUp"})
public class TenderProjectSignUpController
extends BaseController<TenderProjectSignUp, TenderProjectSignUpService> {
    @Autowired
    private TenderProjectSignUpService tenderProjectSignUpService;
    @Autowired
    private TenderProjectSignUpRejectService tenderProjectSignUpRejectService;
    @Resource
    private InvokeBaseRpcService invokeBaseRpcService;
    @Resource
    private PurchaseTenderProjectHeadService projectHeadService;

    @AutoLog(value="\u4f9b\u5e94\u5546\u6295\u6807\u9879\u76ee\u62a5\u540d\u8868-\u63d0\u4ea4")
    @ApiOperation(value="\u62a5\u540d-\u63d0\u4ea4", notes="\u62a5\u540d-\u63d0\u4ea4")
    @PostMapping(value={"/submit"})
    @SrmValidated
    @RequiresPermissions(value={"tender#tenderProject:publish"})
    public Result<?> submit(@RequestBody TenderProjectSignUpVO supplierTenderProjectSignUpVO) {
        TenderProjectSignUp tenderProjectSignUp = (TenderProjectSignUp)((Object)SysUtil.copyProperties((Object)((Object)supplierTenderProjectSignUpVO), TenderProjectSignUp.class));
        this.buildAndCheckParam(tenderProjectSignUp);
        tenderProjectSignUp.setStatus(TenderProjectSignUpStatusEnum.AUDIT_PASS.getValue());
        this.tenderProjectSignUpService.submit(tenderProjectSignUp, supplierTenderProjectSignUpVO.getAttachmentList());
        return Result.ok((Object)((Object)tenderProjectSignUp));
    }

    @AutoLog(value="\u4f9b\u5e94\u5546\u6295\u6807\u9879\u76ee\u62a5\u540d\u8868-\u65b0\u589e")
    @ApiOperation(value="\u65b0\u589e", notes="\u65b0\u589e")
    @PostMapping(value={"/add"})
    @SrmValidated
    @RequiresPermissions(value={"tender#tenderProject:add"})
    public Result<?> add(@RequestBody TenderProjectSignUpVO supplierTenderProjectSignUpVO) {
        TenderProjectSignUp tenderProjectSignUp = (TenderProjectSignUp)((Object)SysUtil.copyProperties((Object)((Object)supplierTenderProjectSignUpVO), TenderProjectSignUp.class));
        this.buildAndCheckParam(tenderProjectSignUp);
        this.tenderProjectSignUpService.add(tenderProjectSignUp, supplierTenderProjectSignUpVO.getAttachmentList());
        return Result.ok((Object)((Object)tenderProjectSignUp));
    }

    @AutoLog(value="\u4f9b\u5e94\u5546\u6295\u6807\u9879\u76ee\u62a5\u540d\u8868-\u62a5\u540d")
    @ApiOperation(value="\u62a5\u540d", notes="\u62a5\u540d")
    @PostMapping(value={"/edit"})
    @SrmValidated
    @RequiresPermissions(value={"tender#tenderProject:edit"})
    public Result<?> edit(@RequestBody TenderProjectSignUpVO supplierTenderProjectSignUpVO) {
        TenderProjectSignUp tenderProjectSignUp = (TenderProjectSignUp)((Object)SysUtil.copyProperties((Object)((Object)supplierTenderProjectSignUpVO), TenderProjectSignUp.class));
        this.buildAndCheckParam(tenderProjectSignUp);
        this.tenderProjectSignUpService.edit(tenderProjectSignUp, supplierTenderProjectSignUpVO.getAttachmentList());
        String id = tenderProjectSignUp.getId();
        return this.queryById(id);
    }

    @ApiOperation(value="\u901a\u8fc7id\u67e5\u8be2", notes="\u901a\u8fc7id\u67e5\u8be2")
    @GetMapping(value={"/queryById"})
    @RequiresPermissions(value={"tender#tenderProject:queryById"})
    public Result<?> queryById(@RequestParam(name="id") String id) {
        TenderProjectSignUp tenderProjectSignUp = (TenderProjectSignUp)((Object)this.tenderProjectSignUpService.getOne((Wrapper)new LambdaQueryWrapper().eq(BaseEntity::getId, (Object)id)));
        Assert.isTrue((tenderProjectSignUp != null ? 1 : 0) != 0, (String)I18nUtil.translate((String)"i18n_alert_tHxMK_c2373c29", (String)"\u8bb0\u5f55\u4e0d\u5b58\u5728\uff01"));
        PurchaseTenderProjectHead tenderProjectHead = (PurchaseTenderProjectHead)((Object)this.projectHeadService.getById((Serializable)((Object)tenderProjectSignUp.getTenderProjectId())));
        String elsAccount = TenantContext.getTenant();
        Assert.isTrue((elsAccount.equals(tenderProjectHead.getPurchaseExecutorAccount()) || elsAccount.equals(tenderProjectHead.getElsAccount()) ? 1 : 0) != 0, (String)I18nUtil.translate((String)"i18n_alert_tHxMK_c2373c29", (String)"\u8bb0\u5f55\u4e0d\u5b58\u5728\uff01"));
        List saleAttachmentDemandDTOS = this.invokeBaseRpcService.selectSaleAttachmentByMainId(id);
        if (CollectionUtil.isEmpty((Collection)saleAttachmentDemandDTOS)) {
            List purchaseAttachmentDTOS = this.invokeBaseRpcService.selectPurchaseAttachmentByMainId(id);
            saleAttachmentDemandDTOS = SysUtil.copyProperties((List)purchaseAttachmentDTOS, SaleAttachmentDTO.class);
        }
        TenderProjectSignUpVO tenderProjectSignUpVO = (TenderProjectSignUpVO)((Object)SysUtil.copyProperties((Object)((Object)tenderProjectSignUp), TenderProjectSignUpVO.class));
        tenderProjectSignUpVO.setAttachmentList(saleAttachmentDemandDTOS);
        List<TenderProjectSignUpExamine> tenderProjectSignUpRejects = this.tenderProjectSignUpRejectService.selectByMainId(tenderProjectSignUp.getId());
        tenderProjectSignUpVO.setTenderProjectSignUpRejectList(tenderProjectSignUpRejects);
        tenderProjectSignUpVO.setBusAccount(tenderProjectSignUp.getPurchaseEnterpriseAccount());
        return Result.ok((Object)((Object)tenderProjectSignUpVO));
    }

    @AutoLog(value="\u5ba1\u6279-\u901a\u8fc7")
    @ApiOperation(value="\u5ba1\u6279\u62a5\u540d-\u901a\u8fc7", notes="\u5ba1\u6279-\u901a\u8fc7")
    @GetMapping(value={"/approved"})
    @RequiresPermissions(value={"tender#biddingHall:operational"})
    public Result<?> approved(@RequestParam(name="id") String id) {
        this.tenderProjectSignUpService.updateStatus(id, TenderProjectSignUpStatusEnum.AUDIT_PASS.getValue(), null);
        return Result.ok();
    }

    @AutoLog(value="\u5ba1\u6279-\u62d2\u7edd")
    @ApiOperation(value="\u5ba1\u6279\u62a5\u540d-\u62d2\u7edd", notes="\u5ba1\u6279-\u62d2\u7edd")
    @PostMapping(value={"/reject"})
    @SrmValidated
    @RequiresPermissions(value={"tender#biddingHall:operational"})
    public Result<?> rejection(@RequestBody TenderProjectSignUp tenderProjectSignUp) {
        this.tenderProjectSignUpService.updateStatus(tenderProjectSignUp.getId(), TenderProjectSignUpStatusEnum.AUDIT_REJECT.getValue(), tenderProjectSignUp.getRemark());
        return Result.ok();
    }

    @ApiOperation(value="\u5220\u9664", notes="\u5220\u9664")
    @GetMapping(value={"/delete"})
    @RequiresPermissions(value={"tender#tenderProject:delete"})
    public Result<?> delete(@RequestParam(name="id") String id) {
        this.tenderProjectSignUpService.delete(id);
        return Result.ok();
    }

    private void buildAndCheckParam(TenderProjectSignUp tenderProjectSignUp) {
        tenderProjectSignUp.setSourceType(TenderProjectSourceTypeEnum.OFF_LINE.getValue());
        LoginUserDTO loginUser = SysUtil.getLoginUser();
        tenderProjectSignUp.setElsAccount(loginUser.getElsAccount());
        tenderProjectSignUp.setPurchaseEnterpriseAccount(loginUser.getElsAccount());
        tenderProjectSignUp.setPurchaseEnterpriseName(loginUser.getCompanyName());
        tenderProjectSignUp.setSupplierSubAccount("1001");
        Assert.isTrue((boolean)StrUtil.isNotBlank((CharSequence)tenderProjectSignUp.getSupplierAccount()), (String)I18nUtil.translate((String)"i18n_alert_RdXeyxOLVW_e6a8e73", (String)"\u4f9b\u5e94\u5546\u8d26\u53f7\u4e0d\u80fd\u4e3a\u7a7a!"));
    }
}

