/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.bidding.controller;

import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.els.common.api.vo.Result;
import com.els.common.aspect.annotation.AutoLog;
import com.els.common.aspect.annotation.SrmValidated;
import com.els.common.exception.ELSBootException;
import com.els.common.system.base.controller.BaseController;
import com.els.common.system.query.QueryGenerator;
import com.els.common.util.I18nUtil;
import com.els.config.mybatis.TenantContext;
import com.els.modules.base.api.dto.DictDTO;
import com.els.modules.bidding.entity.PurchaseBiddingChange;
import com.els.modules.bidding.entity.PurchaseBiddingChangeItem;
import com.els.modules.bidding.entity.PurchaseBiddingHead;
import com.els.modules.bidding.service.PurchaseBiddingChangeItemService;
import com.els.modules.bidding.service.PurchaseBiddingChangeService;
import com.els.modules.bidding.service.PurchaseBiddingHeadService;
import com.els.modules.bidding.vo.PurchaseBiddingChangeVO;
import com.els.rpc.service.InvokeBaseRpcService;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.servlet.http.HttpServletRequest;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/bidding/purchaseBiddingChange"})
@Tag(name="\u91c7\u8d2d\u6295\u6807\u5355\u53d8\u66f4")
public class PurchaseBiddingChangeController
extends BaseController<PurchaseBiddingChange, PurchaseBiddingChangeService> {
    @Autowired
    private PurchaseBiddingChangeService purchaseBiddingChangeService;
    @Autowired
    private PurchaseBiddingChangeItemService purchaseBiddingChangeItemService;
    @Autowired
    private PurchaseBiddingHeadService purchaseBiddingHeadService;
    @Autowired
    private InvokeBaseRpcService invokeBaseRpcService;

    @Operation(summary="\u5206\u9875\u5217\u8868\u67e5\u8be2", description="\u5206\u9875\u5217\u8868\u67e5\u8be2")
    @GetMapping(value={"/list"})
    @RequiresPermissions(value={"bidding#purchaseBiddingHead:list"})
    public Result<?> queryPageList(PurchaseBiddingChange purchaseBiddingChange, @RequestParam(name="pageNo", defaultValue="1") Integer pageNo, @RequestParam(name="pageSize", defaultValue="10") Integer pageSize, HttpServletRequest req) {
        QueryWrapper queryWrapper = QueryGenerator.initQueryWrapper((Object)((Object)purchaseBiddingChange), (Map)req.getParameterMap());
        Page page = new Page((long)pageNo.intValue(), (long)pageSize.intValue());
        IPage pageList = this.purchaseBiddingChangeService.page((IPage)page, (Wrapper)queryWrapper);
        return Result.ok((Object)pageList);
    }

    @AutoLog(value="\u91c7\u8d2d\u62db\u6807\u7ba1\u7406-\u91c7\u8d2d\u6295\u6807\u5355\u53d8\u66f4\u6dfb\u52a0")
    @Operation(summary="\u6dfb\u52a0", description="\u6dfb\u52a0")
    @PostMapping(value={"/add"})
    @SrmValidated
    @RequiresPermissions(value={"bidding#purchaseBiddingHead:add"})
    public Result<?> add(@RequestBody PurchaseBiddingChangeVO purchaseBiddingChangePage) {
        PurchaseBiddingChange purchaseBiddingChange = new PurchaseBiddingChange();
        BeanUtils.copyProperties((Object)((Object)purchaseBiddingChangePage), (Object)((Object)purchaseBiddingChange));
        purchaseBiddingChange.setChangeNumber(this.invokeBaseRpcService.getNextCode("srmBiddingChangeNumber", (Object)purchaseBiddingChange));
        this.purchaseBiddingChangeService.saveMain(purchaseBiddingChange, purchaseBiddingChangePage.getPurchaseBiddingChangeItemList());
        return Result.ok((Object)((Object)purchaseBiddingChange));
    }

    @AutoLog(value="\u91c7\u8d2d\u62db\u6807\u7ba1\u7406-\u91c7\u8d2d\u6295\u6807\u5355\u53d8\u66f4\u7f16\u8f91")
    @Operation(summary="\u7f16\u8f91", description="\u7f16\u8f91")
    @PostMapping(value={"/edit"})
    @SrmValidated
    @RequiresPermissions(value={"bidding#purchaseBiddingHead:edit"})
    public Result<?> edit(@RequestBody PurchaseBiddingChangeVO purchaseBiddingChangePage) {
        PurchaseBiddingChange purchaseBiddingChange = new PurchaseBiddingChange();
        BeanUtils.copyProperties((Object)((Object)purchaseBiddingChangePage), (Object)((Object)purchaseBiddingChange));
        this.purchaseBiddingChangeService.updateMain(purchaseBiddingChange, purchaseBiddingChangePage.getPurchaseBiddingChangeItemList());
        return Result.ok((Object)((Object)purchaseBiddingChange));
    }

    @AutoLog(value="\u91c7\u8d2d\u62db\u6807\u7ba1\u7406-\u91c7\u8d2d\u6295\u6807\u5355\u53d8\u66f4\u901a\u8fc7id\u5220\u9664")
    @Operation(summary="\u901a\u8fc7id\u5220\u9664", description="\u901a\u8fc7id\u5220\u9664")
    @GetMapping(value={"/delete"})
    @RequiresPermissions(value={"bidding#purchaseBiddingHead:delete"})
    public Result<?> delete(@RequestParam(name="id") String id) {
        this.purchaseBiddingChangeService.delMain(id);
        return this.commonSuccessResult(4);
    }

    @AutoLog(value="\u91c7\u8d2d\u62db\u6807\u7ba1\u7406-\u91c7\u8d2d\u6295\u6807\u5355\u53d8\u66f4\u6279\u91cf\u5220\u9664")
    @Operation(summary="\u6279\u91cf\u5220\u9664", description="\u6279\u91cf\u5220\u9664")
    @GetMapping(value={"/deleteBatch"})
    @RequiresPermissions(value={"bidding#purchaseBiddingHead:deleteBatch"})
    public Result<?> deleteBatch(@RequestParam(name="ids") String ids) {
        this.purchaseBiddingChangeService.delBatchMain(Arrays.asList(ids.split(",")));
        return this.commonSuccessResult(4);
    }

    @Operation(summary="\u901a\u8fc7id\u67e5\u8be2", description="\u901a\u8fc7id\u67e5\u8be2")
    @GetMapping(value={"/queryById"})
    @RequiresPermissions(value={"bidding#purchaseBiddingHead:queryById"})
    public Result<?> queryById(@RequestParam(name="id") String id) {
        PurchaseBiddingChange purchaseBiddingChange = (PurchaseBiddingChange)((Object)this.purchaseBiddingChangeService.getOne((Wrapper)((QueryWrapper)new QueryWrapper().eq((Object)"id", (Object)id)).eq((Object)"els_account", (Object)TenantContext.getTenant())));
        PurchaseBiddingChangeVO purchaseBiddingChangeVO = new PurchaseBiddingChangeVO();
        BeanUtils.copyProperties((Object)((Object)purchaseBiddingChange), (Object)((Object)purchaseBiddingChangeVO));
        List<PurchaseBiddingChangeItem> purchaseBiddingChangeItemList = this.purchaseBiddingChangeItemService.selectByMainId(id);
        purchaseBiddingChangeVO.setPurchaseBiddingChangeItemList(purchaseBiddingChangeItemList);
        return Result.ok((Object)((Object)purchaseBiddingChangeVO));
    }

    @Operation(summary="\u901a\u8fc7\u62db\u6807id\u67e5\u8be2", description="\u901a\u8fc7\u62db\u6807id\u67e5\u8be2")
    @GetMapping(value={"/queryByBiddingId"})
    @RequiresPermissions(value={"bidding#purchaseBiddingHead:queryById"})
    public Result<?> queryByBiddingId(@RequestParam(name="id") String id) {
        PurchaseBiddingHead biddingHead = (PurchaseBiddingHead)((Object)this.purchaseBiddingHeadService.getOne((Wrapper)((QueryWrapper)new QueryWrapper().eq((Object)"id", (Object)id)).eq((Object)"els_account", (Object)TenantContext.getTenant())));
        if (biddingHead == null) {
            throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_fail_bidding_order_num_no_find_bidding", (String)"\u62db\u6807\u5355\u4e0d\u5b58\u5728\uff01"));
        }
        List dictModelList = this.invokeBaseRpcService.queryDictItemsByCode("biddingChangeFieldCode", this.getTenantId());
        ArrayList<PurchaseBiddingChangeItem> purchaseBiddingChangeItemList = new ArrayList<PurchaseBiddingChangeItem>();
        JSONObject headObj = this.getJsonByObject((Object)biddingHead);
        for (DictDTO model : dictModelList) {
            PurchaseBiddingChangeItem item = new PurchaseBiddingChangeItem();
            item.setFieldCode(model.getValue());
            item.setFieldType(model.getDescription());
            item.setFieldOriginalValue(headObj.getString(model.getValue()));
            purchaseBiddingChangeItemList.add(item);
        }
        return Result.ok(purchaseBiddingChangeItemList);
    }

    private JSONObject getJsonByObject(Object param) {
        ObjectMapper mapper = new ObjectMapper();
        try {
            String json = mapper.writeValueAsString(param);
            return JSONObject.parseObject((String)json);
        }
        catch (JsonProcessingException e) {
            return new JSONObject();
        }
    }

    @Operation(summary="\u91c7\u8d2d\u62db\u6807\u7ba1\u7406-\u901a\u8fc7\u91c7\u8d2d\u6295\u6807\u5355\u53d8\u66f4id\u67e5\u8be2\u91c7\u8d2d\u6295\u6807\u5355\u53d8\u66f4\u884c", description="\u901a\u8fc7\u91c7\u8d2d\u6295\u6807\u5355\u53d8\u66f4id\u67e5\u8be2\u91c7\u8d2d\u6295\u6807\u5355\u53d8\u66f4\u884c")
    @GetMapping(value={"/queryPurchaseBiddingChangeItemByMainId"})
    @RequiresPermissions(value={"bidding#purchaseBiddingHead:queryById"})
    public Result<?> queryPurchaseBiddingChangeItemListByMainId(@RequestParam(name="id") String id) {
        List<PurchaseBiddingChangeItem> purchaseBiddingChangeItemList = this.purchaseBiddingChangeItemService.selectByMainId(id);
        List resultList = purchaseBiddingChangeItemList.stream().filter(o -> StrUtil.isNotBlank((CharSequence)o.getFieldValue())).collect(Collectors.toList());
        return Result.ok(resultList);
    }
}

