/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.ebidding.adapter;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.els.common.aspect.annotation.RpcService;
import com.els.common.enumerate.AuditStatusEnum;
import com.els.common.util.I18nUtil;
import com.els.common.util.SrmUtil;
import com.els.modules.demand.enumerate.PurchaseRequestStatusItemEnum;
import com.els.modules.ebidding.entity.PurchaseEbiddingHead;
import com.els.modules.ebidding.entity.PurchaseEbiddingItem;
import com.els.modules.ebidding.entity.PurchaseEbiddingItemHis;
import com.els.modules.ebidding.entity.PurchaseEbiddingSupplier;
import com.els.modules.ebidding.enumerate.EbiddingItemStatusEnum;
import com.els.modules.ebidding.enumerate.EbiddingMethodEnum;
import com.els.modules.ebidding.enumerate.EbiddingWayEnum;
import com.els.modules.ebidding.service.PurchaseEbiddingHeadService;
import com.els.modules.ebidding.service.PurchaseEbiddingItemHisService;
import com.els.modules.ebidding.service.PurchaseEbiddingItemService;
import com.els.modules.ebidding.service.PurchaseEbiddingSupplierService;
import com.els.modules.ebidding.vo.PurchaseEbiddingHeadVO;
import com.els.modules.inquiry.enumerate.PriceCreateWayEnum;
import com.els.modules.workflow.modules.dto.FlowCallBackDTO;
import com.els.modules.workflow.modules.rpc.WorkflowAuditOptCallBackService;
import com.els.rpc.service.InvokeAccountRpcService;
import jakarta.annotation.Resource;
import java.io.Serializable;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.Assert;

@RpcService(value="resultEbiddingRpcAdapter")
public class ResultEbiddingAdapter
implements WorkflowAuditOptCallBackService {
    @Autowired
    private PurchaseEbiddingHeadService purchaseEbiddingHeadService;
    @Autowired
    private PurchaseEbiddingItemService purchaseEbiddingItemService;
    @Autowired
    private PurchaseEbiddingItemHisService purchaseEbiddingItemHisService;
    @Autowired
    private PurchaseEbiddingSupplierService purchaseEbiddingSupplierService;
    @Resource
    private InvokeAccountRpcService invokeAccountRpcService;

    public void startProcessCallBack(FlowCallBackDTO flowCallbackDTO) {
        this.updateAuditStatus(AuditStatusEnum.AUDIT_DOING.getValue(), flowCallbackDTO);
    }

    public void createTaskCallBack(FlowCallBackDTO flowCallbackDTO) {
    }

    public void completeTaskCallBack(FlowCallBackDTO flowCallbackDTO) {
    }

    public void completeProcessCallBack(FlowCallBackDTO flowCallbackDTO) {
        this.updateAuditStatus(AuditStatusEnum.AUDIT_FINISH.getValue(), flowCallbackDTO);
        PurchaseEbiddingHead dbHead = (PurchaseEbiddingHead)((Object)this.purchaseEbiddingHeadService.getById((Serializable)((Object)flowCallbackDTO.getBusinessId())));
        if (EbiddingMethodEnum.DUTCH.getValue().equals(dbHead.getEbiddingMethod()) && "1".equals(dbHead.getAllowModifyQuantity()) && EbiddingWayEnum.SINGLE.getValue().equals(dbHead.getEbiddingWay())) {
            List<PurchaseEbiddingItemHis> itemList = this.purchaseEbiddingItemHisService.selectByMainId(dbHead.getId());
            if (PriceCreateWayEnum.AUTO.getValue().equals(dbHead.getPriceCreateWay())) {
                List<PurchaseEbiddingItemHis> acceptList = itemList.stream().filter(item -> EbiddingItemStatusEnum.BID_WIN.getValue().equals(item.getItemStatus())).collect(Collectors.toList());
                this.purchaseEbiddingHeadService.generatePriceRecordByHis(dbHead, acceptList);
            }
            List<PurchaseEbiddingSupplier> supplierList = this.purchaseEbiddingSupplierService.selectByMainId(dbHead.getId());
            this.purchaseEbiddingHeadService.pricedByHis(dbHead, itemList, supplierList);
            List ids = itemList.stream().map(PurchaseEbiddingItemHis::getItemId).distinct().collect(Collectors.toList());
            List byIds = this.purchaseEbiddingItemService.listByIds(ids);
            this.purchaseEbiddingHeadService.goBackDemand(byIds, PurchaseRequestStatusItemEnum.COMPLETION_OF_THE_AUCTION.getValue());
        } else {
            List<PurchaseEbiddingItem> itemList = this.purchaseEbiddingItemService.selectByMainId(dbHead.getId());
            if (PriceCreateWayEnum.AUTO.getValue().equals(dbHead.getPriceCreateWay())) {
                List<PurchaseEbiddingItem> acceptList = itemList.stream().filter(item -> EbiddingItemStatusEnum.BID_WIN.getValue().equals(item.getItemStatus())).collect(Collectors.toList());
                acceptList.forEach(item -> Assert.isTrue((item.getPrice() != null ? 1 : 0) != 0, (String)I18nUtil.translate((String)"i18n_import_SLBjtuxObLumdWF_b116e581", (String)"\u7269\u6599\u6ca1\u6709\u5355\u4ef7\uff0c\u4e0d\u80fd\u751f\u6210\u4ef7\u683c\u4e3b\u6570\u636e")));
                this.purchaseEbiddingHeadService.generatePriceRecord(dbHead, acceptList);
            }
            List<PurchaseEbiddingSupplier> supplierList = this.purchaseEbiddingSupplierService.selectByMainId(dbHead.getId());
            this.purchaseEbiddingHeadService.priced(dbHead, itemList, supplierList);
            this.purchaseEbiddingHeadService.goBackDemand(itemList, PurchaseRequestStatusItemEnum.COMPLETION_OF_THE_AUCTION.getValue());
        }
    }

    public void invalidProcessCallBack(FlowCallBackDTO flowCallbackDTO) {
    }

    public void rejectProcessCallBack(FlowCallBackDTO flowCallbackDTO) {
        this.updateAuditStatus(AuditStatusEnum.AUDIT_REJECT.getValue(), flowCallbackDTO);
    }

    public void cancelProcessCallBack(FlowCallBackDTO flowCallbackDTO) {
        this.updateAuditStatus(AuditStatusEnum.AUDIT_NEW.getValue(), flowCallbackDTO);
    }

    public Map<String, Object> getById(String id) {
        PurchaseEbiddingHead head = (PurchaseEbiddingHead)((Object)this.purchaseEbiddingHeadService.getById((Serializable)((Object)id)));
        if (head != null) {
            PurchaseEbiddingHeadVO headVO = new PurchaseEbiddingHeadVO();
            BeanUtils.copyProperties((Object)((Object)head), (Object)((Object)headVO));
            List<PurchaseEbiddingItem> itemList = this.purchaseEbiddingItemService.selectByMainId(id);
            headVO.setPurchaseEbiddingItemList(itemList);
            return SrmUtil.toJSONObject((Object)((Object)headVO));
        }
        return null;
    }

    private void updateAuditStatus(String auditStatus, FlowCallBackDTO flowCallbackDTO) {
        String headId = flowCallbackDTO.getBusinessId();
        String flowId = flowCallbackDTO.getProcessInstanceId();
        PurchaseEbiddingHead updateHead = new PurchaseEbiddingHead();
        updateHead.setId(headId);
        updateHead.setResultFlowId(flowId);
        updateHead.setResultAuditStatus(auditStatus);
        this.purchaseEbiddingHeadService.updateById((Object)updateHead);
        this.purchaseEbiddingItemService.update((Wrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)new LambdaUpdateWrapper().eq(PurchaseEbiddingItem::getHeadId, (Object)headId)).set(PurchaseEbiddingItem::getFlowId, (Object)flowId)).set(PurchaseEbiddingItem::getAuditStatus, (Object)auditStatus));
    }
}

