/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.ebidding.job.utils;

import cn.hutool.core.date.DateTime;
import cn.hutool.core.date.DateUtil;
import com.alibaba.fastjson.JSONObject;
import com.els.common.constant.CommonConstant;
import com.els.common.exception.ELSBootException;
import com.els.common.util.DateUtils;
import com.els.common.util.SrmRpcUtil;
import com.els.config.mybatis.TenantContext;
import com.els.modules.ebidding.entity.PurchaseEbiddingHead;
import com.els.modules.ebidding.entity.SaleEbiddingHead;
import com.els.modules.job.api.dto.QuartzJobDTO;
import com.els.modules.job.api.service.QuartzRpcService;
import java.util.Date;
import java.util.List;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EbiddingJobUtil {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(EbiddingJobUtil.class);
    private static final String BIDDING_START_JOB = "srmEbiddingBeginJobServiceImpl";
    private static final String BIDDING_FAILED_JOB = "srmEbiddingFailedJobServiceImpl";
    private static final String BIDDING_END_JOB = "srmEbiddingEndJobServiceImpl";
    private static final String BIDDING_DUTCH_QUOTE_JOB = "srmEbiddingDutchQuoteJobServiceImpl";

    private static void createJob(PurchaseEbiddingHead purchaseHead, Date time, String jobName) {
        String elsAccount = TenantContext.getTenant();
        String cron = DateUtils.formatDate((Date)time, (String)"ss mm HH dd MM ? yyyy");
        QuartzJobDTO job = new QuartzJobDTO();
        job.setCronExpression(cron);
        job.setJobClassName("com.els.modules.quartz.job.BusinessJob");
        job.setStatus(CommonConstant.STATUS_NORMAL);
        job.setDescription("\u7ade\u4ef7\u5355\u53f7\uff1a" + purchaseHead.getEbiddingNumber());
        if (BIDDING_DUTCH_QUOTE_JOB.equals(jobName)) {
            job.setJobNameKey(jobName + "_" + purchaseHead.getEbiddingNumber() + "_" + purchaseHead.getElsAccount());
        } else {
            job.setJobNameKey(jobName + "_" + purchaseHead.getEbiddingNumber() + "_" + elsAccount);
        }
        JSONObject paramObj = new JSONObject();
        paramObj.put("id", (Object)purchaseHead.getId());
        paramObj.put("jobKey", (Object)job.getJobNameKey());
        paramObj.put("tenantId", (Object)elsAccount);
        paramObj.put("jobImplName", (Object)jobName);
        job.setParameter(paramObj.toJSONString());
        job.setElsAccount(elsAccount);
        try {
            ((QuartzRpcService)SrmRpcUtil.getExecuteServiceImpl(QuartzRpcService.class)).createJob(job);
        }
        catch (Exception e) {
            log.error(e.getMessage());
        }
    }

    public static void createStartJob(PurchaseEbiddingHead purchaseHead, Date time) {
        EbiddingJobUtil.createJob(purchaseHead, time, BIDDING_START_JOB);
    }

    public static void createFailedJob(PurchaseEbiddingHead purchaseHead, Date time) {
        EbiddingJobUtil.createJob(purchaseHead, time, BIDDING_FAILED_JOB);
    }

    public static void createEndJob(PurchaseEbiddingHead purchaseHead, Date time) {
        Date addTime = EbiddingJobUtil.getAddTime(time);
        EbiddingJobUtil.createJob(purchaseHead, addTime, BIDDING_END_JOB);
    }

    public static void createDutchQuoteJob(PurchaseEbiddingHead purchaseHead, Date endTime) {
        DateTime addTime = DateUtil.offsetSecond((Date)endTime, (int)10);
        EbiddingJobUtil.createJob(purchaseHead, (Date)addTime, BIDDING_DUTCH_QUOTE_JOB);
    }

    public static void updateEndJob(SaleEbiddingHead dbSaleHead, Date endTime) {
        Date addTime = EbiddingJobUtil.getAddTime(endTime);
        String elsAccount = dbSaleHead.getToElsAccount();
        String cron = DateUtils.formatDate((Date)addTime, (String)"ss mm HH dd MM ? yyyy");
        QuartzJobDTO job = new QuartzJobDTO();
        job.setCronExpression(cron);
        job.setJobClassName("com.els.modules.quartz.job.BusinessJob");
        job.setStatus(CommonConstant.STATUS_NORMAL);
        job.setJobNameKey("srmEbiddingEndJobServiceImpl_" + dbSaleHead.getEbiddingNumber() + "_" + elsAccount);
        try {
            List jobList = ((QuartzRpcService)SrmRpcUtil.getExecuteServiceImpl(QuartzRpcService.class)).findJobList(job.getJobNameKey());
            if (!jobList.isEmpty()) {
                job.setId(((QuartzJobDTO)jobList.get(0)).getId());
                job.setParameter(((QuartzJobDTO)jobList.get(0)).getParameter());
            }
            ((QuartzRpcService)SrmRpcUtil.getExecuteServiceImpl(QuartzRpcService.class)).updateJob(job);
        }
        catch (Exception e) {
            log.error("ebidding_updateEndJob_failed:", (Throwable)e);
            throw new ELSBootException((Throwable)e);
        }
    }

    public static void deleteDutchQuoteJob(PurchaseEbiddingHead purchaseHead) {
        String jobKey = "srmEbiddingDutchQuoteJobServiceImpl_" + purchaseHead.getEbiddingNumber() + "_" + purchaseHead.getElsAccount();
        EbiddingJobUtil.deleteJob(jobKey);
    }

    public static void deleteJob(String jobKey) {
        List jobList = ((QuartzRpcService)SrmRpcUtil.getExecuteServiceImpl(QuartzRpcService.class)).findJobList(jobKey);
        if (!jobList.isEmpty()) {
            ((QuartzRpcService)SrmRpcUtil.getExecuteServiceImpl(QuartzRpcService.class)).deleteJob((QuartzJobDTO)jobList.get(0));
        }
        EbiddingJobUtil.physicallyDeleteJob(jobKey);
    }

    private static void physicallyDeleteJob(String jobKey) {
        ((QuartzRpcService)SrmRpcUtil.getExecuteServiceImpl(QuartzRpcService.class)).deleteByJobNameKey(jobKey);
    }

    public static void deleteAllJob(PurchaseEbiddingHead purchaseHead) {
        String key = purchaseHead.getEbiddingNumber() + "_" + purchaseHead.getElsAccount();
        EbiddingJobUtil.deleteJob("srmEbiddingBeginJobServiceImpl_" + key);
        EbiddingJobUtil.deleteJob("srmEbiddingFailedJobServiceImpl_" + key);
        EbiddingJobUtil.deleteJob("srmEbiddingEndJobServiceImpl_" + key);
    }

    private static Date getAddTime(Date time) {
        return DateUtil.offsetSecond((Date)time, (int)3);
    }
}

