/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.tender.evaluation.strategy.price.handler;

import cn.hutool.core.util.StrUtil;
import com.els.modules.tender.attachment.entity.PurchaseTenderEvaluationPriceRegulationInfo;
import com.els.modules.tender.attachment.entity.PurchaseTenderEvaluationPrinciples;
import com.els.modules.tender.attachment.vo.PurchaseTenderEvaluationGroupVO;
import com.els.modules.tender.evaluation.strategy.price.TemplatePriceStrategy;
import com.els.modules.tender.evaluation.vo.PurchaseTenderProjectBidEvaRegulationResultVO;
import java.math.BigDecimal;
import java.util.List;
import org.springframework.stereotype.Component;

@Component(value="operationMinPricePositiveDeviationStrategy")
public class OperationMinPricePositiveDeviationStrategy
implements TemplatePriceStrategy {
    @Override
    public void priceScoreCalculate(List<PurchaseTenderProjectBidEvaRegulationResultVO> regulationCalList, PurchaseTenderEvaluationGroupVO evaluationGroupVO, PurchaseTenderEvaluationPrinciples evaluationPrinciples) {
        PurchaseTenderEvaluationPriceRegulationInfo regulationInfo = evaluationGroupVO.getTenderEvaluationTemplatePriceRegulationInfo();
        Integer score = evaluationGroupVO.getScore();
        BigDecimal evaGroupTotalScore = BigDecimal.valueOf(score.intValue());
        int summaryScorePrecision = 20;
        BigDecimal aboveScore = BigDecimal.ZERO;
        BigDecimal lowestScore = BigDecimal.ZERO;
        if (StrUtil.isNotBlank((CharSequence)regulationInfo.getAboveScore())) {
            aboveScore = new BigDecimal(regulationInfo.getAboveScore());
        }
        if (StrUtil.isNotBlank((CharSequence)regulationInfo.getLowestScore())) {
            lowestScore = new BigDecimal(regulationInfo.getLowestScore());
        }
        for (PurchaseTenderProjectBidEvaRegulationResultVO regulationResultVO : regulationCalList) {
            BigDecimal offset = regulationResultVO.getEvaPrice().subtract(regulationResultVO.getBasePrice()).multiply(new BigDecimal(100)).multiply(aboveScore).divide(regulationResultVO.getBasePrice(), summaryScorePrecision, 4);
            BigDecimal result = BigDecimal.valueOf(evaluationGroupVO.getScore().intValue()).subtract(offset);
            if (result.compareTo(lowestScore) > 0) {
                regulationResultVO.setScore(result);
            } else {
                regulationResultVO.setScore(lowestScore);
            }
            if (regulationResultVO.getScore().compareTo(evaGroupTotalScore) >= 0) {
                regulationResultVO.setScore(evaGroupTotalScore);
            }
            BigDecimal evaGroupWeightScope = regulationResultVO.getScore().multiply(regulationResultVO.getWeight()).divide(new BigDecimal(100), summaryScorePrecision, 4);
            regulationResultVO.setWeightScore(evaGroupWeightScope);
        }
        this.resultOrderByWeightScoreHighToLow(regulationCalList);
    }
}

