/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.bidding.controller;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.els.common.api.vo.Result;
import com.els.common.aspect.annotation.AutoLog;
import com.els.common.aspect.annotation.PermissionDataView;
import com.els.common.aspect.annotation.SrmValidated;
import com.els.common.system.base.controller.BaseController;
import com.els.common.system.query.QueryGenerator;
import com.els.common.util.I18nUtil;
import com.els.common.vo.CountVO;
import com.els.config.mybatis.TenantContext;
import com.els.modules.base.api.dto.DictDTO;
import com.els.modules.base.api.dto.PurchaseAttachmentDTO;
import com.els.modules.bidding.entity.PurchaseMentoringHead;
import com.els.modules.bidding.entity.PurchaseMentoringItem;
import com.els.modules.bidding.service.PurchaseMentoringHeadService;
import com.els.modules.bidding.service.PurchaseMentoringItemService;
import com.els.modules.bidding.vo.PurchaseMentoringHeadVO;
import com.els.rpc.service.InvokeBaseRpcService;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.annotation.Resource;
import jakarta.servlet.http.HttpServletRequest;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/bidding/purchaseMentoringHead"})
@Tag(name="\u91c7\u8d2d\u65b9\u7b54\u7591\u4fe1\u606f\u5934")
public class PurchaseMentoringHeadController
extends BaseController<PurchaseMentoringHead, PurchaseMentoringHeadService> {
    @Autowired
    private PurchaseMentoringHeadService purchaseMentoringHeadService;
    @Autowired
    private PurchaseMentoringItemService purchaseMentoringItemService;
    @Resource
    private InvokeBaseRpcService invokeBaseRpcService;

    @Operation(summary="\u5206\u9875\u5217\u8868\u67e5\u8be2", description="\u5206\u9875\u5217\u8868\u67e5\u8be2")
    @GetMapping(value={"/list"})
    @RequiresPermissions(value={"bidding#purchaseMentoringHead:list"})
    @PermissionDataView(businessType="purchaseMentoringHead")
    public Result<?> queryPageList(PurchaseMentoringHead head, @RequestParam(name="pageNo", defaultValue="1") Integer pageNo, @RequestParam(name="pageSize", defaultValue="10") Integer pageSize, HttpServletRequest req) {
        QueryWrapper queryWrapper = QueryGenerator.initQueryWrapper((Object)((Object)head), (Map)req.getParameterMap());
        Page page = new Page((long)pageNo.intValue(), (long)pageSize.intValue());
        IPage pageList = this.purchaseMentoringHeadService.page((IPage)page, (Wrapper)queryWrapper);
        return Result.ok((Object)pageList);
    }

    @AutoLog(value="\u91c7\u8d2d\u65b9\u7b54\u7591\u4fe1\u606f\u5934-\u7f16\u8f91", operateType=3)
    @Operation(summary="\u7f16\u8f91", description="\u7f16\u8f91")
    @PostMapping(value={"/edit"})
    @RequiresPermissions(value={"bidding#purchaseMentoringHead:edit"})
    @SrmValidated
    public Result<?> edit(@RequestBody PurchaseMentoringHeadVO purchaseMentoringHeadPage) {
        PurchaseMentoringHead purchaseMentoringHead = new PurchaseMentoringHead();
        BeanUtils.copyProperties((Object)((Object)purchaseMentoringHeadPage), (Object)((Object)purchaseMentoringHead));
        this.purchaseMentoringHeadService.updateMain(purchaseMentoringHead, purchaseMentoringHeadPage.getPurchaseMentoringItemList(), purchaseMentoringHeadPage.getAttachments());
        String id = purchaseMentoringHead.getId();
        return this.queryById(id);
    }

    @Operation(summary="\u901a\u8fc7id\u67e5\u8be2", description="\u901a\u8fc7id\u67e5\u8be2")
    @GetMapping(value={"/queryById"})
    @RequiresPermissions(value={"bidding#purchaseMentoringHead:queryById"})
    public Result<?> queryById(@RequestParam(name="id") String id) {
        PurchaseMentoringHead dbHead = (PurchaseMentoringHead)((Object)this.purchaseMentoringHeadService.getOne((Wrapper)((QueryWrapper)new QueryWrapper().eq((Object)"id", (Object)id)).eq((Object)"els_account", (Object)TenantContext.getTenant())));
        PurchaseMentoringHeadVO headVO = new PurchaseMentoringHeadVO();
        BeanUtils.copyProperties((Object)((Object)dbHead), (Object)((Object)headVO));
        List<PurchaseMentoringItem> dbItemList = this.purchaseMentoringItemService.selectByMainId(id);
        headVO.setPurchaseMentoringItemList(dbItemList);
        List attachments = this.invokeBaseRpcService.selectPurchaseAttachmentByMainId(id);
        List<PurchaseAttachmentDTO> attachmentList = attachments.stream().filter(attachment -> !"purchase_mentoring_file_upload".equals(attachment.getBusinessType())).collect(Collectors.toList());
        headVO.setAttachments(attachmentList);
        return Result.ok((Object)((Object)headVO));
    }

    private String replaceFileNameDashed(String val) {
        String[] strArr = val.split("-");
        if (strArr.length < 3) {
            return val;
        }
        String id = strArr[0];
        return id + "-" + val.replaceAll(id + "-", "").replaceAll("-", "_");
    }

    @AutoLog(value="\u91c7\u8d2d\u65b9\u7b54\u7591-\u53d1\u5e03", operateType=3)
    @Operation(summary="\u53d1\u5e03", description="\u53d1\u5e03")
    @PostMapping(value={"/publish"})
    @SrmValidated
    @RequiresPermissions(value={"bidding#purchaseMentoringHead:publish"})
    public Result<?> publish(@RequestBody PurchaseMentoringHeadVO headVO) {
        PurchaseMentoringHead head = new PurchaseMentoringHead();
        BeanUtils.copyProperties((Object)((Object)headVO), (Object)((Object)head));
        this.purchaseMentoringHeadService.publish(head, headVO.getPurchaseMentoringItemList(), headVO.getAttachments(), headVO.getPurchaseMentoringItem());
        return this.commonSuccessResult(3);
    }

    @Operation(summary="\u901a\u8fc7\u5217\u8868\u9875\u9875\u7b7e\u6570\u91cf\u67e5\u8be2", description="\u5217\u8868\u9875\u9875\u7b7e\u6570\u91cf\u67e5\u8be2")
    @GetMapping(value={"/counts"})
    @PermissionDataView(businessType="purchaseMentoringHead")
    public Result<?> queryTabsCount(PurchaseMentoringHead purchaseMentoringHead, HttpServletRequest req) {
        ArrayList<CountVO> result = new ArrayList<CountVO>();
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.select((Object[])new String[]{"view_status", "count(0) as participateQuantity"});
        queryWrapper.groupBy((Object)"view_status");
        List list = ((PurchaseMentoringHeadService)this.service).list((Wrapper)queryWrapper);
        Map<String, Integer> countMap = list.stream().collect(Collectors.toMap(PurchaseMentoringHead::getViewStatus, PurchaseMentoringHead::getParticipateQuantity));
        Integer all = 0;
        for (Map.Entry<String, Integer> entry : countMap.entrySet()) {
            all = all + entry.getValue();
        }
        result.add(new CountVO(I18nUtil.translate((String)"i18n_title_all", (String)"\u5168\u90e8"), "viewStatus", null, (long)all.intValue()));
        List srmRequestStatus = this.invokeBaseRpcService.queryDictItemsByCode("srmHandleFlag", TenantContext.getTenant());
        for (DictDTO status : srmRequestStatus) {
            Integer total = countMap.get(status.getValue()) == null ? 0 : countMap.get(status.getValue());
            result.add(new CountVO(I18nUtil.translate((String)status.getTextI18nKey(), (String)status.getText()), "viewStatus", status.getValue(), (long)total.intValue()));
        }
        return Result.ok(result);
    }
}

