/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.logisticspurchase.base.service.impl;

import cn.hutool.core.util.StrUtil;
import com.els.common.constant.CommonConstant;
import com.els.common.exception.ELSBootException;
import com.els.common.system.base.service.impl.BaseServiceImpl;
import com.els.common.util.Assert;
import com.els.common.util.I18nUtil;
import com.els.modules.logisticspurchase.base.entity.OriginatingAddressLibrary;
import com.els.modules.logisticspurchase.base.enumerate.StatusEnum;
import com.els.modules.logisticspurchase.base.mapper.OriginatingAddressLibraryMapper;
import com.els.modules.logisticspurchase.base.service.OriginatingAddressLibraryService;
import com.els.rpc.service.InvokeBaseRpcService;
import java.io.Serializable;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class OriginatingAddressLibraryServiceImpl
extends BaseServiceImpl<OriginatingAddressLibraryMapper, OriginatingAddressLibrary>
implements OriginatingAddressLibraryService {
    @Autowired
    private InvokeBaseRpcService baseRpcService;

    @Override
    public void saveOriginatingAddressLibrary(OriginatingAddressLibrary originatingAddressLibrary) {
        this.check(originatingAddressLibrary);
        if (StrUtil.isBlank((CharSequence)originatingAddressLibrary.getStartNumber())) {
            originatingAddressLibrary.setStartNumber(this.baseRpcService.getNextCode("srmStartNumber", (Object)originatingAddressLibrary));
        }
        originatingAddressLibrary.setDeleted(CommonConstant.DEL_FLAG_0);
        originatingAddressLibrary.setStatus(StatusEnum.EFFECTIVE.getValue());
        ((OriginatingAddressLibraryMapper)this.baseMapper).insert((Object)originatingAddressLibrary);
    }

    private void check(OriginatingAddressLibrary originatingAddressLibrary) {
        Assert.isNotBlank((String)originatingAddressLibrary.getStartProvince(), (String)I18nUtil.translate((String)"i18n_field_AKbzxOLV_dd739260", (String)"\u8d77\u59cb\u7701\u4efd\u4e0d\u80fd\u4e3a\u7a7a"));
        Assert.isNotBlank((String)originatingAddressLibrary.getStartCity(), (String)I18nUtil.translate((String)"i18n_field_AKntKxOLV_e0279847", (String)"\u8d77\u59cb\u5730\u7ea7\u5e02\u4e0d\u80fd\u4e3a\u7a7a"));
    }

    @Override
    public void updateOriginatingAddressLibrary(OriginatingAddressLibrary originatingAddressLibrary) {
        this.check(originatingAddressLibrary);
        ((OriginatingAddressLibraryMapper)this.baseMapper).updateById((Object)originatingAddressLibrary);
    }

    @Override
    public void delOriginatingAddressLibrary(String id) {
        ((OriginatingAddressLibraryMapper)this.baseMapper).deleteById((Serializable)((Object)id));
    }

    @Override
    public void delBatchOriginatingAddressLibrary(List<String> idList) {
        ((OriginatingAddressLibraryMapper)this.baseMapper).deleteBatchIds(idList);
    }

    @Override
    public void frozenOriginatingAddressLibrary(String id) {
        OriginatingAddressLibrary originatingAddressLibrary = new OriginatingAddressLibrary();
        originatingAddressLibrary.setId(id);
        originatingAddressLibrary.setStatus(StatusEnum.FROZEN.getValue());
        int count = ((OriginatingAddressLibraryMapper)this.baseMapper).updateById((Object)originatingAddressLibrary);
        if (count == 0) {
            throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_APWFIKXWVVVXVSDJHrW_2fe92d52", (String)"\u5f53\u524d\u6570\u636e\u5df2\u5931\u6548\uff0c\u8bf7\u91cd\u65b0\u5237\u65b0\u540e\u63d0\u4ea4\u66f4\u6539\uff01"));
        }
    }

    @Override
    public void thawOriginatingAddressLibrary(String id) {
        OriginatingAddressLibrary originatingAddressLibrary = new OriginatingAddressLibrary();
        originatingAddressLibrary.setId(id);
        originatingAddressLibrary.setStatus(StatusEnum.EFFECTIVE.getValue());
        int count = ((OriginatingAddressLibraryMapper)this.baseMapper).updateById((Object)originatingAddressLibrary);
        if (count == 0) {
            throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_APWFIKXWVVVXVSDJHrW_2fe92d52", (String)"\u5f53\u524d\u6570\u636e\u5df2\u5931\u6548\uff0c\u8bf7\u91cd\u65b0\u5237\u65b0\u540e\u63d0\u4ea4\u66f4\u6539\uff01"));
        }
    }
}

