/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.logisticspurchase.enquiry.controller;

import cn.hutool.core.date.DateTime;
import cn.hutool.core.date.DateUtil;
import cn.hutool.core.lang.Assert;
import cn.hutool.core.util.StrUtil;
import com.alibaba.excel.EasyExcel;
import com.alibaba.excel.read.builder.ExcelReaderBuilder;
import com.alibaba.excel.read.listener.ReadListener;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.els.common.api.vo.Result;
import com.els.common.aspect.annotation.AutoLog;
import com.els.common.exception.ELSBootException;
import com.els.common.system.base.controller.BaseController;
import com.els.common.system.query.QueryGenerator;
import com.els.common.util.DateUtils;
import com.els.common.util.I18nUtil;
import com.els.common.util.RedisUtil;
import com.els.config.mybatis.TenantContext;
import com.els.modules.base.api.dto.ElsInitialTableDTO;
import com.els.modules.inquiry.vo.PublicInquiryVO;
import com.els.modules.logisticspurchase.base.entity.SubjectFileItem;
import com.els.modules.logisticspurchase.base.service.SubjectFileItemService;
import com.els.modules.logisticspurchase.enquiry.entity.PurchaseEnquiryHeadLp;
import com.els.modules.logisticspurchase.enquiry.entity.PurchaseEnquiryItemLp;
import com.els.modules.logisticspurchase.enquiry.enumerate.EnquiryLpStatusEnum;
import com.els.modules.logisticspurchase.enquiry.excel.listener.EnquiryPublishDataListener;
import com.els.modules.logisticspurchase.enquiry.service.PurchaseEnquiryHeadLpService;
import com.els.modules.logisticspurchase.enquiry.service.PurchaseEnquiryItemLpService;
import com.els.modules.logisticspurchase.enquiry.service.PurchaseEnquiryLpOperationService;
import com.els.modules.logisticspurchase.enquiry.vo.PurchaseEnquiryHeadLpVO;
import com.els.rpc.service.InvokeBaseRpcService;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.annotation.Resource;
import jakarta.servlet.http.HttpServletRequest;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.apache.poi.openxml4j.util.ZipSecureFile;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;

@RestController
@RequestMapping(value={"/lpEnquiry/purchaseOperation"})
@Tag(name="\u91c7\u8d2d\u8be2\u4ef7\u5934")
public class LogisticsPurchaseEnquiryOperationController
extends BaseController<PurchaseEnquiryHeadLp, PurchaseEnquiryHeadLpService> {
    @Autowired
    private PurchaseEnquiryItemLpService purchaseEnquiryItemLpService;
    @Autowired
    private PurchaseEnquiryLpOperationService purchaseEnquiryLpOperationService;
    @Resource
    private InvokeBaseRpcService invokeBaseRpcService;
    @Autowired
    private SubjectFileItemService subjectFileItemService;
    @Resource
    private RedisUtil redisUtil;

    @AutoLog(value="\u8be2\u4ef7-\u53d1\u5e03")
    @Operation(summary="\u53d1\u5e03", description="\u53d1\u5e03")
    @PostMapping(value={"/publish"})
    @RequiresPermissions(value={"lpEnquiry#purchaseEnquiryHeadLp:publish"})
    public Result<?> publish(HttpServletRequest request) {
        PurchaseEnquiryHeadLpVO headVO = this.getHeadByRequest(request);
        MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest)request;
        Map fileMap = multipartRequest.getFileMap();
        for (Map.Entry entity : fileMap.entrySet()) {
            MultipartFile file = (MultipartFile)entity.getValue();
            InputStream inputStream = null;
            try {
                EnquiryPublishDataListener dataListener = new EnquiryPublishDataListener();
                inputStream = file.getInputStream();
                ZipSecureFile.setMinInflateRatio((double)0.0);
                ((ExcelReaderBuilder)EasyExcel.read((InputStream)inputStream, (ReadListener)dataListener).headRowNumber(Integer.valueOf(1))).doReadAll();
                headVO.setPurchaseEnquiryItemList(dataListener.getCachedDataList());
                this.purchaseEnquiryLpOperationService.publish(headVO, file);
            }
            catch (Exception e) {
                throw new ELSBootException(e.getMessage(), (Throwable)e, new String[0]);
            }
            finally {
                if (inputStream == null) continue;
                try {
                    inputStream.close();
                }
                catch (IOException iOException) {}
            }
        }
        PurchaseEnquiryHeadLpVO resultHead = new PurchaseEnquiryHeadLpVO();
        resultHead.setId(headVO.getId());
        return Result.ok((Object)((Object)resultHead));
    }

    private PurchaseEnquiryHeadLpVO getHeadByRequest(HttpServletRequest request) {
        PurchaseEnquiryHeadLpVO head = new PurchaseEnquiryHeadLpVO();
        String id = request.getParameter("id");
        String templateNumber = request.getParameter("templateNumber");
        String templateName = request.getParameter("templateName");
        String templateVersion = request.getParameter("templateVersion");
        String templateAccount = request.getParameter("templateAccount");
        String quoteEndTimeStr = request.getParameter("quoteEndTime");
        String quoteStartTimeStr = request.getParameter("quoteStartTime");
        String subjectId = request.getParameter("subjectId");
        String subjectNumber = request.getParameter("subjectNumber");
        String subjectName = request.getParameter("subjectName");
        String subjectYear = request.getParameter("subjectYear");
        String effectiveDateStr = request.getParameter("effectiveDate");
        String expiryDateStr = request.getParameter("expiryDate");
        String subjectType = request.getParameter("subjectType");
        if (StrUtil.isBlank((CharSequence)subjectName)) {
            throw new ELSBootException("\u6807\u7684\u540d\u79f0subjectNumber\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (StrUtil.isBlank((CharSequence)subjectNumber)) {
            throw new ELSBootException("subjectNumber \u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (StrUtil.isBlank((CharSequence)templateNumber)) {
            throw new ELSBootException("\u6a21\u677f\u7f16\u53f7templateNumber \u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (StrUtil.isBlank((CharSequence)templateVersion)) {
            throw new ELSBootException("\u6a21\u677f\u7248\u672ctemplateVersion \u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (StrUtil.isBlank((CharSequence)templateAccount)) {
            throw new ELSBootException("\u6a21\u677f\u8d26\u53f7templateAccount \u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (StrUtil.isBlank((CharSequence)quoteStartTimeStr)) {
            throw new ELSBootException("\u62a5\u4ef7\u5f00\u59cb\u65f6\u95f4quoteStartTime \u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (StrUtil.isBlank((CharSequence)quoteEndTimeStr)) {
            throw new ELSBootException("\u62a5\u4ef7\u622a\u6b62\u65f6\u95f4quoteEndTime \u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (StrUtil.isBlank((CharSequence)effectiveDateStr)) {
            throw new ELSBootException("\u4ef7\u683c\u751f\u6548\u65e5\u671feffectiveDate \u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (StrUtil.isBlank((CharSequence)expiryDateStr)) {
            throw new ELSBootException("\u4ef7\u683c\u5931\u6548\u65e5\u671fexpiryDate \u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (StrUtil.isBlank((CharSequence)subjectId)) {
            throw new ELSBootException("\u6807\u7684subjectId \u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (StrUtil.isBlank((CharSequence)subjectType)) {
            throw new ELSBootException("\u6807\u7684\u8fd0\u8f93\u65b9\u5f0fsubjectType \u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        head.setId(id);
        String enquiryNumber = this.invokeBaseRpcService.getNextCode("srmEnquiryNumberLp", (Object)head);
        head.setEnquiryNumber(enquiryNumber);
        head.setTemplateNumber(templateNumber);
        head.setTemplateName(templateName);
        head.setTemplateVersion(Integer.parseInt(templateVersion));
        head.setTemplateAccount(templateAccount);
        DateTime quoteStartTime = DateUtil.parseDateTime((CharSequence)quoteStartTimeStr);
        DateTime quoteEndTime = DateUtil.parseDateTime((CharSequence)quoteEndTimeStr);
        Date effectiveDate = DateUtils.parseDate((Object)effectiveDateStr);
        Date expiryDate = DateUtils.parseDate((Object)expiryDateStr);
        if (quoteStartTime.after((Date)quoteEndTime)) {
            throw new ELSBootException("\u62a5\u4ef7\u5f00\u59cb\u65f6\u95f4\u4e0d\u80fd\u5927\u4e8e\u62a5\u4ef7\u7ed3\u675f\u65f6\u95f4");
        }
        Assert.isTrue((boolean)quoteEndTime.after(new Date()), (String)I18nUtil.translate((String)"i18n_alert_suyRKIlTfUAPKI_7f71245d", (String)"\u62a5\u4ef7\u622a\u6b62\u65f6\u95f4\u5fc5\u987b\u5927\u4e8e\u5f53\u524d\u65f6\u95f4"), (Object[])new Object[0]);
        head.setQuoteEndTime((Date)quoteEndTime);
        head.setQuoteStartTime((Date)quoteStartTime);
        head.setApplyEndTime((Date)DateUtil.offsetHour((Date)quoteEndTime, (int)-1));
        head.setEnquiryDesc(subjectNumber + subjectName);
        head.setSubjectName(subjectName);
        head.setSubjectType(subjectType);
        head.setSubjectNumber(subjectNumber);
        head.setSubjectFileHeadId(subjectId);
        head.setSubjectYear(subjectYear);
        head.setEffectiveDate(effectiveDate);
        head.setExpiryDate(expiryDate);
        return head;
    }

    @Operation(summary="\u5206\u9875\u5217\u8868\u67e5\u8be2", description="\u5206\u9875\u5217\u8868\u67e5\u8be2")
    @GetMapping(value={"/itemList"})
    @RequiresPermissions(value={"lpEnquiry#purchaseEnquiryHeadLp:list"})
    public Result<?> queryItemPageList(PurchaseEnquiryItemLp purchaseEnquiryItemLp, @RequestParam(name="pageNo", defaultValue="1") Integer pageNo, @RequestParam(name="pageSize", defaultValue="10") Integer pageSize, HttpServletRequest req) {
        String headId = purchaseEnquiryItemLp.getHeadId();
        if (StrUtil.isBlank((CharSequence)headId)) {
            throw new ELSBootException("\u8be2\u4ef7\u5355ID \u201cheadId\u201d \u4e0d\u80fd\u4e3a\u7a7a!");
        }
        PurchaseEnquiryHeadLp dbHead = (PurchaseEnquiryHeadLp)((Object)((PurchaseEnquiryHeadLpService)this.service).getById((Serializable)((Object)headId)));
        QueryWrapper queryWrapper = QueryGenerator.initQueryWrapper((Object)((Object)purchaseEnquiryItemLp), (Map)req.getParameterMap());
        Page page = new Page((long)pageNo.intValue(), (long)pageSize.intValue());
        IPage pageList = this.purchaseEnquiryItemLpService.page((IPage)page, (Wrapper)queryWrapper);
        ArrayList<PurchaseEnquiryItemLp> itemList = pageList.getRecords();
        if ((itemList == null || itemList.isEmpty()) && StrUtil.isBlank((CharSequence)purchaseEnquiryItemLp.getKeyWord())) {
            itemList = new ArrayList<PurchaseEnquiryItemLp>();
            Page page2 = this.invokeBaseRpcService.getInitTablePageByRelationId(headId, pageNo, pageSize);
            for (ElsInitialTableDTO table : page2.getRecords()) {
                PurchaseEnquiryItemLp item = (PurchaseEnquiryItemLp)((Object)JSONObject.parseObject((String)table.getBusinessInfoJson(), PurchaseEnquiryItemLp.class));
                itemList.add(item);
            }
            pageList.setRecords(itemList);
            pageList.setPages(page2.getPages());
            pageList.setTotal(page2.getTotal());
        }
        if (!EnquiryLpStatusEnum.NEW.getValue().equals(dbHead.getEnquiryStatus())) {
            this.purchaseEnquiryItemLpService.hideQuotePrice(dbHead, itemList);
        }
        return Result.ok((Object)pageList);
    }

    @AutoLog(value="\u516c\u5f00\u5bfb\u6e90-\u8be6\u60c5\u67e5\u8be2\u63a5\u53e3")
    @Operation(summary="\u8be6\u60c5\u67e5\u8be2\u63a5\u53e3", description="\u8be6\u60c5\u67e5\u8be2\u63a5\u53e3")
    @GetMapping(value={"/noToken/queryById/{id}"})
    public Result<?> queryById(@PathVariable(value="id") String id) {
        PurchaseEnquiryHeadLp dbHead = (PurchaseEnquiryHeadLp)((Object)((PurchaseEnquiryHeadLpService)this.service).getById((Serializable)((Object)id)));
        PurchaseEnquiryHeadLpVO headVO = new PurchaseEnquiryHeadLpVO();
        BeanUtils.copyProperties((Object)((Object)dbHead), (Object)((Object)headVO));
        List<SubjectFileItem> subjectFileItemList = this.subjectFileItemService.selectByMainId(dbHead.getSubjectFileHeadId());
        headVO.setSubjectFileItemList(subjectFileItemList);
        return Result.ok((Object)((Object)headVO));
    }

    @AutoLog(value="\u516c\u5f00\u5bfb\u6e90-\u884c\u9879\u76ee\u5206\u9875\u67e5\u8be2\u63a5\u53e3")
    @Operation(summary="\u884c\u9879\u76ee\u5206\u9875\u67e5\u8be2\u63a5\u53e3", description="\u884c\u9879\u76ee\u5206\u9875\u67e5\u8be2\u63a5\u53e3")
    @GetMapping(value={"/noToken/queryItemPageById/{id}"})
    public Result<?> queryItemPageById(@PathVariable(value="id") String id, @RequestParam(name="pageNo", defaultValue="1") Integer pageNo, @RequestParam(name="pageSize", defaultValue="10") Integer pageSize, HttpServletRequest req) {
        Page page = this.invokeBaseRpcService.getInitTablePageByRelationId(id, pageNo, pageSize);
        ArrayList<PurchaseEnquiryItemLp> itemList = new ArrayList<PurchaseEnquiryItemLp>();
        for (ElsInitialTableDTO table : page.getRecords()) {
            PurchaseEnquiryItemLp item = (PurchaseEnquiryItemLp)((Object)JSONObject.parseObject((String)table.getBusinessInfoJson(), PurchaseEnquiryItemLp.class));
            itemList.add(item);
        }
        QueryWrapper queryWrapper2 = new QueryWrapper();
        queryWrapper2.eq((Object)"id", (Object)"1");
        Page page2 = new Page((long)pageNo.intValue(), (long)pageSize.intValue());
        TenantContext.setTenant((String)"100000");
        IPage pageList2 = this.purchaseEnquiryItemLpService.page((IPage)page2, (Wrapper)queryWrapper2);
        TenantContext.clear();
        pageList2.setRecords(itemList);
        return Result.ok((Object)pageList2);
    }

    @AutoLog(value="\u516c\u5f00\u5bfb\u6e90-\u62a5\u540d\u63a5\u53e3")
    @Operation(summary="\u62a5\u540d\u63a5\u53e3", description="\u62a5\u540d\u63a5\u53e3")
    @PostMapping(value={"/apply"})
    @RequiresPermissions(value={"lpEnquiry#purchaseEnquiryHeadLp:apply"})
    public Result<?> apply(@RequestBody PublicInquiryVO inquiryVO) {
        this.purchaseEnquiryLpOperationService.apply(inquiryVO);
        return Result.ok((String)I18nUtil.translate((String)"i18n_alert_tkLR_2f0866fe", (String)"\u64cd\u4f5c\u6210\u529f"));
    }

    @GetMapping(value={"/noToken/clearRedis/{key}"})
    public Result<?> clearRedis(@PathVariable(value="key") String key) {
        this.redisUtil.deleteByPrex(key);
        return Result.ok();
    }
}

