/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.logisticspurchase.enquiry.service.impl;

import cn.hutool.core.date.DateTime;
import cn.hutool.core.date.DateUtil;
import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.els.common.aspect.annotation.SrmTransaction;
import com.els.common.enumerate.AuditStatusEnum;
import com.els.common.exception.ELSBootException;
import com.els.common.system.base.entity.BaseEntity;
import com.els.common.system.base.entity.ParentEntity;
import com.els.common.system.base.service.impl.BaseServiceImpl;
import com.els.common.util.LoginUserContext;
import com.els.common.util.RedisUtil;
import com.els.common.util.SpringContextUtils;
import com.els.common.util.SysUtil;
import com.els.config.mybatis.TenantContext;
import com.els.modules.account.api.dto.LoginUserDTO;
import com.els.modules.base.api.dto.ElsInitialTableDTO;
import com.els.modules.base.api.dto.PurchaseAttachmentDTO;
import com.els.modules.base.api.dto.StorageFileInfoDTO;
import com.els.modules.enquiry.enumerate.EnquiryScopeEnum;
import com.els.modules.inquiry.enumerate.SourceTypeEnum;
import com.els.modules.inquiry.vo.PublicInquiryVO;
import com.els.modules.logisticspurchase.base.entity.SubjectFileHead;
import com.els.modules.logisticspurchase.base.entity.SubjectFileItem;
import com.els.modules.logisticspurchase.base.enumerate.AddressTypeEnum;
import com.els.modules.logisticspurchase.base.enumerate.SubjectFileStatusEnum;
import com.els.modules.logisticspurchase.base.service.SubjectFileHeadService;
import com.els.modules.logisticspurchase.base.service.SubjectFileItemService;
import com.els.modules.logisticspurchase.enquiry.entity.EnquirySupplierListLp;
import com.els.modules.logisticspurchase.enquiry.entity.PurchaseEnquiryHeadLp;
import com.els.modules.logisticspurchase.enquiry.entity.PurchaseEnquiryItemLp;
import com.els.modules.logisticspurchase.enquiry.entity.SaleEnquiryHeadLp;
import com.els.modules.logisticspurchase.enquiry.enumerate.EnquiryLpStatusEnum;
import com.els.modules.logisticspurchase.enquiry.mapper.PurchaseEnquiryHeadLpMapper;
import com.els.modules.logisticspurchase.enquiry.service.EnquirySupplierListLpService;
import com.els.modules.logisticspurchase.enquiry.service.PublicEnquiryLpService;
import com.els.modules.logisticspurchase.enquiry.service.PurchaseEnquiryHeadLpService;
import com.els.modules.logisticspurchase.enquiry.service.PurchaseEnquiryLpOperationService;
import com.els.modules.logisticspurchase.enquiry.service.SaleEnquiryHeadLpService;
import com.els.modules.logisticspurchase.enquiry.service.impl.PublicEnquiryLpServiceImpl;
import com.els.modules.logisticspurchase.enquiry.utils.LpEnquiryJobUtil;
import com.els.modules.logisticspurchase.enquiry.vo.PurchaseEnquiryHeadLpVO;
import com.els.rpc.service.InvokeBaseRpcService;
import jakarta.annotation.Resource;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.compress.utils.Lists;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.web.multipart.MultipartFile;

@Service
public class PurchaseEnquiryLpOperationServiceImpl
extends BaseServiceImpl<PurchaseEnquiryHeadLpMapper, PurchaseEnquiryHeadLp>
implements PurchaseEnquiryLpOperationService {
    @Resource
    private PurchaseEnquiryHeadLpService purchaseEnquiryHeadLpService;
    @Resource
    private InvokeBaseRpcService invokeBaseRpcService;
    @Resource
    private SaleEnquiryHeadLpService saleEnquiryHeadLpService;
    @Resource
    private EnquirySupplierListLpService enquirySupplierListLpService;
    @Resource
    private SubjectFileHeadService subjectFileHeadService;
    @Resource
    private SubjectFileItemService subjectFileItemService;
    @Resource
    private RedisUtil redisUtil;
    private static final String BIZ_PATH = "files";
    private static final String STR_FORMAT = "yyyyMMdd";
    private static final String APPLY_KEY = "sys:enquiry:apply";
    @Resource(name="srmPoolExecutor")
    public ThreadPoolExecutor executor;
    @Value(value="${els.storage.type}")
    private String storeType;

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void publish(final PurchaseEnquiryHeadLpVO headVO, MultipartFile file) {
        this.setHeadParamAndCheck(headVO);
        PurchaseEnquiryHeadLp head = new PurchaseEnquiryHeadLp();
        BeanUtils.copyProperties((Object)((Object)headVO), (Object)((Object)head));
        final LoginUserDTO loginUser = SysUtil.getLoginUser();
        if (StrUtil.isBlank((CharSequence)headVO.getId())) {
            this.purchaseEnquiryHeadLpService.save((Object)head);
        } else {
            this.purchaseEnquiryHeadLpService.updateById((Object)head);
        }
        headVO.setId(head.getId());
        this.saveFile(headVO, file);
        this.executor.execute(new Runnable(){

            @Override
            public void run() {
                LoginUserContext.setUser((LoginUserDTO)loginUser);
                TenantContext.setTenant((String)loginUser.getElsAccount());
                try {
                    ((PurchaseEnquiryLpOperationService)SpringContextUtils.getBean(PurchaseEnquiryLpOperationService.class)).asynPublish(headVO, loginUser);
                }
                catch (Exception e) {
                    PurchaseEnquiryLpOperationServiceImpl.this.log.error("enquiry_publish_failed:", (Throwable)e);
                    PurchaseEnquiryHeadLp updateHead = new PurchaseEnquiryHeadLp();
                    updateHead.setEnquiryStatus(EnquiryLpStatusEnum.PUBLISH_FAILED.getValue());
                    updateHead.setId(headVO.getId());
                    updateHead.setFbk3(e.getMessage());
                    updateHead.setUpdateBy(loginUser.getSubAccount());
                    updateHead.setUpdateById(loginUser.getId());
                    PurchaseEnquiryLpOperationServiceImpl.this.purchaseEnquiryHeadLpService.updateById((Object)updateHead);
                }
                finally {
                    LoginUserContext.clear();
                    TenantContext.clear();
                }
            }
        });
    }

    private void saveFile(PurchaseEnquiryHeadLpVO headVO, MultipartFile file) {
        StorageFileInfoDTO fileInfo = null;
        try {
            DateTimeFormatter dtf = DateTimeFormatter.ofPattern(STR_FORMAT);
            LocalDateTime time = LocalDateTime.now();
            String nowDay = dtf.format(time);
            Object documentLocation = File.separator + BIZ_PATH + File.separator + TenantContext.getTenant() + File.separator + nowDay + File.separator + file.getOriginalFilename();
            if (((String)documentLocation).contains("\\")) {
                documentLocation = ((String)documentLocation).replace("\\", "/");
            }
            if (((String)documentLocation).startsWith("\\")) {
                ((String)documentLocation).replace("\\", "");
            }
            fileInfo = this.invokeBaseRpcService.storeFile(file.getInputStream(), file.getOriginalFilename(), file.getName(), (String)documentLocation, this.storeType);
        }
        catch (IOException e) {
            this.log.error("\u5b58\u50a8\u6587\u4ef6\u5f02\u5e38", (Throwable)e);
            throw new RuntimeException(e.getMessage(), e);
        }
        PurchaseAttachmentDTO attachment = new PurchaseAttachmentDTO();
        if (StrUtil.isNotBlank((CharSequence)fileInfo.getId())) {
            attachment.setId(fileInfo.getId());
        }
        attachment.setBusinessType("enquiryLp");
        attachment.setHeadId(headVO.getId());
        attachment.setFileType("5");
        attachment.setUploadSubAccount(SysUtil.getLoginUser().getSubAccount());
        attachment.setUploadElsAccount(TenantContext.getTenant());
        attachment.setFileName(file.getOriginalFilename());
        attachment.setFileSize(String.valueOf(file.getSize()));
        attachment.setFilePath(fileInfo.getPath());
        attachment.setSaveType(fileInfo.getSaveType());
        attachment.setSendStatus("0");
        attachment.setReceiveStatus("0");
        attachment.setUploadTime(new Date());
        attachment.setSourceType("1");
        attachment.setActionRoutePath("");
        attachment.setSourceNumber(headVO.getEnquiryNumber());
        this.invokeBaseRpcService.insertPurchaseAttachment(attachment);
    }

    private void setHeadParamAndCheck(PurchaseEnquiryHeadLpVO headVO) {
        long count;
        this.checkItem(headVO.getSubjectType(), headVO.getPurchaseEnquiryItemList());
        this.checkSubject(headVO.getSubjectFileHeadId(), headVO.getPurchaseEnquiryItemList());
        if (StrUtil.isBlank((CharSequence)headVO.getId()) && (count = this.purchaseEnquiryHeadLpService.count((Wrapper)((QueryWrapper)((QueryWrapper)new QueryWrapper().eq((Object)"els_account", (Object)TenantContext.getTenant())).ne((Object)"enquiry_status", (Object)"10")).eq((Object)"enquiry_number", (Object)headVO.getPurchaseEnquiryItemList().get(0).getEnquiryNumber()))) > 0L) {
            throw new ELSBootException("\u8be2\u4ef7\u5355\u53f7\uff1a" + headVO.getPurchaseEnquiryItemList().get(0).getEnquiryNumber() + "\u5728\u7cfb\u7edf\u4e2d\u5df2\u7ecf\u5b58\u5728\uff01");
        }
        super.setHeadDefaultValue((ParentEntity)headVO);
        headVO.setEnquiryStatus(EnquiryLpStatusEnum.PUBLISHING.getValue());
        String elsAccount = TenantContext.getTenant();
        headVO.setElsAccount(elsAccount);
        headVO.setBusAccount(elsAccount);
        headVO.setResultAuditStatus(AuditStatusEnum.NO_AUDIT_REQUIRED.getValue());
        headVO.setAuditStatus(AuditStatusEnum.NO_AUDIT_REQUIRED.getValue());
        headVO.setOpenBidStatus("0");
        headVO.setEnquiryScope(EnquiryScopeEnum.PUBLIC.getValue());
        headVO.setQuoteType("0");
        headVO.setFbk1(SysUtil.getLoginUser().getCompanyName());
        headVO.setSupplierTaxRate("1");
        headVO.setPurchasePrincipal(this.getLoginSubAndName());
    }

    private void checkSubject(String subjectId, List<PurchaseEnquiryItemLp> itemList) {
        Map<String, List<PurchaseEnquiryItemLp>> itemListMap = itemList.stream().collect(Collectors.groupingBy(PurchaseEnquiryItemLp::getSectionNumber));
        List<SubjectFileItem> subjectItemList = this.subjectFileItemService.selectByMainId(subjectId);
        Map subjectMap = subjectItemList.stream().collect(Collectors.toMap(SubjectFileItem::getSectionNumber, Function.identity()));
        for (String sectionNumber : itemListMap.keySet()) {
            SubjectFileItem subjectItem = (SubjectFileItem)((Object)subjectMap.get(sectionNumber));
            if (subjectItem == null) {
                throw new ELSBootException("\u6807\u6bb5\u7f16\u7801\uff1a" + sectionNumber + " \u5728\u6807\u7684\u4fe1\u606f\u4e2d\u4e0d\u5b58\u5728\uff01");
            }
            if (subjectItem.getTrafficVolumeProportion() != null) continue;
            throw new ELSBootException("\u6807\u6bb5\u7f16\u7801\uff1a" + sectionNumber + " \u7684\u8fd0\u91cf\u5360\u6bd4\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
    }

    private void checkItem(String subjectType, List<PurchaseEnquiryItemLp> itemList) {
        List itemNumberList = itemList.stream().map(o -> o.getSectionNumber() + o.getItemNumber()).distinct().collect(Collectors.toList());
        if (itemList.size() != itemNumberList.size()) {
            throw new ELSBootException("\u540c\u4e00\u4e2a\u6807\u6bb5\u4e0b\u5b58\u5728\u76f8\u540c\u7684\u8be2\u4ef7\u5355\u884c\u53f7\uff0c\u8bf7\u68c0\u67e5\u6570\u636e");
        }
        for (PurchaseEnquiryItemLp item : itemList) {
            if (StrUtil.isBlank((CharSequence)item.getSectionNumber())) {
                throw new ELSBootException("\u5b58\u5728\u6807\u6bb5\u7f16\u7801\u4e3a\u7a7a\u7684\u884c\u6570\u636e\uff0c\u8bf7\u68c0\u67e5");
            }
            if (StrUtil.isBlank((CharSequence)item.getSectionName())) {
                throw new ELSBootException("\u5b58\u5728\u6807\u6bb5\u540d\u79f0\u4e3a\u7a7a\u7684\u884c\u6570\u636e\uff0c\u8bf7\u68c0\u67e5");
            }
            if (StrUtil.isBlank((CharSequence)item.getStartProvince())) {
                throw new ELSBootException("\u5b58\u5728\u59cb\u53d1\u7701\u4efd\u4e3a\u7a7a\u7684\u884c\u6570\u636e\uff0c\u8bf7\u68c0\u67e5");
            }
            if (StrUtil.isBlank((CharSequence)item.getStartCity())) {
                throw new ELSBootException("\u5b58\u5728\u59cb\u53d1\u57ce\u5e02\u4e3a\u7a7a\u7684\u884c\u6570\u636e\uff0c\u8bf7\u68c0\u67e5");
            }
            if (StrUtil.isBlank((CharSequence)item.getArriveProvince())) {
                throw new ELSBootException("\u5b58\u5728\u5230\u8fbe\u7701\u4efd\u4e3a\u7a7a\u7684\u884c\u6570\u636e\uff0c\u8bf7\u68c0\u67e5");
            }
            if (AddressTypeEnum.HIGHWAY.getValue().equals(subjectType) && item.getKilometre() == null) {
                throw new ELSBootException("\u5b58\u5728\u516c\u91cc\u6570\u4e3a\u7a7a\u7684\u884c\u6570\u636e\uff0c\u8bf7\u68c0\u67e5");
            }
            if ((AddressTypeEnum.WATERWAY.getValue().equals(subjectType) || AddressTypeEnum.HIGHWAY.getValue().equals(subjectType)) && StrUtil.isBlank((CharSequence)item.getArriveCity())) {
                throw new ELSBootException("\u5b58\u5728\u5230\u8fbe\u57ce\u5e02\u4e3a\u7a7a\u7684\u884c\u6570\u636e\uff0c\u8bf7\u68c0\u67e5");
            }
            if ((AddressTypeEnum.RAILWAY_EXPRESS.getValue().equals(subjectType) || AddressTypeEnum.RAILWAY_CONTAINER.getValue().equals(subjectType)) && StrUtil.isBlank((CharSequence)item.getArriveCityStation())) {
                throw new ELSBootException("\u5b58\u5728\u5230\u8fbe\u5730\u533a\u4e3a\u7a7a\u7684\u884c\u6570\u636e\uff0c\u8bf7\u68c0\u67e5");
            }
            if (item.getTrafficVolumeProportion() != null) continue;
            throw new ELSBootException("\u5b58\u5728\u7ebf\u8def\u8fd0\u91cf\u5360\u6bd4\u4e3a\u7a7a\u7684\u884c\u6570\u636e\uff0c\u8bf7\u68c0\u67e5");
        }
        Map<String, List<PurchaseEnquiryItemLp>> checkMap = null;
        checkMap = AddressTypeEnum.HIGHWAY.getValue().equals(subjectType) ? itemList.stream().collect(Collectors.groupingBy(o -> o.getSectionNumber() + o.getStartProvince() + o.getStartCity() + o.getStartCounty() + o.getArriveProvince() + o.getArriveCity() + o.getArriveCounty())) : (AddressTypeEnum.WATERWAY.getValue().equals(subjectType) ? itemList.stream().collect(Collectors.groupingBy(o -> o.getSectionNumber() + o.getStartProvince() + o.getStartCity() + o.getStartCounty() + o.getArriveProvince() + o.getArriveCity())) : itemList.stream().collect(Collectors.groupingBy(o -> o.getSectionNumber() + o.getStartProvince() + o.getStartCity() + o.getStartCounty() + o.getArriveProvince() + o.getArriveCityStation())));
        for (String key : checkMap.keySet()) {
            List<PurchaseEnquiryItemLp> checkItemList = checkMap.get(key);
            if (checkItemList.size() <= 1) continue;
            String itemNumbers = checkItemList.stream().map(PurchaseEnquiryItemLp::getItemNumber).collect(Collectors.joining(","));
            throw new ELSBootException("\u8be2\u4ef7\u5355\u884c\u53f7 " + itemNumbers + " \u7ebf\u8def\u4fe1\u606f\u91cd\u590d\uff0c\u8bf7\u68c0\u67e5\u4fee\u6539\u540e\u518d\u5bfc\u5165");
        }
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void asynPublish(PurchaseEnquiryHeadLpVO headVO, LoginUserDTO loginUser) {
        PurchaseEnquiryHeadLp updateHead = new PurchaseEnquiryHeadLp();
        updateHead.setEnquiryStatus(EnquiryLpStatusEnum.QUOTING.getValue());
        updateHead.setId(headVO.getId());
        Date currentDate = new Date();
        updateHead.setPublishTime(currentDate);
        LoginUserDTO user = LoginUserContext.getUser();
        updateHead.setPublishUser(user.getSubAccount() + "_" + user.getRealname());
        updateHead.setEnquiryDate(headVO.getEnquiryDate() == null ? currentDate : headVO.getEnquiryDate());
        updateHead.setAllowDelay(StrUtil.isBlank((CharSequence)headVO.getAllowDelay()) ? "1" : headVO.getAllowDelay());
        updateHead.setFbk3("");
        updateHead.setUpdateBy(loginUser.getSubAccount());
        updateHead.setUpdateById(loginUser.getId());
        this.purchaseEnquiryHeadLpService.updateById((Object)updateHead);
        List<PurchaseEnquiryItemLp> enquiryItemList = headVO.getPurchaseEnquiryItemList();
        for (PurchaseEnquiryItemLp item : enquiryItemList) {
            item.setId(null);
            item.setEnquiryNumber(headVO.getEnquiryNumber());
            item.setElsAccount(TenantContext.getTenant());
            item.setHeadId(headVO.getId());
            item.setDocumentId(headVO.getDocumentId());
            item.setToElsAccount("");
            item.setPurchaseName(LoginUserContext.getUser().getEnterpriseName());
            item.setItemStatus(EnquiryLpStatusEnum.QUOTING.getValue());
            item.setAuditStatus(AuditStatusEnum.NO_AUDIT_REQUIRED.getValue());
            item.setSourceType(StrUtil.isBlank((CharSequence)item.getSourceType()) ? SourceTypeEnum.MANUAL.getValue() : item.getSourceType());
            SysUtil.setNullCreate((BaseEntity)item);
            SysUtil.setSysParam((BaseEntity)item, (BaseEntity)headVO);
        }
        this.saveInitialTable(headVO.getId(), enquiryItemList);
        PublicEnquiryLpService publicEnquiryService = (PublicEnquiryLpService)SpringContextUtils.getBean(PublicEnquiryLpServiceImpl.class);
        publicEnquiryService.publishNotice(headVO);
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"subject_number", (Object)headVO.getSubjectNumber());
        queryWrapper.eq((Object)"subject_year", (Object)headVO.getSubjectYear());
        SubjectFileHead subjectFileHead = (SubjectFileHead)((Object)this.subjectFileHeadService.getOne((Wrapper)queryWrapper));
        if (subjectFileHead != null) {
            subjectFileHead.setStatus(SubjectFileStatusEnum.TRANSFERRED_ENQUIRY.getValue());
            this.subjectFileHeadService.updateById((Object)subjectFileHead);
        }
        DateTime endTime = DateUtil.offsetMinute((Date)headVO.getQuoteEndTime(), (int)5);
        LpEnquiryJobUtil.updateOrCreateJob(headVO, (Date)endTime);
    }

    private void saveInitialTable(String id, List<PurchaseEnquiryItemLp> enquiryItemList) {
        ArrayList initialTableList = Lists.newArrayList();
        for (PurchaseEnquiryItemLp item : enquiryItemList) {
            ElsInitialTableDTO initialTable = new ElsInitialTableDTO();
            initialTable.setElsAccount(TenantContext.getTenant());
            initialTable.setRelationId(id);
            initialTable.setBusinessType(IdWorker.getIdStr());
            String json = JSON.toJSONString((Object)((Object)item));
            initialTable.setBusinessInfoJson(json);
            initialTableList.add(initialTable);
        }
        this.invokeBaseRpcService.batchAddElsInitialTable((List)initialTableList);
    }

    @Override
    public void apply(PublicInquiryVO inquiryVO) {
        String elsAccount;
        final String headId = inquiryVO.getId();
        if (!this.redisUtil.tryGetDistributedLock(APPLY_KEY, headId + (elsAccount = TenantContext.getTenant()), 3600000L)) {
            throw new ELSBootException("\u62a5\u540d\u8bf7\u6c42\u5df2\u7ecf\u63d0\u4ea4\uff0c\u7cfb\u7edf\u6b63\u5728\u5904\u7406\u4e2d\uff0c\u65e0\u9700\u91cd\u590d\u63d0\u4ea4\u62a5\u540d\uff0c\u8bf7\u7a0d\u540e\u5728\u9500\u552e\u534f\u540c-\u5bfb\u6e90\u534f\u540c-\u62a5\u4ef7\u7ba1\u7406\u4e2d\u67e5\u770b");
        }
        final PurchaseEnquiryHeadLp purchaseEnquiryHead = (PurchaseEnquiryHeadLp)((Object)this.purchaseEnquiryHeadLpService.getById((Serializable)((Object)headId)));
        if (purchaseEnquiryHead == null) {
            throw new ELSBootException("id \u4e0d\u5b58\u5728\uff01");
        }
        SaleEnquiryHeadLp saleEnquiryHead = (SaleEnquiryHeadLp)((Object)this.saleEnquiryHeadLpService.getOne((Wrapper)((QueryWrapper)new QueryWrapper().eq((Object)"els_account", (Object)elsAccount)).eq((Object)"relation_id", (Object)headId)));
        if (saleEnquiryHead != null) {
            this.redisUtil.releaseDistributedLock(APPLY_KEY, purchaseEnquiryHead.getId() + TenantContext.getTenant());
            throw new ELSBootException("\u5df2\u7ecf\u62a5\u540d\u6210\u529f\uff0c\u65e0\u9700\u91cd\u590d\u63d0\u4ea4\u62a5\u540d\uff0c\u8bf7\u5728\u9500\u552e\u534f\u540c-\u5bfb\u6e90\u534f\u540c-\u62a5\u4ef7\u7ba1\u7406\u4e2d\u67e5\u770b\u5177\u4f53\u8be2\u4ef7\u5355");
        }
        final LoginUserDTO loginUser = SysUtil.getLoginUser();
        this.executor.execute(new Runnable(){

            @Override
            public void run() {
                Thread.currentThread().setName("Enquiry_Apply_Thread_" + headId + "_" + elsAccount);
                Thread.currentThread().setPriority(10);
                LoginUserContext.setUser((LoginUserDTO)loginUser);
                TenantContext.setTenant((String)loginUser.getElsAccount());
                try {
                    ((PurchaseEnquiryLpOperationService)SpringContextUtils.getBean(PurchaseEnquiryLpOperationService.class)).asynApply(purchaseEnquiryHead);
                }
                catch (Exception e) {
                    PurchaseEnquiryLpOperationServiceImpl.this.log.error("asynApply_faild:", (Throwable)e);
                }
                finally {
                    PurchaseEnquiryLpOperationServiceImpl.this.redisUtil.releaseDistributedLock(PurchaseEnquiryLpOperationServiceImpl.APPLY_KEY, purchaseEnquiryHead.getId() + TenantContext.getTenant());
                    LoginUserContext.clear();
                    TenantContext.clear();
                }
            }
        });
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void asynApply(PurchaseEnquiryHeadLp head) {
        long time = System.currentTimeMillis();
        String elsAccount = TenantContext.getTenant();
        String supplierListId = IdWorker.getIdStr();
        SaleEnquiryHeadLp saleEnquiryHead = new SaleEnquiryHeadLp();
        BeanUtils.copyProperties((Object)((Object)head), (Object)((Object)saleEnquiryHead));
        saleEnquiryHead.setId(IdWorker.getIdStr());
        saleEnquiryHead.setRelationId(head.getId());
        saleEnquiryHead.setElsAccount(elsAccount);
        saleEnquiryHead.setToElsAccount(head.getElsAccount());
        saleEnquiryHead.setSupplierListId(supplierListId);
        saleEnquiryHead.setSupplierName(LoginUserContext.getUser().getEnterpriseName());
        saleEnquiryHead.setPurchaseName(head.getFbk1());
        this.saleEnquiryHeadLpService.save((Object)saleEnquiryHead);
        EnquirySupplierListLp supplierList = new EnquirySupplierListLp();
        supplierList.setId(supplierListId);
        supplierList.setElsAccount(head.getElsAccount());
        supplierList.setHeadId(head.getId());
        supplierList.setToElsAccount(elsAccount);
        supplierList.setSupplierName(LoginUserContext.getUser().getEnterpriseName());
        supplierList.setFbk1("\u5df2\u62a5\u540d");
        supplierList.setFbk2(DateUtil.formatDateTime((Date)new Date()));
        this.enquirySupplierListLpService.save((Object)supplierList);
        this.log.error("toElsAccount_enquiryNumber_apply_cost:" + elsAccount + "_" + saleEnquiryHead.getEnquiryNumber() + "_" + (System.currentTimeMillis() - time));
    }
}

