/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.logisticspurchase.enquiry.utils;

import com.alibaba.fastjson.JSONObject;
import com.els.common.constant.CommonConstant;
import com.els.common.exception.ELSBootException;
import com.els.common.util.DateUtils;
import com.els.common.util.SrmRpcUtil;
import com.els.config.mybatis.TenantContext;
import com.els.modules.job.api.dto.QuartzJobDTO;
import com.els.modules.job.api.service.QuartzRpcService;
import com.els.modules.logisticspurchase.enquiry.entity.PurchaseEnquiryHeadLp;
import java.util.Date;
import java.util.List;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LpEnquiryJobUtil {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(LpEnquiryJobUtil.class);
    private static final String ENQUIRY_END_JOB = "logisticsPurchaseEnquiryEndJobBeanServiceImpl";

    public static void updateOrCreateJob(PurchaseEnquiryHeadLp head, Date quoteEndTime) {
        String elsAccount = TenantContext.getTenant();
        String jobNameKey = "logisticsPurchaseEnquiryEndJobBeanServiceImpl_" + head.getEnquiryNumber() + "_" + elsAccount;
        String cron = DateUtils.formatDate((Date)quoteEndTime, (String)"ss mm HH dd MM ? yyyy");
        QuartzJobDTO job = new QuartzJobDTO();
        job.setCronExpression(cron);
        job.setJobClassName("com.els.modules.quartz.job.BusinessJob");
        job.setStatus(CommonConstant.STATUS_NORMAL);
        job.setJobNameKey(jobNameKey);
        JSONObject paramObj = new JSONObject();
        paramObj.put("id", (Object)head.getId());
        paramObj.put("jobKey", (Object)job.getJobNameKey());
        paramObj.put("tenantId", (Object)TenantContext.getTenant());
        paramObj.put("jobImplName", (Object)ENQUIRY_END_JOB);
        job.setParameter(paramObj.toJSONString());
        job.setElsAccount(elsAccount);
        List jobList = ((QuartzRpcService)SrmRpcUtil.getExecuteServiceImpl(QuartzRpcService.class)).findJobList(jobNameKey);
        try {
            if (jobList.isEmpty()) {
                ((QuartzRpcService)SrmRpcUtil.getExecuteServiceImpl(QuartzRpcService.class)).createJob(job);
            } else {
                job.setId(((QuartzJobDTO)jobList.get(0)).getId());
                ((QuartzRpcService)SrmRpcUtil.getExecuteServiceImpl(QuartzRpcService.class)).updateJob(job);
            }
        }
        catch (Exception e) {
            throw new ELSBootException((Throwable)e);
        }
    }

    public static void deleteJob(String jobKey) {
        List jobList = ((QuartzRpcService)SrmRpcUtil.getExecuteServiceImpl(QuartzRpcService.class)).findJobList(jobKey);
        if (!jobList.isEmpty()) {
            ((QuartzRpcService)SrmRpcUtil.getExecuteServiceImpl(QuartzRpcService.class)).deleteJob((QuartzJobDTO)jobList.get(0));
        }
    }

    public static void deleteJob(PurchaseEnquiryHeadLp dbHead) {
        String jobKey = "logisticsPurchaseEnquiryEndJobBeanServiceImpl_" + dbHead.getEnquiryNumber() + "_" + dbHead.getElsAccount();
        LpEnquiryJobUtil.deleteJob(jobKey);
    }
}

