/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.tender.attachment.service.impl;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.els.common.aspect.annotation.SrmTransaction;
import com.els.common.constant.CommonConstant;
import com.els.common.enumerate.AuditStatusEnum;
import com.els.common.exception.ELSBootException;
import com.els.common.system.base.service.impl.BaseServiceImpl;
import com.els.common.util.I18nUtil;
import com.els.common.util.SysUtil;
import com.els.config.mybatis.TenantContext;
import com.els.modules.base.api.dto.PurchaseAttachmentDTO;
import com.els.modules.tender.archive.enumerate.TenderProjectArchiveAttachmentEnum;
import com.els.modules.tender.archive.utils.ArchiveUtil;
import com.els.modules.tender.attachment.entity.CustomColumnModel;
import com.els.modules.tender.attachment.entity.PurchaseTenderBidLetter;
import com.els.modules.tender.attachment.entity.PurchaseTenderEvaluationGroup;
import com.els.modules.tender.attachment.entity.PurchaseTenderEvaluationPriceRegulationInfo;
import com.els.modules.tender.attachment.entity.PurchaseTenderEvaluationPrinciples;
import com.els.modules.tender.attachment.entity.PurchaseTenderEvaluationRegulationInfo;
import com.els.modules.tender.attachment.entity.PurchaseTenderPriceOpeningsTemplate;
import com.els.modules.tender.attachment.entity.PurchaseTenderProjectAttachmentHead;
import com.els.modules.tender.attachment.entity.PurchaseTenderProjectAttachmentInfo;
import com.els.modules.tender.attachment.enumerate.AttachmentFileStateEnum;
import com.els.modules.tender.attachment.enumerate.AttachmentStateEnum;
import com.els.modules.tender.attachment.enumerate.BidLetterFormatQuoteTypeEnum;
import com.els.modules.tender.attachment.enumerate.BidLetterFormatTypeEnum;
import com.els.modules.tender.attachment.enumerate.PricePointsCalFormualEnum;
import com.els.modules.tender.attachment.enumerate.ShortlistedRulesEnum;
import com.els.modules.tender.attachment.mapper.PurchaseTenderProjectAttachmentHeadMapper;
import com.els.modules.tender.attachment.service.PurchaseTenderBidLetterFormatGroupService;
import com.els.modules.tender.attachment.service.PurchaseTenderBidLetterService;
import com.els.modules.tender.attachment.service.PurchaseTenderEvaluationGroupService;
import com.els.modules.tender.attachment.service.PurchaseTenderEvaluationPriceRegulationInfoService;
import com.els.modules.tender.attachment.service.PurchaseTenderEvaluationPrinciplesService;
import com.els.modules.tender.attachment.service.PurchaseTenderEvaluationRegulationInfoService;
import com.els.modules.tender.attachment.service.PurchaseTenderPriceOpeningsTemplateService;
import com.els.modules.tender.attachment.service.PurchaseTenderProjectAttachmentHeadService;
import com.els.modules.tender.attachment.service.PurchaseTenderProjectAttachmentInfoService;
import com.els.modules.tender.attachment.vo.PurchaseTenderBidLetterFormatGroupVO;
import com.els.modules.tender.attachment.vo.PurchaseTenderBidLetterVO;
import com.els.modules.tender.attachment.vo.PurchaseTenderEvaluationGroupVO;
import com.els.modules.tender.attachment.vo.PurchaseTenderProjectAttachmentHeadVO;
import com.els.modules.tender.column.enumerate.CustomerFieldCategoryEnum;
import com.els.modules.tender.common.event.TenderWriteBackSubpackageInfoEventDTO;
import com.els.modules.tender.common.interceptor.TenderFlagInjectionContext;
import com.els.modules.tender.common.utils.PushEventUtils;
import com.els.modules.tender.project.entity.PurchaseTenderProjectSubpackageInfo;
import com.els.modules.tender.project.enumerate.SubpackageBidOpenTypeEnum;
import com.els.modules.tender.project.enumerate.SubpackageEvaBidTypeEnum;
import com.els.modules.tender.project.enumerate.SubpackageInfoCheckTypeEnum;
import com.els.modules.tender.project.enumerate.SubpackageInfoCurrentStepEnum;
import com.els.modules.tender.project.enumerate.SubpackageInfoProcessTypeEnum;
import com.els.modules.tender.project.enumerate.TenderProjectSubpackageStatusEnum;
import com.els.modules.tender.project.service.PurchaseTenderProjectSubpackageInfoService;
import com.els.modules.workflow.modules.dto.FlowCallBackDTO;
import com.els.rpc.service.InvokeBaseRpcService;
import jakarta.annotation.Resource;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;

@Service
public class PurchaseTenderProjectAttachmentHeadServiceImpl
extends BaseServiceImpl<PurchaseTenderProjectAttachmentHeadMapper, PurchaseTenderProjectAttachmentHead>
implements PurchaseTenderProjectAttachmentHeadService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(PurchaseTenderProjectAttachmentHeadServiceImpl.class);
    @Autowired
    private PurchaseTenderProjectAttachmentInfoService attachmentInfoService;
    @Autowired
    private PurchaseTenderBidLetterFormatGroupService bidLetterFormatGroupService;
    @Autowired
    private PurchaseTenderBidLetterService bidLetterService;
    @Autowired
    private PurchaseTenderPriceOpeningsTemplateService priceOpeningsTemplateService;
    @Autowired
    private PurchaseTenderEvaluationPrinciplesService evaluationPrinciplesService;
    @Autowired
    private PurchaseTenderEvaluationGroupService evaluationGroupService;
    @Autowired
    private PurchaseTenderEvaluationRegulationInfoService regulationInfoService;
    @Autowired
    private PurchaseTenderEvaluationPriceRegulationInfoService evaluationPriceRegulationInfoService;
    @Resource
    private InvokeBaseRpcService invokeBaseRpcService;
    @Autowired
    @Lazy
    private PurchaseTenderProjectSubpackageInfoService subpackageInfoService;

    @Override
    public PurchaseTenderProjectAttachmentHeadVO queryAll(String subpackageId) {
        PurchaseTenderProjectAttachmentHeadVO headVo = new PurchaseTenderProjectAttachmentHeadVO();
        PurchaseTenderProjectAttachmentHead purchaseTenderProjectAttachmentHead = this.getAttachmentHeadBySubpackageId(subpackageId);
        if (null == purchaseTenderProjectAttachmentHead) {
            return headVo;
        }
        BeanUtils.copyProperties((Object)((Object)purchaseTenderProjectAttachmentHead), (Object)((Object)headVo));
        headVo.setBusAccount(purchaseTenderProjectAttachmentHead.getElsAccount());
        List<PurchaseTenderProjectAttachmentInfo> purchaseTenderProjectAttachmentInfoList = this.attachmentInfoService.queryTenderProjectAttachmentInfo(purchaseTenderProjectAttachmentHead);
        headVo.setPurchaseTenderProjectAttachmentInfoList(purchaseTenderProjectAttachmentInfoList);
        PurchaseTenderBidLetterFormatGroupVO purchaseTenderBidLetterFormatGroupVo = this.bidLetterFormatGroupService.queryPurchaseTenderBidLetterFormatGroupVoInfo(purchaseTenderProjectAttachmentHead);
        headVo.setTenderBidLetterFormatGroupVo(purchaseTenderBidLetterFormatGroupVo);
        PurchaseTenderEvaluationPrinciples purchaseTenderEvaluationPrinciples = this.evaluationPrinciplesService.queryPurchaseTenderEvaluationPrinciples(purchaseTenderProjectAttachmentHead);
        headVo.setPurchaseTenderEvaluationPrinciples(purchaseTenderEvaluationPrinciples);
        List<PurchaseTenderEvaluationGroupVO> purchaseTenderEvaluationInfoVoList = this.evaluationGroupService.queryPurchaseTenderEvaluationInfoVo(purchaseTenderProjectAttachmentHead);
        headVo.setTenderEvaluationInfoVoList(purchaseTenderEvaluationInfoVoList);
        purchaseTenderEvaluationInfoVoList.stream().forEach(evaluationGroupVO -> {
            PurchaseTenderEvaluationPriceRegulationInfo priceRegulationInfo = evaluationGroupVO.getTenderEvaluationTemplatePriceRegulationInfo();
            if (priceRegulationInfo != null) {
                List<PurchaseTenderBidLetterVO> tenderBidTetterVoList;
                String tenderBidLetterId = priceRegulationInfo.getTenderBidLetterId();
                String tenderBidLetterFieldName = priceRegulationInfo.getQuoteColumnName();
                if (null != purchaseTenderBidLetterFormatGroupVo && CollectionUtil.isNotEmpty(tenderBidTetterVoList = purchaseTenderBidLetterFormatGroupVo.getTenderBidTetterVoList())) {
                    for (PurchaseTenderBidLetterVO tenderBidLetterVO : tenderBidTetterVoList) {
                        if (null == tenderBidLetterId || !tenderBidLetterId.equals(tenderBidLetterVO.getId())) continue;
                        priceRegulationInfo.setBidLetterName(tenderBidLetterVO.getName());
                        String model = tenderBidLetterVO.getCustomizeFieldModel();
                        if (StrUtil.isBlank((CharSequence)model)) continue;
                        JSONArray jsonArray = JSONArray.parseArray((String)model);
                        for (int i = 0; i < jsonArray.size(); ++i) {
                            JSONObject jsonObject = jsonArray.getJSONObject(i);
                            if (!jsonObject.containsValue((Object)tenderBidLetterFieldName)) continue;
                            String title = jsonObject.get((Object)"title").toString();
                            priceRegulationInfo.setBidLetterFieldName(title);
                        }
                    }
                }
            }
        });
        return headVo;
    }

    @Override
    public PurchaseTenderBidLetterFormatGroupVO queryBidLetterFormatGroup(String subpackageId) {
        PurchaseTenderProjectAttachmentHead purchaseTenderProjectAttachmentHead = this.getAttachmentHeadBySubpackageId(subpackageId);
        if (purchaseTenderProjectAttachmentHead == null) {
            return null;
        }
        return this.bidLetterFormatGroupService.queryPurchaseTenderBidLetterFormatGroupVoInfo(purchaseTenderProjectAttachmentHead);
    }

    @Override
    public PurchaseTenderProjectAttachmentHead getAttachmentHeadBySubpackageId(String subpackageId) {
        String checkType = TenderFlagInjectionContext.getTenderCheckType();
        Assert.hasText((String)checkType, (String)I18nUtil.translate((String)"i18n_alert_UJCKxOLVW_e56eae77", (String)"\u5ba1\u67e5\u65b9\u5f0f\u4e0d\u80fd\u4e3a\u7a7a!"));
        List<PurchaseTenderProjectAttachmentHead> attachmentHeadList = ((PurchaseTenderProjectAttachmentHeadMapper)this.baseMapper).selectBySubpackageId(subpackageId, checkType);
        if (CollectionUtil.isEmpty(attachmentHeadList)) {
            return null;
        }
        return attachmentHeadList.get(0);
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void insertMain(PurchaseTenderProjectAttachmentHeadVO headVO) {
        PurchaseTenderProjectAttachmentHead dbAttachmentHead = this.getAttachmentHeadBySubpackageId(headVO.getSubpackageId());
        Assert.isTrue((dbAttachmentHead == null ? 1 : 0) != 0, (String)I18nUtil.translate((String)"i18n_alert_KyIKXVXVSsK_23f27f71", (String)"\u94fe\u63a5\u5df2\u5931\u6548\uff0c\u8bf7\u5237\u65b0\u540e\u91cd\u8bd5\uff01"));
        PurchaseTenderProjectAttachmentHead attachmentHead = new PurchaseTenderProjectAttachmentHead();
        headVO.setDeleted(CommonConstant.DEL_FLAG_0);
        headVO.setStatus(AttachmentStateEnum.NEW.getValue());
        headVO.setAttachmentNumber(this.invokeBaseRpcService.getNextCode("tenderAttachmentNumber", (Object)attachmentHead));
        headVO.setCheckType(TenderFlagInjectionContext.getTenderCheckType());
        headVO.setProcessType(TenderFlagInjectionContext.getTenderProcessType());
        BeanUtils.copyProperties((Object)((Object)headVO), (Object)((Object)attachmentHead));
        ((PurchaseTenderProjectAttachmentHeadMapper)this.baseMapper).insert((Object)attachmentHead);
        this.deleteAll(headVO);
        headVO.setId(attachmentHead.getId());
        this.insertData(attachmentHead, headVO);
    }

    public void insertData(PurchaseTenderProjectAttachmentHead attachmentHead, PurchaseTenderProjectAttachmentHeadVO attachmentHeadVo) {
        boolean hasPreTrial;
        if (CollectionUtil.isNotEmpty(attachmentHeadVo.getPurchaseTenderProjectAttachmentInfoList())) {
            this.attachmentInfoService.addTenderProjectAttachmentInfo(attachmentHead, attachmentHeadVo.getPurchaseTenderProjectAttachmentInfoList());
        }
        if (null != attachmentHeadVo.getTenderBidLetterFormatGroupVo()) {
            this.bidLetterFormatGroupService.addTenderBidLetter(attachmentHead, attachmentHeadVo.getTenderBidLetterFormatGroupVo());
        }
        if (null != attachmentHeadVo.getPurchaseTenderEvaluationPrinciples()) {
            this.evaluationPrinciplesService.addTenderEvaluationPrinciples(attachmentHead, attachmentHeadVo.getPurchaseTenderEvaluationPrinciples());
        }
        if (CollectionUtil.isNotEmpty(attachmentHeadVo.getTenderEvaluationInfoVoList())) {
            this.evaluationGroupService.addTenderEvaluationInfo(attachmentHead, attachmentHeadVo.getTenderEvaluationInfoVoList());
        }
        String subPackageStatus = (hasPreTrial = SubpackageInfoCheckTypeEnum.hasPreTrial(attachmentHead.getCheckType())) ? "" + TenderProjectSubpackageStatusEnum.PRE_ATTACHMENT_EDIT.getValue() : "" + TenderProjectSubpackageStatusEnum.ATTACHMENT_EDIT.getValue();
        this.updateTenderProjectSubpackageInfo(attachmentHead, subPackageStatus);
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void updateMain(PurchaseTenderProjectAttachmentHeadVO purchaseTenderProjectAttachmentHeadVo) {
        PurchaseTenderProjectAttachmentHead attachmentHead = new PurchaseTenderProjectAttachmentHead();
        BeanUtils.copyProperties((Object)((Object)purchaseTenderProjectAttachmentHeadVo), (Object)((Object)attachmentHead));
        attachmentHead.setStatus(AttachmentStateEnum.NEW.getValue());
        ((PurchaseTenderProjectAttachmentHeadMapper)this.baseMapper).updateById((Object)attachmentHead);
        this.deleteAll(purchaseTenderProjectAttachmentHeadVo);
        this.insertData(attachmentHead, purchaseTenderProjectAttachmentHeadVo);
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void clarificationUpdateMain(PurchaseTenderProjectAttachmentHeadVO attachmentHeadVO) {
        this.bidLetterFormatGroupService.deleteByMainId(attachmentHeadVO.getId());
        this.bidLetterService.deleteByMainId(attachmentHeadVO.getId());
        this.priceOpeningsTemplateService.deleteByMainId(attachmentHeadVO.getId());
        this.evaluationPrinciplesService.deleteByMainId(attachmentHeadVO.getId());
        this.evaluationGroupService.deleteByMainId(attachmentHeadVO.getId());
        this.regulationInfoService.deleteByMainId(attachmentHeadVO.getId());
        this.evaluationPriceRegulationInfoService.deleteByMainId(attachmentHeadVO.getId());
        if (null != attachmentHeadVO.getTenderBidLetterFormatGroupVo()) {
            this.bidLetterFormatGroupService.addTenderBidLetter(attachmentHeadVO, attachmentHeadVO.getTenderBidLetterFormatGroupVo());
        }
        if (null != attachmentHeadVO.getPurchaseTenderEvaluationPrinciples()) {
            this.evaluationPrinciplesService.addTenderEvaluationPrinciples(attachmentHeadVO, attachmentHeadVO.getPurchaseTenderEvaluationPrinciples());
        }
        if (CollectionUtil.isNotEmpty(attachmentHeadVO.getTenderEvaluationInfoVoList())) {
            this.evaluationGroupService.addTenderEvaluationInfo(attachmentHeadVO, attachmentHeadVO.getTenderEvaluationInfoVoList());
        }
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void deleteAll(PurchaseTenderProjectAttachmentHeadVO purchaseTenderProjectAttachmentHeadVo) {
        this.attachmentInfoService.deleteByMainId(purchaseTenderProjectAttachmentHeadVo.getId());
        this.bidLetterFormatGroupService.deleteByMainId(purchaseTenderProjectAttachmentHeadVo.getId());
        this.bidLetterService.deleteByMainId(purchaseTenderProjectAttachmentHeadVo.getId());
        this.priceOpeningsTemplateService.deleteByMainId(purchaseTenderProjectAttachmentHeadVo.getId());
        this.evaluationPrinciplesService.deleteByMainId(purchaseTenderProjectAttachmentHeadVo.getId());
        this.evaluationGroupService.deleteByMainId(purchaseTenderProjectAttachmentHeadVo.getId());
        this.regulationInfoService.deleteByMainId(purchaseTenderProjectAttachmentHeadVo.getId());
        this.evaluationPriceRegulationInfoService.deleteByMainId(purchaseTenderProjectAttachmentHeadVo.getId());
    }

    @Override
    public List<PurchaseTenderBidLetter> queryTenderBidLetterList(String subpackageId) {
        List<PurchaseTenderBidLetter> bidLetterList = this.bidLetterService.queryPurchaseTenderBidLetter(subpackageId);
        return bidLetterList;
    }

    @Override
    public List<CustomColumnModel> queryPriceColumn(String bidLetterId) {
        List<String> bidLetterIdList = Arrays.asList(bidLetterId);
        List<PurchaseTenderPriceOpeningsTemplate> priceOpeningsTemplates = this.priceOpeningsTemplateService.selectByMainIds(bidLetterIdList);
        ArrayList<CustomColumnModel> tenderCustomColumnList = new ArrayList<CustomColumnModel>();
        for (PurchaseTenderPriceOpeningsTemplate priceOpening : priceOpeningsTemplates) {
            List categoryFieldList;
            String customizeFieldModel = priceOpening.getCustomizeFieldModel();
            List customColumnModel = JSONArray.parseArray((String)customizeFieldModel, CustomColumnModel.class);
            if (customColumnModel.isEmpty() || !CollectionUtils.isNotEmpty(categoryFieldList = customColumnModel.stream().filter(column -> CustomerFieldCategoryEnum.TENDER_OFFERS_COLUMN.getValue().equals(column.getFieldCategory())).collect(Collectors.toList()))) continue;
            tenderCustomColumnList.addAll(categoryFieldList);
        }
        return tenderCustomColumnList;
    }

    @Override
    public PurchaseTenderProjectAttachmentHead queryById(String id) {
        return (PurchaseTenderProjectAttachmentHead)((Object)((PurchaseTenderProjectAttachmentHeadMapper)this.baseMapper).selectById((Serializable)((Object)id)));
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void updateAuditStatus(String auditStatus, FlowCallBackDTO flowCallbackDTO) {
        PurchaseTenderProjectAttachmentHead purchaseTenderProjectAttachmentHead = (PurchaseTenderProjectAttachmentHead)((Object)this.getById((Serializable)((Object)flowCallbackDTO.getBusinessId())));
        purchaseTenderProjectAttachmentHead.setFlowId(flowCallbackDTO.getProcessInstanceId());
        String status = null;
        String subPackageStatus = null;
        boolean hasPreTrial = SubpackageInfoCheckTypeEnum.hasPreTrial(purchaseTenderProjectAttachmentHead.getCheckType());
        if (AuditStatusEnum.AUDIT_FINISH.getValue().equals(auditStatus)) {
            status = AttachmentStateEnum.AUDIT_YES.getValue();
            subPackageStatus = hasPreTrial ? "" + TenderProjectSubpackageStatusEnum.PRE_ATTACHMENT_FINISH.getValue() : "" + TenderProjectSubpackageStatusEnum.ATTACHMENT_FINISH.getValue();
        } else if (AuditStatusEnum.AUDIT_REJECT.getValue().equals(auditStatus)) {
            status = AttachmentStateEnum.NEW.getValue();
            subPackageStatus = hasPreTrial ? "" + TenderProjectSubpackageStatusEnum.PRE_ATTACHMENT_REJECT.getValue() : "" + TenderProjectSubpackageStatusEnum.ATTACHMENT_REJECT.getValue();
        } else if (AuditStatusEnum.AUDIT_NEW.getValue().equals(auditStatus)) {
            status = AttachmentStateEnum.NEW.getValue();
            subPackageStatus = hasPreTrial ? "" + TenderProjectSubpackageStatusEnum.PRE_ATTACHMENT_EDIT.getValue() : "" + TenderProjectSubpackageStatusEnum.ATTACHMENT_EDIT.getValue();
        } else {
            status = AttachmentStateEnum.AUDIT.getValue();
            subPackageStatus = hasPreTrial ? "" + TenderProjectSubpackageStatusEnum.PRE_ATTACHMENT_AUDIT.getValue() : "" + TenderProjectSubpackageStatusEnum.ATTACHMENT_AUDIT.getValue();
        }
        purchaseTenderProjectAttachmentHead.setAuditStatus(auditStatus);
        purchaseTenderProjectAttachmentHead.setStatus(status);
        ((PurchaseTenderProjectAttachmentHeadMapper)this.baseMapper).updateById((Object)purchaseTenderProjectAttachmentHead);
        this.updateTenderProjectSubpackageInfo(purchaseTenderProjectAttachmentHead, subPackageStatus);
    }

    private void updateTenderProjectSubpackageInfo(PurchaseTenderProjectAttachmentHead attachmentHead, String subPackageStatus) {
        TenderWriteBackSubpackageInfoEventDTO eventDTO = TenderWriteBackSubpackageInfoEventDTO.builder().event((Object)attachmentHead).subpackageId(attachmentHead.getSubpackageId()).subpackageStatus(subPackageStatus).build();
        PushEventUtils.updateSubpackageInfo(eventDTO);
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void publish(PurchaseTenderProjectAttachmentHeadVO tenderProjectAttachmentInfoVo) {
        if (StrUtil.isNotBlank((CharSequence)tenderProjectAttachmentInfoVo.getId())) {
            this.updateMain(tenderProjectAttachmentInfoVo);
        } else {
            this.insertMain(tenderProjectAttachmentInfoVo);
        }
        Assert.hasText((String)tenderProjectAttachmentInfoVo.getId(), (String)I18nUtil.translate((String)"i18n_alert_VHjS_25c69f34", (String)"\u4fe1\u606f\u6709\u8bef"));
        PurchaseTenderProjectAttachmentHead purchaseTenderProjectAttachmentHead = (PurchaseTenderProjectAttachmentHead)((Object)((PurchaseTenderProjectAttachmentHeadMapper)this.baseMapper).selectById((Serializable)((Object)tenderProjectAttachmentInfoVo.getId())));
        PurchaseTenderProjectAttachmentHeadVO attachmentHeadVO = this.queryAll(purchaseTenderProjectAttachmentHead.getSubpackageId());
        this.checkAndSetParam(attachmentHeadVO);
        purchaseTenderProjectAttachmentHead.setStatus(AttachmentStateEnum.AUDIT_YES.getValue());
        this.updateById((Object)purchaseTenderProjectAttachmentHead);
        List<PurchaseTenderProjectAttachmentInfo> tenderProjectAttachmentInfoList = attachmentHeadVO.getPurchaseTenderProjectAttachmentInfoList();
        List<PurchaseAttachmentDTO> purchaseAttachmentDTOList = this.convertData(purchaseTenderProjectAttachmentHead, tenderProjectAttachmentInfoList);
        ArchiveUtil.saveArchiveByPurchaseAttachmentDTO(purchaseAttachmentDTOList, attachmentHeadVO.getId(), attachmentHeadVO.getSubpackageId(), attachmentHeadVO.getTenderProjectId(), TenderProjectArchiveAttachmentEnum.PROJECT_ATTACHMENT_PREFIX.getValue());
        boolean hasPreTrial = SubpackageInfoCheckTypeEnum.hasPreTrial(purchaseTenderProjectAttachmentHead.getCheckType());
        String subpackageStatus = hasPreTrial ? "" + TenderProjectSubpackageStatusEnum.PRE_ATTACHMENT_FINISH.getValue() : "" + TenderProjectSubpackageStatusEnum.ATTACHMENT_FINISH.getValue();
        this.updateTenderProjectSubpackageInfo(purchaseTenderProjectAttachmentHead, subpackageStatus);
    }

    public void checkAndSetParam(PurchaseTenderProjectAttachmentHeadVO purchaseTenderProjectHead) {
        Assert.hasText((String)purchaseTenderProjectHead.getTenderProjectId(), (String)I18nUtil.translate((String)"i18n_alert_dIAyxOLVW_a6e6f2bb", (String)"\u9879\u76ee\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a\uff01"));
        Assert.hasText((String)purchaseTenderProjectHead.getSubpackageId(), (String)I18nUtil.translate((String)"i18n_alert_zsAyxOLVW_ba7b51", (String)"\u5206\u5305\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a\uff01"));
        Assert.hasText((String)purchaseTenderProjectHead.getCheckType(), (String)I18nUtil.translate((String)"i18n_alert_UJCKxiTLVW_4319cd17", (String)"\u5ba1\u67e5\u65b9\u5f0f\u4e0d\u5141\u8bb8\u4e3a\u7a7a!"));
        PurchaseTenderProjectSubpackageInfo subpackageInfo = this.subpackageInfoService.selectById(purchaseTenderProjectHead.getSubpackageId());
        boolean hasPreTrial = SubpackageInfoCheckTypeEnum.hasPreTrial(purchaseTenderProjectHead.getCheckType());
        boolean bidOpenType = SubpackageBidOpenTypeEnum.ON_LINE.getValue().equals(subpackageInfo.getBidOpenType());
        boolean evaluationType = SubpackageEvaBidTypeEnum.ON_LINE.getValue().equals(subpackageInfo.getEvaluationType());
        HashMap<String, String> bidLetterMap = new HashMap<String, String>();
        HashMap<String, String> bidLetterMaterialsMap = new HashMap<String, String>();
        this.checkAndSetParamAttachmentInfo(purchaseTenderProjectHead);
        if (bidOpenType) {
            this.checkAndSetParamTenderBidLetter(purchaseTenderProjectHead, bidLetterMap, bidLetterMaterialsMap);
        }
        if (evaluationType) {
            this.checkAndSetParamEvaPrinciples(purchaseTenderProjectHead);
            this.checkAndSetParamEvaluationInfo(purchaseTenderProjectHead, subpackageInfo, bidLetterMap, bidLetterMaterialsMap);
        }
    }

    private void checkAndSetParamEvaPrinciples(PurchaseTenderProjectAttachmentHeadVO purchaseTenderProjectHead) {
        PurchaseTenderEvaluationPrinciples tenderEvaluationPrinciples = purchaseTenderProjectHead.getPurchaseTenderEvaluationPrinciples();
        Assert.hasText((String)tenderEvaluationPrinciples.getReviewSummaryRules(), (String)I18nUtil.translate((String)"i18n_alert_UUMkLFxiTLVW_b674dec3", (String)"\u8bc4\u5ba1\u6c47\u603b\u89c4\u5219\u4e0d\u5141\u8bb8\u4e3a\u7a7a!"));
        Assert.hasText((String)tenderEvaluationPrinciples.getSummaryCalType(), (String)I18nUtil.translate((String)"i18n_alert_MktdCKxiTLVW_5be8629d", (String)"\u6c47\u603b\u8ba1\u7b97\u65b9\u5f0f\u4e0d\u5141\u8bb8\u4e3a\u7a7a!"));
        Assert.hasText((String)tenderEvaluationPrinciples.getSummaryScorePrecision(), (String)I18nUtil.translate((String)"i18n_alert_MkzROzxiTLVW_7647f92f", (String)"\u6c47\u603b\u5206\u503c\u7cbe\u5ea6\u4e0d\u5141\u8bb8\u4e3a\u7a7a!"));
        String checkType = TenderFlagInjectionContext.getTenderCheckType();
        String currentStep = TenderFlagInjectionContext.getTenderCurrentStep();
        if ("0".equals(checkType) || "1".equals(checkType) && "1".equals(currentStep)) {
            String shortlistedRules = tenderEvaluationPrinciples.getShortlistedRules();
            Assert.hasText((String)shortlistedRules, (String)I18nUtil.translate((String)"i18n_alert_UBjFsVRiNLLF_e0a4e3d6", (String)"\u8bc4\u6807\u539f\u5219\u4e2d\u8bf7\u52fe\u9009\u5165\u56f4\u89c4\u5219!"));
            if ((ShortlistedRulesEnum.SCORE_RANKING_SHORTLISTED_RULES.getValue().equals(shortlistedRules) || ShortlistedRulesEnum.SCOREANDAGGREGATE_RANKING_SHORTLISTED_RULES.getValue().equals(shortlistedRules) || ShortlistedRulesEnum.SCOREORAGGREGATE_RANKING_SHORTLISTED_RULES.getValue().equals(shortlistedRules)) && null == tenderEvaluationPrinciples.getScoreRanking()) {
                throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_UBjFsjzARxOLVWVImW_ed7bdbe7", (String)"\u8bc4\u6807\u539f\u5219\u4e2d\u5f97\u5206\u6392\u540d\u4e0d\u80fd\u4e3a\u7a7a,\u8bf7\u68c0\u67e5!"));
            }
            if ((ShortlistedRulesEnum.AGGREGATE_SCORERANKING_SHORTLISTED_RULES.getValue().equals(shortlistedRules) || ShortlistedRulesEnum.SCOREANDAGGREGATE_RANKING_SHORTLISTED_RULES.getValue().equals(shortlistedRules) || ShortlistedRulesEnum.SCOREORAGGREGATE_RANKING_SHORTLISTED_RULES.getValue().equals(shortlistedRules)) && null == tenderEvaluationPrinciples.getSummaryScore()) {
                throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_UBjFsMkszxOLVWVImW_6f78f32e", (String)"\u8bc4\u6807\u539f\u5219\u4e2d\u6c47\u603b\u5f97\u5206\u4e0d\u80fd\u4e3a\u7a7a,\u8bf7\u68c0\u67e5!"));
            }
        }
    }

    private void checkAndSetParamEvaluationInfo(PurchaseTenderProjectAttachmentHeadVO purchaseTenderProjectHead, PurchaseTenderProjectSubpackageInfo subpackageInfo, Map<String, String> bidTeeterMap, Map<String, String> bidTeeterMaterialsMap) {
        List<PurchaseTenderEvaluationGroupVO> tenderEvaluationInfoVoList = purchaseTenderProjectHead.getTenderEvaluationInfoVoList();
        Assert.isTrue((boolean)CollectionUtils.isNotEmpty(tenderEvaluationInfoVoList), (String)I18nUtil.translate((String)"i18n_field_UBrhsSyVVHxOLVW_9a786845", (String)"\u8bc4\u6807\u529e\u6cd5\u4e2d\u73af\u8282\u7ec4\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a!"));
        String checkType = TenderFlagInjectionContext.getTenderCheckType();
        String processType = TenderFlagInjectionContext.getTenderProcessType();
        String currentStep = TenderFlagInjectionContext.getTenderCurrentStep();
        if (SubpackageInfoCheckTypeEnum.POST_TRIAL.getValue().equals(checkType) && SubpackageInfoProcessTypeEnum.TWO_STEP.getValue().equals(subpackageInfo.getProcessType())) {
            Set currentStepList = tenderEvaluationInfoVoList.stream().map(PurchaseTenderEvaluationGroup::getCurrentStep).collect(Collectors.toSet());
            Assert.isTrue((boolean)currentStepList.contains(SubpackageInfoCurrentStepEnum.FIRST_STEP.getValue()), (String)I18nUtil.translate((String)"i18n_field_UBrhsSyVnIxUBVHxOLVW_7263c8ad", (String)"\u8bc4\u6807\u529e\u6cd5\u4e2d\u73af\u8282\u7ec4\u7b2c\u4e00\u6b65\u8bc4\u6807\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a!"));
            Assert.isTrue((boolean)currentStepList.contains(SubpackageInfoCurrentStepEnum.SECOND_STEP.getValue()), (String)I18nUtil.translate((String)"i18n_field_UBrhsSyVnxxUBVHxOLVW_df758a39", (String)"\u8bc4\u6807\u529e\u6cd5\u4e2d\u73af\u8282\u7ec4\u7b2c\u4e8c\u6b65\u8bc4\u6807\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a!"));
        }
        HashMap priceRegulationMap = new HashMap();
        tenderEvaluationInfoVoList.stream().forEach(evaluationGroupVo -> {
            if ("1".equals(checkType) && "1".equals(processType)) {
                Assert.hasText((String)evaluationGroupVo.getCurrentStep(), (String)I18nUtil.translate((String)"i18n_field_UBrhsWWWWWWSyIUUyOxOLVW_11480d2e", (String)"\u8bc4\u6807\u529e\u6cd5\u4e2d[${0}]\u73af\u8282\u4e0b\u8bc4\u5ba1\u9636\u6bb5\u4e0d\u80fd\u4e3a\u7a7a!", (String[])new String[]{evaluationGroupVo.getGroupName()}));
            }
            List<PurchaseTenderEvaluationRegulationInfo> evaluationRegulationInfoList = evaluationGroupVo.getTenderEvaluationTemplateRegulationInfoList();
            PurchaseTenderEvaluationPriceRegulationInfo evaluationPriceRegulationInfo = evaluationGroupVo.getTenderEvaluationTemplatePriceRegulationInfo();
            if (CollectionUtils.isEmpty(evaluationRegulationInfoList) && null == evaluationPriceRegulationInfo) {
                throw new ELSBootException(I18nUtil.translate((String)"i18n_field_UBrhsWWWWWWSyIlTjITTvWSWzRtdVHW_a9f1b4d4", (String)"\u8bc4\u6807\u529e\u6cd5\u4e2d[${0}]\u73af\u8282\u4e0b\u5fc5\u987b\u6709\u4e00\u6761\u6761\u4f8b \u6216 \u5206\u503c\u8ba1\u7b97\u4fe1\u606f!", (String[])new String[]{evaluationGroupVo.getGroupName()}));
            }
            if ("0".equals(checkType) && evaluationPriceRegulationInfo != null) {
                throw new ELSBootException(I18nUtil.translate((String)"i18n_field_APYBQILUUWUBrhsWWWWWWSyIxOLHcumztdW_cc088680", (String)"\u5f53\u524d\u62db\u6807\u6587\u4ef6\u4e3a\u9884\u5ba1 \u8bc4\u6807\u529e\u6cd5\u4e2d[${0}]\u73af\u8282\u4e0b\u4e0d\u80fd\u4e3a\u8fdb\u884c\u4ef7\u683c\u5206\u8ba1\u7b97!", (String[])new String[]{evaluationGroupVo.getGroupName()}));
            }
            if (evaluationPriceRegulationInfo != null) {
                String[] params;
                String bidLetterType;
                String quoteColumnName;
                String tenderBidLetterId = evaluationPriceRegulationInfo.getTenderBidLetterId();
                Object checkExist = bidTeeterMap.get(tenderBidLetterId + "_" + (quoteColumnName = evaluationPriceRegulationInfo.getQuoteColumnName()));
                if (null == checkExist) {
                    throw new ELSBootException(I18nUtil.translate((String)"i18n_field_UBrhsWWWWWWSyIdRKjsuAxMKVImW_d865a267", (String)"\u8bc4\u6807\u529e\u6cd5\u4e2d[${0}]\u73af\u8282\u4e0b\u6240\u5173\u8054\u7684\u62a5\u4ef7\u5217\u4e0d\u5b58\u5728\u8bf7\u68c0\u67e5!", (String[])new String[]{evaluationGroupVo.getGroupName()}));
                }
                priceRegulationMap.put(tenderBidLetterId + "_" + quoteColumnName, null);
                if ("1".equals(checkType) && "1".equals(processType) && "0".equals(currentStep) && !(bidLetterType = (params = ((String)bidTeeterMap.get(tenderBidLetterId + "_" + quoteColumnName)).split("_"))[2]).equals(evaluationGroupVo.getCurrentStep())) {
                    throw new ELSBootException(I18nUtil.translate((String)"i18n_field_UBrhsWWWWWWSyIjUUyOniFjeBxAcxIRW_d77783aa", (String)"\u8bc4\u6807\u529e\u6cd5\u4e2d[${0}]\u73af\u8282\u4e0b\u7684\u8bc4\u5ba1\u9636\u6bb5\u548c\u9009\u62e9\u7684\u6295\u6807\u51fd\u7c7b\u578b\u4e0d\u4e00\u81f4!", (String[])new String[]{evaluationGroupVo.getGroupName()}));
                }
                String pricePointsCalFormula = evaluationPriceRegulationInfo.getPricePointsCalFormula();
                if ((PricePointsCalFormualEnum.OPERATION_MIN_PRICE_STRATEGY.equals(pricePointsCalFormula) || PricePointsCalFormualEnum.OPERATION_MIN_PRICE_POSITIVE_DEVIATION_STRATEGY.equals(pricePointsCalFormula)) && !"0".equals(evaluationPriceRegulationInfo.getBaseCalRules())) {
                    throw new ELSBootException(I18nUtil.translate((String)"i18n_field_UBrhsWWWWWWSyItdRKLenuEltdWenuiOvjWtruROiFenuW_12f80d5a", (String)"\u8bc4\u6807\u529e\u6cd5\u4e2d[${0}]\u73af\u8282\u4e0b\u8ba1\u7b97\u516c\u5f0f\u4e3a\u6700\u4f4e\u4ef7\u7b49\u6bd4\u8ba1\u7b97,\u6700\u4f4e\u4ef7\u8bc1\u504f\u79bb\u7684 \u57fa\u51c6\u4ef7\u53ea\u80fd\u9009\u62e9\u6700\u4f4e\u4ef7!", (String[])new String[]{evaluationGroupVo.getGroupName()}));
                }
            }
        });
        for (String bidTeeterKey : bidTeeterMap.keySet()) {
            boolean flag = false;
            for (String key : priceRegulationMap.keySet()) {
                if (!bidTeeterKey.equals(key)) continue;
                flag = true;
                break;
            }
            String bidLeeterInfo = bidTeeterMap.get(bidTeeterKey);
            String[] infoList = bidLeeterInfo.split("_");
            if (flag) continue;
            throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_eBxWWWWWWIjWWWWWWLsuAWTPKUBrhsumUUdIHcyIW_7ac50de7", (String)"\u6295\u6807\u51fd[${0}]\u4e0b\u7684[${1}]\u4e3a\u62a5\u4ef7\u5217,\u9700\u8981\u5728\u8bc4\u6807\u529e\u6cd5\u4e2d\u4ef7\u683c\u8bc4\u5ba1\u9879\u4e0b\u8fdb\u884c\u7ed1\u5b9a!", (String[])new String[]{infoList[0], infoList[1]}));
        }
    }

    private void checkAndSetParamTenderBidLetter(PurchaseTenderProjectAttachmentHeadVO purchaseTenderProjectHead, Map<String, String> bidTeeterMap, Map<String, String> bidLetterMaterialsMap) {
        PurchaseTenderBidLetterFormatGroupVO tenderBidLetterFormatGroupVo = purchaseTenderProjectHead.getTenderBidLetterFormatGroupVo();
        if ("1".equals(TenderFlagInjectionContext.getTenderCheckType())) {
            Assert.hasText((String)tenderBidLetterFormatGroupVo.getQuoteType(), (String)I18nUtil.translate((String)"i18n_alert_suAcxiTLV_5d905242", (String)"\u62a5\u4ef7\u7c7b\u578b\u4e0d\u5141\u8bb8\u4e3a\u7a7a!"));
            Assert.hasText((String)tenderBidLetterFormatGroupVo.getQuotations(), (String)I18nUtil.translate((String)"i18n_alert_suCKxiTLVW_d4501fa5", (String)"\u62a5\u4ef7\u65b9\u5f0f\u4e0d\u5141\u8bb8\u4e3a\u7a7a!"));
        }
        List<PurchaseTenderBidLetterVO> tenderBidLetterVoList = tenderBidLetterFormatGroupVo.getTenderBidTetterVoList();
        Assert.isTrue((boolean)CollectionUtils.isNotEmpty(tenderBidLetterVoList), (String)I18nUtil.translate((String)"i18n_alert_eBxABxiTLVW_14c9a259", (String)"\u6295\u6807\u51fd\u5217\u8868\u4e0d\u5141\u8bb8\u4e3a\u7a7a!"));
        if (BidLetterFormatQuoteTypeEnum.ITEMIZED_QUOTATION.getValue().equals(tenderBidLetterFormatGroupVo.getQuoteType())) {
            List quoteBidLetterList = tenderBidLetterVoList.stream().filter(bidLetterVO -> "1".equals(bidLetterVO.getQuoteBidLetter())).collect(Collectors.toList());
            if (CollectionUtil.size(quoteBidLetterList) > 1) {
                List bidLetterNameList = quoteBidLetterList.stream().map(PurchaseTenderBidLetter::getName).collect(Collectors.toList());
                throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_eBxABWWWWWeKMKsuAW_cdc5fb13", (String)"\u6295\u6807\u51fd\u5217\u8868\u3010{0}\u3011\u540c\u65f6\u5b58\u5728\u62a5\u4ef7\u5217!", (String[])new String[]{StrUtil.join((CharSequence)",", bidLetterNameList)}));
            }
            if (CollectionUtil.size(quoteBidLetterList) == 0) {
                throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_eBxABLGRsuAW_282c525a", (String)"\u6295\u6807\u51fd\u5217\u8868\u672a\u8bbe\u7f6e\u62a5\u4ef7\u5217!"));
            }
        }
        HashMap bidTetterTypeMap = new HashMap();
        tenderBidLetterVoList.stream().forEach(bidTetterVo -> {
            if (bidTetterTypeMap.containsKey(bidTetterVo.getFormatType())) {
                bidTetterTypeMap.put(bidTetterVo.getFormatType(), (Integer)bidTetterTypeMap.get(bidTetterVo.getFormatType()) + 1);
            } else {
                bidTetterTypeMap.put(bidTetterVo.getFormatType(), 1);
            }
            bidTetterVo.setCheckType(purchaseTenderProjectHead.getCheckType());
            PurchaseTenderPriceOpeningsTemplate priceOpeningsList = bidTetterVo.getPriceOpenings();
            if (null == priceOpeningsList) {
                throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_eBxmKIWWWWWWWWumIBBxiTLVW_1c5045e1", (String)"\u6295\u6807\u51fd\u683c\u5f0f\u4e0b[${0}] ,\u4ef7\u683c\u4e00\u89c8\u8868\u4e0d\u5141\u8bb8\u4e3a\u7a7a!", (String[])new String[]{bidTetterVo.getName()}));
            }
            String customizeFieldModel = priceOpeningsList.getCustomizeFieldModel();
            if (null == customizeFieldModel || "[]".equals(customizeFieldModel)) {
                throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_eBxmKIWWWWWWWWumIBBeVHxiTLVW_8065107b", (String)"\u6295\u6807\u51fd\u683c\u5f0f\u4e0b[${0}] ,\u4ef7\u683c\u4e00\u89c8\u8868\u5934\u4fe1\u606f\u4e0d\u5141\u8bb8\u4e3a\u7a7a!", (String[])new String[]{bidTetterVo.getName()}));
            }
            String customizeFieldData = priceOpeningsList.getCustomizeFieldData();
            if (null == customizeFieldData || "[]".equals(customizeFieldData)) {
                throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_eBxmKIWWWWWWWWumIBBABVHxiTLVW_31011e40", (String)"\u6295\u6807\u51fd\u683c\u5f0f\u4e0b[${0}] ,\u4ef7\u683c\u4e00\u89c8\u8868\u5217\u8868\u4fe1\u606f\u4e0d\u5141\u8bb8\u4e3a\u7a7a!", (String[])new String[]{bidTetterVo.getName()}));
            }
            List customColumnModelList = JSONArray.parseArray((String)customizeFieldModel, CustomColumnModel.class);
            JSONArray dataJsonArray = JSONArray.parseArray((String)customizeFieldData);
            int materialCount = 0;
            int bidTeeterCount = 0;
            for (CustomColumnModel customColumnModel : customColumnModelList) {
                if ("1".equals(customColumnModel.getMust()) && "1".equals(customColumnModel.getInputOrg())) {
                    for (int i = 0; i < dataJsonArray.size(); ++i) {
                        JSONObject jsonObject = dataJsonArray.getJSONObject(i);
                        if (null != jsonObject.get((Object)customColumnModel.getField()) && !"".equals(jsonObject.get((Object)customColumnModel.getField()))) continue;
                        throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_eBxmKIWWWWWWsWWWWWWAKYBtLlSdxiTLVW_5c4d8733", (String)"\u6295\u6807\u51fd\u683c\u5f0f\u4e0b[${0}]\u4e2d[${1}]\u5217\u662f\u62db\u6807\u5355\u4f4d\u5fc5\u586b\u9879\u4e0d\u5141\u8bb8\u4e3a\u7a7a!", (String[])new String[]{bidTetterVo.getName(), customColumnModel.getTitle()}));
                    }
                }
                if (!CustomerFieldCategoryEnum.TENDER_OFFERS_COLUMN.getValue().equals(customColumnModel.getFieldCategory())) continue;
                bidTeeterMap.put(bidTetterVo.getId() + "_" + customColumnModel.getField(), bidTetterVo.getName() + "_" + customColumnModel.getTitle() + "_" + bidTetterVo.getFormatType());
                ++bidTeeterCount;
            }
            if (materialCount > 0 && bidTeeterCount > 1) {
                throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_eBxWWWWWWsMKSLAKeOROGRImsuAW_82714aa6", (String)"\u6295\u6807\u51fd[${0}]\u4e2d\u5b58\u5728\u7269\u6599\u5217\u65f6\u6700\u591a\u53ea\u80fd\u8bbe\u7f6e\u4e00\u4e2a\u62a5\u4ef7\u5217!", (String[])new String[]{bidTetterVo.getName()}));
            }
        });
        Integer oneCount = (Integer)bidTetterTypeMap.get(BidLetterFormatTypeEnum.BID_OPENING_PREVIEW_FORM.getValue());
        if ("1".equals(TenderFlagInjectionContext.getTenderCheckType())) {
            if ("1".equals(TenderFlagInjectionContext.getTenderProcessType())) {
                Integer twoCount = (Integer)bidTetterTypeMap.get(BidLetterFormatTypeEnum.RESULT_FORMAT_TYPE.getValue());
                Assert.isTrue((oneCount != null && twoCount != null && oneCount > 0 && twoCount > 0 ? 1 : 0) != 0, (String)I18nUtil.translate((String)"i18n_alert_RxhjYBQIWTPjIxhvBIBBnRxhvBIBBW_be1ae10c", (String)"\u4e24\u6b65\u6cd5\u7684\u62db\u6807\u6587\u4ef6 \u9700\u8981\u6709\u4e00\u6b65\u6cd5\u5f00\u6807\u4e00\u89c8\u8868\u548c\u4e24\u6b65\u6cd5\u5f00\u6807\u4e00\u89c8\u8868!"));
            } else {
                Assert.isTrue((oneCount != null && oneCount > 0 ? 1 : 0) != 0, (String)I18nUtil.translate((String)"i18n_alert_vBIBBxMKVImW_5233ec09", (String)"\u5f00\u6807\u4e00\u89c8\u8868\u4e0d\u5b58\u5728\u8bf7\u68c0\u67e5!"));
            }
        } else {
            Assert.isTrue((oneCount != null && oneCount > 0 ? 1 : 0) != 0, (String)I18nUtil.translate((String)"i18n_alert_UUvBIBBxMKVImW_bfd3c26", (String)"\u9884\u5ba1\u5f00\u6807\u4e00\u89c8\u8868\u4e0d\u5b58\u5728\u8bf7\u68c0\u67e5!"));
        }
    }

    private void checkAndSetParamAttachmentInfo(PurchaseTenderProjectAttachmentHeadVO purchaseTenderProjectHead) {
        List<PurchaseTenderProjectAttachmentInfo> attachmentInfoList = purchaseTenderProjectHead.getPurchaseTenderProjectAttachmentInfoList();
        Assert.isTrue((boolean)CollectionUtils.isNotEmpty(attachmentInfoList), (String)I18nUtil.translate((String)"i18n_alert_YBQIxiTLVW_76c16858", (String)"\u62db\u6807\u6587\u4ef6\u4e0d\u5141\u8bb8\u4e3a\u7a7a!"));
        if ("1".equals(TenderFlagInjectionContext.getTenderCheckType())) {
            long count = attachmentInfoList.parallelStream().filter(info -> AttachmentFileStateEnum.ATTACHMENT_FILE.getValue().equals(info.getFileType())).count();
            Assert.isTrue((count == 1L ? 1 : 0) != 0, (String)I18nUtil.translate((String)"i18n_alert_YBQIjFROjImW_b4559727", (String)"\u62db\u6807\u6587\u4ef6\u6709\u4e14\u53ea\u80fd\u6709\u4e00\u4e2a!"));
        } else {
            long count = attachmentInfoList.parallelStream().filter(info -> AttachmentFileStateEnum.PRE_ATTACHMENT_FILE.getValue().equals(info.getFileType())).count();
            Assert.isTrue((count == 1L ? 1 : 0) != 0, (String)I18nUtil.translate((String)"i18n_alert_UUQIjFROjImW_845828f8", (String)"\u9884\u5ba1\u6587\u4ef6\u6709\u4e14\u53ea\u80fd\u6709\u4e00\u4e2a!"));
        }
    }

    private List<PurchaseAttachmentDTO> convertData(PurchaseTenderProjectAttachmentHead attachmentHead, List<PurchaseTenderProjectAttachmentInfo> purchaseTenderProjectAttachmentInfoList) {
        ArrayList<PurchaseAttachmentDTO> purchaseAttachmentDTOList = new ArrayList<PurchaseAttachmentDTO>();
        purchaseTenderProjectAttachmentInfoList.parallelStream().forEach(projectAttachmentInfo -> {
            PurchaseAttachmentDTO purchaseAttachmentDTO = new PurchaseAttachmentDTO();
            purchaseAttachmentDTO.setId(projectAttachmentInfo.getId());
            purchaseAttachmentDTO.setHeadId(attachmentHead.getId());
            purchaseAttachmentDTO.setFileName(projectAttachmentInfo.getFileName());
            purchaseAttachmentDTO.setFilePath(projectAttachmentInfo.getFilePath());
            purchaseAttachmentDTO.setFileType(projectAttachmentInfo.getFileType());
            purchaseAttachmentDTO.setUploadElsAccount(TenantContext.getTenant());
            purchaseAttachmentDTO.setUploadSubAccount(SysUtil.getLoginUser().getSubAccount());
            purchaseAttachmentDTO.setBusinessType("attachment");
            purchaseAttachmentDTOList.add(purchaseAttachmentDTO);
        });
        return purchaseAttachmentDTOList;
    }
}

