/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.tender.common.utils;

import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.parser.Feature;
import com.alibaba.fastjson.parser.ParserConfig;
import com.alibaba.fastjson.serializer.SerializeConfig;
import com.alibaba.fastjson.serializer.SerializeFilter;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.alibaba.fastjson.support.config.FastJsonConfig;
import com.alibaba.fastjson.support.spring.FastJsonHttpMessageConverter;
import com.els.modules.tender.common.utils.FastJsonParserConfig;
import com.els.modules.tender.common.utils.MvcHttpConcerter;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.MediaType;

public class FastJsonUtils {
    protected static Logger logger = LoggerFactory.getLogger(FastJsonUtils.class);
    private static final SerializeConfig FASTJSON_SERIALIZE_CONFIG = new SerializeConfig();
    private static final ParserConfig FASTJSON_PARSER_CONFIG = new FastJsonParserConfig();
    private static final SerializerFeature[] SERIALIZER_FEATURES = new SerializerFeature[]{SerializerFeature.WriteMapNullValue, SerializerFeature.WriteNullListAsEmpty, SerializerFeature.WriteNullNumberAsZero, SerializerFeature.WriteNullBooleanAsFalse, SerializerFeature.WriteNullStringAsEmpty, SerializerFeature.DisableCircularReferenceDetect, SerializerFeature.WriteEnumUsingToString};
    private static final SerializerFeature[] SERIALIZER_PRETTY_FEATURES = new SerializerFeature[]{SerializerFeature.WriteMapNullValue, SerializerFeature.WriteNullListAsEmpty, SerializerFeature.WriteNullNumberAsZero, SerializerFeature.WriteNullBooleanAsFalse, SerializerFeature.WriteNullStringAsEmpty, SerializerFeature.DisableCircularReferenceDetect, SerializerFeature.WriteEnumUsingToString, SerializerFeature.PrettyFormat};
    private static final SerializeFilter[] SERIALIZER_FILTERS = new SerializeFilter[0];
    private static final Feature[] FEATURE = new Feature[]{Feature.IgnoreNotMatch};

    public static String toString(Object object) {
        return JSON.toJSONString((Object)object, (SerializeConfig)FASTJSON_SERIALIZE_CONFIG, (SerializeFilter[])SERIALIZER_FILTERS, (SerializerFeature[])SERIALIZER_FEATURES);
    }

    public static String toPrettyString(Object object) {
        String json = JSON.toJSONString((Object)object, (SerializeConfig)FASTJSON_SERIALIZE_CONFIG, (SerializeFilter[])SERIALIZER_FILTERS, (SerializerFeature[])SERIALIZER_PRETTY_FEATURES);
        return StrUtil.replace((CharSequence)json, (CharSequence)"\t", (CharSequence)"  ");
    }

    public static Object toBean(String text) {
        return JSON.parse((String)text, (Feature[])FEATURE);
    }

    public static <T> T toBean(String text, Class<T> clazz) {
        return (T)JSON.parseObject((String)text, clazz, (ParserConfig)FASTJSON_PARSER_CONFIG, (Feature[])FEATURE);
    }

    public static <T> T toBean(InputStream content, Class<T> clazz) {
        try {
            return (T)JSON.parseObject((InputStream)content, clazz, (Feature[])FEATURE);
        }
        catch (IOException e) {
            logger.error("InputStream toBean error ", (Throwable)e);
            return null;
        }
    }

    public static <T> Object[] toArray(String text) {
        return FastJsonUtils.toArray(text, null);
    }

    public static <T> Object[] toArray(String text, Class<T> clazz) {
        return JSON.parseArray((String)text, clazz).toArray();
    }

    public static <T> List<T> toList(String text, Class<T> clazz) {
        return JSON.parseArray((String)text, clazz);
    }

    public static byte[] toBytes(Object object) {
        return FastJsonUtils.toString(object).getBytes();
    }

    public static <T> T toBean(byte[] bytes, Class<T> clazz) {
        return FastJsonUtils.toBean(new String(bytes), clazz);
    }

    public static Map toMap(Object object) {
        Map m = FastJsonUtils.toMap(FastJsonUtils.toString(object));
        return m;
    }

    public static Map toMap(String s) {
        JSONObject m = JSONObject.parseObject((String)s);
        return m;
    }

    public static FastJsonHttpMessageConverter getConverter() {
        MvcHttpConcerter fastConverter = new MvcHttpConcerter();
        FastJsonConfig fastJsonConfig = new FastJsonConfig();
        fastJsonConfig.setSerializeConfig(FASTJSON_SERIALIZE_CONFIG);
        fastJsonConfig.setParserConfig(FASTJSON_PARSER_CONFIG);
        fastJsonConfig.setSerializerFeatures(SERIALIZER_FEATURES);
        fastJsonConfig.setSerializeFilters(SERIALIZER_FILTERS);
        fastJsonConfig.setFeatures(FEATURE);
        ArrayList<MediaType> fastMediaTypes = new ArrayList<MediaType>();
        fastMediaTypes.add(MediaType.APPLICATION_JSON_UTF8);
        fastMediaTypes.add(MediaType.APPLICATION_JSON);
        fastConverter.setSupportedMediaTypes(fastMediaTypes);
        fastConverter.setFastJsonConfig(fastJsonConfig);
        return fastConverter;
    }
}

