/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.tender.sale.service.impl;

import cn.hutool.core.collection.CollectionUtil;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.els.common.system.base.entity.ParentEntity;
import com.els.common.system.base.service.impl.BaseServiceImpl;
import com.els.common.util.I18nUtil;
import com.els.config.mybatis.TenantContext;
import com.els.modules.tender.attachment.service.PurchaseTenderProjectAttachmentHeadService;
import com.els.modules.tender.attachment.vo.PurchaseTenderBidLetterFormatGroupVO;
import com.els.modules.tender.common.interceptor.TenderFlagInjectionContext;
import com.els.modules.tender.project.entity.PurchaseTenderProjectSubpackageInfo;
import com.els.modules.tender.project.enumerate.SubpackageEvaBidTypeEnum;
import com.els.modules.tender.project.enumerate.SubpackageInfoCheckTypeEnum;
import com.els.modules.tender.project.service.PurchaseTenderProjectSubpackageInfoService;
import com.els.modules.tender.sale.entity.SaleTenderPriceOpenings;
import com.els.modules.tender.sale.entity.SaleTenderProjectBidWinningAffirmItem;
import com.els.modules.tender.sale.mapper.SaleTenderProjectBidWinningAffirmItemMapper;
import com.els.modules.tender.sale.service.SaleTenderPriceOpeningsService;
import com.els.modules.tender.sale.service.SaleTenderProjectBidWinningAffirmItemService;
import com.els.modules.tender.sale.vo.SaleQuoteColumnVO;
import com.els.modules.tender.sale.vo.SaleTenderProjectBidWinningAffirmItemVo;
import com.els.modules.tender.supplier.entity.TenderProjectSupplier;
import com.els.modules.tender.supplier.service.TenderProjectSupplierService;
import com.els.rpc.service.InvokeBaseRpcService;
import jakarta.annotation.Resource;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;

@Service
public class SaleTenderProjectBidWinningAffirmItemServiceImpl
extends BaseServiceImpl<SaleTenderProjectBidWinningAffirmItemMapper, SaleTenderProjectBidWinningAffirmItem>
implements SaleTenderProjectBidWinningAffirmItemService {
    @Resource
    private InvokeBaseRpcService invokeBaseRpcService;
    @Autowired
    @Lazy
    private SaleTenderPriceOpeningsService salePriceOpeningsService;
    @Resource
    @Lazy
    private PurchaseTenderProjectSubpackageInfoService subpackageInfoService;
    @Autowired
    @Lazy
    private PurchaseTenderProjectAttachmentHeadService attachmentHeadService;
    @Autowired
    @Lazy
    private TenderProjectSupplierService tenderProjectSupplierService;

    @Override
    public void add(SaleTenderProjectBidWinningAffirmItem saleTenderProjectBidWinningAffirmItem) {
        this.save((Object)saleTenderProjectBidWinningAffirmItem);
    }

    @Override
    public void edit(SaleTenderProjectBidWinningAffirmItem saleTenderProjectBidWinningAffirmItem) {
        int count = ((SaleTenderProjectBidWinningAffirmItemMapper)this.baseMapper).updateById((Object)saleTenderProjectBidWinningAffirmItem);
        Assert.isTrue((count != 0 ? 1 : 0) != 0, (String)I18nUtil.translate((String)"i18n_alert_APWFIKXWVVVXVSDJHrW_2fe92d52", (String)"\u5f53\u524d\u6570\u636e\u5df2\u5931\u6548\uff0c\u8bf7\u91cd\u65b0\u5237\u65b0\u540e\u63d0\u4ea4\u66f4\u6539\uff01"));
    }

    @Override
    public void delete(String id) {
        ((SaleTenderProjectBidWinningAffirmItemMapper)this.baseMapper).deleteById((Serializable)((Object)id));
    }

    @Override
    public void deleteBatch(List<String> idList) {
        ((SaleTenderProjectBidWinningAffirmItemMapper)this.baseMapper).deleteBatchIds(idList);
    }

    @Override
    public SaleTenderProjectBidWinningAffirmItemVo queryBySubpackageId(String subpackageId) {
        SaleTenderProjectBidWinningAffirmItemVo affirmItemVo = new SaleTenderProjectBidWinningAffirmItemVo();
        SaleTenderProjectBidWinningAffirmItem saleTenderProjectBidWinningAffirmItem = ((SaleTenderProjectBidWinningAffirmItemMapper)this.baseMapper).selectBySubpackageId(subpackageId, TenantContext.getTenant());
        if (null == saleTenderProjectBidWinningAffirmItem) {
            return null;
        }
        TenderFlagInjectionContext.setTenderCheckType(SubpackageInfoCheckTypeEnum.POST_TRIAL.getValue());
        PurchaseTenderProjectSubpackageInfo subpackageInfo = (PurchaseTenderProjectSubpackageInfo)((Object)this.subpackageInfoService.getById((Serializable)((Object)subpackageId)));
        affirmItemVo.setEvaluationType(subpackageInfo.getEvaluationType());
        if (!SubpackageEvaBidTypeEnum.OFF_LINE.getValue().equals(subpackageInfo.getEvaluationType())) {
            PurchaseTenderBidLetterFormatGroupVO formatGroupVO = this.attachmentHeadService.queryBidLetterFormatGroup(subpackageId);
            String quoteType = formatGroupVO.getQuoteType();
            affirmItemVo.setQuoteType(quoteType);
        }
        TenderProjectSupplier querySupplier = new TenderProjectSupplier();
        querySupplier.setSubpackageId(subpackageId);
        querySupplier.setSupplierAccount(TenantContext.getTenant());
        List<TenderProjectSupplier> tenderProjectSuppliers = this.tenderProjectSupplierService.selectBySubpackageId(querySupplier);
        if (CollectionUtil.isNotEmpty(tenderProjectSuppliers)) {
            TenderProjectSupplier supplier = tenderProjectSuppliers.get(0);
            affirmItemVo.setWinnerAmount(supplier.getWinnerAmount());
        }
        LambdaQueryWrapper lambdaQueryWrapper = new LambdaQueryWrapper();
        lambdaQueryWrapper.eq(SaleTenderPriceOpenings::getSubpackageId, (Object)saleTenderProjectBidWinningAffirmItem.getSubpackageId());
        lambdaQueryWrapper.eq(ParentEntity::getElsAccount, (Object)saleTenderProjectBidWinningAffirmItem.getSupplierAccount());
        lambdaQueryWrapper.eq(SaleTenderPriceOpenings::getStageQuote, (Object)"0");
        List saleTenderPriceOpenings = this.salePriceOpeningsService.getBaseMapper().selectList((Wrapper)lambdaQueryWrapper);
        Map<String, List<SaleTenderPriceOpenings>> salePriceOpeningMaps = saleTenderPriceOpenings.stream().collect(Collectors.groupingBy(ParentEntity::getElsAccount));
        List<SaleTenderPriceOpenings> priceOpeningsList = salePriceOpeningMaps.get(saleTenderProjectBidWinningAffirmItem.getSupplierAccount());
        BeanUtils.copyProperties((Object)((Object)saleTenderProjectBidWinningAffirmItem), (Object)((Object)affirmItemVo));
        if (CollectionUtil.isNotEmpty(priceOpeningsList)) {
            ArrayList<SaleQuoteColumnVO> saleQuoteColumnVOS = new ArrayList<SaleQuoteColumnVO>();
            for (SaleTenderPriceOpenings tenderPriceOpenings : priceOpeningsList) {
                String customizeFieldData = tenderPriceOpenings.getCustomizeFieldData();
                JSONArray dataJsonArray = JSONArray.parseArray((String)customizeFieldData);
                for (int i = 0; i < dataJsonArray.size(); ++i) {
                    JSONObject jsonObject = dataJsonArray.getJSONObject(i);
                    Set keySet = jsonObject.keySet();
                    for (String key : keySet) {
                        SaleQuoteColumnVO saleQuoteColumnVO = new SaleQuoteColumnVO();
                        saleQuoteColumnVO.setBidLetterId(tenderPriceOpenings.getBidLetterId());
                        saleQuoteColumnVO.setField(key);
                        saleQuoteColumnVO.setValue(jsonObject.get((Object)key));
                        saleQuoteColumnVOS.add(saleQuoteColumnVO);
                    }
                }
            }
            affirmItemVo.setSaleQuoteColumnVO(saleQuoteColumnVOS);
        }
        List purchaseAttachmentDTOList = this.invokeBaseRpcService.selectPurchaseAttachmentByMainId(saleTenderProjectBidWinningAffirmItem.getId());
        affirmItemVo.setPurchaseAttachmentDTOList(purchaseAttachmentDTOList);
        return affirmItemVo;
    }

    @Override
    public void deleteBySubpackageId(String subpackageId) {
        ((SaleTenderProjectBidWinningAffirmItemMapper)this.baseMapper).deleteBySubpackageId(subpackageId);
    }
}

